from ttkbootstrap.localization.msgcat import MessageCatalog

MESSAGES = []


def initialize_localities():
    """Load all custom msg files."""
    for m in MESSAGES:
        m.initialize()


class LocaleMsgs:
    """A helper class to allow loading the library message catalog
    without having to package library resources which can cause
    problems with creating distributable applications with some
    packagers."""

    def __init__(self, locale, *msgs):
        self.locale = locale
        self.messages = msgs

    def initialize(self):
        """Initialize this locale in the MessageCatalog"""
        from itertools import chain

        messages = list(chain(*self.messages))
        MessageCatalog.set_many(self.locale, *messages)


MESSAGES.append(
    # CZECH translation
    LocaleMsgs(
        "cs",
        ("Continue", "Pokračovat"),
        ("Retry", "Znovu"),
        ("Delete", "Vymazat"),
        ("Next", "Další"),
        ("Prev", "Předchozí"),
        ("Yes", "Ano"),
        ("No", "Ne"),
        ("Open", "Otevřený"),
        ("Close", "Zavřít"),
        ("Add", "Přidat"),
        ("Remove", "Odstranit"),
        ("Submit", "Podat"),
        ("Family", "Rodina"),
        ("Weight", "Hmotnost"),
        ("Slant", "Sklonit"),
        ("Effects", "Účinky"),
        ("Preview", "Náhled"),
        ("Size", "Velikost"),
    )
)
MESSAGES.append(
    # DANISH translation
    LocaleMsgs(
        "da",
        ("Continue", "Fortsætte"),
        ("Retry", "Prøv"),
        ("Delete", "Slette"),
        ("Next", "Næste"),
        ("Prev", "Forrige"),
        ("Yes", "Ja"),
        ("No", "Nej"),
        ("Open", "Åben"),
        ("Close", "Lukke"),
        ("Add", "Tilføje"),
        ("Remove", "Fjerne"),
        ("Submit", "Indsende"),
        ("Family", "Familie"),
        ("Weight", "Vægt"),
        ("Slant", "Drejning"),
        ("Effects", "Effekter"),
        ("Size", "Størrelse"),
    )
)
MESSAGES.append(
    # SPANISH translation
    LocaleMsgs(
        "es",
        ("OK", "OK"),
        ("Ok", "Ok"),
        ("Retry", "Reintentar"),
        ("Next", "Próximo"),
        ("Prev", "Anterior"),
        ("Yes", "Sí"),
        ("No", "No"),
        ("Open", "Abrir"),
        ("Close", "Cerrar"),
        ("Add", "Agregar"),
        ("Delete", "Borrar"),
        ("Cancel", "Cancelar"),
        ("Remove", "Eliminar"),
        ("Submit", "Enviar"),
        ("Family", "Familia"),
        ("Weight", "Peso"),
        ("Slant", "Inclinación"),
        ("Effects", "Efectos"),
        ("Preview", "Vista previa"),
        ("Size", "Tamaño"),
        ("Should be of data type", "Debe ser del tipo de datos"),
        ("Invalid data type", "Tipo de datos inválido"),
        ("Number cannot be greater than", "El número no puede ser mayor que"),
        ("Number cannot be less than", "El número no puede ser menor que"),
        ("Select an item from the list", "Seleccionar un elemento de la lista"),
        ("Out of range", "Fuera de rango"),
        ("Previous", "Anterior"),
        (
            "The quick brown fox jumps over the lazy dog.",
            "La cigüeña tocaba el saxofón detrás del palenque de paja."
        ),
        ("Font Selector", "Selector de fuentes"),
        ("normal", "normal"),
        ("bold", "negrita"),
        ("roman", "romana"),
        ("italic", "cursiva"),
        ("underline", "subrayado"),
        ("overstrike", "tachado"),
        ("Color Chooser", "Selector de color"),
        ("Advanced", "Avanzado"),
        ("Themed", "Tema"),
        ("Standard", "Estándar"),
        ("Current", "Actual"),
        ("New", "Nuevo"),
        ("Hue", "Tono"),
        ("Sat", "Sat"),
        ("Lum", "Lum"),
        ("Hex", "Hex"),
        ("Red", "Rojo"),
        ("Green", "Verde"),
        ("Blue", "Azul"),
        ("color dropper", "selector de color"),
        ("Cancel", "Cancelar"),
        ("Search", "Buscar"),
        ("Page", "Página"),
        ("of", "de"),
        ("⎌", "⎌"),
        ("Reset table", "Reiniciar tabla"),
        ("Columns", "Columnas"),
        ("Move", "Mover"),
        ("Align", "Alinear"),
        ("Hide column", "Ocultar columna"),
        ("Delete column", "Eliminar columna"),
        ("Show All", "Mostrar todos"),
        ("Move to left", "Mover a la izquierda"),
        ("Move to right", "Mover a la derecha"),
        ("Move to first", "Mover al inicio"),
        ("Move to last", "Mover al final"),
        ("Align left", "Alinear a la izquierda"),
        ("Align center", "Alinear al centro"),
        ("Align right", "Alinear a la derecha"),
        ("Sort", "Ordenar"),
        ("Filter", "Filtrar"),
        ("Export", "Exportar"),
        ("Delete selected rows", "Eliminar filas seleccionadas"),
        ("Sort Ascending", "Ordenar ascendente"),
        ("Sort Descending", "Ordenar descendente"),
        ("Clear filters", "Limpiar filtros"),
        ("Filter by cell's value", "Filtrar por valor de celda"),
        ("Hide select rows", "Ocultar filas seleccionadas"),
        ("Show only select rows", "Mostrar solo filas seleccionadas"),
        ("Export all records", "Exportar todos los registros"),
        ("Export current page", "Exportar página actual"),
        ("Export current selection", "Exportar selección actual"),
        ("Export records in filter", "Exportar registros en filtro"),
        ("Move up", "Mover hacia arriba"),
        ("Move down", "Mover hacia abajo"),
        ("Move to top", "Mover al inicio"),
        ("Move to bottom", "Mover al final"),
        ("Mo", "Lu"),
        ("Tu", "Ma"),
        ("We", "Mi"),
        ("Th", "Ju"),
        ("Fr", "Vi"),
        ("Sa", "Sa"),
        ("Su", "Do"),
    )
)
MESSAGES.append(
    # PORTUGUESE - BRAZIL translation
    LocaleMsgs(
        "pt_br",
        ("Retry", "Repetir"),
        ("Delete", "Excluir"),
        ("Next", "Próximo"),
        ("Prev", "Anterior"),
        ("Yes", "Sim"),
        ("No", "Não"),
        ("Open", "Abrir"),
        ("Close", "Fechar"),
        ("Add", "Adicionar"),
        ("Remove", "Remover"),
        ("Submit", "Enviar"),
        ("Family", "Família"),
        ("Weight", "Espessura"),
        ("Slant", "Estilo"),
        ("Effects", "Efeitos"),
        ("Preview", "Visualizar"),
        ("Size", "Tamanho"),
        ("Should be of data type", "Deve ser do tipo de dados"),
        ("Invalid data type", "Tipo de dados inválido"),
        ("Number cannot be greater than", "O número não deve ser maior que"),
        ("Number cannot be less than", "O número não deve ser menor que"),
        ("Select an item from the list", "Selecionar um item da lista"),
        ("Out of range", "Fora do limite"),
        ("Previous", "Anterior"),
        (
            "The quick brown fox jumps over the lazy dog.",
            "A rápida raposa marrom pula sobre o cachorro preguiçoso.",
        ),
        ("Font Selector", "Seletor de Fontes"),
        ("normal", "normal"),
        ("bold", "negrito"),
        ("roman", "romano"),
        ("italic", "itálico"),
        ("underline", "sublinhado"),
        ("overstrike", "taxado"),
        ("Color Chooser", "Seletor de Cores"),
        ("Advanced", "Avançado"),
        ("Themed", "Tema"),
        ("Standard", "Básicas"),
        ("Current", "Atual"),
        ("New", "Nova"),
        ("Hue", "Matiz"),
        ("Sat", "Sat"),
        ("Lum", "Lum"),
        ("Hex", "Hex"),
        ("Red", "Vermelho"),
        ("Green", "Verde"),
        ("Blue", "Azul"),
        ("color dropper", "Selecionador de cores (conta-gotas)"),
        ("Cancel", "Cancelar"),
        ("Search", "Buscar"),
        ("Page", "Página"),
        ("of", "de"),
        ("⎌", "↺"),
        ("Reset table", "Resetar Tabela"),
        ("Columns", "Colunas"),
        ("Move", "Mover"),
        ("Align", "Alinhar"),
        ("Hide column", "Ocultar coluna"),
        ("Delete column", "Excluir coluna"),
        ("Show All", "Exibir todas"),
        ("Move to left", "Mover para esquerda"),
        ("Move to right", "Mover para direira"),
        ("Move to first", "Mover para o início"),
        ("Move to last", "Mover para o fim"),
        ("Align left", "Alinhar à esquerda"),
        ("Align center", "Alinhar ao centro"),
        ("Align right", "Alinhar à direita"),
        ("Sort", "Classificar"),
        ("Filter", "Filtrar"),
        ("Export", "Exportar"),
        ("Delete selected rows", "Excluir linhas selecionadas"),
        ("Sort Ascending", "Ordem crescente"),
        ("Sort Descending", "Ordem decrescente"),
        ("Clear filters", "Limpar filtros"),
        ("Filter by cell's value", "Filtrar pelo valor da célula"),
        ("Hide select rows", "Ocultar linha selecionada"),
        ("Show only select rows", "Exibir somente as linhas selecionadas"),
        ("Export all records", "Exportar todos os dados"),
        ("Export current page", "Exportar página atual"),
        ("Export current selection", "Exportar seleção atual"),
        ("Export records in filter", "Exportar dados do filtro"),
        ("Move up", "Mover para cima"),
        ("Move down", "Mover para baixo"),
        ("Move to top", "Mover para o início"),
        ("Move to bottom", "Mover para o fim"),
        ("Mo", "S"),
        ("Tu", "T"),
        ("We", "Q"),
        ("Th", "Q"),
        ("Fr", "S"),
        ("Sa", "S"),
        ("Su", "D"),
    )
)
MESSAGES.append(
    # CHINESE - CHINA translation
    LocaleMsgs(
        "zh_cn",
        ("&Abort", "&中止"),
        ("&About...", "&关于……"),
        ("All Files", "所有文件"),
        ("Application Error", "应用程序错误"),
        ("&Apply", "&添加"),
        ("Bold", "粗体"),
        ("Bold Italic", "加粗斜体"),
        ("&Blue", "&蓝色"),
        ("Cancel", "取消"),
        ("&Cancel", "&取消"),
        (
            r'Cannot change to the directory %1\$s.\nPermission denied.',
            r'无法更改目录 %1\$s。\n访问被拒绝。',
        ),
        ("Choose Directory", "选择文件夹"),
        ("Cl&ear", "清&除"),
        ("&Clear Console", "&清除终端"),
        ("Color", "颜色"),
        ("Console", "终端"),
        ("&Copy", "&复制"),
        ("Cu&t", "剪&切"),
        ("&Delete", "&删除"),
        ("Details >>", "详细信息 >>"),
        (r'Directory %1\$s does not exist.', r'目录 %1\$s 不存在。'),
        ("&Directory:", "&目录："),
        ("&Edit", "&编辑"),
        ("Effects", "效果"),
        (r"Error: %1\$s", r"错误： %1\$s"),
        ("E&xit", "退&出"),
        ("&File", "&文件"),
        (
            r'File %1\$s already exists.\nDo you want to overwrite it?',
            r'文件 %1\$s 已经存在。\n您想要覆盖它吗？',
        ),
        (r'File %1\$s already exists.\n\n', r'文件 %1\$s 已经存在。\n\n'),
        (r'File %1\$s does not exist.', r'文件 %1\$s 不存在。'),
        ("File &name:", "文件&名："),
        ("File &names:", "文件&名："),
        ("Files of &type:", "文件&类型："),
        ("Fi&les:", "文&件："),
        ("&Filter", "&过滤"),
        ("Fil&ter:", "过&滤："),
        ("Font", "字体"),
        ("&Font:", "&字体："),
        ("Font st&yle:", "字体&样式："),
        ("&Green", "&绿色"),
        ("&Help", "&帮助"),
        ("Hi", "你好"),
        ("&Hide Console", "&隐藏终端"),
        ("&Ignore", "&忽略"),
        (r'Invalid file name %1\$s.', r'无效的文件名 %1\$s。'),
        ("Italic", "斜体"),
        ("Log Files", "日志文件"),
        ("&No", "&取消"),
        ("No", "取消"),
        ("&OK", "&确定"),
        ("OK", "确定"),
        ("Ok", "确定"),
        ("Open", "打开"),
        ("&Open", "&打开"),
        ("Open Multiple Files", "打开多个文件"),
        ("P&aste", "粘&贴"),
        ("&Quit", "&退出"),
        ("&Red", "红色"),
        ("Regular", "规则"),
        ("Replace existing file?", "替换已有文件？"),
        ("&Retry", "&重试"),
        ("Sample", "样式"),
        ("&Save", "&保存"),
        ("Save As", "另存为"),
        ("Save To Log", "保存到日志"),
        ("Select Log File", "选择日志文件"),
        ("Select a file to source", "选择一个源文件"),
        ("&Selection:", "&选择："),
        ("&Size:", "&大小："),
        ("Show &Hidden Directories", "显示&隐藏目录"),
        ("Show &Hidden Files and Directories", "显示&隐藏文件和目录"),
        ("Skip Messages", "跳过信息"),
        ("&Source...", "&来源……"),
        ("Stri&keout", "删&除线"),
        ("Tcl Scripts", "Tcl脚本"),
        ("Tcl for Windows", "适用于Windows的Tcl"),
        ("Text Files", "文本文档"),
        ("&Underline", "&下划线"),
        ("&Yes", "&确定"),
        ("abort", "中止"),
        ("blue", "蓝色"),
        ("cancel", "取消"),
        ("extension", "拓展"),
        ("extensions", "拓展"),
        ("green", "绿色"),
        ("ignore", "忽略"),
        ("ok", "确定"),
        ("red", "红色"),
        ("retry", "重试"),
        ("Retry", "重试"),
        ("yes", "确认"),
        ("Yes", "确认"),
        ("Should be of data type", "应为数据类型"),
        ("Invalid data type", "无效数据类型"),
        ("Number cannot be greater than", "数字不能大于"),
        ("Out of range", "超出范围"),
        ("Submit", "提交"),
        ("Delete", "删除"),
        ("Next", "下一步"),
        ("Previous", "以前的"),
        ("Open", "打开"),
        ("Close", "关闭"),
        ("Add", "添加"),
        ("Remove", "移除"),
        ("Family", "组"),
        ("Weight", "重量"),
        ("Slant", "倾斜"),
        ("Effects", "效果"),
        ("Preview", "预览"),
        ("Size", "大小"),
        ("The quick brown fox jumps over the lazy dog.", "敏捷的棕色狐狸跳过懒惰的狗。"),
        ("Print", "输出"),
        ("Printer", "打印机"),
        ("Letter ", "信 "),
        ("Legal ", "合法的 "),
        ("A4", "A4"),
        ("Grayscale", "灰度"),
        ("RGB", "RGB"),
        ("Options", "设置"),
        ("Copies", "复制"),
        ("Paper", "纸"),
        ("Scale", "规模"),
        ("Orientation", "方向"),
        ("Portrait", "竖向"),
        ("Landscape", "横向"),
        ("Output", "输出"),
    )
)

MESSAGES.append(
    LocaleMsgs(
        # French
        "fr",
        ("OK", "OK"),
        ("Ok", "Ok"),
        ("Retry", "Recommencer"),
        ("Delete", "Supprimer"),
        ("Next", "Suivant"),
        ("Prev", "Préc."),
        ("Yes", "Oui"),
        ("No", "Non"),
        ("Open", "Ouvrir"),
        ("Close", "Fermer"),
        ("Add", "Ajouter"),
        ("Remove", "Supprimer"),
        ("Submit", "Envoyer"),
        ("Family", "Famille"),
        ("Weight", "Poids"),
        ("Slant", "Italique"),
        ("Effects", "Effets"),
        ("Preview", "Prévisualiser"),
        ("Size", "Taille"),
        ("Should be of data type", "Doit être du type de données"),
        ("Invalid data type", "Type de données invalide"),
        ("Number cannot be greater than",
         "Le nombre ne peut pas être plus grand que"),
        ("Number cannot be less than",
         "Le nombre ne peut pas être inférieur à"),
        ("Select an item from the list", "Sélectionner un élément de la liste"),
        ("Out of range", "Hors limites"),
        ("Previous", "Précédent"),
        ("The quick brown fox jumps over the lazy dog.",
         "The quick brown fox jumps over the lazy dog."),
        ("Font Selector", "Sélecteur de Polices"),
        ("normal", "normal"),
        ("bold", "gras"),
        ("roman", "roman"),
        ("italic", "italique"),
        ("underline", "souligné"),
        ("overstrike", "barré"),
        ("Color Chooser", "Sélecteur de couleur"),
        ("Advanced", "Avancé"),
        ("Themed", "Thème"),
        ("Standard", "Standard"),
        ("Current", "Courant"),
        ("New", "Nouveau"),
        ("Hue", "Teinte"),
        ("Sat", "Sat"),
        ("Lum", "Lum"),
        ("Hex", "Hex"),
        ("Red", "Rouge"),
        ("Green", "Vert"),
        ("Blue", "Bleu"),
        ("color dropper", "Sélecteur de couleurs"),
        ("Cancel", "Annuler"),
        ("Search", "Chercher"),
        ("Page", "Page"),
        ("of", "de"),
        ("⎌", "↺"),
        ("Reset table", "Réinit. table"),
        ("Columns", "Colonnes"),
        ("Move", "Déplacer"),
        ("Align", "Aligner"),
        ("Hide column", "Cacher la colonne"),
        ("Delete column", "Supprimer la colonne"),
        ("Show All", "Afficher tout"),
        ("Move to left", "Déplacer vers la gauche"),
        ("Move to right", "Déplacer vers la droite"),
        ("Move to first", "Déplacer en premier"),
        ("Move to last", "Déplacer en dernier"),
        ("Align left", "Aligner à gauche"),
        ("Align center", "Aligner au centre"),
        ("Align right", "Aligner à droite"),
        ("Sort", "Trier"),
        ("Filter", "Filtrer"),
        ("Export", "Exporter"),
        ("Delete selected rows", "Supprimer les lignes sélectionnées"),
        ("Sort Ascending", "Tri ascendant"),
        ("Sort Descending", "Tri descendant"),
        ("Clear filters", "Effacer les filtres"),
        ("Filter by cell's value", "Filtrer par valeur de cellules"),
        ("Hide select rows", "Cacher les lignes sélectionnées"),
        ("Show only select rows", "N’afficher que les lignes sélectionnées"),
        ("Export all records", "Exporter tous les enregistrements"),
        ("Export current page", "Exporter la page active"),
        ("Export current selection", "Exporter la sélection"),
        ("Export records in filter", "Exporter les enregistrements filtrés"),
        ("Move up", "Déplacer vers le haut"),
        ("Move down", "Déplacer vers le bas"),
        ("Move to top", "Déplacer en premier"),
        ("Move to bottom", "Déplacer en dernier"),
        ("Mo", "Lu"),
        ("Tu", "Ma"),
        ("We", "Me"),
        ("Th", "Je"),
        ("Fr", "Ve"),
        ("Sa", "Sa"),
        ("Su", "Di"),
    )
)

MESSAGES.append(
    # German translation
    LocaleMsgs(
        "de-de",
        ("OK", "OK"),
        ("Ok", "Ok"),
        ("Continue", "Weiter"),
        ("Retry", "Wiederholen"),
        ("Delete", "Löschen"),
        ("Next", "Nächster"),
        ("Prev", "Vorheriger"),
        ("Yes", "Ja"),
        ("No", "Nein"),
        ("Open", "Öffnen"),
        ("Close", "Schließen"),
        ("Add", "Hinzufügen"),
        ("Remove", "Löschen"),
        ("Submit", "Verwenden"),
        ("Family", "Familie"),
        ("Weight", "Bedeutung"),
        ("Slant", "Neigung"),
        ("Effects", "Effekte"),
        ("Preview", "Vorschau"),
        ("Size", "Größe"),
        ("Should be of data type", "Sollte vom Datentyp sein"),
        ("Invalid data type", "Falscher Datentyp"),
        ("Number cannot be greater than", "Zahl kann nicht größer sein als"),
        ("Number cannot be less than", "Zahl kann nicht kleiner sein als"),
        ("Select an item from the list", "Wähle ein Element aus der Liste"),
        ("Out of range", "Ausserhalb des Bereiches"),
        ("Previous", "Vorheriger"),
        ("The quick brown fox jumps over the lazy dog.",
         "The quick brown fox jumps over the lazy dog."),
        ("Font Selector", "Schriftfont Auswahl"),
        ("normal", "normal"),
        ("bold", "fett"),
        ("negrito", "schwarz"),
        ("roman", "Antiqua"),
        ("italic", "kursiv"),
        ("underline", "unterstrichen"),
        ("overstrike", "durchgestrichen"),
        ("Color Chooser", "Farbauswahl"),
        ("Advanced", "Erweitert"),
        ("Themed", "Themed"),
        ("Standard", "Standard"),
        ("Current", "Aktuell"),
        ("New", "Neu"),
        ("Hue", "Farbton"),
        ("Sat", "Sat"),
        ("Lum", "Lum"),
        ("Hex", "Hex"),
        ("Red", "Rot"),
        ("Green", "Grün"),
        ("Blue", "Blau"),
        ("color dropper", "Farbauswahl"),
        ("Cancel", "Abbrechen"),
        ("Search", "Suchen"),
        ("Page", "Seite"),
        ("of", "von"),
        ("⎌", "↺"),
        ("Reset table", "Tabelle zurücksetzen"),
        ("Columns", "Spalten"),
        ("Move", "Verschieben"),
        ("Align", "Ausrichten"),
        ("Hide column", "Spalte verbergen"),
        ("Delete column", "Spalte löschen"),
        ("Show All", "Alles anzeigen"),
        ("Move to left", "Verschiebe nach links"),
        ("Move to right", "Verschiebe nach rechts"),
        ("Move to first", "Verschiebe an den Anfang"),
        ("Move to last", "Verschiebe an das Ende"),
        ("Align left", "Links ausrichten"),
        ("Align center", "Zentrieren"),
        ("Align right", "Rechts ausrichten"),
        ("Sort", "Sortieren"),
        ("Filter", "Filtern"),
        ("Export", "Exportieren"),
        ("Delete selected rows", "Lösche ausgewählte Zeilen"),
        ("Sort Ascending", "Sortiere aufsteigend"),
        ("Sort Descending", "Sortiere absteigend"),
        ("Clear filters", "Filter löschen"),
        ("Filter by cell's value", "Filtern nach Zellinhalt"),
        ("Hide select rows", "Zeilen verbergen"),
        ("Show only select rows", "Nur ausgewählte Zeilen anzeigen"),
        ("Export all records", "Alle Daten exportieren"),
        ("Export current page", "Aktuelle Seite exportieren"),
        ("Export current selection", "Aktuelle Auswahl exportieren"),
        ("Export records in filter", "Alle gefilterten Daten exportieren"),
        ("Move up", "Nach oben verschieben"),
        ("Move down", "Nach unten verschieben"),
        ("Move to top", "An den Anfang verschieben"),
        ("Move to bottom", "An das Ende verschieben"),
        ("Mo", "Mo"),
        ("Tu", "Di"),
        ("We", "Mi"),
        ("Th", "Do"),
        ("Fr", "Fr"),
        ("Sa", "Sa"),
        ("Su", "So"),
    )
)

MESSAGES.append(
    # CHINESE - Taiwan translation
    LocaleMsgs(
        "zh_tw",
        ("&Abort", "中止(&A)"),
        ("&About...", "關於(&A)……"),
        ("&Apply", "套用(&A)"),
        ("&Blue", "藍色(&B)"),
        ("&Cancel", "取消(&C)"),
        ("&Clear Console", "清除終端(&C)"),
        ("&Copy", "複製(&C)"),
        ("&Delete", "刪除(&D)"),
        ("&Directory:", "目錄(&D)："),
        ("&Edit", "編輯(&E)"),
        ("&File", "文件(&F)"),
        ("&Filter", "過濾(&F)"),
        ("&Font:", "字體(&F)："),
        ("&Green", "綠色(&G)"),
        ("&Help", "幫助(&H)"),
        ("&Hide Console", "隱藏終端(&H)"),
        ("&Ignore", "忽略(&I)"),
        ("&No", "否(&N)"),
        ("&OK", "確定(&O)"),
        ("&Open", "打開(&O)"),
        ("&Quit", "退出(&Q)"),
        ("&Red", "紅色(&R)"),
        ("&Retry", "重試(&R)"),
        ("&Save", "儲存(&S)"),
        ("&Selection:", "選擇(&S)："),
        ("&Size:", "大小(&S)："),
        ("&Source...", "來源(&S)……"),
        ("&Underline", "底線(&U)"),
        ("&Yes", "確定(&Y)"),
        ("⎌", "↺"),
        ("A4", "A4"),
        ("abort", "中止"),
        ("Add", "新增"),
        ("Advanced", "進階"),
        ("Align", "對齊"),
        ("Align center", "置中"),
        ("Align left", "靠左對齊"),
        ("Align right", "靠右對齊"),
        ("All Files", "所有文件"),
        ("Application Error", "應用程式錯誤"),
        ("Blue", "藍色"),
        ("Bold", "粗體"),
        ("Bold Italic", "加粗斜體"),
        ("Cancel", "取消"),
        ("cancel", "取消"),
        (r"Cannot change to the directory %1\$s.\nPermission denied.",
         r"無法更改目錄 %1\$s。\n訪問被拒絕。"),
        ("Choose Directory", "選擇資料夾"),
        ("Cl&ear", "清除(&E)"),
        ("Clear filters", "Limpar filtros"),
        ("Close", "關閉"),
        ("Color", "顏色"),
        ("Color Chooser", "顏色挑選器"),
        ("color dropper", "顏色挑選器"),
        ("Columns", "欄"),
        ("Console", "終端"),
        ("Continue", "繼續"),
        ("Copies", "複製"),
        ("Cu&t", "剪&切"),
        ("Current", "目前"),
        ("Delete", "刪除"),
        ("Delete column", "刪除欄"),
        ("Delete selected rows", "刪除所選列"),
        ("Details >>", "詳細資訊 >>"),
        (r"Directory %1\$s does not exist.", r"目錄 %1\$s 不存在。"),
        ("E&xit", "退出(&X)"),
        ("Effects", "效果"),
        (r"Error: %1\$s", r"錯誤： %1\$s"),
        ("Export", "匯出"),
        ("Export all records", "匯出所有內容"),
        ("Export current page", "匯出目前頁面"),
        ("Export current selection", "匯出目前所選"),
        ("Export records in filter", "匯出篩選內容"),
        ("extension", "擴展"),
        ("extensions", "擴展"),
        ("Family", "組"),
        ("Fi&les:", "文件(&L)："),
        ("Fil&ter:", "過濾(&T)："),
        (r"File %1\$s already exists.\n\n", r"文件 %1\$s 已經存在。\n\n"),
        (r"File %1\$s already exists.\nDo you want to overwrite it?",
         r"文件 %1\$s 已經存在。\n您想要覆蓋它嗎？"),
        (r"File %1\$s does not exist.", r"文件 %1\$s 不存在。"),
        ("File &name:", "文件名(&N)："),
        ("File &names:", "文件名(&N)："),
        ("Files of &type:", "文件類型(&T)："),
        ("Filter", "篩選"),
        ("Filter by cell's value", "使用內容值篩選"),
        ("Font", "字體"),
        ("Font Selector", "字體選擇器"),
        ("Font st&yle:", "字體樣式(&Y)："),
        ("Fr", "五"),
        ("Grayscale", "灰度"),
        ("Green", "綠色"),
        ("Hex", "Hex"),
        ("Hi", "你好"),
        ("Hide column", "隱藏欄"),
        ("Hide select rows", "隱藏所選列"),
        ("Hue", "色相"),
        ("ignore", "忽略"),
        ("Invalid data type", "無效資料類型"),
        (r"Invalid file name %1\$s.", r"無效的檔案名 %1\$s。"),
        ("italic", "斜體"),
        ("Italic", "斜體"),
        ("Landscape", "橫向"),
        ("Legal ", "合法的 "),
        ("Letter ", "Letter"),
        ("Log Files", "日誌檔案"),
        ("Mo", "一"),
        ("Move", "移動"),
        ("Move down", "下移"),
        ("Move to bottom", "移至底部"),
        ("Move to first", "移至第一"),
        ("Move to last", "移至最後"),
        ("Move to left", "移至左側"),
        ("Move to right", "移至右側"),
        ("Move to top", "移至頂部"),
        ("Move up", "上移"),
        ("New", "新增"),
        ("Next", "下一步"),
        ("No", "否"),
        ("normal", "正常"),
        ("Number cannot be greater than", "數字不能大於"),
        ("of", "of"),
        ("OK", "確定"),
        ("Ok", "確定"),
        ("ok", "確定"),
        ("Open", "打開"),
        ("Open Multiple Files", "打開多個文件"),
        ("Options", "設定"),
        ("Orientation", "方向"),
        ("Out of range", "超出範圍"),
        ("Output", "輸出"),
        ("overstrike", "overstrike"),
        ("P&aste", "貼上(&A)"),
        ("Page", "頁數"),
        ("Paper", "紙"),
        ("Portrait", "豎向"),
        ("Prev", "上一步"),
        ("Preview", "預覽"),
        ("Previous", "以前的"),
        ("Print", "輸出"),
        ("Printer", "印表機"),
        ("Red", "紅色"),
        ("red", "紅色"),
        ("Regular", "規則"),
        ("Remove", "移除"),
        ("Replace existing file?", "取代已有文件？"),
        ("Reset table", "重設表格"),
        ("retry", "重試"),
        ("Retry", "重試"),
        ("RGB", "RGB"),
        ("roman", ""),
        ("Sa", "六"),
        ("Sample", "範本"),
        ("Save As", "另存新檔"),
        ("Save To Log", "儲存到日誌"),
        ("Scale", "規模"),
        ("Search", "搜尋"),
        ("Select a file to source", "選擇一個來源文件"),
        ("Select Log File", "選擇日誌檔案"),
        ("Should be of data type", "應為資料類型"),
        ("Show &Hidden Directories", "顯示隱藏目錄(&H)"),
        ("Show &Hidden Files and Directories", "顯示隱藏文件和目錄(&H)"),
        ("Show All", "顯示全部"),
        ("Show only select rows", "只顯示所選列"),
        ("Size", "大小"),
        ("Skip Messages", "跳過訊息"),
        ("Slant", "傾斜"),
        ("Sort", "排序"),
        ("Sort Ascending", "順序"),
        ("Sort Descending", "倒序"),
        ("Standard", "標準"),
        ("Stri&keout", "刪除線(&K)"),
        ("Su", "日"),
        ("Submit", "上傳"),
        ("Tcl for Windows", "適用於Windows的Tcl"),
        ("Tcl Scripts", "Tcl腳本"),
        ("Text Files", "文字文件"),
        ("Th", "四"),
        ("The quick brown fox jumps over the lazy dog.", "敏捷的棕色狐狸跳過懶惰的狗。"),
        ("Themed", "主題化"),
        ("Tu", "二"),
        ("underline", "底線"),
        ("We", "三"),
        ("Weight", "重量"),
        ("yes", "確認"),
        ("Yes", "確認"),
    )
)

MESSAGES.append(
    # Dutch translation (nl, nl_nl, nl_be)
    LocaleMsgs(
        "nl",
        ("OK", "OK"),
        ("Ok", "Ok"),
        ("Continue", "Verder"),
        ("Retry", "Herhalen"),
        ("Delete", "Verwijderen"),
        ("Next", "Volgende"),
        ("Prev", "Vorige"),
        ("Yes", "Ja"),
        ("No", "Nee"),
        ("Open", "Openen"),
        ("Close", "Sluiten"),
        ("Add", "Toevoegen"),
        ("Remove", "Verwijderen"),
        ("Submit", "OK"),
        ("Family", "Familie"),
        ("Weight", "Gewicht"),
        ("Slant", "Cursief"),
        ("Effects", "Effect"),
        ("Preview", "Voorbeeld"),
        ("Size", "Grootte"),
        ("Should be of data type", "Moet zijn van type"),
        ("Invalid data type", "Verkeerd type"),
        ("Number cannot be greater than", "Nummer kan niet groter zijn dan"),
        ("Number cannot be less than", "Nummer kan niet kleiner zijn dan"),
        ("Select an item from the list", "Kies een waarde uit de lijst"),
        ("Out of range", "Buiten bereik"),
        ("Previous", "Vorige"),
        ("The quick brown fox jumps over the lazy dog.",
         "The quick brown fox jumps over the lazy dog.\n"
         "Filmquiz bracht knappe ex-yogi van de wijs.\n"
         "Pa's wijze lynx bezag vroom het fikse aquaduct."),
        ("Font Selector", "Lettertypekeuze"),
        ("normal", "normaal"),
        ("bold", "vet"),
        ("negrito", "zwart"),
        ("roman", "normaal"),
        ("italic", "cursief"),
        ("underline", "onderstreept"),
        ("overstrike", "doorhalen"),
        ("Color Chooser", "Kleurkeuze"),
        ("Advanced", "Geavanceerd"),
        ("Themed", "Thema"),
        ("Standard", "Standaard"),
        ("Current", "Huidig"),
        ("New", "Nieuw"),
        ("Hue", "Tint"),
        ("Sat", "Verzadiging"),
        ("Lum", "Helderheid"),
        ("Hex", "Hex"),
        ("Red", "Rood"),
        ("Green", "Groen"),
        ("Blue", "Blauw"),
        ("color dropper", "Kleurenkiezer"),
        ("Cancel", "Annuleren"),
        ("Search", "Zoeken"),
        ("Page", "Pagina"),
        ("of", "van"),
        ("⎌", "⎌"),
        ("Reset table", "Tabel resetten"),
        ("Columns", "Kolommen"),
        ("Move", "Verplaatsen"),
        ("Align", "Uitlijnen"),
        ("Hide column", "Kolom verbergen"),
        ("Delete column", "Kolom verwijderen"),
        ("Show All", "Alle tonen"),
        ("Move to left", "Verplaats naar links"),
        ("Move to right", "Verplaats naar rechts"),
        ("Move to first", "Verplaats naar begin"),
        ("Move to last", "Verplaats naar eind"),
        ("Align left", "Links uitlijnen"),
        ("Align center", "Centreren"),
        ("Align right", "Rechts uitlijnen"),
        ("Sort", "Sorteren"),
        ("Filter", "Filteren"),
        ("Export", "Exporteren"),
        ("Delete selected rows", "Verwijder geselecteerde rijen"),
        ("Sort Ascending", "Sorteer oplopend"),
        ("Sort Descending", "Sorteer aflopend"),
        ("Clear filters", "Filters wissen"),
        ("Filter by cell's value", "Filteren op celinhoud"),
        ("Hide select rows", "Rijen verbergen"),
        ("Show only select rows", "Alleen geselecteerde rijen weergeven"),
        ("Export all records", "Alle data exporteren"),
        ("Export current page", "Huidige pagina exporteren"),
        ("Export current selection", "Huidge selectie exporteren"),
        ("Export records in filter", "Alle gefilterde data exporteren"),
        ("Move up", "Naar boven"),
        ("Move down", "Naar beneden"),
        ("Move to top", "Naar het begin"),
        ("Move to bottom", "Naar het eind"),
        ("Mo", "Ma"),
        ("Tu", "Di"),
        ("We", "Wo"),
        ("Th", "Do"),
        ("Fr", "Vr"),
        ("Sa", "Za"),
        ("Su", "Zo"),
    )
)

MESSAGES.append(
    # Japanese translation
    LocaleMsgs(
        "ja",
        ("OK", "OK"),
        ("Ok", "OK"),
        ("Retry", "再試行"),
        ("Delete", "削除"),
        ("Next", "次へ"),
        ("Prev", "前へ"),
        ("Yes", "はい"),
        ("No", "いいえ"),
        ("Open", "開く"),
        ("Close", "閉じる"),
        ("Add", "追加"),
        ("Remove", "削除"),
        ("Submit", "送信"),
        ("Family", "家族"),
        ("Weight", "重量"),
        ("Slant", "傾斜"),
        ("Effects", "効果"),
        ("Preview", "プレビュー"),
        ("Size", "サイズ"),
        ("Should be of data type", "データ型が一致しません"),
        ("Invalid data type", "無効なデータ型です"),
        ("Number cannot be greater than", "数値はこれより大きくできません"),
        ("Out of range", "範囲外です"),
        ("Previous", "前へ"),
        ("The quick brown fox jumps over the lazy dog.", "素早い茶色の狐はのろまな犬を飛び越える。"),
        ("Font Selector", "フォント選択"),
        ("normal", "標準"),
        ("bold", "太字"),
        ("negrito", "太字（太い）"),
        ("roman", "ローマ体"),
        ("italic", "イタリック体"),
        ("underline", "下線"),
        ("overstrike", "上線"),
        ("Color Chooser", "色選択"),
        ("Advanced", "詳細"),
        ("Themed", "テーマ"),
        ("Standard", "標準"),
        ("Current", "現在使用中"),
        ("New", "新規"),
        ("Hue", "色相"),
        ("Sat", "彩度"),
        ("Lum", "明度"),
        ("Hex", "16進数"),
        ("Red", "赤"),
        ("Green", "緑"),
        ("Blue", "青"),
        ("color dropper", "色選択ツール"),
        ("Cancel", "キャンセル"),
        ("Search", "検索"),
        ("Page", "ページ"),
        ("of", "の"),
        ("⎌", "⎌"),
        ("Reset table", "テーブルをリセット"),
        ("Columns", "列"),
        ("Move", "移動"),
        ("Align", "揃える"),
        ("Hide column", "列を非表示"),
        ("Delete column", "列を削除"),
        ("Show All", "すべて表示"),
        ("Move to left", "左に移動"),
        ("Move to right", "右に移動"),
        ("Move to first", "先頭へ移動"),
        ("Move to last", "最後へ移動"),
        ("Align left", "左揃え"),
        ("Align center", "中央揃え"),
        ("Align right", "右揃え"),
        ("Sort", "並べ替え"),
        ("Filter", "フィルター"),
        ("Export", "エクスポート"),
        ("Delete selected rows", "選択した行を削除"),
        ("Sort Ascending", "昇順で並べ替え"),
        ("Sort Descending", "降順で並べ替え"),
        ("Clear filters", "フィルターをクリア"),
        ("Filter by cell's value", "セルの値でフィルター"),
        ("Hide select rows", "選択した行を非表示"),
        ("Show only select rows", "選択した行のみを表示"),
        ("Export all records", "すべてのレコードをエクスポート"),
        ("Export current page", "現在のページをエクスポート"),
        ("Export current selection", "現在の選択範囲をエクスポート"),
        ("Export records in filter", "フィルター内のレコードをエクスポート"),
        ("Move up", "上へ移動"),
        ("Move down", "下へ移動"),
        ("Move to top", "先頭へ移動"),
        ("Move to bottom", "末尾へ移動"),
        ("Mo", "月"),
        ("Tu", "火"),
        ("We", "水"),
        ("Th", "木"),
        ("Fr", "金"),
        ("Sa", "土"),
        ("Su", "日"),
        (r"Cannot change to the directory %1\$s.\nPermission denied.", r"ディレクトリ %1\$s に変更できません。\nアクセスが拒否されました。"),
        (r"Directory %1\$s does not exist.", r"ディレクトリ %1\$s は存在しません。"),
        (r"Error: %1\$s", r"エラー: %1\$s"),
        (r"File %1\$s already exists.\n\n", r"ファイル %1\$s は既に存在します。\n\n"),
        (r"File %1\$s already exists.\nDo you want to overwrite it?", r"ファイル %1\$s は既に存在します。\n上書きしますか？"),
        (r"File %1\$s does not exist.", r"ファイル %1\$s は存在しません。"),
        (r"Invalid file name %1\$s.", r"無効なファイル名 %1\$s です。"),
        ("⎌", "⎌"),
        ("A4", "A4"),
        ("Abort", "中止"),
        ("abort", "中止"),
        ("About...", "について..."),
        ("Add", "追加"),
        ("Advanced", "高度な"),
        ("Align center", "中央揃え"),
        ("Align left", "左揃え"),
        ("Align right", "右揃え"),
        ("Align", "整列"),
        ("All Files", "すべてのファイル"),
        ("Application Error", "アプリケーションエラー"),
        ("Apply", "適用"),
        ("Blue", "青"),
        ("blue", "青"),
        ("Bold Italic", "太字イタリック"),
        ("bold", "太字"),
        ("Bold", "太字"),
        ("Cancel", "キャンセル"),
        ("cancel", "キャンセル"),
        ("Choose Directory", "ディレクトリを選択"),
        ("Clear Console", "コンソールをクリア"),
        ("Clear filters", "フィルターのクリア"),
        ("Clear", "クリア"),
        ("Close", "閉じる"),
        ("Color Chooser", "カラー選択"),
        ("color dropper", "カラースポイト"),
        ("Color", "カラー"),
        ("Columns", "列"),
        ("Console", "コンソール"),
        ("Continue", "続ける"),
        ("Copies", "コピー"),
        ("Copy", "コピー"),
        ("Current", "現在の"),
        ("Cut", "カット"),
        ("Delete column", "列の削除"),
        ("Delete selected rows", "選択行の削除"),
        ("Delete", "削除"),
        ("Details >>", "詳細 >>"),
        ("Directory:", "ディレクトリ:"),
        ("Edit", "編集"),
        ("Effects", "効果"),
        ("Exit", "終了"),
        ("Export all records", "すべての記録をエクスポート"),
        ("Export current page", "現在のページをエクスポート"),
        ("Export current selection", "現在の選択をエクスポート"),
        ("Export records in filter", "フィルタ内のレコードをエクスポート"),
        ("Export", "エクスポート"),
        ("extension", "エクステンション"),
        ("extensions", "拡張子"),
        ("Family", "家族"),
        ("File name:", "ファイル名:"),
        ("File names:", "ファイル名:"),
        ("File", "ファイル"),
        ("Files of type:", "タイプのファイル:"),
        ("Files:", "ファイル:"),
        ("Filter by cell's value", "セルの値でフィルタ"),
        ("Filter:", "フィルター:"),
        ("Filter", "フィルター"),
        ("Font Selector", "フォント選択"),
        ("Font style:", "フォントのスタイル:"),
        ("Font:", "フォント:"),
        ("Font", "フォント"),
        ("Fr", "金"),
        ("Grayscale", "グレースケール"),
        ("Green", "緑"),
        ("green", "緑"),
        ("Help", "ヘルプ"),
        ("Hex", "16進数"),
        ("Hi", "こんにちは"),
        ("Hide column", "列を隠す"),
        ("Hide Console", "コンソールの非表示"),
        ("Hide select rows", "選択行を隠す"),
        ("Hue", "色相"),
        ("Ignore", "無視"),
        ("ignore", "無視"),
        ("Invalid data type", "無効なデータ型"),
        ("italic", "イタリック体"),
        ("Italic", "イタリック体"),
        ("Landscape", "ランドスケープ"),
        ("Legal ", "リーガル "),
        ("Letter ", "レター "),
        ("Log Files", "ログファイル"),
        ("Lum", "明度"),
        ("Mo", "月"),
        ("Move down", "下に移動"),
        ("Move to bottom", "下に移動"),
        ("Move to first", "先頭に移動"),
        ("Move to last", "最後に移動"),
        ("Move to left", "左に移動"),
        ("Move to right", "右に移動"),
        ("Move to top", "上に移動"),
        ("Move up", "上に移動"),
        ("Move", "移動"),
        ("negrito", "太字（太い）"),
        ("New", "新しい"),
        ("Next", "次へ"),
        ("No", "いいえ"),
        ("normal", "正常"),
        ("Number cannot be greater than", "数値が"),
        ("Number cannot be less than", "を下回ることはできない"),
        ("of", "の"),
        ("OK", "OK"),
        ("Ok", "OK"),
        ("ok", "OK"),
        ("Open Multiple Files", "複数のファイルを開く"),
        ("Open", "開く"),
        ("Options", "オプション"),
        ("Orientation", "方向"),
        ("Out of range", "範囲外"),
        ("Output", "出力"),
        ("overstrike", "上線"),
        ("Page", "ページ"),
        ("Paper", "用紙"),
        ("Paste", "貼り付け"),
        ("Portrait", "ポートレート"),
        ("Prev", "前へ"),
        ("Preview", "プレビュー"),
        ("Previous", "前へ"),
        ("Print", "印刷"),
        ("Printer", "プリンター"),
        ("Quit", "終了"),
        ("Red", "赤"),
        ("red", "赤"),
        ("Regular", "レギュラー"),
        ("Remove", "削除"),
        ("Replace existing file?", "既存のファイルを置き換えるか？"),
        ("Reset table", "テーブルのリセット"),
        ("Retry", "再試行"),
        ("retry", "再試行"),
        ("RGB", "RGB"),
        ("roman", "ローマ字"),
        ("Sa", "土"),
        ("Sample", "サンプル"),
        ("Sat", "彩度"),
        ("Save As", "名前を付けて保存"),
        ("Save To Log", "ログに保存"),
        ("Save", "保存"),
        ("Scale", "スケール"),
        ("Search", "検索"),
        ("Select a file to source", "ソースとなるファイルを選択"),
        ("Select an item from the list", "リストから項目を選択"),
        ("Select Log File", "ログファイルを選択"),
        ("Selection:", "選択:"),
        ("Should be of data type", "データ型であること"),
        ("Show All", "すべて表示"),
        ("Show Hidden Directories", "隠しディレクトリの表示"),
        ("Show Hidden Files and Directories", "隠しファイルと隠しディレクトリの表示"),
        ("Show only select rows", "選択した行のみ表示"),
        ("Size:", "サイズ:"),
        ("Size", "サイズ"),
        ("Skip Messages", "メッセージのスキップ"),
        ("Slant", "斜め"),
        ("Sort Ascending", "昇順で並べ替え"),
        ("Sort Descending", "降順で並べ替え"),
        ("Sort", "並べ替え"),
        ("Source...", "ソース..."),
        ("Standard", "標準"),
        ("Strikeout", "ストライクアウト"),
        ("Su", "日"),
        ("Submit", "提出"),
        ("Tcl for Windows", "Windows用Tcl"),
        ("Tcl Scripts", "Tclスクリプト"),
        ("Text Files", "テキストファイル"),
        ("Th", "木"),
        ("The quick brown fox jumps over the lazy dog.", "素早い茶色の狐は怠け者の犬を飛び越える。"),
        ("Themed", "テーマ"),
        ("Tu", "火"),
        ("Underline", "下線"),
        ("underline", "下線"),
        ("We", "水"),
        ("Weight", "重量"),
        ("Yes", "はい"),
        ("yes", "はい"),
    )
)

MESSAGES.append(
    LocaleMsgs(
        # Slovenian
        "sl",
        ("&Abort", "&Prekini"),
        ("&About...", "&O..."),
        ("All Files", "Vse datoteke"),
        ("Application Error", "Napaka aplikacije"),
        ("&Apply", "&Uporabi"),
        ("Bold", "Krepko"),
        ("Bold Italic", "Krepko ležeče"),
        ("&Blue", "&Modra"),
        ("Cancel", "Prekliči"),
        ("&Cancel", "&Prekliči"),
        (
            r'Cannot change to the directory %1\$s.\nPermission denied.',
            r'Ne morem dostopati do mape %1\$s.\nDostop zavrnjen.',
        ),
        ("Choose Directory", "Izberi mapo"),
        ("Cl&ear", "Poč&isti"),
        ("&Clear Console", "&Počisti konzolo"),
        ("Color", "Barva"),
        ("Console", "Konzola"),
        ("&Copy", "&Kopiraj"),
        ("Cu&t", "&Izreži"),
        ("&Delete", "&Izbriši"),
        ("Details >>", "Podrobnosti >>"),
        (r'Directory  %1\$s does not exist.', r'Mapa %1\$s ne obstaja.'),
        ("&Directory:", "&Mapa:"),
        ("&Edit", "&Uredi"),
        ("Effects", "Učinki"),
        (r"Error: %1\$s", r"Napaka: %1\$s"),
        ("E&xit", "&Izhod"),
        ("&File", "&Datoteka"),
        (
            r'File %1\$s already exists.\nDo you want to overwrite it?',
            r'Datoteka %1\$s že obstaja.\nAli jo želite prepisati?',
        ),
        (r'File %1\$s already exists.\n\n', r'Datoteka %1\$s že obstaja.\n\n'),
        (r'File %1\$s does not exist.', r'Datoteka %1\$s ne obstaja.'),
        ("File &name:", "Ime &datoteke:"),
        ("File &names:", "Imena &datotek:"),
        ("Files of &type:", "Datoteke &vrste:"),
        ("Fi&les:", "&Datoteke:"),
        ("&Filter", "&Filter"),
        ("Fil&ter:", "&Filter:"),
        ("Font", "Pisava"),
        ("&Font:", "&Pisava:"),
        ("Font st&yle:", "&Slog pisave:"),
        ("&Green", "&Zelena"),
        ("&Help", "&Pomoč"),
        ("Hi", "Živjo"),
        ("&Hide Console", "&Skrij konzolo"),
        ("&Ignore", "&Prezri"),
        (r'Invalid file name %1\$s.', r'Neveljavno ime datoteke %1\$s.'),
        ("Italic", "Ležeče"),
        ("Log Files", "Dnevniške datoteke"),
        ("&No", "&Ne"),
        ("&OK", "&V redu"),
        ("OK", "V redu"),
        ("Ok", "V redu"),
        ("Open", "Odpri"),
        ("&Open", "&Odpri"),
        ("Open Multiple Files", "Odpri več datotek"),
        ("P&aste", "Pr&ilepi"),
        ("&Quit", "&Končaj"),
        ("&Red", "&Rdeča"),
        ("Regular", "Navadno"),
        ("Replace existing file?", "Zamenjaj obstoječo datoteko?"),
        ("&Retry", "&Poskusi znova"),
        ("Sample", "Vzorec"),
        ("&Save", "&Shrani"),
        ("Save As", "Shrani kot"),
        ("Save To Log", "Shrani v dnevnik"),
        ("Select Log File", "Izberi dnevniško datoteko"),
        ("Select a file to source", "Izberi datoteko za izvajanje"),
        ("&Selection:", "&Izbor:"),
        ("&Size:", "&Velikost:"),
        ("Show &Hidden Directories", "Prikaži &skrite mape"),
        ("Show &Hidden Files and Directories", "Prikaži &skrite datoteke in mape"),
        ("Skip Messages", "Preskoči sporočila"),
        ("&Source...,", "&Izvedi..."),
        ("Stri&keout", "Pr&ečrtano"),
        ("Tcl Scripts", "Tcl skripte"),
        ("Tcl for Windows", "Tcl za Windows"),
        ("Text Files", "Besedilne datoteke"),
        ("&Underline", "&Podčrtano"),
        ("&Yes", "&Da"),
        ("abort", "prekini"),
        ("blue", "modra"),
        ("cancel", "prekliči"),
        ("extension", "razširitev"),
        ("extensions", "razširitve"),
        ("green", "zelena"),
        ("ignore", "prezri"),
        ("ok", "v redu"),
        ("red", "rdeča"),
        ("retry", "poskusi znova"),
        ("yes", "da"),
        ("OK", "V redu"),
        ("Ok", "V redu"),
        ("Retry", "Poskusi znova"),
        ("Delete", "Izbriši"),
        ("Next", "Naslednji"),
        ("Prev", "Prejšnji"),
        ("Yes", "Da"),
        ("No", "Ne"),
        ("Open", "Odpri"),
        ("Close", "Zapri"),
        ("Add", "Dodaj"),
        ("Remove", "Odstrani"),
        ("Submit", "Pošlji"),
        ("Family", "Družina"),
        ("Size", "Velikost"),
        ("Should be of data type", "Mora biti podatkovnega tipa"),
        ("Invalid data type", "Neveljaven podatkovni tip"),
        ("Number cannot be greater than", "Število ne sme biti večje od"),
        ("Out of range", "Izven obsega"),
        ("Previous", "Prejšnji"),
        (
            "The quick brown fox jumps over the lazy dog.",
            "Hitra rjava lisica skače čez lenega psa.",
        ),
        ("Font Selector", "Izbirnik pisav"),
        ("normal", "normalno"),
        ("bold", "krepko"),
        ("roman", "rimski"),
        ("italic", "ležeče"),
        ("underline", "podčrtano"),
        ("overstrike", "prečrtano"),
        ("Color Chooser", "Izbirnik barv"),
        ("Advanced", "Napredno"),
        ("Themed", "Tematsko"),
        ("Standard", "Standardno"),
        ("Current", "Trenutno"),
        ("New", "Novo"),
        ("Hue", "Odtenek"),
        ("Sat", "Nasičenost"),
        ("Lum", "Svetlost"),
        ("Hex", "Heksadecimalno"),
        ("Red", "Rdeča"),
        ("Green", "Zelena"),
        ("Blue", "Modra"),
        ("color dropper", "kapalka za barve"),
        ("Cancel", "Prekliči"),
        ("Search", "Iskanje"),
        ("Page", "Stran"),
        ("of", "od"),
        ("⎌", "⎌"),
        ("Reset table", "Ponastavi tabelo"),
        ("Columns", "Stolpci"),
        ("Move", "Premakni"),
        ("Align", "Poravnaj"),
        ("Hide column", "Skrij stolpec"),
        ("Delete column", "Izbriši stolpec"),
        ("Show All", "Prikaži vse"),
        ("Move to left", "Premakni levo"),
        ("Move to right", "Premakni desno"),
        ("Move to first", "Premakni na prvo mesto"),
        ("Move to last", "Premakni na zadnje mesto"),
        ("Align left", "Poravnaj levo"),
        ("Align center", "Poravnaj na sredino"),
        ("Align right", "Poravnaj desno"),
        ("Sort", "Razvrsti"),
        ("Filter", "Filtriraj"),
        ("Export", "Izvozi"),
        ("Delete selected rows", "Izbriši izbrane vrstice"),
        ("Sort Ascending", "Razvrsti naraščajoče"),
        ("Sort Descending", "Razvrsti padajoče"),
        ("Clear filters", "Počisti filtre"),
        ("Filter by cell’s value", "Filtriraj po vrednosti celice"),
        ("Hide select rows", "Skrij izbrane vrstice"),
        ("Show only select rows", "Prikaži samo izbrane vrstice"),
        ("Export all records", "Izvozi vse zapise"),
        ("Export current page", "Izvozi trenutno stran"),
        ("Export current selection", "Izvozi trenutno izbiro"),
        ("Export records in filter", "Izvozi zapise v filtru"),
        ("Move up", "Premakni gor"),
        ("Move down", "Premakni dol"),
        ("Move to top", "Premakni na vrh"),
        ("Move to bottom", "Premakni na dno"),
        ("Mo", "Pon"),
        ("Tu", "Tor"),
        ("We", "Sre"),
        ("Th", "Čet"),
        ("Fr", "Pet"),
        ("Sa", "Sob"),
        ("Su", "Ned"),
    )
)
