<a id="mypy-boto3-s3"></a>

# mypy-boto3-s3

[![PyPI - mypy-boto3-s3](https://img.shields.io/pypi/v/mypy-boto3-s3.svg?color=blue)](https://pypi.org/project/mypy-boto3-s3)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-s3.svg?color=blue)](https://pypi.org/project/mypy-boto3-s3)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-s3?color=blue)](https://pypistats.org/packages/mypy-boto3-s3)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.S3 1.20.49](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/s3.html#S3)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.4.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-s3 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-s3](#mypy-boto3-s3)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
    - [From conda-forge](#from-conda-forge)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `S3`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `S3` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[s3]'

# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[s3]'

# standalone installation
python -m pip install mypy-boto3-s3
```

<a id="from-conda-forge"></a>

### From conda-forge

Installing `mypy-boto3-s3` from the `conda-forge` channel can be achieved by
adding `conda-forge` to your channels with:

```bash
conda config --add channels conda-forge
conda config --set channel_priority strict
```

Once the `conda-forge` channel has been enabled, `mypy-boto3-s3` can be
installed with:

```bash
conda install mypy-boto3-s3
```

It is possible to list all of the versions of `mypy-boto3-s3` available on your
platform with:

```bash
conda search mypy-boto3-s3 --channel conda-forge
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[s3]` in your environment:
  `python -m pip install 'boto3-stubs[s3]'`

Both type checking and auto-complete should work for `S3` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto3-stubs[s3]` in your environment:
  `python -m pip install 'boto3-stubs[s3]'`

Both type checking and auto-complete should work for `S3` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[s3]` in your environment:
  `python -m pip install 'boto3-stubs[s3]'`
- Run `mypy` as usual

Type checking should work for `S3` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto3-stubs[s3]` in your environment:
  `python -m pip install 'boto3-stubs[s3]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `S3` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`S3Client` provides annotations for `boto3.client("s3")`.

```python
from boto3.session import Session

from mypy_boto3_s3 import S3Client

client: S3Client = Session().client("s3")

# now client usage is checked by mypy and IDE should provide code auto-complete
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_s3.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_s3 import S3Client
from mypy_boto3_s3.paginator import (
    ListMultipartUploadsPaginator,
    ListObjectVersionsPaginator,
    ListObjectsPaginator,
    ListObjectsV2Paginator,
    ListPartsPaginator,
)

client: S3Client = Session().client("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_multipart_uploads_paginator: ListMultipartUploadsPaginator = client.get_paginator("list_multipart_uploads")
list_object_versions_paginator: ListObjectVersionsPaginator = client.get_paginator("list_object_versions")
list_objects_paginator: ListObjectsPaginator = client.get_paginator("list_objects")
list_objects_v2_paginator: ListObjectsV2Paginator = client.get_paginator("list_objects_v2")
list_parts_paginator: ListPartsPaginator = client.get_paginator("list_parts")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_s3.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_s3 import S3Client
from mypy_boto3_s3.waiter import (
    BucketExistsWaiter,
    BucketNotExistsWaiter,
    ObjectExistsWaiter,
    ObjectNotExistsWaiter,
)

client: S3Client = Session().client("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bucket_exists_waiter: BucketExistsWaiter = client.get_waiter("bucket_exists")
bucket_not_exists_waiter: BucketNotExistsWaiter = client.get_waiter("bucket_not_exists")
object_exists_waiter: ObjectExistsWaiter = client.get_waiter("object_exists")
object_not_exists_waiter: ObjectNotExistsWaiter = client.get_waiter("object_not_exists")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`S3ServiceResource` provides annotations for `boto3.resource("s3")`.

```python
from boto3.session import Session

from mypy_boto3_s3 import S3ServiceResource

resource: S3ServiceResource = Session().resource("s3")

# now resource usage is checked by mypy and IDE should provide code auto-complete
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_s3.service_resource` module contains type annotations for all
resources.

```python
from boto3.session import Session

from mypy_boto3_s3 import S3ServiceResource
from mypy_boto3_s3.service_resource import (
    Bucket,
    BucketAcl,
    BucketCors,
    BucketLifecycle,
    BucketLifecycleConfiguration,
    BucketLogging,
    BucketNotification,
    BucketPolicy,
    BucketRequestPayment,
    BucketTagging,
    BucketVersioning,
    BucketWebsite,
    MultipartUpload,
    MultipartUploadPart,
    Object,
    ObjectAcl,
    ObjectSummary,
    ObjectVersion,
)

resource: S3ServiceResource = Session().resource("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_bucket: Bucket = resource.Bucket(...)
my_bucket_acl: BucketAcl = resource.BucketAcl(...)
my_bucket_cors: BucketCors = resource.BucketCors(...)
my_bucket_lifecycle: BucketLifecycle = resource.BucketLifecycle(...)
my_bucket_lifecycle_configuration: BucketLifecycleConfiguration = resource.BucketLifecycleConfiguration(...)
my_bucket_logging: BucketLogging = resource.BucketLogging(...)
my_bucket_notification: BucketNotification = resource.BucketNotification(...)
my_bucket_policy: BucketPolicy = resource.BucketPolicy(...)
my_bucket_request_payment: BucketRequestPayment = resource.BucketRequestPayment(...)
my_bucket_tagging: BucketTagging = resource.BucketTagging(...)
my_bucket_versioning: BucketVersioning = resource.BucketVersioning(...)
my_bucket_website: BucketWebsite = resource.BucketWebsite(...)
my_multipart_upload: MultipartUpload = resource.MultipartUpload(...)
my_multipart_upload_part: MultipartUploadPart = resource.MultipartUploadPart(...)
my_object: Object = resource.Object(...)
my_object_acl: ObjectAcl = resource.ObjectAcl(...)
my_object_summary: ObjectSummary = resource.ObjectSummary(...)
my_object_version: ObjectVersion = resource.ObjectVersion(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_s3.service_resource` module contains type annotations for all
`S3ServiceResource` collections.

```python
from boto3.session import Session

from mypy_boto3_s3 import S3ServiceResource
from mypy_boto3_s3.service_resource import (
    ServiceResourceBucketsCollection,
)

resource: S3ServiceResource = Session().resource("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
buckets: s3_resources.ServiceResourceBucketsCollection = resource.buckets
```

<a id="literals"></a>

### Literals

`mypy_boto3_s3.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_s3.literals import (
    AnalyticsS3ExportFileFormatType,
    ArchiveStatusType,
    BucketAccelerateStatusType,
    BucketCannedACLType,
    BucketExistsWaiterName,
    BucketLocationConstraintType,
    BucketLogsPermissionType,
    BucketNotExistsWaiterName,
    BucketVersioningStatusType,
    CompressionTypeType,
    DeleteMarkerReplicationStatusType,
    EncodingTypeType,
    EventType,
    ExistingObjectReplicationStatusType,
    ExpirationStatusType,
    ExpressionTypeType,
    FileHeaderInfoType,
    FilterRuleNameType,
    IntelligentTieringAccessTierType,
    IntelligentTieringStatusType,
    InventoryFormatType,
    InventoryFrequencyType,
    InventoryIncludedObjectVersionsType,
    InventoryOptionalFieldType,
    JSONTypeType,
    ListMultipartUploadsPaginatorName,
    ListObjectVersionsPaginatorName,
    ListObjectsPaginatorName,
    ListObjectsV2PaginatorName,
    ListPartsPaginatorName,
    MFADeleteStatusType,
    MFADeleteType,
    MetadataDirectiveType,
    MetricsStatusType,
    ObjectCannedACLType,
    ObjectExistsWaiterName,
    ObjectLockEnabledType,
    ObjectLockLegalHoldStatusType,
    ObjectLockModeType,
    ObjectLockRetentionModeType,
    ObjectNotExistsWaiterName,
    ObjectOwnershipType,
    ObjectStorageClassType,
    ObjectVersionStorageClassType,
    OwnerOverrideType,
    PayerType,
    PermissionType,
    ProtocolType,
    QuoteFieldsType,
    ReplicaModificationsStatusType,
    ReplicationRuleStatusType,
    ReplicationStatusType,
    ReplicationTimeStatusType,
    RequestChargedType,
    RequestPayerType,
    RestoreRequestTypeType,
    ServerSideEncryptionType,
    SseKmsEncryptedObjectsStatusType,
    StorageClassAnalysisSchemaVersionType,
    StorageClassType,
    TaggingDirectiveType,
    TierType,
    TransitionStorageClassType,
    TypeType,
    ServiceName,
    PaginatorName,
    WaiterName,
)

def check_value(value: AnalyticsS3ExportFileFormatType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_s3.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_s3.type_defs import (
    AbortIncompleteMultipartUploadTypeDef,
    AbortMultipartUploadOutputTypeDef,
    AbortMultipartUploadRequestMultipartUploadTypeDef,
    AbortMultipartUploadRequestRequestTypeDef,
    AccelerateConfigurationTypeDef,
    AccessControlPolicyTypeDef,
    AccessControlTranslationTypeDef,
    AnalyticsAndOperatorTypeDef,
    AnalyticsConfigurationTypeDef,
    AnalyticsExportDestinationTypeDef,
    AnalyticsFilterTypeDef,
    AnalyticsS3BucketDestinationTypeDef,
    BucketCopyRequestTypeDef,
    BucketDownloadFileRequestTypeDef,
    BucketDownloadFileobjRequestTypeDef,
    BucketLifecycleConfigurationTypeDef,
    BucketLoggingStatusTypeDef,
    BucketObjectRequestTypeDef,
    BucketTypeDef,
    BucketUploadFileRequestTypeDef,
    BucketUploadFileobjRequestTypeDef,
    CORSConfigurationTypeDef,
    CORSRuleTypeDef,
    CSVInputTypeDef,
    CSVOutputTypeDef,
    ClientCopyRequestTypeDef,
    ClientDownloadFileRequestTypeDef,
    ClientDownloadFileobjRequestTypeDef,
    ClientGeneratePresignedPostRequestTypeDef,
    ClientUploadFileRequestTypeDef,
    ClientUploadFileobjRequestTypeDef,
    CloudFunctionConfigurationTypeDef,
    CommonPrefixTypeDef,
    CompleteMultipartUploadOutputTypeDef,
    CompleteMultipartUploadRequestMultipartUploadTypeDef,
    CompleteMultipartUploadRequestRequestTypeDef,
    CompletedMultipartUploadTypeDef,
    CompletedPartTypeDef,
    ConditionTypeDef,
    CopyObjectOutputTypeDef,
    CopyObjectRequestObjectSummaryTypeDef,
    CopyObjectRequestObjectTypeDef,
    CopyObjectRequestRequestTypeDef,
    CopyObjectResultTypeDef,
    CopyPartResultTypeDef,
    CopySourceTypeDef,
    CreateBucketConfigurationTypeDef,
    CreateBucketOutputTypeDef,
    CreateBucketRequestBucketTypeDef,
    CreateBucketRequestRequestTypeDef,
    CreateBucketRequestServiceResourceTypeDef,
    CreateMultipartUploadOutputTypeDef,
    CreateMultipartUploadRequestObjectSummaryTypeDef,
    CreateMultipartUploadRequestObjectTypeDef,
    CreateMultipartUploadRequestRequestTypeDef,
    DefaultRetentionTypeDef,
    DeleteBucketAnalyticsConfigurationRequestRequestTypeDef,
    DeleteBucketCorsRequestBucketCorsTypeDef,
    DeleteBucketCorsRequestRequestTypeDef,
    DeleteBucketEncryptionRequestRequestTypeDef,
    DeleteBucketIntelligentTieringConfigurationRequestRequestTypeDef,
    DeleteBucketInventoryConfigurationRequestRequestTypeDef,
    DeleteBucketLifecycleRequestBucketLifecycleConfigurationTypeDef,
    DeleteBucketLifecycleRequestBucketLifecycleTypeDef,
    DeleteBucketLifecycleRequestRequestTypeDef,
    DeleteBucketMetricsConfigurationRequestRequestTypeDef,
    DeleteBucketOwnershipControlsRequestRequestTypeDef,
    DeleteBucketPolicyRequestBucketPolicyTypeDef,
    DeleteBucketPolicyRequestRequestTypeDef,
    DeleteBucketReplicationRequestRequestTypeDef,
    DeleteBucketRequestBucketTypeDef,
    DeleteBucketRequestRequestTypeDef,
    DeleteBucketTaggingRequestBucketTaggingTypeDef,
    DeleteBucketTaggingRequestRequestTypeDef,
    DeleteBucketWebsiteRequestBucketWebsiteTypeDef,
    DeleteBucketWebsiteRequestRequestTypeDef,
    DeleteMarkerEntryTypeDef,
    DeleteMarkerReplicationTypeDef,
    DeleteObjectOutputTypeDef,
    DeleteObjectRequestObjectSummaryTypeDef,
    DeleteObjectRequestObjectTypeDef,
    DeleteObjectRequestObjectVersionTypeDef,
    DeleteObjectRequestRequestTypeDef,
    DeleteObjectTaggingOutputTypeDef,
    DeleteObjectTaggingRequestRequestTypeDef,
    DeleteObjectsOutputTypeDef,
    DeleteObjectsRequestBucketTypeDef,
    DeleteObjectsRequestRequestTypeDef,
    DeletePublicAccessBlockRequestRequestTypeDef,
    DeleteTypeDef,
    DeletedObjectTypeDef,
    DestinationTypeDef,
    EncryptionConfigurationTypeDef,
    EncryptionTypeDef,
    ErrorDocumentResponseMetadataTypeDef,
    ErrorDocumentTypeDef,
    ErrorTypeDef,
    ExistingObjectReplicationTypeDef,
    FilterRuleTypeDef,
    GetBucketAccelerateConfigurationOutputTypeDef,
    GetBucketAccelerateConfigurationRequestRequestTypeDef,
    GetBucketAclOutputTypeDef,
    GetBucketAclRequestRequestTypeDef,
    GetBucketAnalyticsConfigurationOutputTypeDef,
    GetBucketAnalyticsConfigurationRequestRequestTypeDef,
    GetBucketCorsOutputTypeDef,
    GetBucketCorsRequestRequestTypeDef,
    GetBucketEncryptionOutputTypeDef,
    GetBucketEncryptionRequestRequestTypeDef,
    GetBucketIntelligentTieringConfigurationOutputTypeDef,
    GetBucketIntelligentTieringConfigurationRequestRequestTypeDef,
    GetBucketInventoryConfigurationOutputTypeDef,
    GetBucketInventoryConfigurationRequestRequestTypeDef,
    GetBucketLifecycleConfigurationOutputTypeDef,
    GetBucketLifecycleConfigurationRequestRequestTypeDef,
    GetBucketLifecycleOutputTypeDef,
    GetBucketLifecycleRequestRequestTypeDef,
    GetBucketLocationOutputTypeDef,
    GetBucketLocationRequestRequestTypeDef,
    GetBucketLoggingOutputTypeDef,
    GetBucketLoggingRequestRequestTypeDef,
    GetBucketMetricsConfigurationOutputTypeDef,
    GetBucketMetricsConfigurationRequestRequestTypeDef,
    GetBucketNotificationConfigurationRequestRequestTypeDef,
    GetBucketOwnershipControlsOutputTypeDef,
    GetBucketOwnershipControlsRequestRequestTypeDef,
    GetBucketPolicyOutputTypeDef,
    GetBucketPolicyRequestRequestTypeDef,
    GetBucketPolicyStatusOutputTypeDef,
    GetBucketPolicyStatusRequestRequestTypeDef,
    GetBucketReplicationOutputTypeDef,
    GetBucketReplicationRequestRequestTypeDef,
    GetBucketRequestPaymentOutputTypeDef,
    GetBucketRequestPaymentRequestRequestTypeDef,
    GetBucketTaggingOutputTypeDef,
    GetBucketTaggingRequestRequestTypeDef,
    GetBucketVersioningOutputTypeDef,
    GetBucketVersioningRequestRequestTypeDef,
    GetBucketWebsiteOutputTypeDef,
    GetBucketWebsiteRequestRequestTypeDef,
    GetObjectAclOutputTypeDef,
    GetObjectAclRequestRequestTypeDef,
    GetObjectLegalHoldOutputTypeDef,
    GetObjectLegalHoldRequestRequestTypeDef,
    GetObjectLockConfigurationOutputTypeDef,
    GetObjectLockConfigurationRequestRequestTypeDef,
    GetObjectOutputTypeDef,
    GetObjectRequestObjectSummaryTypeDef,
    GetObjectRequestObjectTypeDef,
    GetObjectRequestObjectVersionTypeDef,
    GetObjectRequestRequestTypeDef,
    GetObjectRetentionOutputTypeDef,
    GetObjectRetentionRequestRequestTypeDef,
    GetObjectTaggingOutputTypeDef,
    GetObjectTaggingRequestRequestTypeDef,
    GetObjectTorrentOutputTypeDef,
    GetObjectTorrentRequestRequestTypeDef,
    GetPublicAccessBlockOutputTypeDef,
    GetPublicAccessBlockRequestRequestTypeDef,
    GlacierJobParametersTypeDef,
    GrantTypeDef,
    GranteeTypeDef,
    HeadBucketRequestRequestTypeDef,
    HeadObjectOutputTypeDef,
    HeadObjectRequestObjectVersionTypeDef,
    HeadObjectRequestRequestTypeDef,
    IndexDocumentResponseMetadataTypeDef,
    IndexDocumentTypeDef,
    InitiatorResponseMetadataTypeDef,
    InitiatorTypeDef,
    InputSerializationTypeDef,
    IntelligentTieringAndOperatorTypeDef,
    IntelligentTieringConfigurationTypeDef,
    IntelligentTieringFilterTypeDef,
    InventoryConfigurationTypeDef,
    InventoryDestinationTypeDef,
    InventoryEncryptionTypeDef,
    InventoryFilterTypeDef,
    InventoryS3BucketDestinationTypeDef,
    InventoryScheduleTypeDef,
    JSONInputTypeDef,
    JSONOutputTypeDef,
    LambdaFunctionConfigurationTypeDef,
    LifecycleConfigurationTypeDef,
    LifecycleExpirationTypeDef,
    LifecycleRuleAndOperatorTypeDef,
    LifecycleRuleFilterTypeDef,
    LifecycleRuleTypeDef,
    ListBucketAnalyticsConfigurationsOutputTypeDef,
    ListBucketAnalyticsConfigurationsRequestRequestTypeDef,
    ListBucketIntelligentTieringConfigurationsOutputTypeDef,
    ListBucketIntelligentTieringConfigurationsRequestRequestTypeDef,
    ListBucketInventoryConfigurationsOutputTypeDef,
    ListBucketInventoryConfigurationsRequestRequestTypeDef,
    ListBucketMetricsConfigurationsOutputTypeDef,
    ListBucketMetricsConfigurationsRequestRequestTypeDef,
    ListBucketsOutputTypeDef,
    ListMultipartUploadsOutputTypeDef,
    ListMultipartUploadsRequestRequestTypeDef,
    ListObjectVersionsOutputTypeDef,
    ListObjectVersionsRequestRequestTypeDef,
    ListObjectsOutputTypeDef,
    ListObjectsRequestRequestTypeDef,
    ListObjectsV2OutputTypeDef,
    ListObjectsV2RequestRequestTypeDef,
    ListPartsOutputTypeDef,
    ListPartsRequestRequestTypeDef,
    LoggingEnabledResponseMetadataTypeDef,
    LoggingEnabledTypeDef,
    MetadataEntryTypeDef,
    MetricsAndOperatorTypeDef,
    MetricsConfigurationTypeDef,
    MetricsFilterTypeDef,
    MetricsTypeDef,
    MultipartUploadPartRequestTypeDef,
    MultipartUploadTypeDef,
    NoncurrentVersionExpirationTypeDef,
    NoncurrentVersionTransitionTypeDef,
    NotificationConfigurationDeprecatedResponseMetadataTypeDef,
    NotificationConfigurationDeprecatedTypeDef,
    NotificationConfigurationFilterTypeDef,
    NotificationConfigurationResponseMetadataTypeDef,
    NotificationConfigurationTypeDef,
    ObjectCopyRequestTypeDef,
    ObjectDownloadFileRequestTypeDef,
    ObjectDownloadFileobjRequestTypeDef,
    ObjectIdentifierTypeDef,
    ObjectLockConfigurationTypeDef,
    ObjectLockLegalHoldTypeDef,
    ObjectLockRetentionTypeDef,
    ObjectLockRuleTypeDef,
    ObjectMultipartUploadRequestTypeDef,
    ObjectSummaryMultipartUploadRequestTypeDef,
    ObjectSummaryVersionRequestTypeDef,
    ObjectTypeDef,
    ObjectUploadFileRequestTypeDef,
    ObjectUploadFileobjRequestTypeDef,
    ObjectVersionRequestTypeDef,
    ObjectVersionTypeDef,
    OutputLocationTypeDef,
    OutputSerializationTypeDef,
    OwnerResponseMetadataTypeDef,
    OwnerTypeDef,
    OwnershipControlsRuleTypeDef,
    OwnershipControlsTypeDef,
    PaginatorConfigTypeDef,
    PartTypeDef,
    PolicyStatusTypeDef,
    ProgressEventTypeDef,
    ProgressTypeDef,
    PublicAccessBlockConfigurationTypeDef,
    PutBucketAccelerateConfigurationRequestRequestTypeDef,
    PutBucketAclRequestBucketAclTypeDef,
    PutBucketAclRequestRequestTypeDef,
    PutBucketAnalyticsConfigurationRequestRequestTypeDef,
    PutBucketCorsRequestBucketCorsTypeDef,
    PutBucketCorsRequestRequestTypeDef,
    PutBucketEncryptionRequestRequestTypeDef,
    PutBucketIntelligentTieringConfigurationRequestRequestTypeDef,
    PutBucketInventoryConfigurationRequestRequestTypeDef,
    PutBucketLifecycleConfigurationRequestBucketLifecycleConfigurationTypeDef,
    PutBucketLifecycleConfigurationRequestRequestTypeDef,
    PutBucketLifecycleRequestBucketLifecycleTypeDef,
    PutBucketLifecycleRequestRequestTypeDef,
    PutBucketLoggingRequestBucketLoggingTypeDef,
    PutBucketLoggingRequestRequestTypeDef,
    PutBucketMetricsConfigurationRequestRequestTypeDef,
    PutBucketNotificationConfigurationRequestBucketNotificationTypeDef,
    PutBucketNotificationConfigurationRequestRequestTypeDef,
    PutBucketNotificationRequestRequestTypeDef,
    PutBucketOwnershipControlsRequestRequestTypeDef,
    PutBucketPolicyRequestBucketPolicyTypeDef,
    PutBucketPolicyRequestRequestTypeDef,
    PutBucketReplicationRequestRequestTypeDef,
    PutBucketRequestPaymentRequestBucketRequestPaymentTypeDef,
    PutBucketRequestPaymentRequestRequestTypeDef,
    PutBucketTaggingRequestBucketTaggingTypeDef,
    PutBucketTaggingRequestRequestTypeDef,
    PutBucketVersioningRequestBucketVersioningTypeDef,
    PutBucketVersioningRequestRequestTypeDef,
    PutBucketWebsiteRequestBucketWebsiteTypeDef,
    PutBucketWebsiteRequestRequestTypeDef,
    PutObjectAclOutputTypeDef,
    PutObjectAclRequestObjectAclTypeDef,
    PutObjectAclRequestRequestTypeDef,
    PutObjectLegalHoldOutputTypeDef,
    PutObjectLegalHoldRequestRequestTypeDef,
    PutObjectLockConfigurationOutputTypeDef,
    PutObjectLockConfigurationRequestRequestTypeDef,
    PutObjectOutputTypeDef,
    PutObjectRequestBucketTypeDef,
    PutObjectRequestObjectSummaryTypeDef,
    PutObjectRequestObjectTypeDef,
    PutObjectRequestRequestTypeDef,
    PutObjectRetentionOutputTypeDef,
    PutObjectRetentionRequestRequestTypeDef,
    PutObjectTaggingOutputTypeDef,
    PutObjectTaggingRequestRequestTypeDef,
    PutPublicAccessBlockRequestRequestTypeDef,
    QueueConfigurationDeprecatedTypeDef,
    QueueConfigurationTypeDef,
    RecordsEventTypeDef,
    RedirectAllRequestsToResponseMetadataTypeDef,
    RedirectAllRequestsToTypeDef,
    RedirectTypeDef,
    ReplicaModificationsTypeDef,
    ReplicationConfigurationTypeDef,
    ReplicationRuleAndOperatorTypeDef,
    ReplicationRuleFilterTypeDef,
    ReplicationRuleTypeDef,
    ReplicationTimeTypeDef,
    ReplicationTimeValueTypeDef,
    RequestPaymentConfigurationTypeDef,
    RequestProgressTypeDef,
    ResponseMetadataTypeDef,
    RestoreObjectOutputTypeDef,
    RestoreObjectRequestObjectSummaryTypeDef,
    RestoreObjectRequestObjectTypeDef,
    RestoreObjectRequestRequestTypeDef,
    RestoreRequestTypeDef,
    RoutingRuleTypeDef,
    RuleTypeDef,
    S3KeyFilterTypeDef,
    S3LocationTypeDef,
    SSEKMSTypeDef,
    ScanRangeTypeDef,
    SelectObjectContentEventStreamTypeDef,
    SelectObjectContentOutputTypeDef,
    SelectObjectContentRequestRequestTypeDef,
    SelectParametersTypeDef,
    ServerSideEncryptionByDefaultTypeDef,
    ServerSideEncryptionConfigurationTypeDef,
    ServerSideEncryptionRuleTypeDef,
    ServiceResourceBucketAclRequestTypeDef,
    ServiceResourceBucketCorsRequestTypeDef,
    ServiceResourceBucketLifecycleConfigurationRequestTypeDef,
    ServiceResourceBucketLifecycleRequestTypeDef,
    ServiceResourceBucketLoggingRequestTypeDef,
    ServiceResourceBucketNotificationRequestTypeDef,
    ServiceResourceBucketPolicyRequestTypeDef,
    ServiceResourceBucketRequestPaymentRequestTypeDef,
    ServiceResourceBucketRequestTypeDef,
    ServiceResourceBucketTaggingRequestTypeDef,
    ServiceResourceBucketVersioningRequestTypeDef,
    ServiceResourceBucketWebsiteRequestTypeDef,
    ServiceResourceMultipartUploadPartRequestTypeDef,
    ServiceResourceMultipartUploadRequestTypeDef,
    ServiceResourceObjectAclRequestTypeDef,
    ServiceResourceObjectRequestTypeDef,
    ServiceResourceObjectSummaryRequestTypeDef,
    ServiceResourceObjectVersionRequestTypeDef,
    SourceSelectionCriteriaTypeDef,
    SseKmsEncryptedObjectsTypeDef,
    StatsEventTypeDef,
    StatsTypeDef,
    StorageClassAnalysisDataExportTypeDef,
    StorageClassAnalysisTypeDef,
    TagTypeDef,
    TaggingTypeDef,
    TargetGrantTypeDef,
    TieringTypeDef,
    TopicConfigurationDeprecatedTypeDef,
    TopicConfigurationTypeDef,
    TransitionTypeDef,
    UploadPartCopyOutputTypeDef,
    UploadPartCopyRequestMultipartUploadPartTypeDef,
    UploadPartCopyRequestRequestTypeDef,
    UploadPartOutputTypeDef,
    UploadPartRequestMultipartUploadPartTypeDef,
    UploadPartRequestRequestTypeDef,
    VersioningConfigurationTypeDef,
    WaiterConfigTypeDef,
    WebsiteConfigurationTypeDef,
    WriteGetObjectResponseRequestRequestTypeDef,
)

def get_structure() -> AbortIncompleteMultipartUploadTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-s3` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-s3 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
