# Pull Request

## Description

Provide a clear and concise description of the changes introduced by this pull request. Include the problem addressed, the solution implemented, and any relevant context or background information.

## Type of Change

Please select the type of change that applies to this pull request:

- [ ] Bug fix (non-breaking change that resolves an issue)
- [ ] New feature (non-breaking change that adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update (improvements or additions to documentation)
- [ ] Performance improvement
- [ ] Code refactoring (no functional changes)
- [ ] Build/CI changes
- [ ] Other (please specify):

## Related Issues

List any related issues or tickets that are addressed by this pull request:

- Closes #
- Fixes #
- Related to #

## Changes Made

Provide a detailed list of the changes made:

-
-
-

## Testing

Describe the tests that have been performed to verify the changes. Include instructions for reproducing the issue and testing the fix or feature:

### Test Environment

- OS:
- Python version:
- Redis version:

### Test Cases
- [ ] Unit tests pass
- [ ] Integration tests pass
- [ ] Manual testing performed
- [ ] Performance testing (if applicable)
- [ ] Documentation builds correctly (`mkdocs build --strict`)

### Test Instructions

1.
2.
3.

## Documentation

- [ ] Code is properly documented with docstrings
- [ ] README.md updated (if applicable)
- [ ] API documentation updated (if applicable)
- [ ] Examples updated (if applicable)
- [ ] CHANGELOG.md updated

## Code Quality Checklist

- [ ] Code follows project coding standards
- [ ] Self-review of code completed
- [ ] Code is properly commented, particularly in complex areas
- [ ] No new linting warnings introduced
- [ ] Type hints added where appropriate
- [ ] Error handling implemented appropriately
- [ ] Documentation is accurate and up-to-date

## Breaking Changes

If this PR introduces breaking changes, please describe:

1. What functionality is affected
2. How users should migrate their code
3. Any deprecation notices required

## Performance Impact

- [ ] No performance impact expected
- [ ] Performance improvement expected
- [ ] Performance regression possible (please explain)

## Security Considerations

- [ ] No security implications
- [ ] Security review required
- [ ] Introduces new dependencies (list them)

## Screenshots/Visual Changes

If applicable, add screenshots or describe visual changes:

## Additional Information

Provide any additional information that may be relevant to this pull request, such as:
- Dependencies added or removed
- Configuration changes required
- Migration steps needed
- Known limitations or issues

## Reviewer Notes

Any specific areas you'd like reviewers to focus on:

-
-
-
