## What is Writer Framework?

Writer Framework is an open-source framework for creating AI applications. Build user interfaces using a visual editor; write the backend code in Python.

Writer Framework is fast and flexible with a clean, easily-testable syntax. It provides separation of concerns between UI and business logic, enabling more complex applications.

## Quick Start

### Installation

Writer Framework works on Linux, Mac, and Windows. It supports Python versions 3.9.2 through 3.12.

```sh
pip install writer
```

### Create and Run Your First App

```sh
# Create a demo app
writer hello

# Create a new app
writer create my_app

# Edit your app (opens visual editor)
writer edit my_app

# Run your app
writer run my_app
```

The `writer edit` command opens the visual editor in your browser where you can build your UI by dragging and dropping components.

## Documentation

For comprehensive guides, tutorials, and API reference, visit the [official documentation](https://dev.writer.com/framework/quickstart).

## Contributing

see [CONTRIBUTING.md](CONTRIBUTING.md)

## About Writer

Writer is the full-stack generative AI platform for enterprises. Quickly and easily build and deploy generative AI apps with a suite of developer tools fully integrated with our platform of LLMs, graph-based RAG tools, AI guardrails, and more. Learn more at [writer.com](https://www.writer.com?utm_source=github&utm_medium=readme&utm_campaign=framework).

## License

This project is licensed under the Apache 2.0 License.
