# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDBClusterLakeVersionsResult',
    'AwaitableGetDBClusterLakeVersionsResult',
    'get_db_cluster_lake_versions',
    'get_db_cluster_lake_versions_output',
]

@pulumi.output_type
class GetDBClusterLakeVersionsResult:
    """
    A collection of values returned by getDBClusterLakeVersions.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, output_file=None, page_number=None, page_size=None, resource_group_id=None, status=None, versions=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetDBClusterLakeVersionsVersionResult']:
        """
        A list of Adb Db Clusters. Each element contains the following attributes:
        """
        return pulumi.get(self, "versions")


class AwaitableGetDBClusterLakeVersionsResult(GetDBClusterLakeVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDBClusterLakeVersionsResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            resource_group_id=self.resource_group_id,
            status=self.status,
            versions=self.versions)


def get_db_cluster_lake_versions(enable_details: Optional[_builtins.bool] = None,
                                 ids: Optional[Sequence[_builtins.str]] = None,
                                 output_file: Optional[_builtins.str] = None,
                                 page_number: Optional[_builtins.int] = None,
                                 page_size: Optional[_builtins.int] = None,
                                 resource_group_id: Optional[_builtins.str] = None,
                                 status: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDBClusterLakeVersionsResult:
    """
    This data source provides the Adb DBCluster Lake Versions of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.190.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.adb.get_zones()
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=default.ids[0])
    default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("default",
        db_cluster_version="5.0",
        vpc_id=default_get_networks.ids[0],
        vswitch_id=default_get_switches.ids[0],
        zone_id=default.ids[0],
        compute_resource="16ACU",
        storage_resource="0ACU",
        payment_type="PayAsYouGo",
        enable_default_resource_group=False)
    ids = alicloud.adb.get_db_cluster_lake_versions_output(ids=[default_db_cluster_lake_version.id])
    pulumi.export("adbDbClusterLakeVersionId1", ids.versions[0].id)
    ```


    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of DBCluster IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str status: The status of the resource. Valid values: `Preparing`, `Creating`, `Restoring`, `Running`, `Deleting`, `ClassChanging`, `NetAddressCreating`, `NetAddressDeleting`.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:adb/getDBClusterLakeVersions:getDBClusterLakeVersions', __args__, opts=opts, typ=GetDBClusterLakeVersionsResult).value

    return AwaitableGetDBClusterLakeVersionsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        versions=pulumi.get(__ret__, 'versions'))
def get_db_cluster_lake_versions_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                        page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                        resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDBClusterLakeVersionsResult]:
    """
    This data source provides the Adb DBCluster Lake Versions of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.190.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.adb.get_zones()
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=default.ids[0])
    default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("default",
        db_cluster_version="5.0",
        vpc_id=default_get_networks.ids[0],
        vswitch_id=default_get_switches.ids[0],
        zone_id=default.ids[0],
        compute_resource="16ACU",
        storage_resource="0ACU",
        payment_type="PayAsYouGo",
        enable_default_resource_group=False)
    ids = alicloud.adb.get_db_cluster_lake_versions_output(ids=[default_db_cluster_lake_version.id])
    pulumi.export("adbDbClusterLakeVersionId1", ids.versions[0].id)
    ```


    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of DBCluster IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str status: The status of the resource. Valid values: `Preparing`, `Creating`, `Restoring`, `Running`, `Deleting`, `ClassChanging`, `NetAddressCreating`, `NetAddressDeleting`.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:adb/getDBClusterLakeVersions:getDBClusterLakeVersions', __args__, opts=opts, typ=GetDBClusterLakeVersionsResult)
    return __ret__.apply(lambda __response__: GetDBClusterLakeVersionsResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        status=pulumi.get(__response__, 'status'),
        versions=pulumi.get(__response__, 'versions')))
