# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HealthCheckTemplateArgs', 'HealthCheckTemplate']

@pulumi.input_type
class HealthCheckTemplateArgs:
    def __init__(__self__, *,
                 health_check_template_name: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a HealthCheckTemplate resource.
        :param pulumi.Input[_builtins.str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
               true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
               false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_codes: The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        :param pulumi.Input[_builtins.int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_host: The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        :param pulumi.Input[_builtins.str] health_check_http_version: The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        :param pulumi.Input[_builtins.int] health_check_interval: The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        :param pulumi.Input[_builtins.str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol used for the health check. Value:
               HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
               HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
               TCP: Sends a SYN handshake packet to check whether the server port is alive.
               gRPC: Check whether the server application is healthy by sending a POST or GET request.
        :param pulumi.Input[_builtins.int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        :param pulumi.Input[_builtins.int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_codes is not None:
            pulumi.set(__self__, "health_check_codes", health_check_codes)
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_host is not None:
            pulumi.set(__self__, "health_check_host", health_check_host)
        if health_check_http_version is not None:
            pulumi.set(__self__, "health_check_http_version", health_check_http_version)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "health_check_template_name")

    @health_check_template_name.setter
    def health_check_template_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "health_check_template_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request, value:
        true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
        false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckCodes")
    def health_check_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        """
        return pulumi.get(self, "health_check_codes")

    @health_check_codes.setter
    def health_check_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "health_check_codes", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        """
        return pulumi.get(self, "health_check_host")

    @health_check_host.setter
    def health_check_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_host", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        """
        return pulumi.get(self, "health_check_http_version")

    @health_check_http_version.setter
    def health_check_http_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_http_version", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_method", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_path", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol used for the health check. Value:
        HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
        HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
        TCP: Sends a SYN handshake packet to check whether the server port is alive.
        gRPC: Check whether the server application is healthy by sending a POST or GET request.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_protocol", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class _HealthCheckTemplateState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering HealthCheckTemplate resources.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
               true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
               false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_codes: The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        :param pulumi.Input[_builtins.int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_host: The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        :param pulumi.Input[_builtins.str] health_check_http_version: The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        :param pulumi.Input[_builtins.int] health_check_interval: The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        :param pulumi.Input[_builtins.str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol used for the health check. Value:
               HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
               HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
               TCP: Sends a SYN handshake packet to check whether the server port is alive.
               gRPC: Check whether the server application is healthy by sending a POST or GET request.
        :param pulumi.Input[_builtins.str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        :param pulumi.Input[_builtins.int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_codes is not None:
            pulumi.set(__self__, "health_check_codes", health_check_codes)
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_host is not None:
            pulumi.set(__self__, "health_check_host", health_check_host)
        if health_check_http_version is not None:
            pulumi.set(__self__, "health_check_http_version", health_check_http_version)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_template_name is not None:
            pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request, value:
        true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
        false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckCodes")
    def health_check_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        """
        return pulumi.get(self, "health_check_codes")

    @health_check_codes.setter
    def health_check_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "health_check_codes", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        """
        return pulumi.get(self, "health_check_host")

    @health_check_host.setter
    def health_check_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_host", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        """
        return pulumi.get(self, "health_check_http_version")

    @health_check_http_version.setter
    def health_check_http_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_http_version", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_method", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_path", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol used for the health check. Value:
        HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
        HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
        TCP: Sends a SYN handshake packet to check whether the server port is alive.
        gRPC: Check whether the server application is healthy by sending a POST or GET request.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_protocol", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "health_check_template_name")

    @health_check_template_name.setter
    def health_check_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_template_name", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.type_token("alicloud:alb/healthCheckTemplate:HealthCheckTemplate")
class HealthCheckTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Health Check Template resource.

        Health check template.

        For information about Application Load Balancer (ALB) Health Check Template and how to use it, see [What is Health Check Template](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createhealthchecktemplate).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.alb.HealthCheckTemplate("example", health_check_template_name=name)
        ```

        ## Import

        Application Load Balancer (ALB) Health Check Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/healthCheckTemplate:HealthCheckTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
               true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
               false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_codes: The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        :param pulumi.Input[_builtins.int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_host: The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        :param pulumi.Input[_builtins.str] health_check_http_version: The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        :param pulumi.Input[_builtins.int] health_check_interval: The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        :param pulumi.Input[_builtins.str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol used for the health check. Value:
               HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
               HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
               TCP: Sends a SYN handshake packet to check whether the server port is alive.
               gRPC: Check whether the server application is healthy by sending a POST or GET request.
        :param pulumi.Input[_builtins.str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        :param pulumi.Input[_builtins.int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HealthCheckTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Health Check Template resource.

        Health check template.

        For information about Application Load Balancer (ALB) Health Check Template and how to use it, see [What is Health Check Template](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createhealthchecktemplate).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.alb.HealthCheckTemplate("example", health_check_template_name=name)
        ```

        ## Import

        Application Load Balancer (ALB) Health Check Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/healthCheckTemplate:HealthCheckTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param HealthCheckTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HealthCheckTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HealthCheckTemplateArgs.__new__(HealthCheckTemplateArgs)

            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["health_check_codes"] = health_check_codes
            __props__.__dict__["health_check_connect_port"] = health_check_connect_port
            __props__.__dict__["health_check_host"] = health_check_host
            __props__.__dict__["health_check_http_version"] = health_check_http_version
            __props__.__dict__["health_check_interval"] = health_check_interval
            __props__.__dict__["health_check_method"] = health_check_method
            __props__.__dict__["health_check_path"] = health_check_path
            __props__.__dict__["health_check_protocol"] = health_check_protocol
            if health_check_template_name is None and not opts.urn:
                raise TypeError("Missing required property 'health_check_template_name'")
            __props__.__dict__["health_check_template_name"] = health_check_template_name
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            __props__.__dict__["healthy_threshold"] = healthy_threshold
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        super(HealthCheckTemplate, __self__).__init__(
            'alicloud:alb/healthCheckTemplate:HealthCheckTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_host: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_http_version: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_method: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_template_name: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None) -> 'HealthCheckTemplate':
        """
        Get an existing HealthCheckTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
               true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
               false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_codes: The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        :param pulumi.Input[_builtins.int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        :param pulumi.Input[_builtins.str] health_check_host: The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        :param pulumi.Input[_builtins.str] health_check_http_version: The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        :param pulumi.Input[_builtins.int] health_check_interval: The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        :param pulumi.Input[_builtins.str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        :param pulumi.Input[_builtins.str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol used for the health check. Value:
               HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
               HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
               TCP: Sends a SYN handshake packet to check whether the server port is alive.
               gRPC: Check whether the server application is healthy by sending a POST or GET request.
        :param pulumi.Input[_builtins.str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        :param pulumi.Input[_builtins.int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HealthCheckTemplateState.__new__(_HealthCheckTemplateState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["health_check_codes"] = health_check_codes
        __props__.__dict__["health_check_connect_port"] = health_check_connect_port
        __props__.__dict__["health_check_host"] = health_check_host
        __props__.__dict__["health_check_http_version"] = health_check_http_version
        __props__.__dict__["health_check_interval"] = health_check_interval
        __props__.__dict__["health_check_method"] = health_check_method
        __props__.__dict__["health_check_path"] = health_check_path
        __props__.__dict__["health_check_protocol"] = health_check_protocol
        __props__.__dict__["health_check_template_name"] = health_check_template_name
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["healthy_threshold"] = healthy_threshold
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        return HealthCheckTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request, value:
        true: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code DryRunOperation is returned.
        false (default): Sends a normal request, returns the http_2xx status code after the check, and directly performs the operation.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="healthCheckCodes")
    def health_check_codes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The HTTP code of the health check. The default value is http_2xx. The normal HTTP code for health check. Separate multiple codes with commas (,). Valid values: http_2xx, http_3xx, http_4xx, or http_5xx.
        """
        return pulumi.get(self, "health_check_codes")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> pulumi.Output[_builtins.int]:
        """
        The number of the port that is used for health checks.  Valid values: 0 to 65535.  Default value: 0. This value indicates that the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name that is used for health checks. Valid values:  $SERVER_IP (default value): The private IP addresses of backend servers. If the $_ip parameter is set or the HealthCheckHost parameter is not set, SLB uses the private IP addresses of backend servers as the domain names for health checks.  domain: The domain name must be 1 to 80 characters in length, and can contain only letters, digits, periods (.),and hyphens (-).
        """
        return pulumi.get(self, "health_check_host")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the HTTP protocol.  Valid values: HTTP 1.0 and HTTP 1.1.  Default value: HTTP 1.1.
        """
        return pulumi.get(self, "health_check_http_version")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> pulumi.Output[_builtins.int]:
        """
        The time interval between two consecutive health checks.  Valid values: 1 to 50. Unit: seconds.  Default value: 2.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> pulumi.Output[_builtins.str]:
        """
        The health check method.  Valid values: GET and HEAD.  Default value: HEAD.
        """
        return pulumi.get(self, "health_check_method")

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> pulumi.Output[_builtins.str]:
        """
        The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/).
        """
        return pulumi.get(self, "health_check_path")

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol used for the health check. Value:
        HTTP (default): Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy.
        HTTPS: Sends a HEAD or GET request to simulate the browser's access behavior to check whether the server application is healthy. (Data encryption is more secure than HTTP.)
        TCP: Sends a SYN handshake packet to check whether the server port is alive.
        gRPC: Check whether the server application is healthy by sending a POST or GET request.
        """
        return pulumi.get(self, "health_check_protocol")

    @_builtins.property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "health_check_template_name")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: 1 to 300. Unit: seconds.  Default value: 5.
        """
        return pulumi.get(self, "health_check_timeout")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail).
        """
        return pulumi.get(self, "unhealthy_threshold")

