# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerGroupArgs', 'ServerGroup']

@pulumi.input_type
class ServerGroupArgs:
    def __init__(__self__, *,
                 health_check_config: pulumi.Input['ServerGroupHealthCheckConfigArgs'],
                 server_group_name: pulumi.Input[_builtins.str],
                 connection_drain_config: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_config: Optional[pulumi.Input['ServerGroupSlowStartConfigArgs']] = None,
                 sticky_session_config: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uch_config: Optional[pulumi.Input['ServerGroupUchConfigArgs']] = None,
                 upstream_keepalive_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServerGroup resource.
        :param pulumi.Input['ServerGroupHealthCheckConfigArgs'] health_check_config: The configuration of health checks See `health_check_config` below.
        :param pulumi.Input[_builtins.str] server_group_name: The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input['ServerGroupConnectionDrainConfigArgs'] connection_drain_config: Elegant interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
               true: Send a check request,
               false (default): Send a normal request.
        :param pulumi.Input[_builtins.str] health_check_template_id: The ID of the resource group to which you want to transfer the cloud resource.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Enable Ipv6
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.
               
               *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.
               
               *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.
               
               > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        :param pulumi.Input[_builtins.str] resource_group_id: Elegant interrupt configuration.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.
               
               *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.
               
               *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.
               
               > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
               - `Ip`: allows you to add servers by specifying IP addresses.
               - `Fc`: allows you to add servers by specifying functions of Function Compute.
        :param pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]] servers: List of servers. See `servers` below.
        :param pulumi.Input[_builtins.str] service_name: Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        :param pulumi.Input['ServerGroupSlowStartConfigArgs'] slow_start_config: Slow start configuration. See `slow_start_config` below.
        :param pulumi.Input['ServerGroupStickySessionConfigArgs'] sticky_session_config: The configuration of health checks See `sticky_session_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The creation time of the resource
        :param pulumi.Input['ServerGroupUchConfigArgs'] uch_config: Url consistency hash parameter configuration See `uch_config` below.
        :param pulumi.Input[_builtins.bool] upstream_keepalive_enabled: Specifies whether to enable persistent TCP connections.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.
               
               > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        pulumi.set(__self__, "health_check_config", health_check_config)
        pulumi.set(__self__, "server_group_name", server_group_name)
        if connection_drain_config is not None:
            pulumi.set(__self__, "connection_drain_config", connection_drain_config)
        if cross_zone_enabled is not None:
            pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_template_id is not None:
            pulumi.set(__self__, "health_check_template_id", health_check_template_id)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if slow_start_config is not None:
            pulumi.set(__self__, "slow_start_config", slow_start_config)
        if sticky_session_config is not None:
            pulumi.set(__self__, "sticky_session_config", sticky_session_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if uch_config is not None:
            pulumi.set(__self__, "uch_config", uch_config)
        if upstream_keepalive_enabled is not None:
            pulumi.set(__self__, "upstream_keepalive_enabled", upstream_keepalive_enabled)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> pulumi.Input['ServerGroupHealthCheckConfigArgs']:
        """
        The configuration of health checks See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: pulumi.Input['ServerGroupHealthCheckConfigArgs']):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_group_name", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainConfig")
    def connection_drain_config(self) -> Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]:
        """
        Elegant interrupt configuration. See `connection_drain_config` below.
        """
        return pulumi.get(self, "connection_drain_config")

    @connection_drain_config.setter
    def connection_drain_config(self, value: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]):
        pulumi.set(self, "connection_drain_config", value)

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        """
        return pulumi.get(self, "cross_zone_enabled")

    @cross_zone_enabled.setter
    def cross_zone_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_zone_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        true: Send a check request,
        false (default): Send a normal request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTemplateId")
    def health_check_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to transfer the cloud resource.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "health_check_template_id")

    @health_check_template_id.setter
    def health_check_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_template_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Ipv6
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend protocol. Valid values:

        *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.

        *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.

        *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.

        > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elegant interrupt configuration.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduling algorithm. Valid values:

        *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.

        *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.

        *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.

        > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of server group. Valid values:

        - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
        - `Ip`: allows you to add servers by specifying IP addresses.
        - `Fc`: allows you to add servers by specifying functions of Function Compute.
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_type", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]:
        """
        List of servers. See `servers` below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="slowStartConfig")
    def slow_start_config(self) -> Optional[pulumi.Input['ServerGroupSlowStartConfigArgs']]:
        """
        Slow start configuration. See `slow_start_config` below.
        """
        return pulumi.get(self, "slow_start_config")

    @slow_start_config.setter
    def slow_start_config(self, value: Optional[pulumi.Input['ServerGroupSlowStartConfigArgs']]):
        pulumi.set(self, "slow_start_config", value)

    @_builtins.property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]:
        """
        The configuration of health checks See `sticky_session_config` below.
        """
        return pulumi.get(self, "sticky_session_config")

    @sticky_session_config.setter
    def sticky_session_config(self, value: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]):
        pulumi.set(self, "sticky_session_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="uchConfig")
    def uch_config(self) -> Optional[pulumi.Input['ServerGroupUchConfigArgs']]:
        """
        Url consistency hash parameter configuration See `uch_config` below.
        """
        return pulumi.get(self, "uch_config")

    @uch_config.setter
    def uch_config(self, value: Optional[pulumi.Input['ServerGroupUchConfigArgs']]):
        pulumi.set(self, "uch_config", value)

    @_builtins.property
    @pulumi.getter(name="upstreamKeepaliveEnabled")
    def upstream_keepalive_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable persistent TCP connections.
        """
        return pulumi.get(self, "upstream_keepalive_enabled")

    @upstream_keepalive_enabled.setter
    def upstream_keepalive_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upstream_keepalive_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.

        > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _ServerGroupState:
    def __init__(__self__, *,
                 connection_drain_config: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']] = None,
                 health_check_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_config: Optional[pulumi.Input['ServerGroupSlowStartConfigArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session_config: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uch_config: Optional[pulumi.Input['ServerGroupUchConfigArgs']] = None,
                 upstream_keepalive_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerGroup resources.
        :param pulumi.Input['ServerGroupConnectionDrainConfigArgs'] connection_drain_config: Elegant interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
               true: Send a check request,
               false (default): Send a normal request.
        :param pulumi.Input['ServerGroupHealthCheckConfigArgs'] health_check_config: The configuration of health checks See `health_check_config` below.
        :param pulumi.Input[_builtins.str] health_check_template_id: The ID of the resource group to which you want to transfer the cloud resource.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Enable Ipv6
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.
               
               *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.
               
               *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.
               
               > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        :param pulumi.Input[_builtins.str] resource_group_id: Elegant interrupt configuration.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.
               
               *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.
               
               *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.
               
               > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        :param pulumi.Input[_builtins.str] server_group_name: The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
               - `Ip`: allows you to add servers by specifying IP addresses.
               - `Fc`: allows you to add servers by specifying functions of Function Compute.
        :param pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]] servers: List of servers. See `servers` below.
        :param pulumi.Input[_builtins.str] service_name: Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        :param pulumi.Input['ServerGroupSlowStartConfigArgs'] slow_start_config: Slow start configuration. See `slow_start_config` below.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input['ServerGroupStickySessionConfigArgs'] sticky_session_config: The configuration of health checks See `sticky_session_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The creation time of the resource
        :param pulumi.Input['ServerGroupUchConfigArgs'] uch_config: Url consistency hash parameter configuration See `uch_config` below.
        :param pulumi.Input[_builtins.bool] upstream_keepalive_enabled: Specifies whether to enable persistent TCP connections.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.
               
               > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        if connection_drain_config is not None:
            pulumi.set(__self__, "connection_drain_config", connection_drain_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_zone_enabled is not None:
            pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if health_check_template_id is not None:
            pulumi.set(__self__, "health_check_template_id", health_check_template_id)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if slow_start_config is not None:
            pulumi.set(__self__, "slow_start_config", slow_start_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sticky_session_config is not None:
            pulumi.set(__self__, "sticky_session_config", sticky_session_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if uch_config is not None:
            pulumi.set(__self__, "uch_config", uch_config)
        if upstream_keepalive_enabled is not None:
            pulumi.set(__self__, "upstream_keepalive_enabled", upstream_keepalive_enabled)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="connectionDrainConfig")
    def connection_drain_config(self) -> Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]:
        """
        Elegant interrupt configuration. See `connection_drain_config` below.
        """
        return pulumi.get(self, "connection_drain_config")

    @connection_drain_config.setter
    def connection_drain_config(self, value: Optional[pulumi.Input['ServerGroupConnectionDrainConfigArgs']]):
        pulumi.set(self, "connection_drain_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        """
        return pulumi.get(self, "cross_zone_enabled")

    @cross_zone_enabled.setter
    def cross_zone_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_zone_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        true: Send a check request,
        false (default): Send a normal request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]:
        """
        The configuration of health checks See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTemplateId")
    def health_check_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which you want to transfer the cloud resource.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "health_check_template_id")

    @health_check_template_id.setter
    def health_check_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_template_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Ipv6
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend protocol. Valid values:

        *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.

        *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.

        *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.

        > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elegant interrupt configuration.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduling algorithm. Valid values:

        *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.

        *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.

        *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.

        > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of server group. Valid values:

        - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
        - `Ip`: allows you to add servers by specifying IP addresses.
        - `Fc`: allows you to add servers by specifying functions of Function Compute.
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_type", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]:
        """
        List of servers. See `servers` below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="slowStartConfig")
    def slow_start_config(self) -> Optional[pulumi.Input['ServerGroupSlowStartConfigArgs']]:
        """
        Slow start configuration. See `slow_start_config` below.
        """
        return pulumi.get(self, "slow_start_config")

    @slow_start_config.setter
    def slow_start_config(self, value: Optional[pulumi.Input['ServerGroupSlowStartConfigArgs']]):
        pulumi.set(self, "slow_start_config", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]:
        """
        The configuration of health checks See `sticky_session_config` below.
        """
        return pulumi.get(self, "sticky_session_config")

    @sticky_session_config.setter
    def sticky_session_config(self, value: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]):
        pulumi.set(self, "sticky_session_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="uchConfig")
    def uch_config(self) -> Optional[pulumi.Input['ServerGroupUchConfigArgs']]:
        """
        Url consistency hash parameter configuration See `uch_config` below.
        """
        return pulumi.get(self, "uch_config")

    @uch_config.setter
    def uch_config(self, value: Optional[pulumi.Input['ServerGroupUchConfigArgs']]):
        pulumi.set(self, "uch_config", value)

    @_builtins.property
    @pulumi.getter(name="upstreamKeepaliveEnabled")
    def upstream_keepalive_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable persistent TCP connections.
        """
        return pulumi.get(self, "upstream_keepalive_enabled")

    @upstream_keepalive_enabled.setter
    def upstream_keepalive_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upstream_keepalive_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.

        > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:alb/serverGroup:ServerGroup")
class ServerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_drain_config: Optional[pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']]] = None,
                 health_check_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_config: Optional[pulumi.Input[Union['ServerGroupSlowStartConfigArgs', 'ServerGroupSlowStartConfigArgsDict']]] = None,
                 sticky_session_config: Optional[pulumi.Input[Union['ServerGroupStickySessionConfigArgs', 'ServerGroupStickySessionConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uch_config: Optional[pulumi.Input[Union['ServerGroupUchConfigArgs', 'ServerGroupUchConfigArgsDict']]] = None,
                 upstream_keepalive_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Server Group resource.

        For information about Application Load Balancer (ALB) Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createservergroup).

        > **NOTE:** Available since v1.131.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.resourcemanager.get_resource_groups()
        example_get_zones = alicloud.get_zones(available_resource_creation="Instance")
        example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example_get_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=name,
            cidr_block="10.4.0.0/16",
            vpc_id=example_network.id,
            zone_id=example_get_zones.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            description=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            availability_zone=example_get_zones.zones[0].id,
            instance_name=name,
            image_id=example_get_images.images[0].id,
            instance_type=example_get_instance_types.instance_types[0].id,
            security_groups=[example_security_group.id],
            vswitch_id=example_switch.id)
        example_server_group = alicloud.alb.ServerGroup("example",
            protocol="HTTP",
            vpc_id=example_network.id,
            server_group_name=name,
            resource_group_id=example.groups[0].id,
            sticky_session_config={
                "sticky_session_enabled": True,
                "cookie": "tf-example",
                "sticky_session_type": "Server",
            },
            health_check_config={
                "health_check_connect_port": 46325,
                "health_check_enabled": True,
                "health_check_host": "tf-example.com",
                "health_check_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                "health_check_http_version": "HTTP1.1",
                "health_check_interval": 2,
                "health_check_method": "HEAD",
                "health_check_path": "/tf-example",
                "health_check_protocol": "HTTP",
                "health_check_timeout": 5,
                "healthy_threshold": 3,
                "unhealthy_threshold": 3,
            },
            servers=[{
                "description": name,
                "port": 80,
                "server_id": example_instance.id,
                "server_ip": example_instance.private_ip,
                "server_type": "Ecs",
                "weight": 10,
            }],
            tags={
                "Created": "TF",
            })
        ```

        ## Import

        Application Load Balancer (ALB) Server Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/serverGroup:ServerGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']] connection_drain_config: Elegant interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
               true: Send a check request,
               false (default): Send a normal request.
        :param pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']] health_check_config: The configuration of health checks See `health_check_config` below.
        :param pulumi.Input[_builtins.str] health_check_template_id: The ID of the resource group to which you want to transfer the cloud resource.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Enable Ipv6
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.
               
               *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.
               
               *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.
               
               > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        :param pulumi.Input[_builtins.str] resource_group_id: Elegant interrupt configuration.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.
               
               *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.
               
               *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.
               
               > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        :param pulumi.Input[_builtins.str] server_group_name: The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
               - `Ip`: allows you to add servers by specifying IP addresses.
               - `Fc`: allows you to add servers by specifying functions of Function Compute.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]] servers: List of servers. See `servers` below.
        :param pulumi.Input[_builtins.str] service_name: Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        :param pulumi.Input[Union['ServerGroupSlowStartConfigArgs', 'ServerGroupSlowStartConfigArgsDict']] slow_start_config: Slow start configuration. See `slow_start_config` below.
        :param pulumi.Input[Union['ServerGroupStickySessionConfigArgs', 'ServerGroupStickySessionConfigArgsDict']] sticky_session_config: The configuration of health checks See `sticky_session_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The creation time of the resource
        :param pulumi.Input[Union['ServerGroupUchConfigArgs', 'ServerGroupUchConfigArgsDict']] uch_config: Url consistency hash parameter configuration See `uch_config` below.
        :param pulumi.Input[_builtins.bool] upstream_keepalive_enabled: Specifies whether to enable persistent TCP connections.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.
               
               > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Server Group resource.

        For information about Application Load Balancer (ALB) Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createservergroup).

        > **NOTE:** Available since v1.131.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.resourcemanager.get_resource_groups()
        example_get_zones = alicloud.get_zones(available_resource_creation="Instance")
        example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example_get_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vswitch_name=name,
            cidr_block="10.4.0.0/16",
            vpc_id=example_network.id,
            zone_id=example_get_zones.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            description=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("example",
            availability_zone=example_get_zones.zones[0].id,
            instance_name=name,
            image_id=example_get_images.images[0].id,
            instance_type=example_get_instance_types.instance_types[0].id,
            security_groups=[example_security_group.id],
            vswitch_id=example_switch.id)
        example_server_group = alicloud.alb.ServerGroup("example",
            protocol="HTTP",
            vpc_id=example_network.id,
            server_group_name=name,
            resource_group_id=example.groups[0].id,
            sticky_session_config={
                "sticky_session_enabled": True,
                "cookie": "tf-example",
                "sticky_session_type": "Server",
            },
            health_check_config={
                "health_check_connect_port": 46325,
                "health_check_enabled": True,
                "health_check_host": "tf-example.com",
                "health_check_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                "health_check_http_version": "HTTP1.1",
                "health_check_interval": 2,
                "health_check_method": "HEAD",
                "health_check_path": "/tf-example",
                "health_check_protocol": "HTTP",
                "health_check_timeout": 5,
                "healthy_threshold": 3,
                "unhealthy_threshold": 3,
            },
            servers=[{
                "description": name,
                "port": 80,
                "server_id": example_instance.id,
                "server_ip": example_instance.private_ip,
                "server_type": "Ecs",
                "weight": 10,
            }],
            tags={
                "Created": "TF",
            })
        ```

        ## Import

        Application Load Balancer (ALB) Server Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/serverGroup:ServerGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_drain_config: Optional[pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_config: Optional[pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']]] = None,
                 health_check_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_config: Optional[pulumi.Input[Union['ServerGroupSlowStartConfigArgs', 'ServerGroupSlowStartConfigArgsDict']]] = None,
                 sticky_session_config: Optional[pulumi.Input[Union['ServerGroupStickySessionConfigArgs', 'ServerGroupStickySessionConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uch_config: Optional[pulumi.Input[Union['ServerGroupUchConfigArgs', 'ServerGroupUchConfigArgsDict']]] = None,
                 upstream_keepalive_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerGroupArgs.__new__(ServerGroupArgs)

            __props__.__dict__["connection_drain_config"] = connection_drain_config
            __props__.__dict__["cross_zone_enabled"] = cross_zone_enabled
            __props__.__dict__["dry_run"] = dry_run
            if health_check_config is None and not opts.urn:
                raise TypeError("Missing required property 'health_check_config'")
            __props__.__dict__["health_check_config"] = health_check_config
            __props__.__dict__["health_check_template_id"] = health_check_template_id
            __props__.__dict__["ipv6_enabled"] = ipv6_enabled
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scheduler"] = scheduler
            if server_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_name'")
            __props__.__dict__["server_group_name"] = server_group_name
            __props__.__dict__["server_group_type"] = server_group_type
            __props__.__dict__["servers"] = servers
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["slow_start_config"] = slow_start_config
            __props__.__dict__["sticky_session_config"] = sticky_session_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["uch_config"] = uch_config
            __props__.__dict__["upstream_keepalive_enabled"] = upstream_keepalive_enabled
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(ServerGroup, __self__).__init__(
            'alicloud:alb/serverGroup:ServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_drain_config: Optional[pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_config: Optional[pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']]] = None,
            health_check_template_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduler: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            slow_start_config: Optional[pulumi.Input[Union['ServerGroupSlowStartConfigArgs', 'ServerGroupSlowStartConfigArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sticky_session_config: Optional[pulumi.Input[Union['ServerGroupStickySessionConfigArgs', 'ServerGroupStickySessionConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            uch_config: Optional[pulumi.Input[Union['ServerGroupUchConfigArgs', 'ServerGroupUchConfigArgsDict']]] = None,
            upstream_keepalive_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerGroup':
        """
        Get an existing ServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerGroupConnectionDrainConfigArgs', 'ServerGroupConnectionDrainConfigArgsDict']] connection_drain_config: Elegant interrupt configuration. See `connection_drain_config` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
               true: Send a check request,
               false (default): Send a normal request.
        :param pulumi.Input[Union['ServerGroupHealthCheckConfigArgs', 'ServerGroupHealthCheckConfigArgsDict']] health_check_config: The configuration of health checks See `health_check_config` below.
        :param pulumi.Input[_builtins.str] health_check_template_id: The ID of the resource group to which you want to transfer the cloud resource.
               
               > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Enable Ipv6
        :param pulumi.Input[_builtins.str] protocol: The backend protocol. Valid values:
               
               *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.
               
               *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.
               
               *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.
               
               > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        :param pulumi.Input[_builtins.str] resource_group_id: Elegant interrupt configuration.
        :param pulumi.Input[_builtins.str] scheduler: The scheduling algorithm. Valid values:
               
               *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.
               
               *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.
               
               *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.
               
               > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        :param pulumi.Input[_builtins.str] server_group_name: The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.str] server_group_type: The type of server group. Valid values:
               
               - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
               - `Ip`: allows you to add servers by specifying IP addresses.
               - `Fc`: allows you to add servers by specifying functions of Function Compute.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerGroupServerArgs', 'ServerGroupServerArgsDict']]]] servers: List of servers. See `servers` below.
        :param pulumi.Input[_builtins.str] service_name: Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        :param pulumi.Input[Union['ServerGroupSlowStartConfigArgs', 'ServerGroupSlowStartConfigArgsDict']] slow_start_config: Slow start configuration. See `slow_start_config` below.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Union['ServerGroupStickySessionConfigArgs', 'ServerGroupStickySessionConfigArgsDict']] sticky_session_config: The configuration of health checks See `sticky_session_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The creation time of the resource
        :param pulumi.Input[Union['ServerGroupUchConfigArgs', 'ServerGroupUchConfigArgsDict']] uch_config: Url consistency hash parameter configuration See `uch_config` below.
        :param pulumi.Input[_builtins.bool] upstream_keepalive_enabled: Specifies whether to enable persistent TCP connections.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.
               
               > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerGroupState.__new__(_ServerGroupState)

        __props__.__dict__["connection_drain_config"] = connection_drain_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_zone_enabled"] = cross_zone_enabled
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["health_check_config"] = health_check_config
        __props__.__dict__["health_check_template_id"] = health_check_template_id
        __props__.__dict__["ipv6_enabled"] = ipv6_enabled
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scheduler"] = scheduler
        __props__.__dict__["server_group_name"] = server_group_name
        __props__.__dict__["server_group_type"] = server_group_type
        __props__.__dict__["servers"] = servers
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["slow_start_config"] = slow_start_config
        __props__.__dict__["status"] = status
        __props__.__dict__["sticky_session_config"] = sticky_session_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["uch_config"] = uch_config
        __props__.__dict__["upstream_keepalive_enabled"] = upstream_keepalive_enabled
        __props__.__dict__["vpc_id"] = vpc_id
        return ServerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionDrainConfig")
    def connection_drain_config(self) -> pulumi.Output['outputs.ServerGroupConnectionDrainConfig']:
        """
        Elegant interrupt configuration. See `connection_drain_config` below.
        """
        return pulumi.get(self, "connection_drain_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether cross-zone load balancing is enabled for the server group. Valid values:
        """
        return pulumi.get(self, "cross_zone_enabled")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        true: Send a check request,
        false (default): Send a normal request.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> pulumi.Output['outputs.ServerGroupHealthCheckConfig']:
        """
        The configuration of health checks See `health_check_config` below.
        """
        return pulumi.get(self, "health_check_config")

    @_builtins.property
    @pulumi.getter(name="healthCheckTemplateId")
    def health_check_template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the resource group to which you want to transfer the cloud resource.

        > **NOTE:**   You can use resource groups to manage resources within your Alibaba Cloud account by group. This helps you resolve issues such as resource grouping and permission management for your Alibaba Cloud account. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
        """
        return pulumi.get(self, "health_check_template_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable Ipv6
        """
        return pulumi.get(self, "ipv6_enabled")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The backend protocol. Valid values:

        *   `HTTP`: allows you to associate an HTTPS, HTTP, or QUIC listener with the server group. This is the default value.

        *   `HTTPS`: allows you to associate HTTPS listeners with backend servers.

        *   `gRPC`: allows you to associate an HTTPS or QUIC listener with the server group.

        > **NOTE:**   You do not need to specify a backend protocol if you set `ServerGroupType` to `Fc`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Elegant interrupt configuration.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output[_builtins.str]:
        """
        The scheduling algorithm. Valid values:

        *   `Wrr` (default): The weighted round-robin algorithm is used. Backend servers that have higher weights receive more requests than those that have lower weights.

        *   `Wlc`: The weighted least connections algorithm is used. Requests are distributed based on the weights and the number of connections to backend servers. If two backend servers have the same weight, the backend server that has fewer connections is expected to receive more requests.

        *   `Sch`: The consistent hashing algorithm is used. Requests from the same source IP address are distributed to the same backend server.

        > **NOTE:**  This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "server_group_name")

    @_builtins.property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of server group. Valid values:

        - `Instance` (default): allows you to add servers by specifying `Ecs`, `Eni`, or `Eci`.
        - `Ip`: allows you to add servers by specifying IP addresses.
        - `Fc`: allows you to add servers by specifying functions of Function Compute.
        """
        return pulumi.get(self, "server_group_type")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.ServerGroupServer']]]:
        """
        List of servers. See `servers` below.
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Only applicable to the ALB Ingress scenario, indicating the K8s Service name corresponding to the server group.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="slowStartConfig")
    def slow_start_config(self) -> pulumi.Output['outputs.ServerGroupSlowStartConfig']:
        """
        Slow start configuration. See `slow_start_config` below.
        """
        return pulumi.get(self, "slow_start_config")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> pulumi.Output[Optional['outputs.ServerGroupStickySessionConfig']]:
        """
        The configuration of health checks See `sticky_session_config` below.
        """
        return pulumi.get(self, "sticky_session_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="uchConfig")
    def uch_config(self) -> pulumi.Output[Optional['outputs.ServerGroupUchConfig']]:
        """
        Url consistency hash parameter configuration See `uch_config` below.
        """
        return pulumi.get(self, "uch_config")

    @_builtins.property
    @pulumi.getter(name="upstreamKeepaliveEnabled")
    def upstream_keepalive_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable persistent TCP connections.
        """
        return pulumi.get(self, "upstream_keepalive_enabled")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC). You can add only servers that are deployed in the specified VPC to the server group.

        > **NOTE:**   This parameter takes effect when the `ServerGroupType` parameter is set to `Instance` or `Ip`.
        """
        return pulumi.get(self, "vpc_id")

