# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CallbackArgs', 'Callback']

@pulumi.input_type
class CallbackArgs:
    def __init__(__self__, *,
                 callback_name: pulumi.Input[_builtins.str],
                 callback_suggestions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 callback_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 callback_url: pulumi.Input[_builtins.str],
                 crypt_type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Callback resource.
        :param pulumi.Input[_builtins.str] callback_name: The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_suggestions: List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_types: A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        :param pulumi.Input[_builtins.str] callback_url: The detection result will be called back to the url.
        :param pulumi.Input[_builtins.int] crypt_type: The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        pulumi.set(__self__, "callback_name", callback_name)
        pulumi.set(__self__, "callback_suggestions", callback_suggestions)
        pulumi.set(__self__, "callback_types", callback_types)
        pulumi.set(__self__, "callback_url", callback_url)
        if crypt_type is not None:
            pulumi.set(__self__, "crypt_type", crypt_type)

    @_builtins.property
    @pulumi.getter(name="callbackName")
    def callback_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        """
        return pulumi.get(self, "callback_name")

    @callback_name.setter
    def callback_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "callback_name", value)

    @_builtins.property
    @pulumi.getter(name="callbackSuggestions")
    def callback_suggestions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        """
        return pulumi.get(self, "callback_suggestions")

    @callback_suggestions.setter
    def callback_suggestions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "callback_suggestions", value)

    @_builtins.property
    @pulumi.getter(name="callbackTypes")
    def callback_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        """
        return pulumi.get(self, "callback_types")

    @callback_types.setter
    def callback_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "callback_types", value)

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Input[_builtins.str]:
        """
        The detection result will be called back to the url.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "callback_url", value)

    @_builtins.property
    @pulumi.getter(name="cryptType")
    def crypt_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        return pulumi.get(self, "crypt_type")

    @crypt_type.setter
    def crypt_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "crypt_type", value)


@pulumi.input_type
class _CallbackState:
    def __init__(__self__, *,
                 callback_name: Optional[pulumi.Input[_builtins.str]] = None,
                 callback_suggestions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 callback_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 crypt_type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Callback resources.
        :param pulumi.Input[_builtins.str] callback_name: The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_suggestions: List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_types: A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        :param pulumi.Input[_builtins.str] callback_url: The detection result will be called back to the url.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the Callback.
        :param pulumi.Input[_builtins.int] crypt_type: The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        if callback_name is not None:
            pulumi.set(__self__, "callback_name", callback_name)
        if callback_suggestions is not None:
            pulumi.set(__self__, "callback_suggestions", callback_suggestions)
        if callback_types is not None:
            pulumi.set(__self__, "callback_types", callback_types)
        if callback_url is not None:
            pulumi.set(__self__, "callback_url", callback_url)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypt_type is not None:
            pulumi.set(__self__, "crypt_type", crypt_type)

    @_builtins.property
    @pulumi.getter(name="callbackName")
    def callback_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        """
        return pulumi.get(self, "callback_name")

    @callback_name.setter
    def callback_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_name", value)

    @_builtins.property
    @pulumi.getter(name="callbackSuggestions")
    def callback_suggestions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        """
        return pulumi.get(self, "callback_suggestions")

    @callback_suggestions.setter
    def callback_suggestions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "callback_suggestions", value)

    @_builtins.property
    @pulumi.getter(name="callbackTypes")
    def callback_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        """
        return pulumi.get(self, "callback_types")

    @callback_types.setter
    def callback_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "callback_types", value)

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detection result will be called back to the url.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_url", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the Callback.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="cryptType")
    def crypt_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        return pulumi.get(self, "crypt_type")

    @crypt_type.setter
    def crypt_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "crypt_type", value)


@pulumi.type_token("alicloud:aligreen/callback:Callback")
class Callback(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback_name: Optional[pulumi.Input[_builtins.str]] = None,
                 callback_suggestions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 callback_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 crypt_type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Aligreen Callback resource.

        Detection Result Callback.

        For information about Aligreen Callback and how to use it, see [What is Callback](https://next.api.alibabacloud.com/document/Green/2017-08-23/CreateCallback).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.aligreen.Callback("default",
            callback_url="https://www.aliyun.com",
            crypt_type=0,
            callback_name=name,
            callback_types=[
                "machineScan",
                "selfAudit",
                "example",
            ],
            callback_suggestions=[
                "block",
                "review",
                "pass",
            ])
        ```

        ## Import

        Aligreen Callback can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:aligreen/callback:Callback example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] callback_name: The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_suggestions: List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_types: A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        :param pulumi.Input[_builtins.str] callback_url: The detection result will be called back to the url.
        :param pulumi.Input[_builtins.int] crypt_type: The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CallbackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Aligreen Callback resource.

        Detection Result Callback.

        For information about Aligreen Callback and how to use it, see [What is Callback](https://next.api.alibabacloud.com/document/Green/2017-08-23/CreateCallback).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.aligreen.Callback("default",
            callback_url="https://www.aliyun.com",
            crypt_type=0,
            callback_name=name,
            callback_types=[
                "machineScan",
                "selfAudit",
                "example",
            ],
            callback_suggestions=[
                "block",
                "review",
                "pass",
            ])
        ```

        ## Import

        Aligreen Callback can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:aligreen/callback:Callback example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CallbackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CallbackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback_name: Optional[pulumi.Input[_builtins.str]] = None,
                 callback_suggestions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 callback_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 crypt_type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CallbackArgs.__new__(CallbackArgs)

            if callback_name is None and not opts.urn:
                raise TypeError("Missing required property 'callback_name'")
            __props__.__dict__["callback_name"] = callback_name
            if callback_suggestions is None and not opts.urn:
                raise TypeError("Missing required property 'callback_suggestions'")
            __props__.__dict__["callback_suggestions"] = callback_suggestions
            if callback_types is None and not opts.urn:
                raise TypeError("Missing required property 'callback_types'")
            __props__.__dict__["callback_types"] = callback_types
            if callback_url is None and not opts.urn:
                raise TypeError("Missing required property 'callback_url'")
            __props__.__dict__["callback_url"] = callback_url
            __props__.__dict__["crypt_type"] = crypt_type
            __props__.__dict__["create_time"] = None
        super(Callback, __self__).__init__(
            'alicloud:aligreen/callback:Callback',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            callback_name: Optional[pulumi.Input[_builtins.str]] = None,
            callback_suggestions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            callback_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            callback_url: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            crypt_type: Optional[pulumi.Input[_builtins.int]] = None) -> 'Callback':
        """
        Get an existing Callback resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] callback_name: The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_suggestions: List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] callback_types: A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        :param pulumi.Input[_builtins.str] callback_url: The detection result will be called back to the url.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the Callback.
        :param pulumi.Input[_builtins.int] crypt_type: The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CallbackState.__new__(_CallbackState)

        __props__.__dict__["callback_name"] = callback_name
        __props__.__dict__["callback_suggestions"] = callback_suggestions
        __props__.__dict__["callback_types"] = callback_types
        __props__.__dict__["callback_url"] = callback_url
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypt_type"] = crypt_type
        return Callback(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="callbackName")
    def callback_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Callback name defined by the customer. It can contain no more than 20 characters in Chinese, English, underscore (_), and digits.
        """
        return pulumi.get(self, "callback_name")

    @_builtins.property
    @pulumi.getter(name="callbackSuggestions")
    def callback_suggestions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of audit results supported by message notification. Value: block: confirmed violation, review: Suspected violation, review: normal.
        """
        return pulumi.get(self, "callback_suggestions")

    @_builtins.property
    @pulumi.getter(name="callbackTypes")
    def callback_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Callback types. Value: machineScan: Machine audit result notification, selfAudit: self-service audit notification.
        """
        return pulumi.get(self, "callback_types")

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Output[_builtins.str]:
        """
        The detection result will be called back to the url.
        """
        return pulumi.get(self, "callback_url")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the Callback.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="cryptType")
    def crypt_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The encryption algorithm is used to verify that the callback request is sent by the Aliyun Green Service to your business service. Value: 0:SHA256,1: SM3.
        """
        return pulumi.get(self, "crypt_type")

