# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 https_policy: pulumi.Input[_builtins.str],
                 instance_name: pulumi.Input[_builtins.str],
                 instance_spec: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 delete_vpc_ip_block: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ingress_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 to_connect_vpc_ip_block: Optional[pulumi.Input['InstanceToConnectVpcIpBlockArgs']] = None,
                 user_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_slb_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_vswitch_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] https_policy: Https policy.
        :param pulumi.Input[_builtins.str] instance_name: Instance name.
        :param pulumi.Input[_builtins.str] instance_spec: Instance spec.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] delete_vpc_ip_block: Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        :param pulumi.Input[_builtins.int] duration: The time of the instance package. Valid values:
               - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
               - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
               
               When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.bool] egress_ipv6_enable: Specifies whether IPv6 egress capability is enabled.
        :param pulumi.Input[_builtins.str] ingress_vpc_id: The VpcID which the client at.
        :param pulumi.Input[_builtins.str] ingress_vpc_owner_id: The user ID that the VpcID of `ingress_vpc_id` belongs to.
        :param pulumi.Input[_builtins.str] ingress_vswitch_id: The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        :param pulumi.Input[_builtins.str] instance_cidr: The CIDR block for the instance deployment. Valid values are:
               - `192.168.0.0/16`.
               - `172.16.0.0/12`.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. Valid values are:
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Specifies whether IPv6 ingress capability is enabled.
        :param pulumi.Input[_builtins.str] pricing_cycle: The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        :param pulumi.Input[_builtins.bool] skip_wait_switch: Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        :param pulumi.Input['InstanceToConnectVpcIpBlockArgs'] to_connect_vpc_ip_block: The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        :param pulumi.Input[_builtins.str] user_vpc_id: User's VpcID.
        :param pulumi.Input[_builtins.bool] vpc_slb_intranet_enable: Whether the slb of the Vpc supports.
        :param pulumi.Input[_builtins.str] zone_id: The zone where the instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]] zone_vswitch_security_groups: Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        pulumi.set(__self__, "https_policy", https_policy)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_spec", instance_spec)
        pulumi.set(__self__, "payment_type", payment_type)
        if delete_vpc_ip_block is not None:
            pulumi.set(__self__, "delete_vpc_ip_block", delete_vpc_ip_block)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if egress_ipv6_enable is not None:
            pulumi.set(__self__, "egress_ipv6_enable", egress_ipv6_enable)
        if ingress_vpc_id is not None:
            pulumi.set(__self__, "ingress_vpc_id", ingress_vpc_id)
        if ingress_vpc_owner_id is not None:
            pulumi.set(__self__, "ingress_vpc_owner_id", ingress_vpc_owner_id)
        if ingress_vswitch_id is not None:
            pulumi.set(__self__, "ingress_vswitch_id", ingress_vswitch_id)
        if instance_cidr is not None:
            pulumi.set(__self__, "instance_cidr", instance_cidr)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if skip_wait_switch is not None:
            pulumi.set(__self__, "skip_wait_switch", skip_wait_switch)
        if to_connect_vpc_ip_block is not None:
            pulumi.set(__self__, "to_connect_vpc_ip_block", to_connect_vpc_ip_block)
        if user_vpc_id is not None:
            pulumi.set(__self__, "user_vpc_id", user_vpc_id)
        if vpc_slb_intranet_enable is not None:
            pulumi.set(__self__, "vpc_slb_intranet_enable", vpc_slb_intranet_enable)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_vswitch_security_groups is not None:
            pulumi.set(__self__, "zone_vswitch_security_groups", zone_vswitch_security_groups)

    @_builtins.property
    @pulumi.getter(name="httpsPolicy")
    def https_policy(self) -> pulumi.Input[_builtins.str]:
        """
        Https policy.
        """
        return pulumi.get(self, "https_policy")

    @https_policy.setter
    def https_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "https_policy", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        Instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> pulumi.Input[_builtins.str]:
        """
        Instance spec.
        """
        return pulumi.get(self, "instance_spec")

    @instance_spec.setter
    def instance_spec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_spec", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="deleteVpcIpBlock")
    def delete_vpc_ip_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        """
        return pulumi.get(self, "delete_vpc_ip_block")

    @delete_vpc_ip_block.setter
    def delete_vpc_ip_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_vpc_ip_block", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time of the instance package. Valid values:
        - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
        - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.

        When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="egressIpv6Enable")
    def egress_ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether IPv6 egress capability is enabled.
        """
        return pulumi.get(self, "egress_ipv6_enable")

    @egress_ipv6_enable.setter
    def egress_ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "egress_ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="ingressVpcId")
    def ingress_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VpcID which the client at.
        """
        return pulumi.get(self, "ingress_vpc_id")

    @ingress_vpc_id.setter
    def ingress_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressVpcOwnerId")
    def ingress_vpc_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user ID that the VpcID of `ingress_vpc_id` belongs to.
        """
        return pulumi.get(self, "ingress_vpc_owner_id")

    @ingress_vpc_owner_id.setter
    def ingress_vpc_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_vpc_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressVswitchId")
    def ingress_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        """
        return pulumi.get(self, "ingress_vswitch_id")

    @ingress_vswitch_id.setter
    def ingress_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceCidr")
    def instance_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block for the instance deployment. Valid values are:
        - `192.168.0.0/16`.
        - `172.16.0.0/12`.
        """
        return pulumi.get(self, "instance_cidr")

    @instance_cidr.setter
    def instance_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_cidr", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance. Valid values are:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether IPv6 ingress capability is enabled.
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="skipWaitSwitch")
    def skip_wait_switch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        """
        return pulumi.get(self, "skip_wait_switch")

    @skip_wait_switch.setter
    def skip_wait_switch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wait_switch", value)

    @_builtins.property
    @pulumi.getter(name="toConnectVpcIpBlock")
    def to_connect_vpc_ip_block(self) -> Optional[pulumi.Input['InstanceToConnectVpcIpBlockArgs']]:
        """
        The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        """
        return pulumi.get(self, "to_connect_vpc_ip_block")

    @to_connect_vpc_ip_block.setter
    def to_connect_vpc_ip_block(self, value: Optional[pulumi.Input['InstanceToConnectVpcIpBlockArgs']]):
        pulumi.set(self, "to_connect_vpc_ip_block", value)

    @_builtins.property
    @pulumi.getter(name="userVpcId")
    def user_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User's VpcID.
        """
        return pulumi.get(self, "user_vpc_id")

    @user_vpc_id.setter
    def user_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcSlbIntranetEnable")
    def vpc_slb_intranet_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the slb of the Vpc supports.
        """
        return pulumi.get(self, "vpc_slb_intranet_enable")

    @vpc_slb_intranet_enable.setter
    def vpc_slb_intranet_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vpc_slb_intranet_enable", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone where the instance is deployed.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneVswitchSecurityGroups")
    def zone_vswitch_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]]]:
        """
        Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        return pulumi.get(self, "zone_vswitch_security_groups")

    @zone_vswitch_security_groups.setter
    def zone_vswitch_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]]]):
        pulumi.set(self, "zone_vswitch_security_groups", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 connect_cidr_blocks: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_vpc_ip_block: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 to_connect_vpc_ip_block: Optional[pulumi.Input['InstanceToConnectVpcIpBlockArgs']] = None,
                 user_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_slb_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_vswitch_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] connect_cidr_blocks: (Available since v1.228.0) The CIDR blocks that can be accessed by the Vpc integration instance.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] delete_vpc_ip_block: Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        :param pulumi.Input[_builtins.int] duration: The time of the instance package. Valid values:
               - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
               - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
               
               When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.bool] egress_ipv6_enable: Specifies whether IPv6 egress capability is enabled.
        :param pulumi.Input[_builtins.str] https_policy: Https policy.
        :param pulumi.Input[_builtins.str] ingress_vpc_id: The VpcID which the client at.
        :param pulumi.Input[_builtins.str] ingress_vpc_owner_id: The user ID that the VpcID of `ingress_vpc_id` belongs to.
        :param pulumi.Input[_builtins.str] ingress_vswitch_id: The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        :param pulumi.Input[_builtins.str] instance_cidr: The CIDR block for the instance deployment. Valid values are:
               - `192.168.0.0/16`.
               - `172.16.0.0/12`.
        :param pulumi.Input[_builtins.str] instance_name: Instance name.
        :param pulumi.Input[_builtins.str] instance_spec: Instance spec.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. Valid values are:
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Specifies whether IPv6 ingress capability is enabled.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] pricing_cycle: The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        :param pulumi.Input[_builtins.bool] skip_wait_switch: Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.bool] support_ipv6: Does ipv6 support.
        :param pulumi.Input['InstanceToConnectVpcIpBlockArgs'] to_connect_vpc_ip_block: The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        :param pulumi.Input[_builtins.str] user_vpc_id: User's VpcID.
        :param pulumi.Input[_builtins.bool] vpc_slb_intranet_enable: Whether the slb of the Vpc supports.
        :param pulumi.Input[_builtins.str] zone_id: The zone where the instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]] zone_vswitch_security_groups: Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        if connect_cidr_blocks is not None:
            pulumi.set(__self__, "connect_cidr_blocks", connect_cidr_blocks)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_vpc_ip_block is not None:
            pulumi.set(__self__, "delete_vpc_ip_block", delete_vpc_ip_block)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if egress_ipv6_enable is not None:
            pulumi.set(__self__, "egress_ipv6_enable", egress_ipv6_enable)
        if https_policy is not None:
            pulumi.set(__self__, "https_policy", https_policy)
        if ingress_vpc_id is not None:
            pulumi.set(__self__, "ingress_vpc_id", ingress_vpc_id)
        if ingress_vpc_owner_id is not None:
            pulumi.set(__self__, "ingress_vpc_owner_id", ingress_vpc_owner_id)
        if ingress_vswitch_id is not None:
            pulumi.set(__self__, "ingress_vswitch_id", ingress_vswitch_id)
        if instance_cidr is not None:
            pulumi.set(__self__, "instance_cidr", instance_cidr)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_spec is not None:
            pulumi.set(__self__, "instance_spec", instance_spec)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if skip_wait_switch is not None:
            pulumi.set(__self__, "skip_wait_switch", skip_wait_switch)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_ipv6 is not None:
            pulumi.set(__self__, "support_ipv6", support_ipv6)
        if to_connect_vpc_ip_block is not None:
            pulumi.set(__self__, "to_connect_vpc_ip_block", to_connect_vpc_ip_block)
        if user_vpc_id is not None:
            pulumi.set(__self__, "user_vpc_id", user_vpc_id)
        if vpc_slb_intranet_enable is not None:
            pulumi.set(__self__, "vpc_slb_intranet_enable", vpc_slb_intranet_enable)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_vswitch_security_groups is not None:
            pulumi.set(__self__, "zone_vswitch_security_groups", zone_vswitch_security_groups)

    @_builtins.property
    @pulumi.getter(name="connectCidrBlocks")
    def connect_cidr_blocks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.228.0) The CIDR blocks that can be accessed by the Vpc integration instance.
        """
        return pulumi.get(self, "connect_cidr_blocks")

    @connect_cidr_blocks.setter
    def connect_cidr_blocks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteVpcIpBlock")
    def delete_vpc_ip_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        """
        return pulumi.get(self, "delete_vpc_ip_block")

    @delete_vpc_ip_block.setter
    def delete_vpc_ip_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_vpc_ip_block", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time of the instance package. Valid values:
        - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
        - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.

        When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="egressIpv6Enable")
    def egress_ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether IPv6 egress capability is enabled.
        """
        return pulumi.get(self, "egress_ipv6_enable")

    @egress_ipv6_enable.setter
    def egress_ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "egress_ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="httpsPolicy")
    def https_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Https policy.
        """
        return pulumi.get(self, "https_policy")

    @https_policy.setter
    def https_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_policy", value)

    @_builtins.property
    @pulumi.getter(name="ingressVpcId")
    def ingress_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VpcID which the client at.
        """
        return pulumi.get(self, "ingress_vpc_id")

    @ingress_vpc_id.setter
    def ingress_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressVpcOwnerId")
    def ingress_vpc_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user ID that the VpcID of `ingress_vpc_id` belongs to.
        """
        return pulumi.get(self, "ingress_vpc_owner_id")

    @ingress_vpc_owner_id.setter
    def ingress_vpc_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_vpc_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressVswitchId")
    def ingress_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        """
        return pulumi.get(self, "ingress_vswitch_id")

    @ingress_vswitch_id.setter
    def ingress_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceCidr")
    def instance_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block for the instance deployment. Valid values are:
        - `192.168.0.0/16`.
        - `172.16.0.0/12`.
        """
        return pulumi.get(self, "instance_cidr")

    @instance_cidr.setter
    def instance_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_cidr", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance spec.
        """
        return pulumi.get(self, "instance_spec")

    @instance_spec.setter
    def instance_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_spec", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the instance. Valid values are:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether IPv6 ingress capability is enabled.
        """
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="skipWaitSwitch")
    def skip_wait_switch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        """
        return pulumi.get(self, "skip_wait_switch")

    @skip_wait_switch.setter
    def skip_wait_switch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wait_switch", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportIpv6")
    def support_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does ipv6 support.
        """
        return pulumi.get(self, "support_ipv6")

    @support_ipv6.setter
    def support_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="toConnectVpcIpBlock")
    def to_connect_vpc_ip_block(self) -> Optional[pulumi.Input['InstanceToConnectVpcIpBlockArgs']]:
        """
        The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        """
        return pulumi.get(self, "to_connect_vpc_ip_block")

    @to_connect_vpc_ip_block.setter
    def to_connect_vpc_ip_block(self, value: Optional[pulumi.Input['InstanceToConnectVpcIpBlockArgs']]):
        pulumi.set(self, "to_connect_vpc_ip_block", value)

    @_builtins.property
    @pulumi.getter(name="userVpcId")
    def user_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User's VpcID.
        """
        return pulumi.get(self, "user_vpc_id")

    @user_vpc_id.setter
    def user_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcSlbIntranetEnable")
    def vpc_slb_intranet_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the slb of the Vpc supports.
        """
        return pulumi.get(self, "vpc_slb_intranet_enable")

    @vpc_slb_intranet_enable.setter
    def vpc_slb_intranet_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vpc_slb_intranet_enable", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone where the instance is deployed.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneVswitchSecurityGroups")
    def zone_vswitch_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]]]:
        """
        Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        return pulumi.get(self, "zone_vswitch_security_groups")

    @zone_vswitch_security_groups.setter
    def zone_vswitch_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceZoneVswitchSecurityGroupArgs']]]]):
        pulumi.set(self, "zone_vswitch_security_groups", value)


@pulumi.type_token("alicloud:apigateway/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_vpc_ip_block: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 to_connect_vpc_ip_block: Optional[pulumi.Input[Union['InstanceToConnectVpcIpBlockArgs', 'InstanceToConnectVpcIpBlockArgsDict']]] = None,
                 user_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_slb_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_vswitch_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceZoneVswitchSecurityGroupArgs', 'InstanceZoneVswitchSecurityGroupArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Api Gateway Instance resource.

        For information about Api Gateway Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/api-gateway/product-overview/dedicated-instances).

        > **NOTE:** Available since v1.218.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.apigateway.Instance("default",
            instance_name=name,
            instance_spec="api.s1.small",
            https_policy="HTTPS2_TLS1_0",
            zone_id="cn-hangzhou-MAZ6(i,j,k)",
            payment_type="PayAsYouGo",
            instance_type="normal")
        ```

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        vswitch1 = alicloud.vpc.Switch("vswitch_1",
            vpc_id=vpc.id,
            cidr_block="172.16.0.0/16",
            zone_id="cn-hangzhou-j",
            vswitch_name=f"{name}_1")
        vswitch2 = alicloud.vpc.Switch("vswitch_2",
            vpc_id=vpc.id,
            cidr_block="172.17.0.0/16",
            zone_id="cn-hangzhou-k",
            vswitch_name=f"{name}_2")
        security_group = alicloud.ecs.SecurityGroup("security_group",
            vpc_id=vpc.id,
            security_group_name=name)
        vpc_integration_instance = alicloud.apigateway.Instance("vpc_integration_instance",
            instance_name=name,
            https_policy="HTTPS2_TLS1_0",
            instance_spec="api.s1.small",
            instance_type="vpc_connect",
            payment_type="PayAsYouGo",
            user_vpc_id=vpc.id,
            instance_cidr="192.168.0.0/16",
            zone_vswitch_security_groups=[
                {
                    "zone_id": vswitch1.zone_id,
                    "vswitch_id": vswitch1.id,
                    "cidr_block": vswitch1.cidr_block,
                    "security_group": security_group.id,
                },
                {
                    "zone_id": vswitch2.zone_id,
                    "vswitch_id": vswitch2.id,
                    "cidr_block": vswitch2.cidr_block,
                    "security_group": security_group.id,
                },
            ])
        ```

        ## Import

        Api Gateway Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delete_vpc_ip_block: Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        :param pulumi.Input[_builtins.int] duration: The time of the instance package. Valid values:
               - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
               - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
               
               When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.bool] egress_ipv6_enable: Specifies whether IPv6 egress capability is enabled.
        :param pulumi.Input[_builtins.str] https_policy: Https policy.
        :param pulumi.Input[_builtins.str] ingress_vpc_id: The VpcID which the client at.
        :param pulumi.Input[_builtins.str] ingress_vpc_owner_id: The user ID that the VpcID of `ingress_vpc_id` belongs to.
        :param pulumi.Input[_builtins.str] ingress_vswitch_id: The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        :param pulumi.Input[_builtins.str] instance_cidr: The CIDR block for the instance deployment. Valid values are:
               - `192.168.0.0/16`.
               - `172.16.0.0/12`.
        :param pulumi.Input[_builtins.str] instance_name: Instance name.
        :param pulumi.Input[_builtins.str] instance_spec: Instance spec.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. Valid values are:
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Specifies whether IPv6 ingress capability is enabled.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] pricing_cycle: The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        :param pulumi.Input[_builtins.bool] skip_wait_switch: Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        :param pulumi.Input[Union['InstanceToConnectVpcIpBlockArgs', 'InstanceToConnectVpcIpBlockArgsDict']] to_connect_vpc_ip_block: The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        :param pulumi.Input[_builtins.str] user_vpc_id: User's VpcID.
        :param pulumi.Input[_builtins.bool] vpc_slb_intranet_enable: Whether the slb of the Vpc supports.
        :param pulumi.Input[_builtins.str] zone_id: The zone where the instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceZoneVswitchSecurityGroupArgs', 'InstanceZoneVswitchSecurityGroupArgsDict']]]] zone_vswitch_security_groups: Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Api Gateway Instance resource.

        For information about Api Gateway Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/api-gateway/product-overview/dedicated-instances).

        > **NOTE:** Available since v1.218.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.apigateway.Instance("default",
            instance_name=name,
            instance_spec="api.s1.small",
            https_policy="HTTPS2_TLS1_0",
            zone_id="cn-hangzhou-MAZ6(i,j,k)",
            payment_type="PayAsYouGo",
            instance_type="normal")
        ```

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        vswitch1 = alicloud.vpc.Switch("vswitch_1",
            vpc_id=vpc.id,
            cidr_block="172.16.0.0/16",
            zone_id="cn-hangzhou-j",
            vswitch_name=f"{name}_1")
        vswitch2 = alicloud.vpc.Switch("vswitch_2",
            vpc_id=vpc.id,
            cidr_block="172.17.0.0/16",
            zone_id="cn-hangzhou-k",
            vswitch_name=f"{name}_2")
        security_group = alicloud.ecs.SecurityGroup("security_group",
            vpc_id=vpc.id,
            security_group_name=name)
        vpc_integration_instance = alicloud.apigateway.Instance("vpc_integration_instance",
            instance_name=name,
            https_policy="HTTPS2_TLS1_0",
            instance_spec="api.s1.small",
            instance_type="vpc_connect",
            payment_type="PayAsYouGo",
            user_vpc_id=vpc.id,
            instance_cidr="192.168.0.0/16",
            zone_vswitch_security_groups=[
                {
                    "zone_id": vswitch1.zone_id,
                    "vswitch_id": vswitch1.id,
                    "cidr_block": vswitch1.cidr_block,
                    "security_group": security_group.id,
                },
                {
                    "zone_id": vswitch2.zone_id,
                    "vswitch_id": vswitch2.id,
                    "cidr_block": vswitch2.cidr_block,
                    "security_group": security_group.id,
                },
            ])
        ```

        ## Import

        Api Gateway Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_vpc_ip_block: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vpc_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 to_connect_vpc_ip_block: Optional[pulumi.Input[Union['InstanceToConnectVpcIpBlockArgs', 'InstanceToConnectVpcIpBlockArgsDict']]] = None,
                 user_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_slb_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_vswitch_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceZoneVswitchSecurityGroupArgs', 'InstanceZoneVswitchSecurityGroupArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["delete_vpc_ip_block"] = delete_vpc_ip_block
            __props__.__dict__["duration"] = duration
            __props__.__dict__["egress_ipv6_enable"] = egress_ipv6_enable
            if https_policy is None and not opts.urn:
                raise TypeError("Missing required property 'https_policy'")
            __props__.__dict__["https_policy"] = https_policy
            __props__.__dict__["ingress_vpc_id"] = ingress_vpc_id
            __props__.__dict__["ingress_vpc_owner_id"] = ingress_vpc_owner_id
            __props__.__dict__["ingress_vswitch_id"] = ingress_vswitch_id
            __props__.__dict__["instance_cidr"] = instance_cidr
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if instance_spec is None and not opts.urn:
                raise TypeError("Missing required property 'instance_spec'")
            __props__.__dict__["instance_spec"] = instance_spec
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_enabled"] = ipv6_enabled
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["skip_wait_switch"] = skip_wait_switch
            __props__.__dict__["to_connect_vpc_ip_block"] = to_connect_vpc_ip_block
            __props__.__dict__["user_vpc_id"] = user_vpc_id
            __props__.__dict__["vpc_slb_intranet_enable"] = vpc_slb_intranet_enable
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["zone_vswitch_security_groups"] = zone_vswitch_security_groups
            __props__.__dict__["connect_cidr_blocks"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["support_ipv6"] = None
        super(Instance, __self__).__init__(
            'alicloud:apigateway/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connect_cidr_blocks: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_vpc_ip_block: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            egress_ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            https_policy: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_vpc_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            skip_wait_switch: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            to_connect_vpc_ip_block: Optional[pulumi.Input[Union['InstanceToConnectVpcIpBlockArgs', 'InstanceToConnectVpcIpBlockArgsDict']]] = None,
            user_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_slb_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_vswitch_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceZoneVswitchSecurityGroupArgs', 'InstanceZoneVswitchSecurityGroupArgsDict']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connect_cidr_blocks: (Available since v1.228.0) The CIDR blocks that can be accessed by the Vpc integration instance.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] delete_vpc_ip_block: Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        :param pulumi.Input[_builtins.int] duration: The time of the instance package. Valid values:
               - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
               - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
               
               When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.bool] egress_ipv6_enable: Specifies whether IPv6 egress capability is enabled.
        :param pulumi.Input[_builtins.str] https_policy: Https policy.
        :param pulumi.Input[_builtins.str] ingress_vpc_id: The VpcID which the client at.
        :param pulumi.Input[_builtins.str] ingress_vpc_owner_id: The user ID that the VpcID of `ingress_vpc_id` belongs to.
        :param pulumi.Input[_builtins.str] ingress_vswitch_id: The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        :param pulumi.Input[_builtins.str] instance_cidr: The CIDR block for the instance deployment. Valid values are:
               - `192.168.0.0/16`.
               - `172.16.0.0/12`.
        :param pulumi.Input[_builtins.str] instance_name: Instance name.
        :param pulumi.Input[_builtins.str] instance_spec: Instance spec.
        :param pulumi.Input[_builtins.str] instance_type: The type of the instance. Valid values are:
        :param pulumi.Input[_builtins.bool] ipv6_enabled: Specifies whether IPv6 ingress capability is enabled.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource.
        :param pulumi.Input[_builtins.str] pricing_cycle: The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        :param pulumi.Input[_builtins.bool] skip_wait_switch: Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.bool] support_ipv6: Does ipv6 support.
        :param pulumi.Input[Union['InstanceToConnectVpcIpBlockArgs', 'InstanceToConnectVpcIpBlockArgsDict']] to_connect_vpc_ip_block: The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        :param pulumi.Input[_builtins.str] user_vpc_id: User's VpcID.
        :param pulumi.Input[_builtins.bool] vpc_slb_intranet_enable: Whether the slb of the Vpc supports.
        :param pulumi.Input[_builtins.str] zone_id: The zone where the instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceZoneVswitchSecurityGroupArgs', 'InstanceZoneVswitchSecurityGroupArgsDict']]]] zone_vswitch_security_groups: Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["connect_cidr_blocks"] = connect_cidr_blocks
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_vpc_ip_block"] = delete_vpc_ip_block
        __props__.__dict__["duration"] = duration
        __props__.__dict__["egress_ipv6_enable"] = egress_ipv6_enable
        __props__.__dict__["https_policy"] = https_policy
        __props__.__dict__["ingress_vpc_id"] = ingress_vpc_id
        __props__.__dict__["ingress_vpc_owner_id"] = ingress_vpc_owner_id
        __props__.__dict__["ingress_vswitch_id"] = ingress_vswitch_id
        __props__.__dict__["instance_cidr"] = instance_cidr
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_spec"] = instance_spec
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_enabled"] = ipv6_enabled
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["skip_wait_switch"] = skip_wait_switch
        __props__.__dict__["status"] = status
        __props__.__dict__["support_ipv6"] = support_ipv6
        __props__.__dict__["to_connect_vpc_ip_block"] = to_connect_vpc_ip_block
        __props__.__dict__["user_vpc_id"] = user_vpc_id
        __props__.__dict__["vpc_slb_intranet_enable"] = vpc_slb_intranet_enable
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_vswitch_security_groups"] = zone_vswitch_security_groups
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectCidrBlocks")
    def connect_cidr_blocks(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.228.0) The CIDR blocks that can be accessed by the Vpc integration instance.
        """
        return pulumi.get(self, "connect_cidr_blocks")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteVpcIpBlock")
    def delete_vpc_ip_block(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
        """
        return pulumi.get(self, "delete_vpc_ip_block")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time of the instance package. Valid values:
        - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
        - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.

        When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="egressIpv6Enable")
    def egress_ipv6_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether IPv6 egress capability is enabled.
        """
        return pulumi.get(self, "egress_ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="httpsPolicy")
    def https_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Https policy.
        """
        return pulumi.get(self, "https_policy")

    @_builtins.property
    @pulumi.getter(name="ingressVpcId")
    def ingress_vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VpcID which the client at.
        """
        return pulumi.get(self, "ingress_vpc_id")

    @_builtins.property
    @pulumi.getter(name="ingressVpcOwnerId")
    def ingress_vpc_owner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user ID that the VpcID of `ingress_vpc_id` belongs to.
        """
        return pulumi.get(self, "ingress_vpc_owner_id")

    @_builtins.property
    @pulumi.getter(name="ingressVswitchId")
    def ingress_vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VSwitch ID that belongs to the Vpc of `ingress_vpc_id`. Required when `ingress_vpc_id` is set.
        """
        return pulumi.get(self, "ingress_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="instanceCidr")
    def instance_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block for the instance deployment. Valid values are:
        - `192.168.0.0/16`.
        - `172.16.0.0/12`.
        """
        return pulumi.get(self, "instance_cidr")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Instance name.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> pulumi.Output[_builtins.str]:
        """
        Instance spec.
        """
        return pulumi.get(self, "instance_spec")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the instance. Valid values are:
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether IPv6 ingress capability is enabled.
        """
        return pulumi.get(self, "ipv6_enabled")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="skipWaitSwitch")
    def skip_wait_switch(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to skip the WAIT_SWITCH status of instance when modifying instance spec. Works only when instance spec change.
        """
        return pulumi.get(self, "skip_wait_switch")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportIpv6")
    def support_ipv6(self) -> pulumi.Output[_builtins.bool]:
        """
        Does ipv6 support.
        """
        return pulumi.get(self, "support_ipv6")

    @_builtins.property
    @pulumi.getter(name="toConnectVpcIpBlock")
    def to_connect_vpc_ip_block(self) -> pulumi.Output[Optional['outputs.InstanceToConnectVpcIpBlock']]:
        """
        The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
        """
        return pulumi.get(self, "to_connect_vpc_ip_block")

    @_builtins.property
    @pulumi.getter(name="userVpcId")
    def user_vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User's VpcID.
        """
        return pulumi.get(self, "user_vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcSlbIntranetEnable")
    def vpc_slb_intranet_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the slb of the Vpc supports.
        """
        return pulumi.get(self, "vpc_slb_intranet_enable")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone where the instance is deployed.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneVswitchSecurityGroups")
    def zone_vswitch_security_groups(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceZoneVswitchSecurityGroup']]]:
        """
        Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
        """
        return pulumi.get(self, "zone_vswitch_security_groups")

