# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BandwidthPackageArgs', 'BandwidthPackage']

@pulumi.input_type
class BandwidthPackageArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.int],
                 cen_bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_a_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_b_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a BandwidthPackage resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_name: The name of the bandwidth package. Defaults to null.
               
               ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
               
               ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        :param pulumi.Input[_builtins.str] charge_type: Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        :param pulumi.Input[_builtins.str] description: The description of the bandwidth package. Default to null.
        :param pulumi.Input[_builtins.str] geographic_region_a_id: The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[_builtins.str] geographic_region_b_id: The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geographic_region_ids: Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        :param pulumi.Input[_builtins.int] period: The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        if cen_bandwidth_package_name is not None:
            pulumi.set(__self__, "cen_bandwidth_package_name", cen_bandwidth_package_name)
        if charge_type is not None:
            warnings.warn("""Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""", DeprecationWarning)
            pulumi.log.warn("""charge_type is deprecated: Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""")
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if geographic_region_a_id is not None:
            pulumi.set(__self__, "geographic_region_a_id", geographic_region_a_id)
        if geographic_region_b_id is not None:
            pulumi.set(__self__, "geographic_region_b_id", geographic_region_b_id)
        if geographic_region_ids is not None:
            warnings.warn("""Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""geographic_region_ids is deprecated: Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""")
        if geographic_region_ids is not None:
            pulumi.set(__self__, "geographic_region_ids", geographic_region_ids)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.int]:
        """
        The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageName")
    def cen_bandwidth_package_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bandwidth package. Defaults to null.

        ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.

        ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        """
        return pulumi.get(self, "cen_bandwidth_package_name")

    @cen_bandwidth_package_name.setter
    def cen_bandwidth_package_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_bandwidth_package_name", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    @_utilities.deprecated("""Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the bandwidth package. Default to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="geographicRegionAId")
    def geographic_region_a_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        """
        return pulumi.get(self, "geographic_region_a_id")

    @geographic_region_a_id.setter
    def geographic_region_a_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geographic_region_a_id", value)

    @_builtins.property
    @pulumi.getter(name="geographicRegionBId")
    def geographic_region_b_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        """
        return pulumi.get(self, "geographic_region_b_id")

    @geographic_region_b_id.setter
    def geographic_region_b_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geographic_region_b_id", value)

    @_builtins.property
    @pulumi.getter(name="geographicRegionIds")
    @_utilities.deprecated("""Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""")
    def geographic_region_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        """
        return pulumi.get(self, "geographic_region_ids")

    @geographic_region_ids.setter
    def geographic_region_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "geographic_region_ids", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)


@pulumi.input_type
class _BandwidthPackageState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_a_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_b_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BandwidthPackage resources.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_name: The name of the bandwidth package. Defaults to null.
               
               ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
               
               ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        :param pulumi.Input[_builtins.str] charge_type: Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        :param pulumi.Input[_builtins.str] description: The description of the bandwidth package. Default to null.
        :param pulumi.Input[_builtins.str] expired_time: The time of the bandwidth package to expire.
        :param pulumi.Input[_builtins.str] geographic_region_a_id: The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[_builtins.str] geographic_region_b_id: The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geographic_region_ids: Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        :param pulumi.Input[_builtins.int] period: The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] status: The association status of the bandwidth package.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if cen_bandwidth_package_name is not None:
            pulumi.set(__self__, "cen_bandwidth_package_name", cen_bandwidth_package_name)
        if charge_type is not None:
            warnings.warn("""Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""", DeprecationWarning)
            pulumi.log.warn("""charge_type is deprecated: Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""")
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if geographic_region_a_id is not None:
            pulumi.set(__self__, "geographic_region_a_id", geographic_region_a_id)
        if geographic_region_b_id is not None:
            pulumi.set(__self__, "geographic_region_b_id", geographic_region_b_id)
        if geographic_region_ids is not None:
            warnings.warn("""Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""geographic_region_ids is deprecated: Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""")
        if geographic_region_ids is not None:
            pulumi.set(__self__, "geographic_region_ids", geographic_region_ids)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageName")
    def cen_bandwidth_package_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bandwidth package. Defaults to null.

        ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.

        ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        """
        return pulumi.get(self, "cen_bandwidth_package_name")

    @cen_bandwidth_package_name.setter
    def cen_bandwidth_package_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_bandwidth_package_name", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    @_utilities.deprecated("""Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the bandwidth package. Default to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time of the bandwidth package to expire.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="geographicRegionAId")
    def geographic_region_a_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        """
        return pulumi.get(self, "geographic_region_a_id")

    @geographic_region_a_id.setter
    def geographic_region_a_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geographic_region_a_id", value)

    @_builtins.property
    @pulumi.getter(name="geographicRegionBId")
    def geographic_region_b_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        """
        return pulumi.get(self, "geographic_region_b_id")

    @geographic_region_b_id.setter
    def geographic_region_b_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geographic_region_b_id", value)

    @_builtins.property
    @pulumi.getter(name="geographicRegionIds")
    @_utilities.deprecated("""Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""")
    def geographic_region_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        """
        return pulumi.get(self, "geographic_region_ids")

    @geographic_region_ids.setter
    def geographic_region_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "geographic_region_ids", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association status of the bandwidth package.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cen/bandwidthPackage:BandwidthPackage")
class BandwidthPackage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_a_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_b_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        CEN bandwidth package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/bandwidthPackage:BandwidthPackage example cenbwp-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_name: The name of the bandwidth package. Defaults to null.
               
               ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
               
               ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        :param pulumi.Input[_builtins.str] charge_type: Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        :param pulumi.Input[_builtins.str] description: The description of the bandwidth package. Default to null.
        :param pulumi.Input[_builtins.str] geographic_region_a_id: The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[_builtins.str] geographic_region_b_id: The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geographic_region_ids: Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        :param pulumi.Input[_builtins.int] period: The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BandwidthPackageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        CEN bandwidth package can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/bandwidthPackage:BandwidthPackage example cenbwp-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param BandwidthPackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BandwidthPackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 cen_bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_a_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_b_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geographic_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BandwidthPackageArgs.__new__(BandwidthPackageArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["cen_bandwidth_package_name"] = cen_bandwidth_package_name
            __props__.__dict__["charge_type"] = charge_type
            __props__.__dict__["description"] = description
            __props__.__dict__["geographic_region_a_id"] = geographic_region_a_id
            __props__.__dict__["geographic_region_b_id"] = geographic_region_b_id
            __props__.__dict__["geographic_region_ids"] = geographic_region_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["status"] = None
        super(BandwidthPackage, __self__).__init__(
            'alicloud:cen/bandwidthPackage:BandwidthPackage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            cen_bandwidth_package_name: Optional[pulumi.Input[_builtins.str]] = None,
            charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            geographic_region_a_id: Optional[pulumi.Input[_builtins.str]] = None,
            geographic_region_b_id: Optional[pulumi.Input[_builtins.str]] = None,
            geographic_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'BandwidthPackage':
        """
        Get an existing BandwidthPackage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_name: The name of the bandwidth package. Defaults to null.
               
               ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
               
               ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        :param pulumi.Input[_builtins.str] charge_type: Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        :param pulumi.Input[_builtins.str] description: The description of the bandwidth package. Default to null.
        :param pulumi.Input[_builtins.str] expired_time: The time of the bandwidth package to expire.
        :param pulumi.Input[_builtins.str] geographic_region_a_id: The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[_builtins.str] geographic_region_b_id: The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geographic_region_ids: Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        :param pulumi.Input[_builtins.int] period: The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] status: The association status of the bandwidth package.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BandwidthPackageState.__new__(_BandwidthPackageState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["cen_bandwidth_package_name"] = cen_bandwidth_package_name
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["geographic_region_a_id"] = geographic_region_a_id
        __props__.__dict__["geographic_region_b_id"] = geographic_region_b_id
        __props__.__dict__["geographic_region_ids"] = geographic_region_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["status"] = status
        return BandwidthPackage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageName")
    def cen_bandwidth_package_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bandwidth package. Defaults to null.

        ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.

        ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
        """
        return pulumi.get(self, "cen_bandwidth_package_name")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    @_utilities.deprecated("""Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.""")
    def charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the bandwidth package. Default to null.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time of the bandwidth package to expire.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="geographicRegionAId")
    def geographic_region_a_id(self) -> pulumi.Output[_builtins.str]:
        """
        The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        """
        return pulumi.get(self, "geographic_region_a_id")

    @_builtins.property
    @pulumi.getter(name="geographicRegionBId")
    def geographic_region_b_id(self) -> pulumi.Output[_builtins.str]:
        """
        The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
        """
        return pulumi.get(self, "geographic_region_b_id")

    @_builtins.property
    @pulumi.getter(name="geographicRegionIds")
    @_utilities.deprecated("""Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use 'geographic_region_a_id' and 'geographic_region_b_id' instead.""")
    def geographic_region_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
        """
        return pulumi.get(self, "geographic_region_ids")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The association status of the bandwidth package.
        """
        return pulumi.get(self, "status")

