# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRegionRouteEntriesResult',
    'AwaitableGetRegionRouteEntriesResult',
    'get_region_route_entries',
    'get_region_route_entries_output',
]

@pulumi.output_type
class GetRegionRouteEntriesResult:
    """
    A collection of values returned by getRegionRouteEntries.
    """
    def __init__(__self__, entries=None, id=None, instance_id=None, output_file=None, region_id=None):
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetRegionRouteEntriesEntryResult']:
        """
        A list of CEN Route Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        return pulumi.get(self, "region_id")


class AwaitableGetRegionRouteEntriesResult(GetRegionRouteEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionRouteEntriesResult(
            entries=self.entries,
            id=self.id,
            instance_id=self.instance_id,
            output_file=self.output_file,
            region_id=self.region_id)


def get_region_route_entries(instance_id: Optional[_builtins.str] = None,
                             output_file: Optional[_builtins.str] = None,
                             region_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionRouteEntriesResult:
    """
    This data source provides CEN Regional Route Entries available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    entry = alicloud.cen.get_region_route_entries(instance_id="cen-id1",
        region_id="cn-beijing")
    pulumi.export("firstRegionRouteEntriesRouteEntryCidrBlock", entry.entries[0].cidr_block)
    ```


    :param _builtins.str instance_id: ID of the CEN instance.
    :param _builtins.str region_id: ID of the region.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['regionId'] = region_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getRegionRouteEntries:getRegionRouteEntries', __args__, opts=opts, typ=GetRegionRouteEntriesResult).value

    return AwaitableGetRegionRouteEntriesResult(
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        region_id=pulumi.get(__ret__, 'region_id'))
def get_region_route_entries_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    region_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionRouteEntriesResult]:
    """
    This data source provides CEN Regional Route Entries available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    entry = alicloud.cen.get_region_route_entries(instance_id="cen-id1",
        region_id="cn-beijing")
    pulumi.export("firstRegionRouteEntriesRouteEntryCidrBlock", entry.entries[0].cidr_block)
    ```


    :param _builtins.str instance_id: ID of the CEN instance.
    :param _builtins.str region_id: ID of the region.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['regionId'] = region_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getRegionRouteEntries:getRegionRouteEntries', __args__, opts=opts, typ=GetRegionRouteEntriesResult)
    return __ret__.apply(lambda __response__: GetRegionRouteEntriesResult(
        entries=pulumi.get(__response__, 'entries'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        region_id=pulumi.get(__response__, 'region_id')))
