# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouteTableAggregationsResult',
    'AwaitableGetTransitRouteTableAggregationsResult',
    'get_transit_route_table_aggregations',
    'get_transit_route_table_aggregations_output',
]

@pulumi.output_type
class GetTransitRouteTableAggregationsResult:
    """
    A collection of values returned by getTransitRouteTableAggregations.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None, transit_route_table_aggregation_cidr=None, transit_route_table_aggregations=None, transit_route_table_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transit_route_table_aggregation_cidr and not isinstance(transit_route_table_aggregation_cidr, str):
            raise TypeError("Expected argument 'transit_route_table_aggregation_cidr' to be a str")
        pulumi.set(__self__, "transit_route_table_aggregation_cidr", transit_route_table_aggregation_cidr)
        if transit_route_table_aggregations and not isinstance(transit_route_table_aggregations, list):
            raise TypeError("Expected argument 'transit_route_table_aggregations' to be a list")
        pulumi.set(__self__, "transit_route_table_aggregations", transit_route_table_aggregations)
        if transit_route_table_id and not isinstance(transit_route_table_id, str):
            raise TypeError("Expected argument 'transit_route_table_id' to be a str")
        pulumi.set(__self__, "transit_route_table_id", transit_route_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Transit Route Table Aggregation names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the Transit Route Table Aggregation.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableAggregationCidr")
    def transit_route_table_aggregation_cidr(self) -> Optional[_builtins.str]:
        """
        The destination CIDR block of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_cidr")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableAggregations")
    def transit_route_table_aggregations(self) -> Sequence['outputs.GetTransitRouteTableAggregationsTransitRouteTableAggregationResult']:
        """
        A list of Cen Transit Route Table Aggregations. Each element contains the following attributes:
        """
        return pulumi.get(self, "transit_route_table_aggregations")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableId")
    def transit_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_route_table_id")


class AwaitableGetTransitRouteTableAggregationsResult(GetTransitRouteTableAggregationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouteTableAggregationsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status,
            transit_route_table_aggregation_cidr=self.transit_route_table_aggregation_cidr,
            transit_route_table_aggregations=self.transit_route_table_aggregations,
            transit_route_table_id=self.transit_route_table_id)


def get_transit_route_table_aggregations(ids: Optional[Sequence[_builtins.str]] = None,
                                         name_regex: Optional[_builtins.str] = None,
                                         output_file: Optional[_builtins.str] = None,
                                         status: Optional[_builtins.str] = None,
                                         transit_route_table_aggregation_cidr: Optional[_builtins.str] = None,
                                         transit_route_table_id: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouteTableAggregationsResult:
    """
    This data source provides the Cen Transit Route Table Aggregations of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.202.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cen.get_transit_route_table_aggregations(ids=["example_id"],
        transit_route_table_id="your_transit_route_table_id")
    pulumi.export("cenTransitRouterMulticastDomainId0", ids.transit_route_table_aggregations[0].id)
    name_regex = alicloud.cen.get_transit_route_table_aggregations(name_regex="^my-name",
        transit_route_table_id="your_transit_route_table_id")
    pulumi.export("cenTransitRouterMulticastDomainId1", name_regex.transit_route_table_aggregations[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Transit Route Table Aggregation IDs.
    :param _builtins.str name_regex: A regex string to filter results by Transit Route Table Aggregation name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
    :param _builtins.str transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route.
    :param _builtins.str transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['transitRouteTableAggregationCidr'] = transit_route_table_aggregation_cidr
    __args__['transitRouteTableId'] = transit_route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouteTableAggregations:getTransitRouteTableAggregations', __args__, opts=opts, typ=GetTransitRouteTableAggregationsResult).value

    return AwaitableGetTransitRouteTableAggregationsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        transit_route_table_aggregation_cidr=pulumi.get(__ret__, 'transit_route_table_aggregation_cidr'),
        transit_route_table_aggregations=pulumi.get(__ret__, 'transit_route_table_aggregations'),
        transit_route_table_id=pulumi.get(__ret__, 'transit_route_table_id'))
def get_transit_route_table_aggregations_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                                name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                transit_route_table_aggregation_cidr: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                transit_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransitRouteTableAggregationsResult]:
    """
    This data source provides the Cen Transit Route Table Aggregations of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.202.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cen.get_transit_route_table_aggregations(ids=["example_id"],
        transit_route_table_id="your_transit_route_table_id")
    pulumi.export("cenTransitRouterMulticastDomainId0", ids.transit_route_table_aggregations[0].id)
    name_regex = alicloud.cen.get_transit_route_table_aggregations(name_regex="^my-name",
        transit_route_table_id="your_transit_route_table_id")
    pulumi.export("cenTransitRouterMulticastDomainId1", name_regex.transit_route_table_aggregations[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Transit Route Table Aggregation IDs.
    :param _builtins.str name_regex: A regex string to filter results by Transit Route Table Aggregation name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
    :param _builtins.str transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route.
    :param _builtins.str transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['transitRouteTableAggregationCidr'] = transit_route_table_aggregation_cidr
    __args__['transitRouteTableId'] = transit_route_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getTransitRouteTableAggregations:getTransitRouteTableAggregations', __args__, opts=opts, typ=GetTransitRouteTableAggregationsResult)
    return __ret__.apply(lambda __response__: GetTransitRouteTableAggregationsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status'),
        transit_route_table_aggregation_cidr=pulumi.get(__response__, 'transit_route_table_aggregation_cidr'),
        transit_route_table_aggregations=pulumi.get(__response__, 'transit_route_table_aggregations'),
        transit_route_table_id=pulumi.get(__response__, 'transit_route_table_id')))
