# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateZoneArgs', 'PrivateZone']

@pulumi.input_type
class PrivateZoneArgs:
    def __init__(__self__, *,
                 access_region_id: pulumi.Input[_builtins.str],
                 cen_id: pulumi.Input[_builtins.str],
                 host_region_id: pulumi.Input[_builtins.str],
                 host_vpc_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PrivateZone resource.
        :param pulumi.Input[_builtins.str] access_region_id: The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] host_region_id: The ID of the region where PrivateZone is deployed.
               
               ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        :param pulumi.Input[_builtins.str] host_vpc_id: The ID of the VPC that is associated with PrivateZone.
        """
        pulumi.set(__self__, "access_region_id", access_region_id)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "host_region_id", host_region_id)
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        """
        return pulumi.get(self, "access_region_id")

    @access_region_id.setter
    def access_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_region_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region where PrivateZone is deployed.

        ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        """
        return pulumi.get(self, "host_region_id")

    @host_region_id.setter
    def host_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_region_id", value)

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC that is associated with PrivateZone.
        """
        return pulumi.get(self, "host_vpc_id")

    @host_vpc_id.setter
    def host_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_vpc_id", value)


@pulumi.input_type
class _PrivateZoneState:
    def __init__(__self__, *,
                 access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateZone resources.
        :param pulumi.Input[_builtins.str] access_region_id: The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] host_region_id: The ID of the region where PrivateZone is deployed.
               
               ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        :param pulumi.Input[_builtins.str] host_vpc_id: The ID of the VPC that is associated with PrivateZone.
        :param pulumi.Input[_builtins.str] status: The status of the Private Zone.
        """
        if access_region_id is not None:
            pulumi.set(__self__, "access_region_id", access_region_id)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if host_region_id is not None:
            pulumi.set(__self__, "host_region_id", host_region_id)
        if host_vpc_id is not None:
            pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        """
        return pulumi.get(self, "access_region_id")

    @access_region_id.setter
    def access_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_region_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where PrivateZone is deployed.

        ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        """
        return pulumi.get(self, "host_region_id")

    @host_region_id.setter
    def host_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_region_id", value)

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC that is associated with PrivateZone.
        """
        return pulumi.get(self, "host_vpc_id")

    @host_vpc_id.setter
    def host_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Private Zone.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cen/privateZone:PrivateZone")
class PrivateZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Private Zone resource.

        For information about Cloud Enterprise Network (CEN) Private Zone and how to use it, see [What is Private Zone](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-routeprivatezoneincentovpc).

        > **NOTE:** Available since v1.83.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_regions(current=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.17.3.0/24")
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            description=name)
        default_instance_attachment = alicloud.cen.InstanceAttachment("default",
            instance_id=default_instance.id,
            child_instance_id=default_network.id,
            child_instance_type="VPC",
            child_instance_region_id=default.regions[0].id)
        default_private_zone = alicloud.cen.PrivateZone("default",
            cen_id=default_instance_attachment.instance_id,
            access_region_id=default.regions[0].id,
            host_vpc_id=default_network.id,
            host_region_id=default.regions[0].id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Private Zone can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/privateZone:PrivateZone example <cen_id>:<access_region_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_region_id: The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] host_region_id: The ID of the region where PrivateZone is deployed.
               
               ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        :param pulumi.Input[_builtins.str] host_vpc_id: The ID of the VPC that is associated with PrivateZone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Private Zone resource.

        For information about Cloud Enterprise Network (CEN) Private Zone and how to use it, see [What is Private Zone](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-routeprivatezoneincentovpc).

        > **NOTE:** Available since v1.83.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_regions(current=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.17.3.0/24")
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            description=name)
        default_instance_attachment = alicloud.cen.InstanceAttachment("default",
            instance_id=default_instance.id,
            child_instance_id=default_network.id,
            child_instance_type="VPC",
            child_instance_region_id=default.regions[0].id)
        default_private_zone = alicloud.cen.PrivateZone("default",
            cen_id=default_instance_attachment.instance_id,
            access_region_id=default.regions[0].id,
            host_vpc_id=default_network.id,
            host_region_id=default.regions[0].id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Private Zone can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/privateZone:PrivateZone example <cen_id>:<access_region_id>
        ```

        :param str resource_name: The name of the resource.
        :param PrivateZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateZoneArgs.__new__(PrivateZoneArgs)

            if access_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_region_id'")
            __props__.__dict__["access_region_id"] = access_region_id
            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            if host_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_region_id'")
            __props__.__dict__["host_region_id"] = host_region_id
            if host_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_vpc_id'")
            __props__.__dict__["host_vpc_id"] = host_vpc_id
            __props__.__dict__["status"] = None
        super(PrivateZone, __self__).__init__(
            'alicloud:cen/privateZone:PrivateZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateZone':
        """
        Get an existing PrivateZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_region_id: The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] host_region_id: The ID of the region where PrivateZone is deployed.
               
               ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        :param pulumi.Input[_builtins.str] host_vpc_id: The ID of the VPC that is associated with PrivateZone.
        :param pulumi.Input[_builtins.str] status: The status of the Private Zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateZoneState.__new__(_PrivateZoneState)

        __props__.__dict__["access_region_id"] = access_region_id
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["host_region_id"] = host_region_id
        __props__.__dict__["host_vpc_id"] = host_vpc_id
        __props__.__dict__["status"] = status
        return PrivateZone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where PrivateZone is accessed. This region refers to the region in which PrivateZone is accessed by clients.
        """
        return pulumi.get(self, "access_region_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where PrivateZone is deployed.

        ->**NOTE:** The resource `cen.PrivateZone` depends on the resource `cen.InstanceAttachment`.
        """
        return pulumi.get(self, "host_region_id")

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC that is associated with PrivateZone.
        """
        return pulumi.get(self, "host_vpc_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Private Zone.
        """
        return pulumi.get(self, "status")

