# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrafficMarkingPolicyArgs', 'TrafficMarkingPolicy']

@pulumi.input_type
class TrafficMarkingPolicyArgs:
    def __init__(__self__, *,
                 marking_dscp: pulumi.Input[_builtins.int],
                 priority: pulumi.Input[_builtins.int],
                 transit_router_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 traffic_marking_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_match_rules: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]]] = None):
        """
        The set of arguments for constructing a TrafficMarkingPolicy resource.
        :param pulumi.Input[_builtins.int] marking_dscp: MarkingDscp
        :param pulumi.Input[_builtins.int] priority: Priority
        :param pulumi.Input[_builtins.str] transit_router_id: TransitRouterId
        :param pulumi.Input[_builtins.str] description: TrafficMarkingPolicyDescription
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly delete the traffic marker policy. Valid values:
        :param pulumi.Input[_builtins.str] traffic_marking_policy_name: TrafficMarkingPolicyName
        :param pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]] traffic_match_rules: List of stream classification rules.
               You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        """
        pulumi.set(__self__, "marking_dscp", marking_dscp)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if traffic_marking_policy_name is not None:
            pulumi.set(__self__, "traffic_marking_policy_name", traffic_marking_policy_name)
        if traffic_match_rules is not None:
            pulumi.set(__self__, "traffic_match_rules", traffic_match_rules)

    @_builtins.property
    @pulumi.getter(name="markingDscp")
    def marking_dscp(self) -> pulumi.Input[_builtins.int]:
        """
        MarkingDscp
        """
        return pulumi.get(self, "marking_dscp")

    @marking_dscp.setter
    def marking_dscp(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "marking_dscp", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Priority
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[_builtins.str]:
        """
        TransitRouterId
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TrafficMarkingPolicyDescription
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forcibly delete the traffic marker policy. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyName")
    def traffic_marking_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TrafficMarkingPolicyName
        """
        return pulumi.get(self, "traffic_marking_policy_name")

    @traffic_marking_policy_name.setter
    def traffic_marking_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_marking_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="trafficMatchRules")
    def traffic_match_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]]]:
        """
        List of stream classification rules.
        You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        """
        return pulumi.get(self, "traffic_match_rules")

    @traffic_match_rules.setter
    def traffic_match_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]]]):
        pulumi.set(self, "traffic_match_rules", value)


@pulumi.input_type
class _TrafficMarkingPolicyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 marking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_marking_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_marking_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_match_rules: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrafficMarkingPolicy resources.
        :param pulumi.Input[_builtins.str] description: TrafficMarkingPolicyDescription
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly delete the traffic marker policy. Valid values:
        :param pulumi.Input[_builtins.int] marking_dscp: MarkingDscp
        :param pulumi.Input[_builtins.int] priority: Priority
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] traffic_marking_policy_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] traffic_marking_policy_name: TrafficMarkingPolicyName
        :param pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]] traffic_match_rules: List of stream classification rules.
               You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        :param pulumi.Input[_builtins.str] transit_router_id: TransitRouterId
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if marking_dscp is not None:
            pulumi.set(__self__, "marking_dscp", marking_dscp)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if traffic_marking_policy_id is not None:
            pulumi.set(__self__, "traffic_marking_policy_id", traffic_marking_policy_id)
        if traffic_marking_policy_name is not None:
            pulumi.set(__self__, "traffic_marking_policy_name", traffic_marking_policy_name)
        if traffic_match_rules is not None:
            pulumi.set(__self__, "traffic_match_rules", traffic_match_rules)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TrafficMarkingPolicyDescription
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forcibly delete the traffic marker policy. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="markingDscp")
    def marking_dscp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MarkingDscp
        """
        return pulumi.get(self, "marking_dscp")

    @marking_dscp.setter
    def marking_dscp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "marking_dscp", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyId")
    def traffic_marking_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "traffic_marking_policy_id")

    @traffic_marking_policy_id.setter
    def traffic_marking_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_marking_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyName")
    def traffic_marking_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TrafficMarkingPolicyName
        """
        return pulumi.get(self, "traffic_marking_policy_name")

    @traffic_marking_policy_name.setter
    def traffic_marking_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_marking_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="trafficMatchRules")
    def traffic_match_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]]]:
        """
        List of stream classification rules.
        You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        """
        return pulumi.get(self, "traffic_match_rules")

    @traffic_match_rules.setter
    def traffic_match_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficMarkingPolicyTrafficMatchRuleArgs']]]]):
        pulumi.set(self, "traffic_match_rules", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TransitRouterId
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)


@pulumi.type_token("alicloud:cen/trafficMarkingPolicy:TrafficMarkingPolicy")
class TrafficMarkingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 marking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 traffic_marking_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficMarkingPolicyTrafficMatchRuleArgs', 'TrafficMarkingPolicyTrafficMatchRuleArgsDict']]]]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Traffic Marking Policy resource.

        For information about Cloud Enterprise Network (CEN) Traffic Marking Policy and how to use it, see [What is Traffic Marking Policy](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtrafficmarkingpolicy).

        > **NOTE:** Available since v1.173.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.cen.Instance("example",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_transit_router = alicloud.cen.TransitRouter("example",
            transit_router_name="tf_example",
            cen_id=example.id)
        example_traffic_marking_policy = alicloud.cen.TrafficMarkingPolicy("example",
            marking_dscp=1,
            priority=1,
            traffic_marking_policy_name="tf_example",
            transit_router_id=example_transit_router.transit_router_id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Traffic Marking Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/trafficMarkingPolicy:TrafficMarkingPolicy example <transit_router_id>:<traffic_marking_policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: TrafficMarkingPolicyDescription
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly delete the traffic marker policy. Valid values:
        :param pulumi.Input[_builtins.int] marking_dscp: MarkingDscp
        :param pulumi.Input[_builtins.int] priority: Priority
        :param pulumi.Input[_builtins.str] traffic_marking_policy_name: TrafficMarkingPolicyName
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficMarkingPolicyTrafficMatchRuleArgs', 'TrafficMarkingPolicyTrafficMatchRuleArgsDict']]]] traffic_match_rules: List of stream classification rules.
               You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        :param pulumi.Input[_builtins.str] transit_router_id: TransitRouterId
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficMarkingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Traffic Marking Policy resource.

        For information about Cloud Enterprise Network (CEN) Traffic Marking Policy and how to use it, see [What is Traffic Marking Policy](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtrafficmarkingpolicy).

        > **NOTE:** Available since v1.173.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.cen.Instance("example",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_transit_router = alicloud.cen.TransitRouter("example",
            transit_router_name="tf_example",
            cen_id=example.id)
        example_traffic_marking_policy = alicloud.cen.TrafficMarkingPolicy("example",
            marking_dscp=1,
            priority=1,
            traffic_marking_policy_name="tf_example",
            transit_router_id=example_transit_router.transit_router_id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Traffic Marking Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/trafficMarkingPolicy:TrafficMarkingPolicy example <transit_router_id>:<traffic_marking_policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param TrafficMarkingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficMarkingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 marking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 traffic_marking_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficMarkingPolicyTrafficMatchRuleArgs', 'TrafficMarkingPolicyTrafficMatchRuleArgsDict']]]]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficMarkingPolicyArgs.__new__(TrafficMarkingPolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["force"] = force
            if marking_dscp is None and not opts.urn:
                raise TypeError("Missing required property 'marking_dscp'")
            __props__.__dict__["marking_dscp"] = marking_dscp
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["traffic_marking_policy_name"] = traffic_marking_policy_name
            __props__.__dict__["traffic_match_rules"] = traffic_match_rules
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["status"] = None
            __props__.__dict__["traffic_marking_policy_id"] = None
        super(TrafficMarkingPolicy, __self__).__init__(
            'alicloud:cen/trafficMarkingPolicy:TrafficMarkingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            marking_dscp: Optional[pulumi.Input[_builtins.int]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_marking_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_marking_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficMarkingPolicyTrafficMatchRuleArgs', 'TrafficMarkingPolicyTrafficMatchRuleArgsDict']]]]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrafficMarkingPolicy':
        """
        Get an existing TrafficMarkingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: TrafficMarkingPolicyDescription
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly delete the traffic marker policy. Valid values:
        :param pulumi.Input[_builtins.int] marking_dscp: MarkingDscp
        :param pulumi.Input[_builtins.int] priority: Priority
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] traffic_marking_policy_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] traffic_marking_policy_name: TrafficMarkingPolicyName
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficMarkingPolicyTrafficMatchRuleArgs', 'TrafficMarkingPolicyTrafficMatchRuleArgsDict']]]] traffic_match_rules: List of stream classification rules.
               You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        :param pulumi.Input[_builtins.str] transit_router_id: TransitRouterId
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficMarkingPolicyState.__new__(_TrafficMarkingPolicyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["force"] = force
        __props__.__dict__["marking_dscp"] = marking_dscp
        __props__.__dict__["priority"] = priority
        __props__.__dict__["status"] = status
        __props__.__dict__["traffic_marking_policy_id"] = traffic_marking_policy_id
        __props__.__dict__["traffic_marking_policy_name"] = traffic_marking_policy_name
        __props__.__dict__["traffic_match_rules"] = traffic_match_rules
        __props__.__dict__["transit_router_id"] = transit_router_id
        return TrafficMarkingPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        TrafficMarkingPolicyDescription
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to forcibly delete the traffic marker policy. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="markingDscp")
    def marking_dscp(self) -> pulumi.Output[_builtins.int]:
        """
        MarkingDscp
        """
        return pulumi.get(self, "marking_dscp")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Priority
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyId")
    def traffic_marking_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "traffic_marking_policy_id")

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyName")
    def traffic_marking_policy_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        TrafficMarkingPolicyName
        """
        return pulumi.get(self, "traffic_marking_policy_name")

    @_builtins.property
    @pulumi.getter(name="trafficMatchRules")
    def traffic_match_rules(self) -> pulumi.Output[Optional[Sequence['outputs.TrafficMarkingPolicyTrafficMatchRule']]]:
        """
        List of stream classification rules.
        You can add up to 50 stream classification rules at a time. See `traffic_match_rules` below.
        """
        return pulumi.get(self, "traffic_match_rules")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        TransitRouterId
        """
        return pulumi.get(self, "transit_router_id")

