# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TransitRouterRouteTableAssociationArgs', 'TransitRouterRouteTableAssociation']

@pulumi.input_type
class TransitRouterRouteTableAssociationArgs:
    def __init__(__self__, *,
                 transit_router_attachment_id: pulumi.Input[_builtins.str],
                 transit_router_route_table_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TransitRouterRouteTableAssociation resource.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: TransitRouterAttachmentId
        :param pulumi.Input[_builtins.str] transit_router_route_table_id: TransitRouterRouteTableId
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Input[_builtins.str]:
        """
        TransitRouterAttachmentId
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        TransitRouterRouteTableId
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @transit_router_route_table_id.setter
    def transit_router_route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)


@pulumi.input_type
class _TransitRouterRouteTableAssociationState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_route_table_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterRouteTableAssociation resources.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: TransitRouterAttachmentId
        :param pulumi.Input[_builtins.str] transit_router_route_table_id: TransitRouterRouteTableId
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_route_table_id is not None:
            pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TransitRouterAttachmentId
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TransitRouterRouteTableId
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @transit_router_route_table_id.setter
    def transit_router_route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_route_table_id", value)


@pulumi.type_token("alicloud:cen/transitRouterRouteTableAssociation:TransitRouterRouteTableAssociation")
class TransitRouterRouteTableAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Route Table Association resource.

        The routing association of the routing table of the forwarding router.

        For information about Cloud Enterprise Network (CEN) Transit Router Route Table Association and how to use it, see [What is Transit Router Route Table Association](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-associatetransitrouterattachmentwithroutetable).

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cen.get_transit_router_available_resources()
        master_zone = default.resources[0].master_zones[0]
        slave_zone = default.resources[0].slave_zones[1]
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_master = alicloud.vpc.Switch("default_master",
            vswitch_name=name,
            cidr_block="192.168.1.0/24",
            vpc_id=default_network.id,
            zone_id=master_zone)
        default_slave = alicloud.vpc.Switch("default_slave",
            vswitch_name=name,
            cidr_block="192.168.2.0/24",
            vpc_id=default_network.id,
            zone_id=slave_zone)
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_transit_router = alicloud.cen.TransitRouter("default",
            transit_router_name=name,
            cen_id=default_instance.id)
        default_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("default", transit_router_id=default_transit_router.transit_router_id)
        default_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("default",
            cen_id=default_instance.id,
            transit_router_id=default_transit_router.transit_router_id,
            vpc_id=default_network.id,
            transit_router_vpc_attachment_name=name,
            transit_router_attachment_description=name,
            zone_mappings=[
                {
                    "zone_id": master_zone,
                    "vswitch_id": default_master.id,
                },
                {
                    "zone_id": slave_zone,
                    "vswitch_id": default_slave.id,
                },
            ])
        default_transit_router_route_table_association = alicloud.cen.TransitRouterRouteTableAssociation("default",
            transit_router_route_table_id=default_transit_router_route_table.transit_router_route_table_id,
            transit_router_attachment_id=default_transit_router_vpc_attachment.transit_router_attachment_id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Route Table Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterRouteTableAssociation:TransitRouterRouteTableAssociation example <transit_router_attachment_id>:<transit_router_route_table_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: TransitRouterAttachmentId
        :param pulumi.Input[_builtins.str] transit_router_route_table_id: TransitRouterRouteTableId
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterRouteTableAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Route Table Association resource.

        The routing association of the routing table of the forwarding router.

        For information about Cloud Enterprise Network (CEN) Transit Router Route Table Association and how to use it, see [What is Transit Router Route Table Association](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-associatetransitrouterattachmentwithroutetable).

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cen.get_transit_router_available_resources()
        master_zone = default.resources[0].master_zones[0]
        slave_zone = default.resources[0].slave_zones[1]
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        default_master = alicloud.vpc.Switch("default_master",
            vswitch_name=name,
            cidr_block="192.168.1.0/24",
            vpc_id=default_network.id,
            zone_id=master_zone)
        default_slave = alicloud.vpc.Switch("default_slave",
            vswitch_name=name,
            cidr_block="192.168.2.0/24",
            vpc_id=default_network.id,
            zone_id=slave_zone)
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_transit_router = alicloud.cen.TransitRouter("default",
            transit_router_name=name,
            cen_id=default_instance.id)
        default_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("default", transit_router_id=default_transit_router.transit_router_id)
        default_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("default",
            cen_id=default_instance.id,
            transit_router_id=default_transit_router.transit_router_id,
            vpc_id=default_network.id,
            transit_router_vpc_attachment_name=name,
            transit_router_attachment_description=name,
            zone_mappings=[
                {
                    "zone_id": master_zone,
                    "vswitch_id": default_master.id,
                },
                {
                    "zone_id": slave_zone,
                    "vswitch_id": default_slave.id,
                },
            ])
        default_transit_router_route_table_association = alicloud.cen.TransitRouterRouteTableAssociation("default",
            transit_router_route_table_id=default_transit_router_route_table.transit_router_route_table_id,
            transit_router_attachment_id=default_transit_router_vpc_attachment.transit_router_attachment_id)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Route Table Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterRouteTableAssociation:TransitRouterRouteTableAssociation example <transit_router_attachment_id>:<transit_router_route_table_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterRouteTableAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterRouteTableAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterRouteTableAssociationArgs.__new__(TransitRouterRouteTableAssociationArgs)

            __props__.__dict__["dry_run"] = dry_run
            if transit_router_attachment_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_attachment_id'")
            __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
            if transit_router_route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_route_table_id'")
            __props__.__dict__["transit_router_route_table_id"] = transit_router_route_table_id
            __props__.__dict__["status"] = None
        super(TransitRouterRouteTableAssociation, __self__).__init__(
            'alicloud:cen/transitRouterRouteTableAssociation:TransitRouterRouteTableAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_route_table_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitRouterRouteTableAssociation':
        """
        Get an existing TransitRouterRouteTableAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: TransitRouterAttachmentId
        :param pulumi.Input[_builtins.str] transit_router_route_table_id: TransitRouterRouteTableId
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterRouteTableAssociationState.__new__(_TransitRouterRouteTableAssociationState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_route_table_id"] = transit_router_route_table_id
        return TransitRouterRouteTableAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        TransitRouterAttachmentId
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        TransitRouterRouteTableId
        """
        return pulumi.get(self, "transit_router_route_table_id")

