# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDeliveriesResult',
    'AwaitableGetDeliveriesResult',
    'get_deliveries',
    'get_deliveries_output',
]

@pulumi.output_type
class GetDeliveriesResult:
    """
    A collection of values returned by getDeliveries.
    """
    def __init__(__self__, deliveries=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None):
        if deliveries and not isinstance(deliveries, list):
            raise TypeError("Expected argument 'deliveries' to be a list")
        pulumi.set(__self__, "deliveries", deliveries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, int):
            raise TypeError("Expected argument 'status' to be a int")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def deliveries(self) -> Sequence['outputs.GetDeliveriesDeliveryResult']:
        """
        A list of Config Deliveries. Each element contains the following attributes:
        """
        return pulumi.get(self, "deliveries")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Config Delivery names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        """
        The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
        """
        return pulumi.get(self, "status")


class AwaitableGetDeliveriesResult(GetDeliveriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeliveriesResult(
            deliveries=self.deliveries,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_deliveries(ids: Optional[Sequence[_builtins.str]] = None,
                   name_regex: Optional[_builtins.str] = None,
                   output_file: Optional[_builtins.str] = None,
                   status: Optional[_builtins.int] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeliveriesResult:
    """
    This data source provides the Config Deliveries of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.171.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cfg.get_deliveries(ids=["example_id"])
    pulumi.export("configDeliveryId1", ids.deliveries[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Delivery IDs.
    :param _builtins.str name_regex: A regex string to filter results by delivery channel name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int status: The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cfg/getDeliveries:getDeliveries', __args__, opts=opts, typ=GetDeliveriesResult).value

    return AwaitableGetDeliveriesResult(
        deliveries=pulumi.get(__ret__, 'deliveries'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_deliveries_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                          name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          status: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeliveriesResult]:
    """
    This data source provides the Config Deliveries of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.171.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cfg.get_deliveries(ids=["example_id"])
    pulumi.export("configDeliveryId1", ids.deliveries[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Delivery IDs.
    :param _builtins.str name_regex: A regex string to filter results by delivery channel name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int status: The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cfg/getDeliveries:getDeliveries', __args__, opts=opts, typ=GetDeliveriesResult)
    return __ret__.apply(lambda __response__: GetDeliveriesResult(
        deliveries=pulumi.get(__response__, 'deliveries'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
