# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupPolicyArgs', 'BackupPolicy']

@pulumi.input_type
class BackupPolicyArgs:
    def __init__(__self__, *,
                 backup_retention_period: pulumi.Input[_builtins.int],
                 db_instance_id: pulumi.Input[_builtins.str],
                 preferred_backup_period: pulumi.Input[_builtins.str],
                 preferred_backup_time: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a BackupPolicy resource.
        :param pulumi.Input[_builtins.int] backup_retention_period: Backup retention time.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] preferred_backup_period: Backup period.
        :param pulumi.Input[_builtins.str] preferred_backup_time: Backup time.
        """
        pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "preferred_backup_period", preferred_backup_period)
        pulumi.set(__self__, "preferred_backup_time", preferred_backup_time)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Input[_builtins.int]:
        """
        Backup retention time.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriod")
    def preferred_backup_period(self) -> pulumi.Input[_builtins.str]:
        """
        Backup period.
        """
        return pulumi.get(self, "preferred_backup_period")

    @preferred_backup_period.setter
    def preferred_backup_period(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "preferred_backup_period", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> pulumi.Input[_builtins.str]:
        """
        Backup time.
        """
        return pulumi.get(self, "preferred_backup_time")

    @preferred_backup_time.setter
    def preferred_backup_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "preferred_backup_time", value)


@pulumi.input_type
class _BackupPolicyState:
    def __init__(__self__, *,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPolicy resources.
        :param pulumi.Input[_builtins.int] backup_retention_period: Backup retention time.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] preferred_backup_period: Backup period.
        :param pulumi.Input[_builtins.str] preferred_backup_time: Backup time.
        """
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if preferred_backup_period is not None:
            pulumi.set(__self__, "preferred_backup_period", preferred_backup_period)
        if preferred_backup_time is not None:
            pulumi.set(__self__, "preferred_backup_time", preferred_backup_time)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Backup retention time.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriod")
    def preferred_backup_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup period.
        """
        return pulumi.get(self, "preferred_backup_period")

    @preferred_backup_period.setter
    def preferred_backup_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_period", value)

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup time.
        """
        return pulumi.get(self, "preferred_backup_time")

    @preferred_backup_time.setter
    def preferred_backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_backup_time", value)


@pulumi.type_token("alicloud:clickhouseenterprisedbcluster/backupPolicy:BackupPolicy")
class BackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Click House Enterprise Db Cluster Backup Policy resource.

        Enterprise ClickHouse instance backup policy.

        For information about Click House Enterprise Db Cluster Backup Policy and how to use it, see [What is Enterprise Db Cluster Backup Policy](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/CreateBackupPolicy).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        default1t_t_lwe = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("default1tTLwe",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id)
        default = alicloud.clickhouseenterprisedbcluster.BackupPolicy("default",
            preferred_backup_period="Monday",
            preferred_backup_time="04:00Z-05:00Z",
            backup_retention_period=7,
            db_instance_id=default1t_t_lwe.id)
        ```

        ## Import

        Click House Enterprise Db Cluster Backup Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/backupPolicy:BackupPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] backup_retention_period: Backup retention time.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] preferred_backup_period: Backup period.
        :param pulumi.Input[_builtins.str] preferred_backup_time: Backup time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Click House Enterprise Db Cluster Backup Policy resource.

        Enterprise ClickHouse instance backup policy.

        For information about Click House Enterprise Db Cluster Backup Policy and how to use it, see [What is Enterprise Db Cluster Backup Policy](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/CreateBackupPolicy).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        default1t_t_lwe = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("default1tTLwe",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id)
        default = alicloud.clickhouseenterprisedbcluster.BackupPolicy("default",
            preferred_backup_period="Monday",
            preferred_backup_time="04:00Z-05:00Z",
            backup_retention_period=7,
            db_instance_id=default1t_t_lwe.id)
        ```

        ## Import

        Click House Enterprise Db Cluster Backup Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/backupPolicy:BackupPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_backup_period: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyArgs.__new__(BackupPolicyArgs)

            if backup_retention_period is None and not opts.urn:
                raise TypeError("Missing required property 'backup_retention_period'")
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            if preferred_backup_period is None and not opts.urn:
                raise TypeError("Missing required property 'preferred_backup_period'")
            __props__.__dict__["preferred_backup_period"] = preferred_backup_period
            if preferred_backup_time is None and not opts.urn:
                raise TypeError("Missing required property 'preferred_backup_time'")
            __props__.__dict__["preferred_backup_time"] = preferred_backup_time
        super(BackupPolicy, __self__).__init__(
            'alicloud:clickhouseenterprisedbcluster/backupPolicy:BackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_backup_period: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_backup_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupPolicy':
        """
        Get an existing BackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] backup_retention_period: Backup retention time.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] preferred_backup_period: Backup period.
        :param pulumi.Input[_builtins.str] preferred_backup_time: Backup time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyState.__new__(_BackupPolicyState)

        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["preferred_backup_period"] = preferred_backup_period
        __props__.__dict__["preferred_backup_time"] = preferred_backup_time
        return BackupPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[_builtins.int]:
        """
        Backup retention time.
        """
        return pulumi.get(self, "backup_retention_period")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="preferredBackupPeriod")
    def preferred_backup_period(self) -> pulumi.Output[_builtins.str]:
        """
        Backup period.
        """
        return pulumi.get(self, "preferred_backup_period")

    @_builtins.property
    @pulumi.getter(name="preferredBackupTime")
    def preferred_backup_time(self) -> pulumi.Output[_builtins.str]:
        """
        Backup time.
        """
        return pulumi.get(self, "preferred_backup_time")

