# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ControlPolicyArgs', 'ControlPolicy']

@pulumi.input_type
class ControlPolicyArgs:
    def __init__(__self__, *,
                 acl_action: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 destination: pulumi.Input[_builtins.str],
                 destination_type: pulumi.Input[_builtins.str],
                 direction: pulumi.Input[_builtins.str],
                 proto: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ControlPolicy resource.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        :param pulumi.Input[_builtins.str] proto: The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        :param pulumi.Input[_builtins.str] application_name: The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The application types supported by the access control policy.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        :param pulumi.Input[_builtins.str] dest_port_group: The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] domain_resolve_type: The domain name resolution method of the access control policy. Valid values:
               - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
               - `DNS`: DNS-based dynamic resolution.
               - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        :param pulumi.Input[_builtins.int] end_time: The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        :param pulumi.Input[_builtins.str] ip_version: The IP version supported by the access control policy. Default value: `4`. Valid values:
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] release: The status of the access control policy. Valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: The days of a week or of a month on which the access control policy takes effect. Valid values:
               - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
               - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
               > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        :param pulumi.Input[_builtins.str] repeat_end_time: The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        :param pulumi.Input[_builtins.str] repeat_start_time: The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        :param pulumi.Input[_builtins.str] repeat_type: The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
               - `Permanent`: The policy always takes effect.
               - `None`: The policy takes effect for only once.
               - `Daily`: The policy takes effect on a daily basis.
               - `Weekly`: The policy takes effect on a weekly basis.
               - `Monthly`: The policy takes effect on a monthly basis.
        :param pulumi.Input[_builtins.str] source_ip: The source IP address of the request.
        :param pulumi.Input[_builtins.int] start_time: The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        pulumi.set(__self__, "acl_action", acl_action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_type", source_type)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if application_name_lists is not None:
            pulumi.set(__self__, "application_name_lists", application_name_lists)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if domain_resolve_type is not None:
            pulumi.set(__self__, "domain_resolve_type", domain_resolve_type)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if repeat_days is not None:
            pulumi.set(__self__, "repeat_days", repeat_days)
        if repeat_end_time is not None:
            pulumi.set(__self__, "repeat_end_time", repeat_end_time)
        if repeat_start_time is not None:
            pulumi.set(__self__, "repeat_start_time", repeat_start_time)
        if repeat_type is not None:
            pulumi.set(__self__, "repeat_type", repeat_type)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Input[_builtins.str]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        The destination address in the access control policy.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def proto(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "proto", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        The source address in the access control policy.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter(name="applicationNameLists")
    def application_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The application types supported by the access control policy.
        > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        """
        return pulumi.get(self, "application_name_lists")

    @application_name_lists.setter
    def application_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_name_lists", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_group", value)

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the destination port in the access control policy. Valid values: `port`, `group`.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_type", value)

    @_builtins.property
    @pulumi.getter(name="domainResolveType")
    def domain_resolve_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name resolution method of the access control policy. Valid values:
        - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
        - `DNS`: DNS-based dynamic resolution.
        - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        """
        return pulumi.get(self, "domain_resolve_type")

    @domain_resolve_type.setter
    def domain_resolve_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_resolve_type", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version supported by the access control policy. Default value: `4`. Valid values:
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the content within the request and response. Valid values: `zh`, `en`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the access control policy. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release", value)

    @_builtins.property
    @pulumi.getter(name="repeatDays")
    def repeat_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        The days of a week or of a month on which the access control policy takes effect. Valid values:
        - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
        - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
        > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        """
        return pulumi.get(self, "repeat_days")

    @repeat_days.setter
    def repeat_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "repeat_days", value)

    @_builtins.property
    @pulumi.getter(name="repeatEndTime")
    def repeat_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        """
        return pulumi.get(self, "repeat_end_time")

    @repeat_end_time.setter
    def repeat_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_end_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatStartTime")
    def repeat_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        return pulumi.get(self, "repeat_start_time")

    @repeat_start_time.setter
    def repeat_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_start_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatType")
    def repeat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
        - `Permanent`: The policy always takes effect.
        - `None`: The policy takes effect for only once.
        - `Daily`: The policy takes effect on a daily basis.
        - `Weekly`: The policy takes effect on a weekly basis.
        - `Monthly`: The policy takes effect on a monthly basis.
        """
        return pulumi.get(self, "repeat_type")

    @repeat_type.setter
    def repeat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IP address of the request.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _ControlPolicyState:
    def __init__(__self__, *,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ControlPolicy resources.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] acl_uuid: (Available since v1.148.0) The unique ID of the access control policy.
        :param pulumi.Input[_builtins.str] application_name: The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The application types supported by the access control policy.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.232.0) The time when the access control policy was created.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        :param pulumi.Input[_builtins.str] dest_port_group: The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        :param pulumi.Input[_builtins.str] domain_resolve_type: The domain name resolution method of the access control policy. Valid values:
               - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
               - `DNS`: DNS-based dynamic resolution.
               - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        :param pulumi.Input[_builtins.int] end_time: The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        :param pulumi.Input[_builtins.str] ip_version: The IP version supported by the access control policy. Default value: `4`. Valid values:
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] proto: The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.str] release: The status of the access control policy. Valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: The days of a week or of a month on which the access control policy takes effect. Valid values:
               - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
               - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
               > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        :param pulumi.Input[_builtins.str] repeat_end_time: The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        :param pulumi.Input[_builtins.str] repeat_start_time: The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        :param pulumi.Input[_builtins.str] repeat_type: The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
               - `Permanent`: The policy always takes effect.
               - `None`: The policy takes effect for only once.
               - `Daily`: The policy takes effect on a daily basis.
               - `Weekly`: The policy takes effect on a weekly basis.
               - `Monthly`: The policy takes effect on a monthly basis.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy.
        :param pulumi.Input[_builtins.str] source_ip: The source IP address of the request.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        :param pulumi.Input[_builtins.int] start_time: The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        if acl_action is not None:
            pulumi.set(__self__, "acl_action", acl_action)
        if acl_uuid is not None:
            pulumi.set(__self__, "acl_uuid", acl_uuid)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if application_name_lists is not None:
            pulumi.set(__self__, "application_name_lists", application_name_lists)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if domain_resolve_type is not None:
            pulumi.set(__self__, "domain_resolve_type", domain_resolve_type)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if proto is not None:
            pulumi.set(__self__, "proto", proto)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if repeat_days is not None:
            pulumi.set(__self__, "repeat_days", repeat_days)
        if repeat_end_time is not None:
            pulumi.set(__self__, "repeat_end_time", repeat_end_time)
        if repeat_start_time is not None:
            pulumi.set(__self__, "repeat_start_time", repeat_start_time)
        if repeat_type is not None:
            pulumi.set(__self__, "repeat_type", repeat_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_action", value)

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.148.0) The unique ID of the access control policy.
        """
        return pulumi.get(self, "acl_uuid")

    @acl_uuid.setter
    def acl_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_uuid", value)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter(name="applicationNameLists")
    def application_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The application types supported by the access control policy.
        > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        """
        return pulumi.get(self, "application_name_lists")

    @application_name_lists.setter
    def application_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_name_lists", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.232.0) The time when the access control policy was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_group", value)

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the destination port in the access control policy. Valid values: `port`, `group`.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_type", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination address in the access control policy.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="domainResolveType")
    def domain_resolve_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name resolution method of the access control policy. Valid values:
        - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
        - `DNS`: DNS-based dynamic resolution.
        - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        """
        return pulumi.get(self, "domain_resolve_type")

    @domain_resolve_type.setter
    def domain_resolve_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_resolve_type", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version supported by the access control policy. Default value: `4`. Valid values:
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the content within the request and response. Valid values: `zh`, `en`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter
    def proto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proto", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the access control policy. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release", value)

    @_builtins.property
    @pulumi.getter(name="repeatDays")
    def repeat_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        The days of a week or of a month on which the access control policy takes effect. Valid values:
        - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
        - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
        > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        """
        return pulumi.get(self, "repeat_days")

    @repeat_days.setter
    def repeat_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "repeat_days", value)

    @_builtins.property
    @pulumi.getter(name="repeatEndTime")
    def repeat_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        """
        return pulumi.get(self, "repeat_end_time")

    @repeat_end_time.setter
    def repeat_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_end_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatStartTime")
    def repeat_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        return pulumi.get(self, "repeat_start_time")

    @repeat_start_time.setter
    def repeat_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_start_time", value)

    @_builtins.property
    @pulumi.getter(name="repeatType")
    def repeat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
        - `Permanent`: The policy always takes effect.
        - `None`: The policy takes effect for only once.
        - `Daily`: The policy takes effect on a daily basis.
        - `Weekly`: The policy takes effect on a weekly basis.
        - `Monthly`: The policy takes effect on a monthly basis.
        """
        return pulumi.get(self, "repeat_type")

    @repeat_type.setter
    def repeat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_type", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source address in the access control policy.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IP address of the request.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)


@pulumi.type_token("alicloud:cloudfirewall/controlPolicy:ControlPolicy")
class ControlPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Control Policy resource.

        For information about Cloud Firewall Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/doc-detail/138867.htm).

        > **NOTE:** Available since v1.129.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudfirewall.ControlPolicy("default",
            direction="in",
            application_name="ANY",
            description=name,
            acl_action="accept",
            source="127.0.0.1/32",
            source_type="net",
            destination="127.0.0.2/32",
            destination_type="net",
            proto="ANY")
        ```

        ## Import

        Cloud Firewall Control Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/controlPolicy:ControlPolicy example <acl_uuid>:<direction>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] application_name: The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The application types supported by the access control policy.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        :param pulumi.Input[_builtins.str] dest_port_group: The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        :param pulumi.Input[_builtins.str] domain_resolve_type: The domain name resolution method of the access control policy. Valid values:
               - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
               - `DNS`: DNS-based dynamic resolution.
               - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        :param pulumi.Input[_builtins.int] end_time: The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        :param pulumi.Input[_builtins.str] ip_version: The IP version supported by the access control policy. Default value: `4`. Valid values:
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] proto: The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.str] release: The status of the access control policy. Valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: The days of a week or of a month on which the access control policy takes effect. Valid values:
               - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
               - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
               > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        :param pulumi.Input[_builtins.str] repeat_end_time: The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        :param pulumi.Input[_builtins.str] repeat_start_time: The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        :param pulumi.Input[_builtins.str] repeat_type: The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
               - `Permanent`: The policy always takes effect.
               - `None`: The policy takes effect for only once.
               - `Daily`: The policy takes effect on a daily basis.
               - `Weekly`: The policy takes effect on a weekly basis.
               - `Monthly`: The policy takes effect on a monthly basis.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy.
        :param pulumi.Input[_builtins.str] source_ip: The source IP address of the request.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        :param pulumi.Input[_builtins.int] start_time: The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ControlPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Control Policy resource.

        For information about Cloud Firewall Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/doc-detail/138867.htm).

        > **NOTE:** Available since v1.129.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudfirewall.ControlPolicy("default",
            direction="in",
            application_name="ANY",
            description=name,
            acl_action="accept",
            source="127.0.0.1/32",
            source_type="net",
            destination="127.0.0.2/32",
            destination_type="net",
            proto="ANY")
        ```

        ## Import

        Cloud Firewall Control Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/controlPolicy:ControlPolicy example <acl_uuid>:<direction>
        ```

        :param str resource_name: The name of the resource.
        :param ControlPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resolve_type: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlPolicyArgs.__new__(ControlPolicyArgs)

            if acl_action is None and not opts.urn:
                raise TypeError("Missing required property 'acl_action'")
            __props__.__dict__["acl_action"] = acl_action
            __props__.__dict__["application_name"] = application_name
            __props__.__dict__["application_name_lists"] = application_name_lists
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["dest_port"] = dest_port
            __props__.__dict__["dest_port_group"] = dest_port_group
            __props__.__dict__["dest_port_type"] = dest_port_type
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if destination_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_type'")
            __props__.__dict__["destination_type"] = destination_type
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["domain_resolve_type"] = domain_resolve_type
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["lang"] = lang
            if proto is None and not opts.urn:
                raise TypeError("Missing required property 'proto'")
            __props__.__dict__["proto"] = proto
            __props__.__dict__["release"] = release
            __props__.__dict__["repeat_days"] = repeat_days
            __props__.__dict__["repeat_end_time"] = repeat_end_time
            __props__.__dict__["repeat_start_time"] = repeat_start_time
            __props__.__dict__["repeat_type"] = repeat_type
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_ip"] = source_ip
            if source_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_type'")
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["acl_uuid"] = None
            __props__.__dict__["create_time"] = None
        super(ControlPolicy, __self__).__init__(
            'alicloud:cloudfirewall/controlPolicy:ControlPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_action: Optional[pulumi.Input[_builtins.str]] = None,
            acl_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            application_name: Optional[pulumi.Input[_builtins.str]] = None,
            application_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            domain_resolve_type: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.int]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            proto: Optional[pulumi.Input[_builtins.str]] = None,
            release: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            repeat_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_type: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_ip: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'ControlPolicy':
        """
        Get an existing ControlPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] acl_uuid: (Available since v1.148.0) The unique ID of the access control policy.
        :param pulumi.Input[_builtins.str] application_name: The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_name_lists: The application types supported by the access control policy.
               > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.232.0) The time when the access control policy was created.
        :param pulumi.Input[_builtins.str] description: The description of the access control policy.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        :param pulumi.Input[_builtins.str] dest_port_group: The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        :param pulumi.Input[_builtins.str] domain_resolve_type: The domain name resolution method of the access control policy. Valid values:
               - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
               - `DNS`: DNS-based dynamic resolution.
               - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        :param pulumi.Input[_builtins.int] end_time: The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        :param pulumi.Input[_builtins.str] ip_version: The IP version supported by the access control policy. Default value: `4`. Valid values:
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] proto: The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.str] release: The status of the access control policy. Valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] repeat_days: The days of a week or of a month on which the access control policy takes effect. Valid values:
               - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
               - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
               > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        :param pulumi.Input[_builtins.str] repeat_end_time: The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
               > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        :param pulumi.Input[_builtins.str] repeat_start_time: The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        :param pulumi.Input[_builtins.str] repeat_type: The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
               - `Permanent`: The policy always takes effect.
               - `None`: The policy takes effect for only once.
               - `Daily`: The policy takes effect on a daily basis.
               - `Weekly`: The policy takes effect on a weekly basis.
               - `Monthly`: The policy takes effect on a monthly basis.
        :param pulumi.Input[_builtins.str] source: The source address in the access control policy.
        :param pulumi.Input[_builtins.str] source_ip: The source IP address of the request.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        :param pulumi.Input[_builtins.int] start_time: The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlPolicyState.__new__(_ControlPolicyState)

        __props__.__dict__["acl_action"] = acl_action
        __props__.__dict__["acl_uuid"] = acl_uuid
        __props__.__dict__["application_name"] = application_name
        __props__.__dict__["application_name_lists"] = application_name_lists
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dest_port"] = dest_port
        __props__.__dict__["dest_port_group"] = dest_port_group
        __props__.__dict__["dest_port_type"] = dest_port_type
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["direction"] = direction
        __props__.__dict__["domain_resolve_type"] = domain_resolve_type
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["lang"] = lang
        __props__.__dict__["proto"] = proto
        __props__.__dict__["release"] = release
        __props__.__dict__["repeat_days"] = repeat_days
        __props__.__dict__["repeat_end_time"] = repeat_end_time
        __props__.__dict__["repeat_start_time"] = repeat_start_time
        __props__.__dict__["repeat_type"] = repeat_type
        __props__.__dict__["source"] = source
        __props__.__dict__["source_ip"] = source_ip
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["start_time"] = start_time
        return ControlPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Output[_builtins.str]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.148.0) The unique ID of the access control policy.
        """
        return pulumi.get(self, "acl_uuid")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The application type supported by the access control policy. Valid values: `ANY`, `HTTP`, `HTTPS`, `MQTT`, `Memcache`, `MongoDB`, `MySQL`, `RDP`, `Redis`, `SMTP`, `SMTPS`, `SSH`, `SSL`, `VNC`.
        > **NOTE:** If `proto` is set to `TCP`, you can set `application_name` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name` to `ANY`.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="applicationNameLists")
    def application_name_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The application types supported by the access control policy.
        > **NOTE:** If `proto` is set to `TCP`, you can set `application_name_list` to any valid value. If `proto` is set to `UDP`, `ICMP`, or `ANY`, you can only set `application_name_list` to `["ANY"]`. From version 1.232.0, You must specify at least one of the `application_name_list` and `application_name`. If you specify both `application_name_list` and `application_name`, only the `application_name_list` takes effect.
        """
        return pulumi.get(self, "application_name_lists")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.232.0) The time when the access control policy was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the access control policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Output[_builtins.str]:
        """
        The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify `dest_port`.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the destination port address book in the access control policy. **Note:** If `dest_port_type` is set to `group`, you must specify `dest_port_group`.
        """
        return pulumi.get(self, "dest_port_group")

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the destination port in the access control policy. Valid values: `port`, `group`.
        """
        return pulumi.get(self, "dest_port_type")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        The destination address in the access control policy.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`, `location`.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.str]:
        """
        The direction of the traffic to which the access control policy applies. Valid values: `in`, `out`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="domainResolveType")
    def domain_resolve_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain name resolution method of the access control policy. Valid values:
        - `FQDN`: Fully qualified domain name (FQDN)-based resolution.
        - `DNS`: DNS-based dynamic resolution.
        - `FQDN_AND_DNS`: FQDN and DNS-based dynamic resolution.
        """
        return pulumi.get(self, "domain_resolve_type")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        > **NOTE:** If `repeat_type` is set to `None`, `Daily`, `Weekly`, or `Monthly`, `start_time` and `end_time` must be set.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version supported by the access control policy. Default value: `4`. Valid values:
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the content within the request and response. Valid values: `zh`, `en`.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol type supported by the access control policy. Valid values: `ANY`, ` TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter
    def release(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the access control policy. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter(name="repeatDays")
    def repeat_days(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        The days of a week or of a month on which the access control policy takes effect. Valid values:
        - If `repeat_type` is set to `Weekly`. Valid values: `0` to `6`.
        - If `repeat_type` is set to `Monthly`. Valid values: `1` to `31`.
        > **NOTE:** If `repeat_type` is set to `Weekly`, or `Monthly`, `repeat_days` must be set.
        """
        return pulumi.get(self, "repeat_days")

    @_builtins.property
    @pulumi.getter(name="repeatEndTime")
    def repeat_end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The point in time when the recurrence ends. Example: `23:30`. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        > **NOTE:** If `repeat_type` is set to `Daily`, `Weekly`, or `Monthly`, `repeat_start_time` and `repeat_end_time` must be set.
        """
        return pulumi.get(self, "repeat_end_time")

    @_builtins.property
    @pulumi.getter(name="repeatStartTime")
    def repeat_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The point in time when the recurrence starts. Example: `08:00`. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        return pulumi.get(self, "repeat_start_time")

    @_builtins.property
    @pulumi.getter(name="repeatType")
    def repeat_type(self) -> pulumi.Output[_builtins.str]:
        """
        The recurrence type for the access control policy to take effect. Default value: `Permanent`. Valid values:
        - `Permanent`: The policy always takes effect.
        - `None`: The policy takes effect for only once.
        - `Daily`: The policy takes effect on a daily basis.
        - `Weekly`: The policy takes effect on a weekly basis.
        - `Monthly`: The policy takes effect on a monthly basis.
        """
        return pulumi.get(self, "repeat_type")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        The source address in the access control policy.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source IP address of the request.
        """
        return pulumi.get(self, "source_ip")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the source address in the access control policy. Valid values: `net`, `group`, `location`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        """
        return pulumi.get(self, "start_time")

