# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FirewallVpcFirewallControlPolicyArgs', 'FirewallVpcFirewallControlPolicy']

@pulumi.input_type
class FirewallVpcFirewallControlPolicyArgs:
    def __init__(__self__, *,
                 acl_action: pulumi.Input[_builtins.str],
                 application_name: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 destination: pulumi.Input[_builtins.str],
                 destination_type: pulumi.Input[_builtins.str],
                 order: pulumi.Input[_builtins.int],
                 proto: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 vpc_firewall_id: pulumi.Input[_builtins.str],
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a FirewallVpcFirewallControlPolicy resource.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] application_name: The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        :param pulumi.Input[_builtins.str] description: Access control over VPC firewalls description of the strategy information.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy. Valid values:
               - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
               - If `destination_type` is set to `group`, the value of `destination` must be an address book.
               - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        :param pulumi.Input[_builtins.int] order: The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        :param pulumi.Input[_builtins.str] proto: The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.str] source: Access control over VPC firewalls strategy in the source address.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`.
        :param pulumi.Input[_builtins.str] vpc_firewall_id: The ID of the VPC firewall instance. Valid values:
               - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
               - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        :param pulumi.Input[_builtins.str] dest_port_group: Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.bool] release: The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        """
        pulumi.set(__self__, "acl_action", acl_action)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if member_uid is not None:
            pulumi.set(__self__, "member_uid", member_uid)
        if release is not None:
            pulumi.set(__self__, "release", release)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Input[_builtins.str]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_action", value)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Access control over VPC firewalls description of the strategy information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        The destination address in the access control policy. Valid values:
        - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
        - If `destination_type` is set to `group`, the value of `destination` must be an address book.
        - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter
    def proto(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "proto", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Access control over VPC firewalls strategy in the source address.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the source address in the access control policy. Valid values: `net`, `group`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC firewall instance. Valid values:
        - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
        - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")

    @vpc_firewall_id.setter
    def vpc_firewall_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_group", value)

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the destination port in the access control policy. Valid values: `port`, `group`.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_type", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the content within the request and response. Valid values: `zh`, `en`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the member account of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @member_uid.setter
    def member_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_uid", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release", value)


@pulumi.input_type
class _FirewallVpcFirewallControlPolicyState:
    def __init__(__self__, *,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_group_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 hit_times: Optional[pulumi.Input[_builtins.int]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input[_builtins.int]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_group_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallVpcFirewallControlPolicy resources.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] acl_uuid: Access control over VPC firewalls strategy unique identifier.
        :param pulumi.Input[_builtins.str] application_id: Policy specifies the application ID.
        :param pulumi.Input[_builtins.str] application_name: The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        :param pulumi.Input[_builtins.str] description: Access control over VPC firewalls description of the strategy information.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        :param pulumi.Input[_builtins.str] dest_port_group: Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dest_port_group_ports: Port Address Book port list.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy. Valid values:
               - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
               - If `destination_type` is set to `group`, the value of `destination` must be an address book.
               - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_group_cidrs: Destination address book defined in the address list.
        :param pulumi.Input[_builtins.str] destination_group_type: The destination address book type in the access control policy.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        :param pulumi.Input[_builtins.int] hit_times: Control strategy of hits per second.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.int] order: The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        :param pulumi.Input[_builtins.str] proto: The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.bool] release: The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        :param pulumi.Input[_builtins.str] source: Access control over VPC firewalls strategy in the source address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_group_cidrs: SOURCE address of the address list.
        :param pulumi.Input[_builtins.str] source_group_type: The source address type in the access control policy.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`.
        :param pulumi.Input[_builtins.str] vpc_firewall_id: The ID of the VPC firewall instance. Valid values:
               - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
               - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        if acl_action is not None:
            pulumi.set(__self__, "acl_action", acl_action)
        if acl_uuid is not None:
            pulumi.set(__self__, "acl_uuid", acl_uuid)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if dest_port_group is not None:
            pulumi.set(__self__, "dest_port_group", dest_port_group)
        if dest_port_group_ports is not None:
            pulumi.set(__self__, "dest_port_group_ports", dest_port_group_ports)
        if dest_port_type is not None:
            pulumi.set(__self__, "dest_port_type", dest_port_type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_group_cidrs is not None:
            pulumi.set(__self__, "destination_group_cidrs", destination_group_cidrs)
        if destination_group_type is not None:
            pulumi.set(__self__, "destination_group_type", destination_group_type)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if hit_times is not None:
            pulumi.set(__self__, "hit_times", hit_times)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if member_uid is not None:
            pulumi.set(__self__, "member_uid", member_uid)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if proto is not None:
            pulumi.set(__self__, "proto", proto)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_group_cidrs is not None:
            pulumi.set(__self__, "source_group_cidrs", source_group_cidrs)
        if source_group_type is not None:
            pulumi.set(__self__, "source_group_type", source_group_type)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if vpc_firewall_id is not None:
            pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @acl_action.setter
    def acl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_action", value)

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control over VPC firewalls strategy unique identifier.
        """
        return pulumi.get(self, "acl_uuid")

    @acl_uuid.setter
    def acl_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_uuid", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy specifies the application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control over VPC firewalls description of the strategy information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        """
        return pulumi.get(self, "dest_port_group")

    @dest_port_group.setter
    def dest_port_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_group", value)

    @_builtins.property
    @pulumi.getter(name="destPortGroupPorts")
    def dest_port_group_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Port Address Book port list.
        """
        return pulumi.get(self, "dest_port_group_ports")

    @dest_port_group_ports.setter
    def dest_port_group_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dest_port_group_ports", value)

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the destination port in the access control policy. Valid values: `port`, `group`.
        """
        return pulumi.get(self, "dest_port_type")

    @dest_port_type.setter
    def dest_port_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port_type", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination address in the access control policy. Valid values:
        - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
        - If `destination_type` is set to `group`, the value of `destination` must be an address book.
        - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="destinationGroupCidrs")
    def destination_group_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Destination address book defined in the address list.
        """
        return pulumi.get(self, "destination_group_cidrs")

    @destination_group_cidrs.setter
    def destination_group_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_group_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="destinationGroupType")
    def destination_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination address book type in the access control policy.
        """
        return pulumi.get(self, "destination_group_type")

    @destination_group_type.setter
    def destination_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_group_type", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter(name="hitTimes")
    def hit_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Control strategy of hits per second.
        """
        return pulumi.get(self, "hit_times")

    @hit_times.setter
    def hit_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hit_times", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the content within the request and response. Valid values: `zh`, `en`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the member account of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @member_uid.setter
    def member_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_uid", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter
    def proto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proto", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "release", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control over VPC firewalls strategy in the source address.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceGroupCidrs")
    def source_group_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        SOURCE address of the address list.
        """
        return pulumi.get(self, "source_group_cidrs")

    @source_group_cidrs.setter
    def source_group_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_group_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="sourceGroupType")
    def source_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source address type in the access control policy.
        """
        return pulumi.get(self, "source_group_type")

    @source_group_type.setter
    def source_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_group_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the source address in the access control policy. Valid values: `net`, `group`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC firewall instance. Valid values:
        - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
        - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")

    @vpc_firewall_id.setter
    def vpc_firewall_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_firewall_id", value)


@pulumi.type_token("alicloud:cloudfirewall/firewallVpcFirewallControlPolicy:FirewallVpcFirewallControlPolicy")
class FirewallVpcFirewallControlPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input[_builtins.int]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Vpc Firewall Control Policy resource.

        For information about Cloud Firewall Vpc Firewall Control Policy and how to use it, see [What is Vpc Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcontrolpolicy).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_account()
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            description="example_value",
            tags={
                "Created": "TF",
                "For": "acceptance test",
            })
        default_firewall_vpc_firewall_control_policy = alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy("default",
            order=1,
            destination="127.0.0.2/32",
            application_name="ANY",
            description="example_value",
            source_type="net",
            dest_port="80/88",
            acl_action="accept",
            lang="zh",
            destination_type="net",
            source="127.0.0.1/32",
            dest_port_type="port",
            proto="TCP",
            release=True,
            member_uid=default.id,
            vpc_firewall_id=default_instance.id)
        ```

        ## Import

        Cloud Firewall Vpc Firewall Control Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallControlPolicy:FirewallVpcFirewallControlPolicy example <vpc_firewall_id>:<acl_uuid>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] application_name: The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        :param pulumi.Input[_builtins.str] description: Access control over VPC firewalls description of the strategy information.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        :param pulumi.Input[_builtins.str] dest_port_group: Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy. Valid values:
               - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
               - If `destination_type` is set to `group`, the value of `destination` must be an address book.
               - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.int] order: The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        :param pulumi.Input[_builtins.str] proto: The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.bool] release: The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        :param pulumi.Input[_builtins.str] source: Access control over VPC firewalls strategy in the source address.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`.
        :param pulumi.Input[_builtins.str] vpc_firewall_id: The ID of the VPC firewall instance. Valid values:
               - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
               - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallVpcFirewallControlPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Vpc Firewall Control Policy resource.

        For information about Cloud Firewall Vpc Firewall Control Policy and how to use it, see [What is Vpc Firewall Control Policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcontrolpolicy).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_account()
        default_instance = alicloud.cen.Instance("default",
            cen_instance_name=name,
            description="example_value",
            tags={
                "Created": "TF",
                "For": "acceptance test",
            })
        default_firewall_vpc_firewall_control_policy = alicloud.cloudfirewall.FirewallVpcFirewallControlPolicy("default",
            order=1,
            destination="127.0.0.2/32",
            application_name="ANY",
            description="example_value",
            source_type="net",
            dest_port="80/88",
            acl_action="accept",
            lang="zh",
            destination_type="net",
            source="127.0.0.1/32",
            dest_port_type="port",
            proto="TCP",
            release=True,
            member_uid=default.id,
            vpc_firewall_id=default_instance.id)
        ```

        ## Import

        Cloud Firewall Vpc Firewall Control Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallControlPolicy:FirewallVpcFirewallControlPolicy example <vpc_firewall_id>:<acl_uuid>
        ```

        :param str resource_name: The name of the resource.
        :param FirewallVpcFirewallControlPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallVpcFirewallControlPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input[_builtins.int]] = None,
                 proto: Optional[pulumi.Input[_builtins.str]] = None,
                 release: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallVpcFirewallControlPolicyArgs.__new__(FirewallVpcFirewallControlPolicyArgs)

            if acl_action is None and not opts.urn:
                raise TypeError("Missing required property 'acl_action'")
            __props__.__dict__["acl_action"] = acl_action
            if application_name is None and not opts.urn:
                raise TypeError("Missing required property 'application_name'")
            __props__.__dict__["application_name"] = application_name
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["dest_port"] = dest_port
            __props__.__dict__["dest_port_group"] = dest_port_group
            __props__.__dict__["dest_port_type"] = dest_port_type
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if destination_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_type'")
            __props__.__dict__["destination_type"] = destination_type
            __props__.__dict__["lang"] = lang
            __props__.__dict__["member_uid"] = member_uid
            if order is None and not opts.urn:
                raise TypeError("Missing required property 'order'")
            __props__.__dict__["order"] = order
            if proto is None and not opts.urn:
                raise TypeError("Missing required property 'proto'")
            __props__.__dict__["proto"] = proto
            __props__.__dict__["release"] = release
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            if source_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_type'")
            __props__.__dict__["source_type"] = source_type
            if vpc_firewall_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_firewall_id'")
            __props__.__dict__["vpc_firewall_id"] = vpc_firewall_id
            __props__.__dict__["acl_uuid"] = None
            __props__.__dict__["application_id"] = None
            __props__.__dict__["dest_port_group_ports"] = None
            __props__.__dict__["destination_group_cidrs"] = None
            __props__.__dict__["destination_group_type"] = None
            __props__.__dict__["hit_times"] = None
            __props__.__dict__["source_group_cidrs"] = None
            __props__.__dict__["source_group_type"] = None
        super(FirewallVpcFirewallControlPolicy, __self__).__init__(
            'alicloud:cloudfirewall/firewallVpcFirewallControlPolicy:FirewallVpcFirewallControlPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_action: Optional[pulumi.Input[_builtins.str]] = None,
            acl_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            application_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_group: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port_group_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dest_port_type: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            destination_group_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destination_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            hit_times: Optional[pulumi.Input[_builtins.int]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            member_uid: Optional[pulumi.Input[_builtins.str]] = None,
            order: Optional[pulumi.Input[_builtins.int]] = None,
            proto: Optional[pulumi.Input[_builtins.str]] = None,
            release: Optional[pulumi.Input[_builtins.bool]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_group_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FirewallVpcFirewallControlPolicy':
        """
        Get an existing FirewallVpcFirewallControlPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        :param pulumi.Input[_builtins.str] acl_uuid: Access control over VPC firewalls strategy unique identifier.
        :param pulumi.Input[_builtins.str] application_id: Policy specifies the application ID.
        :param pulumi.Input[_builtins.str] application_name: The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        :param pulumi.Input[_builtins.str] description: Access control over VPC firewalls description of the strategy information.
        :param pulumi.Input[_builtins.str] dest_port: The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        :param pulumi.Input[_builtins.str] dest_port_group: Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dest_port_group_ports: Port Address Book port list.
        :param pulumi.Input[_builtins.str] dest_port_type: The type of the destination port in the access control policy. Valid values: `port`, `group`.
        :param pulumi.Input[_builtins.str] destination: The destination address in the access control policy. Valid values:
               - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
               - If `destination_type` is set to `group`, the value of `destination` must be an address book.
               - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_group_cidrs: Destination address book defined in the address list.
        :param pulumi.Input[_builtins.str] destination_group_type: The destination address book type in the access control policy.
        :param pulumi.Input[_builtins.str] destination_type: The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        :param pulumi.Input[_builtins.int] hit_times: Control strategy of hits per second.
        :param pulumi.Input[_builtins.str] lang: The language of the content within the request and response. Valid values: `zh`, `en`.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.int] order: The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        :param pulumi.Input[_builtins.str] proto: The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        :param pulumi.Input[_builtins.bool] release: The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        :param pulumi.Input[_builtins.str] source: Access control over VPC firewalls strategy in the source address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_group_cidrs: SOURCE address of the address list.
        :param pulumi.Input[_builtins.str] source_group_type: The source address type in the access control policy.
        :param pulumi.Input[_builtins.str] source_type: The type of the source address in the access control policy. Valid values: `net`, `group`.
        :param pulumi.Input[_builtins.str] vpc_firewall_id: The ID of the VPC firewall instance. Valid values:
               - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
               - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallVpcFirewallControlPolicyState.__new__(_FirewallVpcFirewallControlPolicyState)

        __props__.__dict__["acl_action"] = acl_action
        __props__.__dict__["acl_uuid"] = acl_uuid
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_name"] = application_name
        __props__.__dict__["description"] = description
        __props__.__dict__["dest_port"] = dest_port
        __props__.__dict__["dest_port_group"] = dest_port_group
        __props__.__dict__["dest_port_group_ports"] = dest_port_group_ports
        __props__.__dict__["dest_port_type"] = dest_port_type
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_group_cidrs"] = destination_group_cidrs
        __props__.__dict__["destination_group_type"] = destination_group_type
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["hit_times"] = hit_times
        __props__.__dict__["lang"] = lang
        __props__.__dict__["member_uid"] = member_uid
        __props__.__dict__["order"] = order
        __props__.__dict__["proto"] = proto
        __props__.__dict__["release"] = release
        __props__.__dict__["source"] = source
        __props__.__dict__["source_group_cidrs"] = source_group_cidrs
        __props__.__dict__["source_group_type"] = source_group_type
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["vpc_firewall_id"] = vpc_firewall_id
        return FirewallVpcFirewallControlPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> pulumi.Output[_builtins.str]:
        """
        The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
        """
        return pulumi.get(self, "acl_action")

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Access control over VPC firewalls strategy unique identifier.
        """
        return pulumi.get(self, "acl_uuid")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        Policy specifies the application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the applications that the access control policy supports. Valid values: `FTP`, `HTTP`, `HTTPS`, `MySQL`, `SMTP`, `SMTPS`, `RDP`, `VNC`, `SSH`, `Redis`, `MQTT`, `MongoDB`, `Memcache`, `SSL`, `ANY`.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Access control over VPC firewalls description of the strategy information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Output[_builtins.str]:
        """
        The destination port in the access control policy. **Note:** If `dest_port_type` is set to `port`, you must specify this parameter.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="destPortGroup")
    def dest_port_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access control policy in the access traffic of the destination port address book name. **Note:** If `dest_port_type` is set to `group`, you must specify this parameter.
        """
        return pulumi.get(self, "dest_port_group")

    @_builtins.property
    @pulumi.getter(name="destPortGroupPorts")
    def dest_port_group_ports(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Port Address Book port list.
        """
        return pulumi.get(self, "dest_port_group_ports")

    @_builtins.property
    @pulumi.getter(name="destPortType")
    def dest_port_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the destination port in the access control policy. Valid values: `port`, `group`.
        """
        return pulumi.get(self, "dest_port_type")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        The destination address in the access control policy. Valid values:
        - If `destination_type` is set to `net`, the value of `destination` must be a CIDR block.
        - If `destination_type` is set to `group`, the value of `destination` must be an address book.
        - If `destination_type` is set to `domain`, the value of `destination` must be a domain name.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationGroupCidrs")
    def destination_group_cidrs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Destination address book defined in the address list.
        """
        return pulumi.get(self, "destination_group_cidrs")

    @_builtins.property
    @pulumi.getter(name="destinationGroupType")
    def destination_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The destination address book type in the access control policy.
        """
        return pulumi.get(self, "destination_group_type")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the destination address in the access control policy. Valid values: `net`, `group`, `domain`.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="hitTimes")
    def hit_times(self) -> pulumi.Output[_builtins.int]:
        """
        Control strategy of hits per second.
        """
        return pulumi.get(self, "hit_times")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the content within the request and response. Valid values: `zh`, `en`.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> pulumi.Output[_builtins.str]:
        """
        The UID of the member account of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the protocol in the access control policy. Valid values: `ANY`, `TCP`, `UDP`, `ICMP`.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter
    def release(self) -> pulumi.Output[_builtins.bool]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created.. Valid values:
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Access control over VPC firewalls strategy in the source address.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceGroupCidrs")
    def source_group_cidrs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        SOURCE address of the address list.
        """
        return pulumi.get(self, "source_group_cidrs")

    @_builtins.property
    @pulumi.getter(name="sourceGroupType")
    def source_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The source address type in the access control policy.
        """
        return pulumi.get(self, "source_group_type")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the source address in the access control policy. Valid values: `net`, `group`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC firewall instance. Valid values:
        - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
        - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")

