# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 net_redirect_policy: Optional[pulumi.Input['PolicyNetRedirectPolicyArgs']] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution_height: Optional[pulumi.Input[_builtins.int]] = None,
                 resolution_width: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to turn on local camera redirection.
        :param pulumi.Input[_builtins.str] clipboard: Clipboard permissions.
        :param pulumi.Input[_builtins.str] lock_resolution: Whether to lock the resolution.
        :param pulumi.Input['PolicyNetRedirectPolicyArgs'] net_redirect_policy: Network redirection. See `net_redirect_policy` below.
        :param pulumi.Input[_builtins.str] policy_group_name: The policy name.
        :param pulumi.Input[_builtins.int] resolution_height: The height of the resolution. Unit: Pixels.
        :param pulumi.Input[_builtins.int] resolution_width: The width of the resolution. Unit: Pixels.
        """
        if camera_redirect is not None:
            pulumi.set(__self__, "camera_redirect", camera_redirect)
        if clipboard is not None:
            pulumi.set(__self__, "clipboard", clipboard)
        if lock_resolution is not None:
            pulumi.set(__self__, "lock_resolution", lock_resolution)
        if net_redirect_policy is not None:
            pulumi.set(__self__, "net_redirect_policy", net_redirect_policy)
        if policy_group_name is not None:
            pulumi.set(__self__, "policy_group_name", policy_group_name)
        if resolution_height is not None:
            pulumi.set(__self__, "resolution_height", resolution_height)
        if resolution_width is not None:
            pulumi.set(__self__, "resolution_width", resolution_width)

    @_builtins.property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to turn on local camera redirection.
        """
        return pulumi.get(self, "camera_redirect")

    @camera_redirect.setter
    def camera_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "camera_redirect", value)

    @_builtins.property
    @pulumi.getter
    def clipboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Clipboard permissions.
        """
        return pulumi.get(self, "clipboard")

    @clipboard.setter
    def clipboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clipboard", value)

    @_builtins.property
    @pulumi.getter(name="lockResolution")
    def lock_resolution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to lock the resolution.
        """
        return pulumi.get(self, "lock_resolution")

    @lock_resolution.setter
    def lock_resolution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_resolution", value)

    @_builtins.property
    @pulumi.getter(name="netRedirectPolicy")
    def net_redirect_policy(self) -> Optional[pulumi.Input['PolicyNetRedirectPolicyArgs']]:
        """
        Network redirection. See `net_redirect_policy` below.
        """
        return pulumi.get(self, "net_redirect_policy")

    @net_redirect_policy.setter
    def net_redirect_policy(self, value: Optional[pulumi.Input['PolicyNetRedirectPolicyArgs']]):
        pulumi.set(self, "net_redirect_policy", value)

    @_builtins.property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "policy_group_name")

    @policy_group_name.setter
    def policy_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resolutionHeight")
    def resolution_height(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The height of the resolution. Unit: Pixels.
        """
        return pulumi.get(self, "resolution_height")

    @resolution_height.setter
    def resolution_height(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolution_height", value)

    @_builtins.property
    @pulumi.getter(name="resolutionWidth")
    def resolution_width(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The width of the resolution. Unit: Pixels.
        """
        return pulumi.get(self, "resolution_width")

    @resolution_width.setter
    def resolution_width(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolution_width", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 net_redirect_policy: Optional[pulumi.Input['PolicyNetRedirectPolicyArgs']] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution_height: Optional[pulumi.Input[_builtins.int]] = None,
                 resolution_width: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to turn on local camera redirection.
        :param pulumi.Input[_builtins.str] clipboard: Clipboard permissions.
        :param pulumi.Input[_builtins.str] lock_resolution: Whether to lock the resolution.
        :param pulumi.Input['PolicyNetRedirectPolicyArgs'] net_redirect_policy: Network redirection. See `net_redirect_policy` below.
        :param pulumi.Input[_builtins.str] policy_group_name: The policy name.
        :param pulumi.Input[_builtins.int] resolution_height: The height of the resolution. Unit: Pixels.
        :param pulumi.Input[_builtins.int] resolution_width: The width of the resolution. Unit: Pixels.
        """
        if camera_redirect is not None:
            pulumi.set(__self__, "camera_redirect", camera_redirect)
        if clipboard is not None:
            pulumi.set(__self__, "clipboard", clipboard)
        if lock_resolution is not None:
            pulumi.set(__self__, "lock_resolution", lock_resolution)
        if net_redirect_policy is not None:
            pulumi.set(__self__, "net_redirect_policy", net_redirect_policy)
        if policy_group_name is not None:
            pulumi.set(__self__, "policy_group_name", policy_group_name)
        if resolution_height is not None:
            pulumi.set(__self__, "resolution_height", resolution_height)
        if resolution_width is not None:
            pulumi.set(__self__, "resolution_width", resolution_width)

    @_builtins.property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to turn on local camera redirection.
        """
        return pulumi.get(self, "camera_redirect")

    @camera_redirect.setter
    def camera_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "camera_redirect", value)

    @_builtins.property
    @pulumi.getter
    def clipboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Clipboard permissions.
        """
        return pulumi.get(self, "clipboard")

    @clipboard.setter
    def clipboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clipboard", value)

    @_builtins.property
    @pulumi.getter(name="lockResolution")
    def lock_resolution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to lock the resolution.
        """
        return pulumi.get(self, "lock_resolution")

    @lock_resolution.setter
    def lock_resolution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_resolution", value)

    @_builtins.property
    @pulumi.getter(name="netRedirectPolicy")
    def net_redirect_policy(self) -> Optional[pulumi.Input['PolicyNetRedirectPolicyArgs']]:
        """
        Network redirection. See `net_redirect_policy` below.
        """
        return pulumi.get(self, "net_redirect_policy")

    @net_redirect_policy.setter
    def net_redirect_policy(self, value: Optional[pulumi.Input['PolicyNetRedirectPolicyArgs']]):
        pulumi.set(self, "net_redirect_policy", value)

    @_builtins.property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "policy_group_name")

    @policy_group_name.setter
    def policy_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resolutionHeight")
    def resolution_height(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The height of the resolution. Unit: Pixels.
        """
        return pulumi.get(self, "resolution_height")

    @resolution_height.setter
    def resolution_height(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolution_height", value)

    @_builtins.property
    @pulumi.getter(name="resolutionWidth")
    def resolution_width(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The width of the resolution. Unit: Pixels.
        """
        return pulumi.get(self, "resolution_width")

    @resolution_width.setter
    def resolution_width(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolution_width", value)


@pulumi.type_token("alicloud:cloudphone/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 net_redirect_policy: Optional[pulumi.Input[Union['PolicyNetRedirectPolicyArgs', 'PolicyNetRedirectPolicyArgsDict']]] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution_height: Optional[pulumi.Input[_builtins.int]] = None,
                 resolution_width: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Cloud Phone Policy resource.

        Cloud phone policy.

        For information about Cloud Phone Policy and how to use it, see [What is Policy](https://next.api.alibabacloud.com/document/eds-aic/2023-09-30/CreatePolicyGroup).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudphone.Policy("default",
            policy_group_name="NewPolicyName",
            resolution_width=720,
            lock_resolution="on",
            camera_redirect="on",
            resolution_height=1280,
            clipboard="read",
            net_redirect_policy={
                "net_redirect": "on",
                "custom_proxy": "on",
                "proxy_type": "socks5",
                "host_addr": "192.168.12.13",
                "port": "8888",
                "proxy_user_name": "user1",
                "proxy_password": "123456",
            })
        ```

        ## Import

        Cloud Phone Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudphone/policy:Policy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to turn on local camera redirection.
        :param pulumi.Input[_builtins.str] clipboard: Clipboard permissions.
        :param pulumi.Input[_builtins.str] lock_resolution: Whether to lock the resolution.
        :param pulumi.Input[Union['PolicyNetRedirectPolicyArgs', 'PolicyNetRedirectPolicyArgsDict']] net_redirect_policy: Network redirection. See `net_redirect_policy` below.
        :param pulumi.Input[_builtins.str] policy_group_name: The policy name.
        :param pulumi.Input[_builtins.int] resolution_height: The height of the resolution. Unit: Pixels.
        :param pulumi.Input[_builtins.int] resolution_width: The width of the resolution. Unit: Pixels.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Phone Policy resource.

        Cloud phone policy.

        For information about Cloud Phone Policy and how to use it, see [What is Policy](https://next.api.alibabacloud.com/document/eds-aic/2023-09-30/CreatePolicyGroup).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudphone.Policy("default",
            policy_group_name="NewPolicyName",
            resolution_width=720,
            lock_resolution="on",
            camera_redirect="on",
            resolution_height=1280,
            clipboard="read",
            net_redirect_policy={
                "net_redirect": "on",
                "custom_proxy": "on",
                "proxy_type": "socks5",
                "host_addr": "192.168.12.13",
                "port": "8888",
                "proxy_user_name": "user1",
                "proxy_password": "123456",
            })
        ```

        ## Import

        Cloud Phone Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudphone/policy:Policy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 net_redirect_policy: Optional[pulumi.Input[Union['PolicyNetRedirectPolicyArgs', 'PolicyNetRedirectPolicyArgsDict']]] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution_height: Optional[pulumi.Input[_builtins.int]] = None,
                 resolution_width: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["camera_redirect"] = camera_redirect
            __props__.__dict__["clipboard"] = clipboard
            __props__.__dict__["lock_resolution"] = lock_resolution
            __props__.__dict__["net_redirect_policy"] = net_redirect_policy
            __props__.__dict__["policy_group_name"] = policy_group_name
            __props__.__dict__["resolution_height"] = resolution_height
            __props__.__dict__["resolution_width"] = resolution_width
        super(Policy, __self__).__init__(
            'alicloud:cloudphone/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
            clipboard: Optional[pulumi.Input[_builtins.str]] = None,
            lock_resolution: Optional[pulumi.Input[_builtins.str]] = None,
            net_redirect_policy: Optional[pulumi.Input[Union['PolicyNetRedirectPolicyArgs', 'PolicyNetRedirectPolicyArgsDict']]] = None,
            policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            resolution_height: Optional[pulumi.Input[_builtins.int]] = None,
            resolution_width: Optional[pulumi.Input[_builtins.int]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to turn on local camera redirection.
        :param pulumi.Input[_builtins.str] clipboard: Clipboard permissions.
        :param pulumi.Input[_builtins.str] lock_resolution: Whether to lock the resolution.
        :param pulumi.Input[Union['PolicyNetRedirectPolicyArgs', 'PolicyNetRedirectPolicyArgsDict']] net_redirect_policy: Network redirection. See `net_redirect_policy` below.
        :param pulumi.Input[_builtins.str] policy_group_name: The policy name.
        :param pulumi.Input[_builtins.int] resolution_height: The height of the resolution. Unit: Pixels.
        :param pulumi.Input[_builtins.int] resolution_width: The width of the resolution. Unit: Pixels.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["camera_redirect"] = camera_redirect
        __props__.__dict__["clipboard"] = clipboard
        __props__.__dict__["lock_resolution"] = lock_resolution
        __props__.__dict__["net_redirect_policy"] = net_redirect_policy
        __props__.__dict__["policy_group_name"] = policy_group_name
        __props__.__dict__["resolution_height"] = resolution_height
        __props__.__dict__["resolution_width"] = resolution_width
        return Policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to turn on local camera redirection.
        """
        return pulumi.get(self, "camera_redirect")

    @_builtins.property
    @pulumi.getter
    def clipboard(self) -> pulumi.Output[_builtins.str]:
        """
        Clipboard permissions.
        """
        return pulumi.get(self, "clipboard")

    @_builtins.property
    @pulumi.getter(name="lockResolution")
    def lock_resolution(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to lock the resolution.
        """
        return pulumi.get(self, "lock_resolution")

    @_builtins.property
    @pulumi.getter(name="netRedirectPolicy")
    def net_redirect_policy(self) -> pulumi.Output['outputs.PolicyNetRedirectPolicy']:
        """
        Network redirection. See `net_redirect_policy` below.
        """
        return pulumi.get(self, "net_redirect_policy")

    @_builtins.property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The policy name.
        """
        return pulumi.get(self, "policy_group_name")

    @_builtins.property
    @pulumi.getter(name="resolutionHeight")
    def resolution_height(self) -> pulumi.Output[_builtins.int]:
        """
        The height of the resolution. Unit: Pixels.
        """
        return pulumi.get(self, "resolution_height")

    @_builtins.property
    @pulumi.getter(name="resolutionWidth")
    def resolution_width(self) -> pulumi.Output[_builtins.int]:
        """
        The width of the resolution. Unit: Pixels.
        """
        return pulumi.get(self, "resolution_width")

