# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessManagementArgs', 'AccessManagement']

@pulumi.input_type
class AccessManagementArgs:
    def __init__(__self__, *,
                 access_configuration_id: pulumi.Input[_builtins.str],
                 directory_id: pulumi.Input[_builtins.str],
                 principal_id: pulumi.Input[_builtins.str],
                 principal_type: pulumi.Input[_builtins.str],
                 target_id: pulumi.Input[_builtins.str],
                 target_type: pulumi.Input[_builtins.str],
                 deprovision_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessManagement resource.
        :param pulumi.Input[_builtins.str] access_configuration_id: The ID of the access configuration.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO identity.
        :param pulumi.Input[_builtins.str] principal_type: The type of the CloudSSO identity. Valid values: `User`, `Group`.
        :param pulumi.Input[_builtins.str] target_id: The ID of the task object.
        :param pulumi.Input[_builtins.str] target_type: The type of the task object. Valid values: `RD-Account`.
        :param pulumi.Input[_builtins.str] deprovision_strategy: Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_type", target_type)
        if deprovision_strategy is not None:
            pulumi.set(__self__, "deprovision_strategy", deprovision_strategy)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the access configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @access_configuration_id.setter
    def access_configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CloudSSO identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the CloudSSO identity. Valid values: `User`, `Group`.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the task object.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the task object. Valid values: `RD-Account`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter(name="deprovisionStrategy")
    def deprovision_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        """
        return pulumi.get(self, "deprovision_strategy")

    @deprovision_strategy.setter
    def deprovision_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprovision_strategy", value)


@pulumi.input_type
class _AccessManagementState:
    def __init__(__self__, *,
                 access_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovision_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessManagement resources.
        :param pulumi.Input[_builtins.str] access_configuration_id: The ID of the access configuration.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.254.0) The time when the access permissions were assigned.
        :param pulumi.Input[_builtins.str] deprovision_strategy: Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO identity.
        :param pulumi.Input[_builtins.str] principal_type: The type of the CloudSSO identity. Valid values: `User`, `Group`.
        :param pulumi.Input[_builtins.str] target_id: The ID of the task object.
        :param pulumi.Input[_builtins.str] target_type: The type of the task object. Valid values: `RD-Account`.
        """
        if access_configuration_id is not None:
            pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deprovision_strategy is not None:
            pulumi.set(__self__, "deprovision_strategy", deprovision_strategy)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the access configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @access_configuration_id.setter
    def access_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.254.0) The time when the access permissions were assigned.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deprovisionStrategy")
    def deprovision_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        """
        return pulumi.get(self, "deprovision_strategy")

    @deprovision_strategy.setter
    def deprovision_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprovision_strategy", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CloudSSO identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the CloudSSO identity. Valid values: `User`, `Group`.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the task object.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the task object. Valid values: `RD-Account`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_type", value)


@pulumi.type_token("alicloud:cloudsso/accessManagement:AccessManagement")
class AccessManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovision_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud SSO Access Assignment resource.

        For information about Cloud SSO Access Assignment and how to use it, see [What is Access Assignment](https://www.alibabacloud.com/help/en/cloudsso/developer-reference/api-cloudsso-2021-05-15-createaccessassignment).

        > **NOTE:** When you configure access assignment for the first time, access configuration will be automatically deployed.

        > **NOTE:** Available since v1.145.0.

        > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region

        ## Import

        Cloud SSO Access Assignment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/accessManagement:AccessManagement example <directory_id>:<access_configuration_id>:<target_type>:<target_id>:<principal_type>:<principal_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_configuration_id: The ID of the access configuration.
        :param pulumi.Input[_builtins.str] deprovision_strategy: Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO identity.
        :param pulumi.Input[_builtins.str] principal_type: The type of the CloudSSO identity. Valid values: `User`, `Group`.
        :param pulumi.Input[_builtins.str] target_id: The ID of the task object.
        :param pulumi.Input[_builtins.str] target_type: The type of the task object. Valid values: `RD-Account`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud SSO Access Assignment resource.

        For information about Cloud SSO Access Assignment and how to use it, see [What is Access Assignment](https://www.alibabacloud.com/help/en/cloudsso/developer-reference/api-cloudsso-2021-05-15-createaccessassignment).

        > **NOTE:** When you configure access assignment for the first time, access configuration will be automatically deployed.

        > **NOTE:** Available since v1.145.0.

        > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region

        ## Import

        Cloud SSO Access Assignment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/accessManagement:AccessManagement example <directory_id>:<access_configuration_id>:<target_type>:<target_id>:<principal_type>:<principal_id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovision_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessManagementArgs.__new__(AccessManagementArgs)

            if access_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_configuration_id'")
            __props__.__dict__["access_configuration_id"] = access_configuration_id
            __props__.__dict__["deprovision_strategy"] = deprovision_strategy
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["create_time"] = None
        super(AccessManagement, __self__).__init__(
            'alicloud:cloudsso/accessManagement:AccessManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deprovision_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessManagement':
        """
        Get an existing AccessManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_configuration_id: The ID of the access configuration.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.254.0) The time when the access permissions were assigned.
        :param pulumi.Input[_builtins.str] deprovision_strategy: Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the CloudSSO identity.
        :param pulumi.Input[_builtins.str] principal_type: The type of the CloudSSO identity. Valid values: `User`, `Group`.
        :param pulumi.Input[_builtins.str] target_id: The ID of the task object.
        :param pulumi.Input[_builtins.str] target_type: The type of the task object. Valid values: `RD-Account`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessManagementState.__new__(_AccessManagementState)

        __props__.__dict__["access_configuration_id"] = access_configuration_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deprovision_strategy"] = deprovision_strategy
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_type"] = target_type
        return AccessManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the access configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.254.0) The time when the access permissions were assigned.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deprovisionStrategy")
    def deprovision_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to de-provision the access configuration when you remove the access permissions from the CloudSSO identity. Valid values: `DeprovisionForLastAccessAssignmentOnAccount` and `None`. Default Value: `DeprovisionForLastAccessAssignmentOnAccount`. **NOTE:** When `deprovision_strategy` is `DeprovisionForLastAccessAssignmentOnAccount`, and the access assignment to be deleted is the last access assignment for the same account and the same AC, this option is used for the undeployment operation.
        """
        return pulumi.get(self, "deprovision_strategy")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CloudSSO identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the CloudSSO identity. Valid values: `User`, `Group`.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the task object.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the task object. Valid values: `RD-Account`.
        """
        return pulumi.get(self, "target_type")

