# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExpressSyncArgs', 'ExpressSync']

@pulumi.input_type
class ExpressSyncArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[_builtins.str],
                 bucket_region: pulumi.Input[_builtins.str],
                 express_sync_name: pulumi.Input[_builtins.str],
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExpressSync resource.
        :param pulumi.Input[_builtins.str] bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_region: The region of the OSS Bucket.
        :param pulumi.Input[_builtins.str] express_sync_name: The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        :param pulumi.Input[_builtins.str] bucket_prefix: The prefix of the OSS Bucket.
        :param pulumi.Input[_builtins.str] description: The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "express_sync_name", express_sync_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_region", value)

    @_builtins.property
    @pulumi.getter(name="expressSyncName")
    def express_sync_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        """
        return pulumi.get(self, "express_sync_name")

    @express_sync_name.setter
    def express_sync_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "express_sync_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ExpressSyncState:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 express_sync_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExpressSync resources.
        :param pulumi.Input[_builtins.str] bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_prefix: The prefix of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_region: The region of the OSS Bucket.
        :param pulumi.Input[_builtins.str] description: The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        :param pulumi.Input[_builtins.str] express_sync_name: The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if express_sync_name is not None:
            pulumi.set(__self__, "express_sync_name", express_sync_name)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_region", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expressSyncName")
    def express_sync_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        """
        return pulumi.get(self, "express_sync_name")

    @express_sync_name.setter
    def express_sync_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_sync_name", value)


@pulumi.type_token("alicloud:cloudstoragegateway/expressSync:ExpressSync")
class ExpressSync(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 express_sync_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Storage Gateway Express Sync resource.

        For information about Cloud Storage Gateway Express Sync and how to use it, see [What is Express Sync](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/xzpxo3).

        > **NOTE:** Available since v1.144.0.

        ## Import

        Cloud Storage Gateway Express Sync can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/expressSync:ExpressSync example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_prefix: The prefix of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_region: The region of the OSS Bucket.
        :param pulumi.Input[_builtins.str] description: The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        :param pulumi.Input[_builtins.str] express_sync_name: The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressSyncArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Storage Gateway Express Sync resource.

        For information about Cloud Storage Gateway Express Sync and how to use it, see [What is Express Sync](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/xzpxo3).

        > **NOTE:** Available since v1.144.0.

        ## Import

        Cloud Storage Gateway Express Sync can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/expressSync:ExpressSync example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ExpressSyncArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressSyncArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 express_sync_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressSyncArgs.__new__(ExpressSyncArgs)

            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["bucket_prefix"] = bucket_prefix
            if bucket_region is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_region'")
            __props__.__dict__["bucket_region"] = bucket_region
            __props__.__dict__["description"] = description
            if express_sync_name is None and not opts.urn:
                raise TypeError("Missing required property 'express_sync_name'")
            __props__.__dict__["express_sync_name"] = express_sync_name
        super(ExpressSync, __self__).__init__(
            'alicloud:cloudstoragegateway/expressSync:ExpressSync',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            express_sync_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExpressSync':
        """
        Get an existing ExpressSync resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: The name of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_prefix: The prefix of the OSS Bucket.
        :param pulumi.Input[_builtins.str] bucket_region: The region of the OSS Bucket.
        :param pulumi.Input[_builtins.str] description: The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        :param pulumi.Input[_builtins.str] express_sync_name: The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressSyncState.__new__(_ExpressSyncState)

        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["bucket_prefix"] = bucket_prefix
        __props__.__dict__["bucket_region"] = bucket_region
        __props__.__dict__["description"] = description
        __props__.__dict__["express_sync_name"] = express_sync_name
        return ExpressSync(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The prefix of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_prefix")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the OSS Bucket.
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Express Sync. The length of the name is limited to `1` to `255` characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expressSyncName")
    def express_sync_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ExpressSync. The length of the name is limited to `1` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, English periods (.), underscores (_), or hyphens (-), and must start with  letters.
        """
        return pulumi.get(self, "express_sync_name")

