# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayCacheDiskArgs', 'GatewayCacheDisk']

@pulumi.input_type
class GatewayCacheDiskArgs:
    def __init__(__self__, *,
                 cache_disk_size_in_gb: pulumi.Input[_builtins.int],
                 gateway_id: pulumi.Input[_builtins.str],
                 cache_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayCacheDisk resource.
        :param pulumi.Input[_builtins.int] cache_disk_size_in_gb: The capacity of the cache disk.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the gateway.
        :param pulumi.Input[_builtins.str] cache_disk_category: The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        :param pulumi.Input[_builtins.str] performance_level: The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        """
        pulumi.set(__self__, "cache_disk_size_in_gb", cache_disk_size_in_gb)
        pulumi.set(__self__, "gateway_id", gateway_id)
        if cache_disk_category is not None:
            pulumi.set(__self__, "cache_disk_category", cache_disk_category)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @_builtins.property
    @pulumi.getter(name="cacheDiskSizeInGb")
    def cache_disk_size_in_gb(self) -> pulumi.Input[_builtins.int]:
        """
        The capacity of the cache disk.
        """
        return pulumi.get(self, "cache_disk_size_in_gb")

    @cache_disk_size_in_gb.setter
    def cache_disk_size_in_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cache_disk_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheDiskCategory")
    def cache_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        """
        return pulumi.get(self, "cache_disk_category")

    @cache_disk_category.setter
    def cache_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)


@pulumi.input_type
class _GatewayCacheDiskState:
    def __init__(__self__, *,
                 cache_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering GatewayCacheDisk resources.
        :param pulumi.Input[_builtins.str] cache_disk_category: The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        :param pulumi.Input[_builtins.int] cache_disk_size_in_gb: The capacity of the cache disk.
        :param pulumi.Input[_builtins.str] cache_id: The ID of the cache disk.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the gateway.
        :param pulumi.Input[_builtins.str] local_file_path: The path of the cache disk.
        :param pulumi.Input[_builtins.str] performance_level: The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        :param pulumi.Input[_builtins.int] status: The status of the Gateway Cache Disk.
        """
        if cache_disk_category is not None:
            pulumi.set(__self__, "cache_disk_category", cache_disk_category)
        if cache_disk_size_in_gb is not None:
            pulumi.set(__self__, "cache_disk_size_in_gb", cache_disk_size_in_gb)
        if cache_id is not None:
            pulumi.set(__self__, "cache_id", cache_id)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if local_file_path is not None:
            pulumi.set(__self__, "local_file_path", local_file_path)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cacheDiskCategory")
    def cache_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        """
        return pulumi.get(self, "cache_disk_category")

    @cache_disk_category.setter
    def cache_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="cacheDiskSizeInGb")
    def cache_disk_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The capacity of the cache disk.
        """
        return pulumi.get(self, "cache_disk_size_in_gb")

    @cache_disk_size_in_gb.setter
    def cache_disk_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_disk_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="cacheId")
    def cache_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cache disk.
        """
        return pulumi.get(self, "cache_id")

    @cache_id.setter
    def cache_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the cache disk.
        """
        return pulumi.get(self, "local_file_path")

    @local_file_path.setter
    def local_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_file_path", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the Gateway Cache Disk.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cloudstoragegateway/gatewayCacheDisk:GatewayCacheDisk")
class GatewayCacheDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Storage Gateway Gateway Cache Disk resource.

        For information about Cloud Storage Gateway Gateway Cache Disk and how to use it, see [What is Gateway Cache Disk](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaycachedisk).

        > **NOTE:** Available since v1.144.0.

        ## Import

        Cloud Storage Gateway Gateway Cache Disk can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gatewayCacheDisk:GatewayCacheDisk example <gateway_id>:<cache_id>:<local_file_path>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cache_disk_category: The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        :param pulumi.Input[_builtins.int] cache_disk_size_in_gb: The capacity of the cache disk.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the gateway.
        :param pulumi.Input[_builtins.str] performance_level: The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayCacheDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Storage Gateway Gateway Cache Disk resource.

        For information about Cloud Storage Gateway Gateway Cache Disk and how to use it, see [What is Gateway Cache Disk](https://www.alibabacloud.com/help/en/cloud-storage-gateway/latest/creategatewaycachedisk).

        > **NOTE:** Available since v1.144.0.

        ## Import

        Cloud Storage Gateway Gateway Cache Disk can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudstoragegateway/gatewayCacheDisk:GatewayCacheDisk example <gateway_id>:<cache_id>:<local_file_path>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayCacheDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayCacheDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayCacheDiskArgs.__new__(GatewayCacheDiskArgs)

            __props__.__dict__["cache_disk_category"] = cache_disk_category
            if cache_disk_size_in_gb is None and not opts.urn:
                raise TypeError("Missing required property 'cache_disk_size_in_gb'")
            __props__.__dict__["cache_disk_size_in_gb"] = cache_disk_size_in_gb
            if gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_id'")
            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["performance_level"] = performance_level
            __props__.__dict__["cache_id"] = None
            __props__.__dict__["local_file_path"] = None
            __props__.__dict__["status"] = None
        super(GatewayCacheDisk, __self__).__init__(
            'alicloud:cloudstoragegateway/gatewayCacheDisk:GatewayCacheDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            cache_disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            cache_id: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            local_file_path: Optional[pulumi.Input[_builtins.str]] = None,
            performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None) -> 'GatewayCacheDisk':
        """
        Get an existing GatewayCacheDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cache_disk_category: The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        :param pulumi.Input[_builtins.int] cache_disk_size_in_gb: The capacity of the cache disk.
        :param pulumi.Input[_builtins.str] cache_id: The ID of the cache disk.
        :param pulumi.Input[_builtins.str] gateway_id: The ID of the gateway.
        :param pulumi.Input[_builtins.str] local_file_path: The path of the cache disk.
        :param pulumi.Input[_builtins.str] performance_level: The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        :param pulumi.Input[_builtins.int] status: The status of the Gateway Cache Disk.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayCacheDiskState.__new__(_GatewayCacheDiskState)

        __props__.__dict__["cache_disk_category"] = cache_disk_category
        __props__.__dict__["cache_disk_size_in_gb"] = cache_disk_size_in_gb
        __props__.__dict__["cache_id"] = cache_id
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["local_file_path"] = local_file_path
        __props__.__dict__["performance_level"] = performance_level
        __props__.__dict__["status"] = status
        return GatewayCacheDisk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheDiskCategory")
    def cache_disk_category(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the cache disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`. **NOTE:** From version 1.227.0, `cache_disk_category` can be set to `cloud_essd`.
        """
        return pulumi.get(self, "cache_disk_category")

    @_builtins.property
    @pulumi.getter(name="cacheDiskSizeInGb")
    def cache_disk_size_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The capacity of the cache disk.
        """
        return pulumi.get(self, "cache_disk_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="cacheId")
    def cache_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cache disk.
        """
        return pulumi.get(self, "cache_id")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the cache disk.
        """
        return pulumi.get(self, "local_file_path")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The performance level (PL) of the Enterprise SSD (ESSD). Valid values: `PL1`, `PL2`, `PL3`. **NOTE:** If `cache_disk_category` is set to `cloud_essd`, `performance_level` is required.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the Gateway Cache Disk.
        """
        return pulumi.get(self, "status")

