# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmArgs', 'Alarm']

@pulumi.input_type
class AlarmArgs:
    def __init__(__self__, *,
                 contact_groups: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 metric: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 composite_expression: Optional[pulumi.Input['AlarmCompositeExpressionArgs']] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 escalations_critical: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']] = None,
                 escalations_info: Optional[pulumi.Input['AlarmEscalationsInfoArgs']] = None,
                 escalations_warn: Optional[pulumi.Input['AlarmEscalationsWarnArgs']] = None,
                 metric_dimensions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]] = None,
                 silence_time: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]]] = None,
                 webhook: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Alarm resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[_builtins.str] metric: The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] project: The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input['AlarmCompositeExpressionArgs'] composite_expression: The trigger conditions for multiple metrics. See `composite_expression` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dimensions: Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        :param pulumi.Input[_builtins.str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable alarm rule. Default value: `true`.
        :param pulumi.Input[_builtins.int] end_time: Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input['AlarmEscalationsCriticalArgs'] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input['AlarmEscalationsInfoArgs'] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input['AlarmEscalationsWarnArgs'] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[_builtins.str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] name: The name of the alert rule.
        :param pulumi.Input[_builtins.int] period: The statistical period of the metric. Unit: seconds. Default value: `300`.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[_builtins.int] silence_time: Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        :param pulumi.Input[_builtins.int] start_time: Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]] targets: Adds or modifies the push channels of an alert rule. See `targets` below.
        :param pulumi.Input[_builtins.str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        pulumi.set(__self__, "contact_groups", contact_groups)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "project", project)
        if composite_expression is not None:
            pulumi.set(__self__, "composite_expression", composite_expression)
        if dimensions is not None:
            warnings.warn("""Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""", DeprecationWarning)
            pulumi.log.warn("""dimensions is deprecated: Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""")
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_interval is not None:
            pulumi.set(__self__, "effective_interval", effective_interval)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is not None:
            warnings.warn("""Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""", DeprecationWarning)
            pulumi.log.warn("""end_time is deprecated: Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if escalations_critical is not None:
            pulumi.set(__self__, "escalations_critical", escalations_critical)
        if escalations_info is not None:
            pulumi.set(__self__, "escalations_info", escalations_info)
        if escalations_warn is not None:
            pulumi.set(__self__, "escalations_warn", escalations_warn)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if prometheuses is not None:
            pulumi.set(__self__, "prometheuses", prometheuses)
        if silence_time is not None:
            pulumi.set(__self__, "silence_time", silence_time)
        if start_time is not None:
            warnings.warn("""Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""", DeprecationWarning)
            pulumi.log.warn("""start_time is deprecated: Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List contact groups of the alarm rule, which must have been created on the console.
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "contact_groups", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="compositeExpression")
    def composite_expression(self) -> Optional[pulumi.Input['AlarmCompositeExpressionArgs']]:
        """
        The trigger conditions for multiple metrics. See `composite_expression` below.
        """
        return pulumi.get(self, "composite_expression")

    @composite_expression.setter
    def composite_expression(self, value: Optional[pulumi.Input['AlarmCompositeExpressionArgs']]):
        pulumi.set(self, "composite_expression", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""")
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @_builtins.property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        """
        return pulumi.get(self, "effective_interval")

    @effective_interval.setter
    def effective_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_interval", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable alarm rule. Default value: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    @_utilities.deprecated("""Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="escalationsCritical")
    def escalations_critical(self) -> Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]:
        """
        A configuration of critical alarm. See `escalations_critical` below.
        """
        return pulumi.get(self, "escalations_critical")

    @escalations_critical.setter
    def escalations_critical(self, value: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]):
        pulumi.set(self, "escalations_critical", value)

    @_builtins.property
    @pulumi.getter(name="escalationsInfo")
    def escalations_info(self) -> Optional[pulumi.Input['AlarmEscalationsInfoArgs']]:
        """
        A configuration of critical info. See `escalations_info` below.
        """
        return pulumi.get(self, "escalations_info")

    @escalations_info.setter
    def escalations_info(self, value: Optional[pulumi.Input['AlarmEscalationsInfoArgs']]):
        pulumi.set(self, "escalations_info", value)

    @_builtins.property
    @pulumi.getter(name="escalationsWarn")
    def escalations_warn(self) -> Optional[pulumi.Input['AlarmEscalationsWarnArgs']]:
        """
        A configuration of critical warn. See `escalations_warn` below.
        """
        return pulumi.get(self, "escalations_warn")

    @escalations_warn.setter
    def escalations_warn(self, value: Optional[pulumi.Input['AlarmEscalationsWarnArgs']]):
        pulumi.set(self, "escalations_warn", value)

    @_builtins.property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_dimensions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The statistical period of the metric. Unit: seconds. Default value: `300`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def prometheuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]:
        """
        The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        """
        return pulumi.get(self, "prometheuses")

    @prometheuses.setter
    def prometheuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]):
        pulumi.set(self, "prometheuses", value)

    @_builtins.property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        """
        return pulumi.get(self, "silence_time")

    @silence_time.setter
    def silence_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "silence_time", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    @_utilities.deprecated("""Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]]]:
        """
        Adds or modifies the push channels of an alert rule. See `targets` below.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "webhook", value)


@pulumi.input_type
class _AlarmState:
    def __init__(__self__, *,
                 composite_expression: Optional[pulumi.Input['AlarmCompositeExpressionArgs']] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 escalations_critical: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']] = None,
                 escalations_info: Optional[pulumi.Input['AlarmEscalationsInfoArgs']] = None,
                 escalations_warn: Optional[pulumi.Input['AlarmEscalationsWarnArgs']] = None,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_dimensions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]] = None,
                 silence_time: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]]] = None,
                 webhook: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alarm resources.
        :param pulumi.Input['AlarmCompositeExpressionArgs'] composite_expression: The trigger conditions for multiple metrics. See `composite_expression` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dimensions: Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        :param pulumi.Input[_builtins.str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable alarm rule. Default value: `true`.
        :param pulumi.Input[_builtins.int] end_time: Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input['AlarmEscalationsCriticalArgs'] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input['AlarmEscalationsInfoArgs'] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input['AlarmEscalationsWarnArgs'] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[_builtins.str] metric: The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] name: The name of the alert rule.
        :param pulumi.Input[_builtins.int] period: The statistical period of the metric. Unit: seconds. Default value: `300`.
        :param pulumi.Input[_builtins.str] project: The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[_builtins.int] silence_time: Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        :param pulumi.Input[_builtins.int] start_time: Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input[_builtins.str] status: The status of the Alarm.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]] targets: Adds or modifies the push channels of an alert rule. See `targets` below.
        :param pulumi.Input[_builtins.str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        if composite_expression is not None:
            pulumi.set(__self__, "composite_expression", composite_expression)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if dimensions is not None:
            warnings.warn("""Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""", DeprecationWarning)
            pulumi.log.warn("""dimensions is deprecated: Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""")
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_interval is not None:
            pulumi.set(__self__, "effective_interval", effective_interval)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is not None:
            warnings.warn("""Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""", DeprecationWarning)
            pulumi.log.warn("""end_time is deprecated: Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if escalations_critical is not None:
            pulumi.set(__self__, "escalations_critical", escalations_critical)
        if escalations_info is not None:
            pulumi.set(__self__, "escalations_info", escalations_info)
        if escalations_warn is not None:
            pulumi.set(__self__, "escalations_warn", escalations_warn)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if prometheuses is not None:
            pulumi.set(__self__, "prometheuses", prometheuses)
        if silence_time is not None:
            pulumi.set(__self__, "silence_time", silence_time)
        if start_time is not None:
            warnings.warn("""Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""", DeprecationWarning)
            pulumi.log.warn("""start_time is deprecated: Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @_builtins.property
    @pulumi.getter(name="compositeExpression")
    def composite_expression(self) -> Optional[pulumi.Input['AlarmCompositeExpressionArgs']]:
        """
        The trigger conditions for multiple metrics. See `composite_expression` below.
        """
        return pulumi.get(self, "composite_expression")

    @composite_expression.setter
    def composite_expression(self, value: Optional[pulumi.Input['AlarmCompositeExpressionArgs']]):
        pulumi.set(self, "composite_expression", value)

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List contact groups of the alarm rule, which must have been created on the console.
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "contact_groups", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""")
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @_builtins.property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        """
        return pulumi.get(self, "effective_interval")

    @effective_interval.setter
    def effective_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_interval", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable alarm rule. Default value: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    @_utilities.deprecated("""Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="escalationsCritical")
    def escalations_critical(self) -> Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]:
        """
        A configuration of critical alarm. See `escalations_critical` below.
        """
        return pulumi.get(self, "escalations_critical")

    @escalations_critical.setter
    def escalations_critical(self, value: Optional[pulumi.Input['AlarmEscalationsCriticalArgs']]):
        pulumi.set(self, "escalations_critical", value)

    @_builtins.property
    @pulumi.getter(name="escalationsInfo")
    def escalations_info(self) -> Optional[pulumi.Input['AlarmEscalationsInfoArgs']]:
        """
        A configuration of critical info. See `escalations_info` below.
        """
        return pulumi.get(self, "escalations_info")

    @escalations_info.setter
    def escalations_info(self, value: Optional[pulumi.Input['AlarmEscalationsInfoArgs']]):
        pulumi.set(self, "escalations_info", value)

    @_builtins.property
    @pulumi.getter(name="escalationsWarn")
    def escalations_warn(self) -> Optional[pulumi.Input['AlarmEscalationsWarnArgs']]:
        """
        A configuration of critical warn. See `escalations_warn` below.
        """
        return pulumi.get(self, "escalations_warn")

    @escalations_warn.setter
    def escalations_warn(self, value: Optional[pulumi.Input['AlarmEscalationsWarnArgs']]):
        pulumi.set(self, "escalations_warn", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_dimensions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The statistical period of the metric. Unit: seconds. Default value: `300`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def prometheuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]:
        """
        The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        """
        return pulumi.get(self, "prometheuses")

    @prometheuses.setter
    def prometheuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmPrometheusArgs']]]]):
        pulumi.set(self, "prometheuses", value)

    @_builtins.property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        """
        return pulumi.get(self, "silence_time")

    @silence_time.setter
    def silence_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "silence_time", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    @_utilities.deprecated("""Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Alarm.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]]]:
        """
        Adds or modifies the push channels of an alert rule. See `targets` below.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "webhook", value)


@pulumi.type_token("alicloud:cms/alarm:Alarm")
class Alarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 composite_expression: Optional[pulumi.Input[Union['AlarmCompositeExpressionArgs', 'AlarmCompositeExpressionArgsDict']]] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 escalations_critical: Optional[pulumi.Input[Union['AlarmEscalationsCriticalArgs', 'AlarmEscalationsCriticalArgsDict']]] = None,
                 escalations_info: Optional[pulumi.Input[Union['AlarmEscalationsInfoArgs', 'AlarmEscalationsInfoArgsDict']]] = None,
                 escalations_warn: Optional[pulumi.Input[Union['AlarmEscalationsWarnArgs', 'AlarmEscalationsWarnArgsDict']]] = None,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_dimensions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmPrometheusArgs', 'AlarmPrometheusArgsDict']]]]] = None,
                 silence_time: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmTargetArgs', 'AlarmTargetArgsDict']]]]] = None,
                 webhook: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Monitor Service Alarm resource.

        For information about Cloud Monitor Service Alarm and how to use it, see [What is Alarm](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putresourcemetricrule).

        > **NOTE:** Available since v1.9.1.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            image_id=default_get_images.images[0].id)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name=name,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id)
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
        default_alarm = alicloud.cms.Alarm("default",
            name=name,
            project="acs_ecs_dashboard",
            metric="disk_writebytes",
            period=900,
            contact_groups=[default_alarm_contact_group.alarm_contact_group_name],
            effective_interval="06:00-20:00",
            metric_dimensions=default_instance.id.apply(lambda id: f\"\"\"  [
            {{
              "instanceId": "{id}",
              "device": "/dev/vda1"
            }}
          ]
        \"\"\"),
            escalations_critical={
                "statistics": "Average",
                "comparison_operator": "<=",
                "threshold": "35",
                "times": 2,
            })
        ```

        ## Import

        Cloud Monitor Service Alarm can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/alarm:Alarm example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmCompositeExpressionArgs', 'AlarmCompositeExpressionArgsDict']] composite_expression: The trigger conditions for multiple metrics. See `composite_expression` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dimensions: Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        :param pulumi.Input[_builtins.str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable alarm rule. Default value: `true`.
        :param pulumi.Input[_builtins.int] end_time: Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input[Union['AlarmEscalationsCriticalArgs', 'AlarmEscalationsCriticalArgsDict']] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input[Union['AlarmEscalationsInfoArgs', 'AlarmEscalationsInfoArgsDict']] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input[Union['AlarmEscalationsWarnArgs', 'AlarmEscalationsWarnArgsDict']] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[_builtins.str] metric: The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] name: The name of the alert rule.
        :param pulumi.Input[_builtins.int] period: The statistical period of the metric. Unit: seconds. Default value: `300`.
        :param pulumi.Input[_builtins.str] project: The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmPrometheusArgs', 'AlarmPrometheusArgsDict']]]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[_builtins.int] silence_time: Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        :param pulumi.Input[_builtins.int] start_time: Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmTargetArgs', 'AlarmTargetArgsDict']]]] targets: Adds or modifies the push channels of an alert rule. See `targets` below.
        :param pulumi.Input[_builtins.str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Monitor Service Alarm resource.

        For information about Cloud Monitor Service Alarm and how to use it, see [What is Alarm](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putresourcemetricrule).

        > **NOTE:** Available since v1.9.1.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            image_id=default_get_images.images[0].id)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name=name,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id)
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
        default_alarm = alicloud.cms.Alarm("default",
            name=name,
            project="acs_ecs_dashboard",
            metric="disk_writebytes",
            period=900,
            contact_groups=[default_alarm_contact_group.alarm_contact_group_name],
            effective_interval="06:00-20:00",
            metric_dimensions=default_instance.id.apply(lambda id: f\"\"\"  [
            {{
              "instanceId": "{id}",
              "device": "/dev/vda1"
            }}
          ]
        \"\"\"),
            escalations_critical={
                "statistics": "Average",
                "comparison_operator": "<=",
                "threshold": "35",
                "times": 2,
            })
        ```

        ## Import

        Cloud Monitor Service Alarm can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/alarm:Alarm example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 composite_expression: Optional[pulumi.Input[Union['AlarmCompositeExpressionArgs', 'AlarmCompositeExpressionArgsDict']]] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 escalations_critical: Optional[pulumi.Input[Union['AlarmEscalationsCriticalArgs', 'AlarmEscalationsCriticalArgsDict']]] = None,
                 escalations_info: Optional[pulumi.Input[Union['AlarmEscalationsInfoArgs', 'AlarmEscalationsInfoArgsDict']]] = None,
                 escalations_warn: Optional[pulumi.Input[Union['AlarmEscalationsWarnArgs', 'AlarmEscalationsWarnArgsDict']]] = None,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_dimensions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmPrometheusArgs', 'AlarmPrometheusArgsDict']]]]] = None,
                 silence_time: Optional[pulumi.Input[_builtins.int]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmTargetArgs', 'AlarmTargetArgsDict']]]]] = None,
                 webhook: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmArgs.__new__(AlarmArgs)

            __props__.__dict__["composite_expression"] = composite_expression
            if contact_groups is None and not opts.urn:
                raise TypeError("Missing required property 'contact_groups'")
            __props__.__dict__["contact_groups"] = contact_groups
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["effective_interval"] = effective_interval
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["escalations_critical"] = escalations_critical
            __props__.__dict__["escalations_info"] = escalations_info
            __props__.__dict__["escalations_warn"] = escalations_warn
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["metric_dimensions"] = metric_dimensions
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["prometheuses"] = prometheuses
            __props__.__dict__["silence_time"] = silence_time
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["targets"] = targets
            __props__.__dict__["webhook"] = webhook
            __props__.__dict__["status"] = None
        super(Alarm, __self__).__init__(
            'alicloud:cms/alarm:Alarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            composite_expression: Optional[pulumi.Input[Union['AlarmCompositeExpressionArgs', 'AlarmCompositeExpressionArgsDict']]] = None,
            contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_interval: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            end_time: Optional[pulumi.Input[_builtins.int]] = None,
            escalations_critical: Optional[pulumi.Input[Union['AlarmEscalationsCriticalArgs', 'AlarmEscalationsCriticalArgsDict']]] = None,
            escalations_info: Optional[pulumi.Input[Union['AlarmEscalationsInfoArgs', 'AlarmEscalationsInfoArgsDict']]] = None,
            escalations_warn: Optional[pulumi.Input[Union['AlarmEscalationsWarnArgs', 'AlarmEscalationsWarnArgsDict']]] = None,
            metric: Optional[pulumi.Input[_builtins.str]] = None,
            metric_dimensions: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            prometheuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmPrometheusArgs', 'AlarmPrometheusArgsDict']]]]] = None,
            silence_time: Optional[pulumi.Input[_builtins.int]] = None,
            start_time: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmTargetArgs', 'AlarmTargetArgsDict']]]]] = None,
            webhook: Optional[pulumi.Input[_builtins.str]] = None) -> 'Alarm':
        """
        Get an existing Alarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmCompositeExpressionArgs', 'AlarmCompositeExpressionArgsDict']] composite_expression: The trigger conditions for multiple metrics. See `composite_expression` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contact_groups: List contact groups of the alarm rule, which must have been created on the console.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dimensions: Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        :param pulumi.Input[_builtins.str] effective_interval: The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable alarm rule. Default value: `true`.
        :param pulumi.Input[_builtins.int] end_time: Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input[Union['AlarmEscalationsCriticalArgs', 'AlarmEscalationsCriticalArgsDict']] escalations_critical: A configuration of critical alarm. See `escalations_critical` below.
        :param pulumi.Input[Union['AlarmEscalationsInfoArgs', 'AlarmEscalationsInfoArgsDict']] escalations_info: A configuration of critical info. See `escalations_info` below.
        :param pulumi.Input[Union['AlarmEscalationsWarnArgs', 'AlarmEscalationsWarnArgsDict']] escalations_warn: A configuration of critical warn. See `escalations_warn` below.
        :param pulumi.Input[_builtins.str] metric: The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] metric_dimensions: Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        :param pulumi.Input[_builtins.str] name: The name of the alert rule.
        :param pulumi.Input[_builtins.int] period: The statistical period of the metric. Unit: seconds. Default value: `300`.
        :param pulumi.Input[_builtins.str] project: The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
               **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmPrometheusArgs', 'AlarmPrometheusArgsDict']]]] prometheuses: The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        :param pulumi.Input[_builtins.int] silence_time: Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        :param pulumi.Input[_builtins.int] start_time: Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        :param pulumi.Input[_builtins.str] status: The status of the Alarm.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmTargetArgs', 'AlarmTargetArgsDict']]]] targets: Adds or modifies the push channels of an alert rule. See `targets` below.
        :param pulumi.Input[_builtins.str] webhook: The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmState.__new__(_AlarmState)

        __props__.__dict__["composite_expression"] = composite_expression
        __props__.__dict__["contact_groups"] = contact_groups
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["effective_interval"] = effective_interval
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["escalations_critical"] = escalations_critical
        __props__.__dict__["escalations_info"] = escalations_info
        __props__.__dict__["escalations_warn"] = escalations_warn
        __props__.__dict__["metric"] = metric
        __props__.__dict__["metric_dimensions"] = metric_dimensions
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["project"] = project
        __props__.__dict__["prometheuses"] = prometheuses
        __props__.__dict__["silence_time"] = silence_time
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["targets"] = targets
        __props__.__dict__["webhook"] = webhook
        return Alarm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compositeExpression")
    def composite_expression(self) -> pulumi.Output[Optional['outputs.AlarmCompositeExpression']]:
        """
        The trigger conditions for multiple metrics. See `composite_expression` below.
        """
        return pulumi.get(self, "composite_expression")

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List contact groups of the alarm rule, which must have been created on the console.
        """
        return pulumi.get(self, "contact_groups")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.""")
    def dimensions(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="effectiveInterval")
    def effective_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
        """
        return pulumi.get(self, "effective_interval")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable alarm rule. Default value: `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="endTime")
    @_utilities.deprecated("""Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
    def end_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="escalationsCritical")
    def escalations_critical(self) -> pulumi.Output['outputs.AlarmEscalationsCritical']:
        """
        A configuration of critical alarm. See `escalations_critical` below.
        """
        return pulumi.get(self, "escalations_critical")

    @_builtins.property
    @pulumi.getter(name="escalationsInfo")
    def escalations_info(self) -> pulumi.Output['outputs.AlarmEscalationsInfo']:
        """
        A configuration of critical info. See `escalations_info` below.
        """
        return pulumi.get(self, "escalations_info")

    @_builtins.property
    @pulumi.getter(name="escalationsWarn")
    def escalations_warn(self) -> pulumi.Output['outputs.AlarmEscalationsWarn']:
        """
        A configuration of critical warn. See `escalations_warn` below.
        """
        return pulumi.get(self, "escalations_warn")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> pulumi.Output[_builtins.str]:
        """
        Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        """
        return pulumi.get(self, "metric_dimensions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the alert rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The statistical period of the metric. Unit: seconds. Default value: `300`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
        **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def prometheuses(self) -> pulumi.Output[Sequence['outputs.AlarmPrometheus']]:
        """
        The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
        """
        return pulumi.get(self, "prometheuses")

    @_builtins.property
    @pulumi.getter(name="silenceTime")
    def silence_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
        """
        return pulumi.get(self, "silence_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    @_utilities.deprecated("""Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.""")
    def start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Alarm.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence['outputs.AlarmTarget']]:
        """
        Adds or modifies the push channels of an alert rule. See `targets` below.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
        """
        return pulumi.get(self, "webhook")

