# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SiteMonitorArgs', 'SiteMonitor']

@pulumi.input_type
class SiteMonitorArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 task_name: pulumi.Input[_builtins.str],
                 task_type: pulumi.Input[_builtins.str],
                 alert_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 isp_cities: Optional[pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]]] = None,
                 options_json: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SiteMonitor resource.
        :param pulumi.Input[_builtins.str] address: The URL or IP address monitored by the site monitoring task.
        :param pulumi.Input[_builtins.str] task_name: The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        :param pulumi.Input[_builtins.str] task_type: The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_ids: The IDs of existing alert rules to be associated with the site monitoring task.
        :param pulumi.Input[_builtins.int] interval: The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        :param pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]] isp_cities: The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        :param pulumi.Input[_builtins.str] options_json: The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "task_name", task_name)
        pulumi.set(__self__, "task_type", task_type)
        if alert_ids is not None:
            pulumi.set(__self__, "alert_ids", alert_ids)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if isp_cities is not None:
            pulumi.set(__self__, "isp_cities", isp_cities)
        if options_json is not None:
            pulumi.set(__self__, "options_json", options_json)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        The URL or IP address monitored by the site monitoring task.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        """
        return pulumi.get(self, "task_name")

    @task_name.setter
    def task_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_name", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="alertIds")
    def alert_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of existing alert rules to be associated with the site monitoring task.
        """
        return pulumi.get(self, "alert_ids")

    @alert_ids.setter
    def alert_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alert_ids", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="ispCities")
    def isp_cities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]]]:
        """
        The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        """
        return pulumi.get(self, "isp_cities")

    @isp_cities.setter
    def isp_cities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]]]):
        pulumi.set(self, "isp_cities", value)

    @_builtins.property
    @pulumi.getter(name="optionsJson")
    def options_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        """
        return pulumi.get(self, "options_json")

    @options_json.setter
    def options_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options_json", value)


@pulumi.input_type
class _SiteMonitorState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 isp_cities: Optional[pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]]] = None,
                 options_json: Optional[pulumi.Input[_builtins.str]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 task_state: Optional[pulumi.Input[_builtins.str]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SiteMonitor resources.
        :param pulumi.Input[_builtins.str] address: The URL or IP address monitored by the site monitoring task.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_ids: The IDs of existing alert rules to be associated with the site monitoring task.
        :param pulumi.Input[_builtins.str] create_time: The time when the site monitoring task was created.
        :param pulumi.Input[_builtins.int] interval: The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        :param pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]] isp_cities: The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        :param pulumi.Input[_builtins.str] options_json: The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        :param pulumi.Input[_builtins.str] task_name: The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        :param pulumi.Input[_builtins.str] task_state: The status of the site monitoring task.
        :param pulumi.Input[_builtins.str] task_type: The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        :param pulumi.Input[_builtins.str] update_time: The time when the site monitoring task was updated.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if alert_ids is not None:
            pulumi.set(__self__, "alert_ids", alert_ids)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if isp_cities is not None:
            pulumi.set(__self__, "isp_cities", isp_cities)
        if options_json is not None:
            pulumi.set(__self__, "options_json", options_json)
        if task_name is not None:
            pulumi.set(__self__, "task_name", task_name)
        if task_state is not None:
            pulumi.set(__self__, "task_state", task_state)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL or IP address monitored by the site monitoring task.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="alertIds")
    def alert_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of existing alert rules to be associated with the site monitoring task.
        """
        return pulumi.get(self, "alert_ids")

    @alert_ids.setter
    def alert_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alert_ids", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the site monitoring task was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="ispCities")
    def isp_cities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]]]:
        """
        The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        """
        return pulumi.get(self, "isp_cities")

    @isp_cities.setter
    def isp_cities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SiteMonitorIspCityArgs']]]]):
        pulumi.set(self, "isp_cities", value)

    @_builtins.property
    @pulumi.getter(name="optionsJson")
    def options_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        """
        return pulumi.get(self, "options_json")

    @options_json.setter
    def options_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options_json", value)

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        """
        return pulumi.get(self, "task_name")

    @task_name.setter
    def task_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_name", value)

    @_builtins.property
    @pulumi.getter(name="taskState")
    def task_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the site monitoring task.
        """
        return pulumi.get(self, "task_state")

    @task_state.setter
    def task_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_state", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the site monitoring task was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("alicloud:cms/siteMonitor:SiteMonitor")
class SiteMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 isp_cities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SiteMonitorIspCityArgs', 'SiteMonitorIspCityArgsDict']]]]] = None,
                 options_json: Optional[pulumi.Input[_builtins.str]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides a site monitor resource and it can be used to monitor public endpoints and websites.
        Details at https://www.alibabacloud.com/help/doc-detail/67907.htm

        > **NOTE:** Available since v1.72.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        basic = alicloud.cms.SiteMonitor("basic",
            address="http://www.alibabacloud.com",
            task_name="tf-example",
            task_type="HTTP",
            interval=5,
            isp_cities=[{
                "city": "546",
                "isp": "465",
            }],
            options_json=\"\"\"{
            "http_method": "get",
            "waitTime_after_completion": null,
            "ipv6_task": false,
            "diagnosis_ping": false,
            "diagnosis_mtr": false,
            "assertions": [
                {
                    "operator": "lessThan",
                    "type": "response_time",
                    "target": 1000
                }
            ],
            "time_out": 30000
        }
        \"\"\")
        ```

        ## Import

        Cloud Monitor Service Site Monitor can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/siteMonitor:SiteMonitor example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The URL or IP address monitored by the site monitoring task.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_ids: The IDs of existing alert rules to be associated with the site monitoring task.
        :param pulumi.Input[_builtins.int] interval: The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SiteMonitorIspCityArgs', 'SiteMonitorIspCityArgsDict']]]] isp_cities: The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        :param pulumi.Input[_builtins.str] options_json: The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        :param pulumi.Input[_builtins.str] task_name: The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        :param pulumi.Input[_builtins.str] task_type: The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SiteMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides a site monitor resource and it can be used to monitor public endpoints and websites.
        Details at https://www.alibabacloud.com/help/doc-detail/67907.htm

        > **NOTE:** Available since v1.72.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        basic = alicloud.cms.SiteMonitor("basic",
            address="http://www.alibabacloud.com",
            task_name="tf-example",
            task_type="HTTP",
            interval=5,
            isp_cities=[{
                "city": "546",
                "isp": "465",
            }],
            options_json=\"\"\"{
            "http_method": "get",
            "waitTime_after_completion": null,
            "ipv6_task": false,
            "diagnosis_ping": false,
            "diagnosis_mtr": false,
            "assertions": [
                {
                    "operator": "lessThan",
                    "type": "response_time",
                    "target": 1000
                }
            ],
            "time_out": 30000
        }
        \"\"\")
        ```

        ## Import

        Cloud Monitor Service Site Monitor can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/siteMonitor:SiteMonitor example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SiteMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SiteMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 isp_cities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SiteMonitorIspCityArgs', 'SiteMonitorIspCityArgsDict']]]]] = None,
                 options_json: Optional[pulumi.Input[_builtins.str]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 task_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SiteMonitorArgs.__new__(SiteMonitorArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["alert_ids"] = alert_ids
            __props__.__dict__["interval"] = interval
            __props__.__dict__["isp_cities"] = isp_cities
            __props__.__dict__["options_json"] = options_json
            if task_name is None and not opts.urn:
                raise TypeError("Missing required property 'task_name'")
            __props__.__dict__["task_name"] = task_name
            if task_type is None and not opts.urn:
                raise TypeError("Missing required property 'task_type'")
            __props__.__dict__["task_type"] = task_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["task_state"] = None
            __props__.__dict__["update_time"] = None
        super(SiteMonitor, __self__).__init__(
            'alicloud:cms/siteMonitor:SiteMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            alert_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            isp_cities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SiteMonitorIspCityArgs', 'SiteMonitorIspCityArgsDict']]]]] = None,
            options_json: Optional[pulumi.Input[_builtins.str]] = None,
            task_name: Optional[pulumi.Input[_builtins.str]] = None,
            task_state: Optional[pulumi.Input[_builtins.str]] = None,
            task_type: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'SiteMonitor':
        """
        Get an existing SiteMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The URL or IP address monitored by the site monitoring task.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_ids: The IDs of existing alert rules to be associated with the site monitoring task.
        :param pulumi.Input[_builtins.str] create_time: The time when the site monitoring task was created.
        :param pulumi.Input[_builtins.int] interval: The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SiteMonitorIspCityArgs', 'SiteMonitorIspCityArgsDict']]]] isp_cities: The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        :param pulumi.Input[_builtins.str] options_json: The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        :param pulumi.Input[_builtins.str] task_name: The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        :param pulumi.Input[_builtins.str] task_state: The status of the site monitoring task.
        :param pulumi.Input[_builtins.str] task_type: The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        :param pulumi.Input[_builtins.str] update_time: The time when the site monitoring task was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SiteMonitorState.__new__(_SiteMonitorState)

        __props__.__dict__["address"] = address
        __props__.__dict__["alert_ids"] = alert_ids
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["interval"] = interval
        __props__.__dict__["isp_cities"] = isp_cities
        __props__.__dict__["options_json"] = options_json
        __props__.__dict__["task_name"] = task_name
        __props__.__dict__["task_state"] = task_state
        __props__.__dict__["task_type"] = task_type
        __props__.__dict__["update_time"] = update_time
        return SiteMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The URL or IP address monitored by the site monitoring task.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="alertIds")
    def alert_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of existing alert rules to be associated with the site monitoring task.
        """
        return pulumi.get(self, "alert_ids")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the site monitoring task was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="ispCities")
    def isp_cities(self) -> pulumi.Output[Optional[Sequence['outputs.SiteMonitorIspCity']]]:
        """
        The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively. You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
        """
        return pulumi.get(self, "isp_cities")

    @_builtins.property
    @pulumi.getter(name="optionsJson")
    def options_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
        """
        return pulumi.get(self, "options_json")

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
        """
        return pulumi.get(self, "task_name")

    @_builtins.property
    @pulumi.getter(name="taskState")
    def task_state(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the site monitoring task.
        """
        return pulumi.get(self, "task_state")

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
        """
        return pulumi.get(self, "task_type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the site monitoring task was updated.
        """
        return pulumi.get(self, "update_time")

