# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEndpointAclPoliciesResult',
    'AwaitableGetEndpointAclPoliciesResult',
    'get_endpoint_acl_policies',
    'get_endpoint_acl_policies_output',
]

@pulumi.output_type
class GetEndpointAclPoliciesResult:
    """
    A collection of values returned by getEndpointAclPolicies.
    """
    def __init__(__self__, endpoint_type=None, id=None, ids=None, instance_id=None, output_file=None, policies=None):
        if endpoint_type and not isinstance(endpoint_type, str):
            raise TypeError("Expected argument 'endpoint_type' to be a str")
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> _builtins.str:
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetEndpointAclPoliciesPolicyResult']:
        return pulumi.get(self, "policies")


class AwaitableGetEndpointAclPoliciesResult(GetEndpointAclPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointAclPoliciesResult(
            endpoint_type=self.endpoint_type,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            output_file=self.output_file,
            policies=self.policies)


def get_endpoint_acl_policies(endpoint_type: Optional[_builtins.str] = None,
                              ids: Optional[Sequence[_builtins.str]] = None,
                              instance_id: Optional[_builtins.str] = None,
                              output_file: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointAclPoliciesResult:
    """
    This data source provides the Cr Endpoint Acl Policies of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.139.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cr.get_endpoint_acl_policies(instance_id="example_value",
        endpoint_type="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("crEndpointAclPolicyId1", ids.policies[0].id)
    ```


    :param _builtins.str endpoint_type: The type of endpoint. Valid values: `internet`.
    :param Sequence[_builtins.str] ids: A list of Endpoint Acl Policy IDs.
    :param _builtins.str instance_id: The ID of the CR Instance.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['endpointType'] = endpoint_type
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cr/getEndpointAclPolicies:getEndpointAclPolicies', __args__, opts=opts, typ=GetEndpointAclPoliciesResult).value

    return AwaitableGetEndpointAclPoliciesResult(
        endpoint_type=pulumi.get(__ret__, 'endpoint_type'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        policies=pulumi.get(__ret__, 'policies'))
def get_endpoint_acl_policies_output(endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointAclPoliciesResult]:
    """
    This data source provides the Cr Endpoint Acl Policies of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.139.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cr.get_endpoint_acl_policies(instance_id="example_value",
        endpoint_type="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("crEndpointAclPolicyId1", ids.policies[0].id)
    ```


    :param _builtins.str endpoint_type: The type of endpoint. Valid values: `internet`.
    :param Sequence[_builtins.str] ids: A list of Endpoint Acl Policy IDs.
    :param _builtins.str instance_id: The ID of the CR Instance.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['endpointType'] = endpoint_type
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cr/getEndpointAclPolicies:getEndpointAclPolicies', __args__, opts=opts, typ=GetEndpointAclPoliciesResult)
    return __ret__.apply(lambda __response__: GetEndpointAclPoliciesResult(
        endpoint_type=pulumi.get(__response__, 'endpoint_type'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        policies=pulumi.get(__response__, 'policies')))
