# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ChainChainConfig',
    'ChainChainConfigNode',
    'ChainChainConfigNodeNodeConfig',
    'ChainChainConfigNodeNodeConfigDenyPolicy',
    'ChainChainConfigRouter',
    'ChainChainConfigRouterFrom',
    'ChainChainConfigRouterTo',
    'RegistryEnterpriseInstanceInstanceEndpoint',
    'RegistryEnterpriseInstanceInstanceEndpointDomain',
    'RepoDomainList',
    'GetChainsChainResult',
    'GetChainsChainChainConfigResult',
    'GetChainsChainChainConfigNodeResult',
    'GetChainsChainChainConfigNodeNodeConfigResult',
    'GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult',
    'GetChainsChainChainConfigRouterResult',
    'GetChainsChainChainConfigRouterFromResult',
    'GetChainsChainChainConfigRouterToResult',
    'GetChartNamespacesNamespaceResult',
    'GetChartRepositoriesRepositoryResult',
    'GetEndpointAclPoliciesPolicyResult',
    'GetNamespacesNamespaceResult',
    'GetReposRepoResult',
    'GetReposRepoDomainListResult',
    'GetReposRepoTagResult',
    'GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpcResult',
]

@pulumi.output_type
class ChainChainConfig(dict):
    def __init__(__self__, *,
                 nodes: Optional[Sequence['outputs.ChainChainConfigNode']] = None,
                 routers: Optional[Sequence['outputs.ChainChainConfigRouter']] = None):
        """
        :param Sequence['ChainChainConfigNodeArgs'] nodes: Each node in the delivery chain. See `nodes` below.
               
               > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        :param Sequence['ChainChainConfigRouterArgs'] routers: Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.ChainChainConfigNode']]:
        """
        Each node in the delivery chain. See `nodes` below.

        > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def routers(self) -> Optional[Sequence['outputs.ChainChainConfigRouter']]:
        """
        Execution sequence relationship between delivery chain nodes. See `routers` below.
        """
        return pulumi.get(self, "routers")


@pulumi.output_type
class ChainChainConfigNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeConfigs":
            suggest = "node_configs"
        elif key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[_builtins.bool] = None,
                 node_configs: Optional[Sequence['outputs.ChainChainConfigNodeNodeConfig']] = None,
                 node_name: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable: Whether to enable the delivery chain node. Valid values: `true`, `false`.
        :param Sequence['ChainChainConfigNodeNodeConfigArgs'] node_configs: The configuration of delivery chain node. See `node_config` below.
        :param _builtins.str node_name: The name of delivery chain node.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if node_configs is not None:
            pulumi.set(__self__, "node_configs", node_configs)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the delivery chain node. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Optional[Sequence['outputs.ChainChainConfigNodeNodeConfig']]:
        """
        The configuration of delivery chain node. See `node_config` below.
        """
        return pulumi.get(self, "node_configs")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[_builtins.str]:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ChainChainConfigNodeNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denyPolicies":
            suggest = "deny_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigNodeNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigNodeNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigNodeNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deny_policies: Optional[Sequence['outputs.ChainChainConfigNodeNodeConfigDenyPolicy']] = None):
        """
        :param Sequence['ChainChainConfigNodeNodeConfigDenyPolicyArgs'] deny_policies: Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        if deny_policies is not None:
            pulumi.set(__self__, "deny_policies", deny_policies)

    @_builtins.property
    @pulumi.getter(name="denyPolicies")
    def deny_policies(self) -> Optional[Sequence['outputs.ChainChainConfigNodeNodeConfigDenyPolicy']]:
        """
        Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        return pulumi.get(self, "deny_policies")


@pulumi.output_type
class ChainChainConfigNodeNodeConfigDenyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issueCount":
            suggest = "issue_count"
        elif key == "issueLevel":
            suggest = "issue_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigNodeNodeConfigDenyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigNodeNodeConfigDenyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigNodeNodeConfigDenyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 issue_count: Optional[_builtins.str] = None,
                 issue_level: Optional[_builtins.str] = None,
                 logic: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        :param _builtins.str issue_count: The count of scanning vulnerabilities that triggers blocking.
        :param _builtins.str issue_level: The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        :param _builtins.str logic: The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if issue_count is not None:
            pulumi.set(__self__, "issue_count", issue_count)
        if issue_level is not None:
            pulumi.set(__self__, "issue_level", issue_level)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="issueCount")
    def issue_count(self) -> Optional[_builtins.str]:
        """
        The count of scanning vulnerabilities that triggers blocking.
        """
        return pulumi.get(self, "issue_count")

    @_builtins.property
    @pulumi.getter(name="issueLevel")
    def issue_level(self) -> Optional[_builtins.str]:
        """
        The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        """
        return pulumi.get(self, "issue_level")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        """
        The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        return pulumi.get(self, "logic")


@pulumi.output_type
class ChainChainConfigRouter(dict):
    def __init__(__self__, *,
                 froms: Optional[Sequence['outputs.ChainChainConfigRouterFrom']] = None,
                 tos: Optional[Sequence['outputs.ChainChainConfigRouterTo']] = None):
        """
        :param Sequence['ChainChainConfigRouterFromArgs'] froms: Source node. See `from` below.
        :param Sequence['ChainChainConfigRouterToArgs'] tos: Destination node. See `to` below.
        """
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[Sequence['outputs.ChainChainConfigRouterFrom']]:
        """
        Source node. See `from` below.
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[Sequence['outputs.ChainChainConfigRouterTo']]:
        """
        Destination node. See `to` below.
        """
        return pulumi.get(self, "tos")


@pulumi.output_type
class ChainChainConfigRouterFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigRouterFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigRouterFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigRouterFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str node_name: The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[_builtins.str]:
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ChainChainConfigRouterTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChainChainConfigRouterTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChainChainConfigRouterTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChainChainConfigRouterTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str node_name: The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[_builtins.str]:
        """
        The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class RegistryEnterpriseInstanceInstanceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryEnterpriseInstanceInstanceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryEnterpriseInstanceInstanceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryEnterpriseInstanceInstanceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domains: Optional[Sequence['outputs.RegistryEnterpriseInstanceInstanceEndpointDomain']] = None,
                 enable: Optional[_builtins.bool] = None,
                 endpoint_type: Optional[_builtins.str] = None):
        """
        :param Sequence['RegistryEnterpriseInstanceInstanceEndpointDomainArgs'] domains: Domain List
        :param _builtins.bool enable: enable
        :param _builtins.str endpoint_type: Network Access Endpoint Type
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[Sequence['outputs.RegistryEnterpriseInstanceInstanceEndpointDomain']]:
        """
        Domain List
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        enable
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[_builtins.str]:
        """
        Network Access Endpoint Type
        """
        return pulumi.get(self, "endpoint_type")


@pulumi.output_type
class RegistryEnterpriseInstanceInstanceEndpointDomain(dict):
    def __init__(__self__, *,
                 domain: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain: Domain
        :param _builtins.str type: Domain Type
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        Domain
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Domain Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RepoDomainList(dict):
    def __init__(__self__, *,
                 internal: Optional[_builtins.str] = None,
                 public: Optional[_builtins.str] = None,
                 vpc: Optional[_builtins.str] = None):
        """
        :param _builtins.str internal: Domain of internal endpoint, only in some regions.
        :param _builtins.str public: Domain of public endpoint.
        :param _builtins.str vpc: Domain of vpc endpoint.
        """
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[_builtins.str]:
        """
        Domain of internal endpoint, only in some regions.
        """
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[_builtins.str]:
        """
        Domain of public endpoint.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[_builtins.str]:
        """
        Domain of vpc endpoint.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class GetChainsChainResult(dict):
    def __init__(__self__, *,
                 chain_configs: Sequence['outputs.GetChainsChainChainConfigResult'],
                 chain_id: _builtins.str,
                 chain_name: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 modified_time: _builtins.str,
                 scope_id: _builtins.str,
                 scope_type: _builtins.str):
        """
        :param Sequence['GetChainsChainChainConfigArgs'] chain_configs: The configuration of delivery chain.
        :param _builtins.str chain_id: The ID of delivery chain.
        :param _builtins.str chain_name: The name of delivery chain.
        :param _builtins.str create_time: The creation time of delivery chain.
        :param _builtins.str description: The description of delivery chain.
        :param _builtins.str id: The resource ID of the delivery chain. The value formats as `<instance_id>:<chain_id>`.
        :param _builtins.str instance_id: The ID of CR Enterprise Edition instance.
        :param _builtins.str modified_time: The modification time of delivery chain description.
        :param _builtins.str scope_id: Delivery chain scope ID.
        :param _builtins.str scope_type: Delivery chain scope type.
        """
        pulumi.set(__self__, "chain_configs", chain_configs)
        pulumi.set(__self__, "chain_id", chain_id)
        pulumi.set(__self__, "chain_name", chain_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "scope_id", scope_id)
        pulumi.set(__self__, "scope_type", scope_type)

    @_builtins.property
    @pulumi.getter(name="chainConfigs")
    def chain_configs(self) -> Sequence['outputs.GetChainsChainChainConfigResult']:
        """
        The configuration of delivery chain.
        """
        return pulumi.get(self, "chain_configs")

    @_builtins.property
    @pulumi.getter(name="chainId")
    def chain_id(self) -> _builtins.str:
        """
        The ID of delivery chain.
        """
        return pulumi.get(self, "chain_id")

    @_builtins.property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> _builtins.str:
        """
        The name of delivery chain.
        """
        return pulumi.get(self, "chain_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of delivery chain.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of delivery chain.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID of the delivery chain. The value formats as `<instance_id>:<chain_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of CR Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> _builtins.str:
        """
        The modification time of delivery chain description.
        """
        return pulumi.get(self, "modified_time")

    @_builtins.property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> _builtins.str:
        """
        Delivery chain scope ID.
        """
        return pulumi.get(self, "scope_id")

    @_builtins.property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> _builtins.str:
        """
        Delivery chain scope type.
        """
        return pulumi.get(self, "scope_type")


@pulumi.output_type
class GetChainsChainChainConfigResult(dict):
    def __init__(__self__, *,
                 nodes: Sequence['outputs.GetChainsChainChainConfigNodeResult'],
                 routers: Sequence['outputs.GetChainsChainChainConfigRouterResult']):
        """
        :param Sequence['GetChainsChainChainConfigNodeArgs'] nodes: Each node in the delivery chain.
        :param Sequence['GetChainsChainChainConfigRouterArgs'] routers: Execution sequence relationship between delivery chain nodes.
        """
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "routers", routers)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetChainsChainChainConfigNodeResult']:
        """
        Each node in the delivery chain.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def routers(self) -> Sequence['outputs.GetChainsChainChainConfigRouterResult']:
        """
        Execution sequence relationship between delivery chain nodes.
        """
        return pulumi.get(self, "routers")


@pulumi.output_type
class GetChainsChainChainConfigNodeResult(dict):
    def __init__(__self__, *,
                 enable: _builtins.bool,
                 node_configs: Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigResult'],
                 node_name: _builtins.str):
        """
        :param _builtins.bool enable: Whether to enable the delivery chain node. Valid values: `true`, `false`.
        :param Sequence['GetChainsChainChainConfigNodeNodeConfigArgs'] node_configs: The configuration of delivery chain node.
        :param _builtins.str node_name: The name of delivery chain node.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "node_configs", node_configs)
        pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Whether to enable the delivery chain node. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigResult']:
        """
        The configuration of delivery chain node.
        """
        return pulumi.get(self, "node_configs")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> _builtins.str:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class GetChainsChainChainConfigNodeNodeConfigResult(dict):
    def __init__(__self__, *,
                 deny_policies: Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult']):
        """
        :param Sequence['GetChainsChainChainConfigNodeNodeConfigDenyPolicyArgs'] deny_policies: Blocking rules for scanning nodes in delivery chain nodes. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        pulumi.set(__self__, "deny_policies", deny_policies)

    @_builtins.property
    @pulumi.getter(name="denyPolicies")
    def deny_policies(self) -> Sequence['outputs.GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult']:
        """
        Blocking rules for scanning nodes in delivery chain nodes. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
        """
        return pulumi.get(self, "deny_policies")


@pulumi.output_type
class GetChainsChainChainConfigNodeNodeConfigDenyPolicyResult(dict):
    def __init__(__self__, *,
                 issue_count: _builtins.str,
                 issue_level: _builtins.str,
                 logic: _builtins.str,
                 action: Optional[_builtins.str] = None):
        """
        :param _builtins.str issue_count: The count of scanning vulnerabilities that triggers blocking.
        :param _builtins.str issue_level: The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        :param _builtins.str logic: The logic of trigger blocking. Valid values: `AND`, `OR`.
        :param _builtins.str action: The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        pulumi.set(__self__, "issue_count", issue_count)
        pulumi.set(__self__, "issue_level", issue_level)
        pulumi.set(__self__, "logic", logic)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="issueCount")
    def issue_count(self) -> _builtins.str:
        """
        The count of scanning vulnerabilities that triggers blocking.
        """
        return pulumi.get(self, "issue_count")

    @_builtins.property
    @pulumi.getter(name="issueLevel")
    def issue_level(self) -> _builtins.str:
        """
        The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
        """
        return pulumi.get(self, "issue_level")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> _builtins.str:
        """
        The logic of trigger blocking. Valid values: `AND`, `OR`.
        """
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class GetChainsChainChainConfigRouterResult(dict):
    def __init__(__self__, *,
                 froms: Sequence['outputs.GetChainsChainChainConfigRouterFromResult'],
                 tos: Sequence['outputs.GetChainsChainChainConfigRouterToResult']):
        """
        :param Sequence['GetChainsChainChainConfigRouterFromArgs'] froms: Source node.
        :param Sequence['GetChainsChainChainConfigRouterToArgs'] tos: Destination node.
        """
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Sequence['outputs.GetChainsChainChainConfigRouterFromResult']:
        """
        Source node.
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Sequence['outputs.GetChainsChainChainConfigRouterToResult']:
        """
        Destination node.
        """
        return pulumi.get(self, "tos")


@pulumi.output_type
class GetChainsChainChainConfigRouterFromResult(dict):
    def __init__(__self__, *,
                 node_name: _builtins.str):
        """
        :param _builtins.str node_name: The name of delivery chain node.
        """
        pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> _builtins.str:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class GetChainsChainChainConfigRouterToResult(dict):
    def __init__(__self__, *,
                 node_name: _builtins.str):
        """
        :param _builtins.str node_name: The name of delivery chain node.
        """
        pulumi.set(__self__, "node_name", node_name)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> _builtins.str:
        """
        The name of delivery chain node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class GetChartNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 auto_create_repo: _builtins.bool,
                 chart_namespace_id: _builtins.str,
                 default_repo_type: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 namespace_name: _builtins.str):
        """
        :param _builtins.bool auto_create_repo: Indicates whether a repository is automatically created when an image is pushed to the namespace.
        :param _builtins.str chart_namespace_id: The ID of the namespace.
        :param _builtins.str default_repo_type: The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
        :param _builtins.str id: The ID of the Chart Namespace.
        :param _builtins.str instance_id: The ID of the namespace.
        :param _builtins.str namespace_name: The name of the namespace.
        """
        pulumi.set(__self__, "auto_create_repo", auto_create_repo)
        pulumi.set(__self__, "chart_namespace_id", chart_namespace_id)
        pulumi.set(__self__, "default_repo_type", default_repo_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "namespace_name", namespace_name)

    @_builtins.property
    @pulumi.getter(name="autoCreateRepo")
    def auto_create_repo(self) -> _builtins.bool:
        """
        Indicates whether a repository is automatically created when an image is pushed to the namespace.
        """
        return pulumi.get(self, "auto_create_repo")

    @_builtins.property
    @pulumi.getter(name="chartNamespaceId")
    def chart_namespace_id(self) -> _builtins.str:
        """
        The ID of the namespace.
        """
        return pulumi.get(self, "chart_namespace_id")

    @_builtins.property
    @pulumi.getter(name="defaultRepoType")
    def default_repo_type(self) -> _builtins.str:
        """
        The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
        """
        return pulumi.get(self, "default_repo_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Chart Namespace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the namespace.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> _builtins.str:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "namespace_name")


@pulumi.output_type
class GetChartRepositoriesRepositoryResult(dict):
    def __init__(__self__, *,
                 chart_repository_id: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 repo_name: _builtins.str,
                 repo_namespace_name: _builtins.str,
                 repo_type: _builtins.str,
                 summary: _builtins.str):
        """
        :param _builtins.str chart_repository_id: The first ID of the resource.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str id: The ID of the Chart Repository.
        :param _builtins.str instance_id: The ID of the Container Registry instance.
        :param _builtins.str repo_name: The name of the repository.
        :param _builtins.str repo_namespace_name: The namespace to which the repository belongs.
        :param _builtins.str repo_type: The type of the repository. Valid values: `PUBLIC`,`PRIVATE`.
        :param _builtins.str summary: The summary about the repository.
        """
        pulumi.set(__self__, "chart_repository_id", chart_repository_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "repo_namespace_name", repo_namespace_name)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)

    @_builtins.property
    @pulumi.getter(name="chartRepositoryId")
    def chart_repository_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "chart_repository_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Chart Repository.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the Container Registry instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="repoNamespaceName")
    def repo_namespace_name(self) -> _builtins.str:
        """
        The namespace to which the repository belongs.
        """
        return pulumi.get(self, "repo_namespace_name")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        The type of the repository. Valid values: `PUBLIC`,`PRIVATE`.
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        The summary about the repository.
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class GetEndpointAclPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 endpoint_type: _builtins.str,
                 entry: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str):
        """
        :param _builtins.str description: The description of the entry.
        :param _builtins.str endpoint_type: The type of endpoint.
        :param _builtins.str entry: The IP segment that allowed to access.
        :param _builtins.str id: The ID of the Endpoint Acl Policy.
        :param _builtins.str instance_id: The ID of the CR Instance.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the entry.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> _builtins.str:
        """
        The type of endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter
    def entry(self) -> _builtins.str:
        """
        The IP segment that allowed to access.
        """
        return pulumi.get(self, "entry")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Endpoint Acl Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the CR Instance.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 auto_create: _builtins.bool,
                 default_visibility: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.bool auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param _builtins.str default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param _builtins.str name: Name of Container Registry namespace.
        """
        pulumi.set(__self__, "auto_create", auto_create)
        pulumi.set(__self__, "default_visibility", default_visibility)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> _builtins.bool:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> _builtins.str:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Container Registry namespace.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetReposRepoResult(dict):
    def __init__(__self__, *,
                 domain_list: 'outputs.GetReposRepoDomainListResult',
                 name: _builtins.str,
                 namespace: _builtins.str,
                 repo_type: _builtins.str,
                 summary: _builtins.str,
                 tags: Sequence['outputs.GetReposRepoTagResult']):
        """
        :param 'GetReposRepoDomainListArgs' domain_list: The repository domain list.
        :param _builtins.str name: Name of container registry namespace.
        :param _builtins.str namespace: Name of container registry namespace where the repositories are located in.
        :param _builtins.str repo_type: `PUBLIC` or `PRIVATE`, repository's visibility.
        :param _builtins.str summary: The repository general information.
        :param Sequence['GetReposRepoTagArgs'] tags: A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        pulumi.set(__self__, "domain_list", domain_list)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> 'outputs.GetReposRepoDomainListResult':
        """
        The repository domain list.
        """
        return pulumi.get(self, "domain_list")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of container registry namespace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Name of container registry namespace where the repositories are located in.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> _builtins.str:
        """
        `PUBLIC` or `PRIVATE`, repository's visibility.
        """
        return pulumi.get(self, "repo_type")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        The repository general information.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetReposRepoTagResult']:
        """
        A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetReposRepoDomainListResult(dict):
    def __init__(__self__, *,
                 internal: _builtins.str,
                 public: _builtins.str,
                 vpc: _builtins.str):
        """
        :param _builtins.str internal: Domain of internal endpoint, only in some regions.
        :param _builtins.str public: Domain of public endpoint.
        :param _builtins.str vpc: Domain of vpc endpoint.
        """
        pulumi.set(__self__, "internal", internal)
        pulumi.set(__self__, "public", public)
        pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> _builtins.str:
        """
        Domain of internal endpoint, only in some regions.
        """
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter
    def public(self) -> _builtins.str:
        """
        Domain of public endpoint.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> _builtins.str:
        """
        Domain of vpc endpoint.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class GetReposRepoTagResult(dict):
    def __init__(__self__, *,
                 digest: _builtins.str,
                 image_create: _builtins.int,
                 image_id: _builtins.str,
                 image_size: _builtins.int,
                 image_update: _builtins.int,
                 status: _builtins.str,
                 tag: _builtins.str):
        """
        :param _builtins.str digest: Digest of this image.
        :param _builtins.int image_create: Create time of this image, unix time in nanoseconds.
        :param _builtins.str image_id: Id of this image.
        :param _builtins.int image_size: Status of this image, in bytes.
        :param _builtins.int image_update: Last update time of this image, unix time in nanoseconds.
        :param _builtins.str status: Status of this image.
        :param _builtins.str tag: Tag of this image.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "image_create", image_create)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_size", image_size)
        pulumi.set(__self__, "image_update", image_update)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        Digest of this image.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="imageCreate")
    def image_create(self) -> _builtins.int:
        """
        Create time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_create")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        Id of this image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> _builtins.int:
        """
        Status of this image, in bytes.
        """
        return pulumi.get(self, "image_size")

    @_builtins.property
    @pulumi.getter(name="imageUpdate")
    def image_update(self) -> _builtins.int:
        """
        Last update time of this image, unix time in nanoseconds.
        """
        return pulumi.get(self, "image_update")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of this image.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Tag of this image.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpcResult(dict):
    def __init__(__self__, *,
                 default_access: _builtins.bool,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 ip: _builtins.str,
                 module_name: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.bool default_access: Indicates whether the default policy is used to access the instance.
        :param _builtins.str id: The ID of the Vpc Endpoint Linked Vpc. It formats as `<instance_id>:<vpc_id>:<vswitch_id>:<module_name>`.
        :param _builtins.str instance_id: The ID of the instance.
        :param _builtins.str ip: IP address.
        :param _builtins.str module_name: The name of the module that you want to access. Valid Values:
               - `Registry`: the image repository.
               - `Chart`: a Helm chart.
        :param _builtins.str status: The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitch_id: The ID of the vSwitch.
        """
        pulumi.set(__self__, "default_access", default_access)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "module_name", module_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="defaultAccess")
    def default_access(self) -> _builtins.bool:
        """
        Indicates whether the default policy is used to access the instance.
        """
        return pulumi.get(self, "default_access")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Vpc Endpoint Linked Vpc. It formats as `<instance_id>:<vpc_id>:<vswitch_id>:<module_name>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> _builtins.str:
        """
        The name of the module that you want to access. Valid Values:
        - `Registry`: the image repository.
        - `Chart`: a Helm chart.
        """
        return pulumi.get(self, "module_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")


