# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutoscalingConfigArgs', 'AutoscalingConfig']

@pulumi.input_type
class AutoscalingConfigArgs:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 daemonset_eviction_for_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 expander: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 min_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recycle_node_deletion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_up_from_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_nodes_with_local_storage: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_nodes_with_system_pods: Optional[pulumi.Input[_builtins.bool]] = None,
                 unneeded_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutoscalingConfig resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        :param pulumi.Input[_builtins.bool] daemonset_eviction_for_nodes: If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        :param pulumi.Input[_builtins.str] expander: The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        :param pulumi.Input[_builtins.str] gpu_utilization_threshold: The scale-in threshold for GPU instance. Default is `0.5`.
        :param pulumi.Input[_builtins.int] max_graceful_termination_sec: Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        :param pulumi.Input[_builtins.int] min_replica_count: Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        :param pulumi.Input[_builtins.bool] recycle_node_deletion_enabled: Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        :param pulumi.Input[_builtins.bool] scale_down_enabled: Specify whether to allow the scale-in of nodes. Default is `true`.
        :param pulumi.Input[_builtins.bool] scale_up_from_zero: Should CA scale up when there 0 ready nodes. Default is `true`.
        :param pulumi.Input[_builtins.str] scaler_type: The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        :param pulumi.Input[_builtins.str] scan_interval: The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_local_storage: If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_system_pods: If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        :param pulumi.Input[_builtins.str] unneeded_duration: The unneeded duration. Default is `10m`.
        :param pulumi.Input[_builtins.str] utilization_threshold: The scale-in threshold. Default is `0.5`.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cool_down_duration is not None:
            pulumi.set(__self__, "cool_down_duration", cool_down_duration)
        if daemonset_eviction_for_nodes is not None:
            pulumi.set(__self__, "daemonset_eviction_for_nodes", daemonset_eviction_for_nodes)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if gpu_utilization_threshold is not None:
            pulumi.set(__self__, "gpu_utilization_threshold", gpu_utilization_threshold)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)
        if recycle_node_deletion_enabled is not None:
            pulumi.set(__self__, "recycle_node_deletion_enabled", recycle_node_deletion_enabled)
        if scale_down_enabled is not None:
            pulumi.set(__self__, "scale_down_enabled", scale_down_enabled)
        if scale_up_from_zero is not None:
            pulumi.set(__self__, "scale_up_from_zero", scale_up_from_zero)
        if scaler_type is not None:
            pulumi.set(__self__, "scaler_type", scaler_type)
        if scan_interval is not None:
            pulumi.set(__self__, "scan_interval", scan_interval)
        if skip_nodes_with_local_storage is not None:
            pulumi.set(__self__, "skip_nodes_with_local_storage", skip_nodes_with_local_storage)
        if skip_nodes_with_system_pods is not None:
            pulumi.set(__self__, "skip_nodes_with_system_pods", skip_nodes_with_system_pods)
        if unneeded_duration is not None:
            pulumi.set(__self__, "unneeded_duration", unneeded_duration)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="coolDownDuration")
    def cool_down_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        """
        return pulumi.get(self, "cool_down_duration")

    @cool_down_duration.setter
    def cool_down_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cool_down_duration", value)

    @_builtins.property
    @pulumi.getter(name="daemonsetEvictionForNodes")
    def daemonset_eviction_for_nodes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        """
        return pulumi.get(self, "daemonset_eviction_for_nodes")

    @daemonset_eviction_for_nodes.setter
    def daemonset_eviction_for_nodes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "daemonset_eviction_for_nodes", value)

    @_builtins.property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        """
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expander", value)

    @_builtins.property
    @pulumi.getter(name="gpuUtilizationThreshold")
    def gpu_utilization_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scale-in threshold for GPU instance. Default is `0.5`.
        """
        return pulumi.get(self, "gpu_utilization_threshold")

    @gpu_utilization_threshold.setter
    def gpu_utilization_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_utilization_threshold", value)

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @_builtins.property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        """
        return pulumi.get(self, "min_replica_count")

    @min_replica_count.setter
    def min_replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_replica_count", value)

    @_builtins.property
    @pulumi.getter(name="recycleNodeDeletionEnabled")
    def recycle_node_deletion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        """
        return pulumi.get(self, "recycle_node_deletion_enabled")

    @recycle_node_deletion_enabled.setter
    def recycle_node_deletion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "recycle_node_deletion_enabled", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownEnabled")
    def scale_down_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether to allow the scale-in of nodes. Default is `true`.
        """
        return pulumi.get(self, "scale_down_enabled")

    @scale_down_enabled.setter
    def scale_down_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scale_down_enabled", value)

    @_builtins.property
    @pulumi.getter(name="scaleUpFromZero")
    def scale_up_from_zero(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should CA scale up when there 0 ready nodes. Default is `true`.
        """
        return pulumi.get(self, "scale_up_from_zero")

    @scale_up_from_zero.setter
    def scale_up_from_zero(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scale_up_from_zero", value)

    @_builtins.property
    @pulumi.getter(name="scalerType")
    def scaler_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        """
        return pulumi.get(self, "scaler_type")

    @scaler_type.setter
    def scaler_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaler_type", value)

    @_builtins.property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        """
        return pulumi.get(self, "scan_interval")

    @scan_interval.setter
    def scan_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scan_interval", value)

    @_builtins.property
    @pulumi.getter(name="skipNodesWithLocalStorage")
    def skip_nodes_with_local_storage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        """
        return pulumi.get(self, "skip_nodes_with_local_storage")

    @skip_nodes_with_local_storage.setter
    def skip_nodes_with_local_storage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_nodes_with_local_storage", value)

    @_builtins.property
    @pulumi.getter(name="skipNodesWithSystemPods")
    def skip_nodes_with_system_pods(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        """
        return pulumi.get(self, "skip_nodes_with_system_pods")

    @skip_nodes_with_system_pods.setter
    def skip_nodes_with_system_pods(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_nodes_with_system_pods", value)

    @_builtins.property
    @pulumi.getter(name="unneededDuration")
    def unneeded_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unneeded duration. Default is `10m`.
        """
        return pulumi.get(self, "unneeded_duration")

    @unneeded_duration.setter
    def unneeded_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unneeded_duration", value)

    @_builtins.property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scale-in threshold. Default is `0.5`.
        """
        return pulumi.get(self, "utilization_threshold")

    @utilization_threshold.setter
    def utilization_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "utilization_threshold", value)


@pulumi.input_type
class _AutoscalingConfigState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 daemonset_eviction_for_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 expander: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 min_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recycle_node_deletion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_up_from_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_nodes_with_local_storage: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_nodes_with_system_pods: Optional[pulumi.Input[_builtins.bool]] = None,
                 unneeded_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutoscalingConfig resources.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        :param pulumi.Input[_builtins.bool] daemonset_eviction_for_nodes: If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        :param pulumi.Input[_builtins.str] expander: The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        :param pulumi.Input[_builtins.str] gpu_utilization_threshold: The scale-in threshold for GPU instance. Default is `0.5`.
        :param pulumi.Input[_builtins.int] max_graceful_termination_sec: Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        :param pulumi.Input[_builtins.int] min_replica_count: Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        :param pulumi.Input[_builtins.bool] recycle_node_deletion_enabled: Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        :param pulumi.Input[_builtins.bool] scale_down_enabled: Specify whether to allow the scale-in of nodes. Default is `true`.
        :param pulumi.Input[_builtins.bool] scale_up_from_zero: Should CA scale up when there 0 ready nodes. Default is `true`.
        :param pulumi.Input[_builtins.str] scaler_type: The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        :param pulumi.Input[_builtins.str] scan_interval: The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_local_storage: If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_system_pods: If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        :param pulumi.Input[_builtins.str] unneeded_duration: The unneeded duration. Default is `10m`.
        :param pulumi.Input[_builtins.str] utilization_threshold: The scale-in threshold. Default is `0.5`.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cool_down_duration is not None:
            pulumi.set(__self__, "cool_down_duration", cool_down_duration)
        if daemonset_eviction_for_nodes is not None:
            pulumi.set(__self__, "daemonset_eviction_for_nodes", daemonset_eviction_for_nodes)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if gpu_utilization_threshold is not None:
            pulumi.set(__self__, "gpu_utilization_threshold", gpu_utilization_threshold)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)
        if recycle_node_deletion_enabled is not None:
            pulumi.set(__self__, "recycle_node_deletion_enabled", recycle_node_deletion_enabled)
        if scale_down_enabled is not None:
            pulumi.set(__self__, "scale_down_enabled", scale_down_enabled)
        if scale_up_from_zero is not None:
            pulumi.set(__self__, "scale_up_from_zero", scale_up_from_zero)
        if scaler_type is not None:
            pulumi.set(__self__, "scaler_type", scaler_type)
        if scan_interval is not None:
            pulumi.set(__self__, "scan_interval", scan_interval)
        if skip_nodes_with_local_storage is not None:
            pulumi.set(__self__, "skip_nodes_with_local_storage", skip_nodes_with_local_storage)
        if skip_nodes_with_system_pods is not None:
            pulumi.set(__self__, "skip_nodes_with_system_pods", skip_nodes_with_system_pods)
        if unneeded_duration is not None:
            pulumi.set(__self__, "unneeded_duration", unneeded_duration)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="coolDownDuration")
    def cool_down_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        """
        return pulumi.get(self, "cool_down_duration")

    @cool_down_duration.setter
    def cool_down_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cool_down_duration", value)

    @_builtins.property
    @pulumi.getter(name="daemonsetEvictionForNodes")
    def daemonset_eviction_for_nodes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        """
        return pulumi.get(self, "daemonset_eviction_for_nodes")

    @daemonset_eviction_for_nodes.setter
    def daemonset_eviction_for_nodes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "daemonset_eviction_for_nodes", value)

    @_builtins.property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        """
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expander", value)

    @_builtins.property
    @pulumi.getter(name="gpuUtilizationThreshold")
    def gpu_utilization_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scale-in threshold for GPU instance. Default is `0.5`.
        """
        return pulumi.get(self, "gpu_utilization_threshold")

    @gpu_utilization_threshold.setter
    def gpu_utilization_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_utilization_threshold", value)

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @_builtins.property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        """
        return pulumi.get(self, "min_replica_count")

    @min_replica_count.setter
    def min_replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_replica_count", value)

    @_builtins.property
    @pulumi.getter(name="recycleNodeDeletionEnabled")
    def recycle_node_deletion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        """
        return pulumi.get(self, "recycle_node_deletion_enabled")

    @recycle_node_deletion_enabled.setter
    def recycle_node_deletion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "recycle_node_deletion_enabled", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownEnabled")
    def scale_down_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether to allow the scale-in of nodes. Default is `true`.
        """
        return pulumi.get(self, "scale_down_enabled")

    @scale_down_enabled.setter
    def scale_down_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scale_down_enabled", value)

    @_builtins.property
    @pulumi.getter(name="scaleUpFromZero")
    def scale_up_from_zero(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should CA scale up when there 0 ready nodes. Default is `true`.
        """
        return pulumi.get(self, "scale_up_from_zero")

    @scale_up_from_zero.setter
    def scale_up_from_zero(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scale_up_from_zero", value)

    @_builtins.property
    @pulumi.getter(name="scalerType")
    def scaler_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        """
        return pulumi.get(self, "scaler_type")

    @scaler_type.setter
    def scaler_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaler_type", value)

    @_builtins.property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        """
        return pulumi.get(self, "scan_interval")

    @scan_interval.setter
    def scan_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scan_interval", value)

    @_builtins.property
    @pulumi.getter(name="skipNodesWithLocalStorage")
    def skip_nodes_with_local_storage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        """
        return pulumi.get(self, "skip_nodes_with_local_storage")

    @skip_nodes_with_local_storage.setter
    def skip_nodes_with_local_storage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_nodes_with_local_storage", value)

    @_builtins.property
    @pulumi.getter(name="skipNodesWithSystemPods")
    def skip_nodes_with_system_pods(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        """
        return pulumi.get(self, "skip_nodes_with_system_pods")

    @skip_nodes_with_system_pods.setter
    def skip_nodes_with_system_pods(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_nodes_with_system_pods", value)

    @_builtins.property
    @pulumi.getter(name="unneededDuration")
    def unneeded_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unneeded duration. Default is `10m`.
        """
        return pulumi.get(self, "unneeded_duration")

    @unneeded_duration.setter
    def unneeded_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unneeded_duration", value)

    @_builtins.property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scale-in threshold. Default is `0.5`.
        """
        return pulumi.get(self, "utilization_threshold")

    @utilization_threshold.setter
    def utilization_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "utilization_threshold", value)


@pulumi.type_token("alicloud:cs/autoscalingConfig:AutoscalingConfig")
class AutoscalingConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 daemonset_eviction_for_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 expander: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 min_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recycle_node_deletion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_up_from_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_nodes_with_local_storage: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_nodes_with_system_pods: Optional[pulumi.Input[_builtins.bool]] = None,
                 unneeded_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource will help you configure auto scaling for the kubernetes cluster, see [What is autoscaling config](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/api-configure-auto-scaling).

        > **NOTE:** Available since v1.127.0.

        > **NOTE:** From version 1.164.0, support for specifying whether to allow the scale-in of nodes by parameter `scale_down_enabled`.

        > **NOTE:** From version 1.164.0, support for selecting the policy for selecting which node pool to scale by parameter `expander`.

        > **NOTE:** From version 1.237.0, support for selecting the type of autoscaler by parameter `scaler_type`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        :param pulumi.Input[_builtins.bool] daemonset_eviction_for_nodes: If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        :param pulumi.Input[_builtins.str] expander: The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        :param pulumi.Input[_builtins.str] gpu_utilization_threshold: The scale-in threshold for GPU instance. Default is `0.5`.
        :param pulumi.Input[_builtins.int] max_graceful_termination_sec: Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        :param pulumi.Input[_builtins.int] min_replica_count: Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        :param pulumi.Input[_builtins.bool] recycle_node_deletion_enabled: Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        :param pulumi.Input[_builtins.bool] scale_down_enabled: Specify whether to allow the scale-in of nodes. Default is `true`.
        :param pulumi.Input[_builtins.bool] scale_up_from_zero: Should CA scale up when there 0 ready nodes. Default is `true`.
        :param pulumi.Input[_builtins.str] scaler_type: The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        :param pulumi.Input[_builtins.str] scan_interval: The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_local_storage: If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_system_pods: If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        :param pulumi.Input[_builtins.str] unneeded_duration: The unneeded duration. Default is `10m`.
        :param pulumi.Input[_builtins.str] utilization_threshold: The scale-in threshold. Default is `0.5`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AutoscalingConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you configure auto scaling for the kubernetes cluster, see [What is autoscaling config](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/api-configure-auto-scaling).

        > **NOTE:** Available since v1.127.0.

        > **NOTE:** From version 1.164.0, support for specifying whether to allow the scale-in of nodes by parameter `scale_down_enabled`.

        > **NOTE:** From version 1.164.0, support for selecting the policy for selecting which node pool to scale by parameter `expander`.

        > **NOTE:** From version 1.237.0, support for selecting the type of autoscaler by parameter `scaler_type`.

        :param str resource_name: The name of the resource.
        :param AutoscalingConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoscalingConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 daemonset_eviction_for_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 expander: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 min_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 recycle_node_deletion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_up_from_zero: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_nodes_with_local_storage: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_nodes_with_system_pods: Optional[pulumi.Input[_builtins.bool]] = None,
                 unneeded_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoscalingConfigArgs.__new__(AutoscalingConfigArgs)

            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["cool_down_duration"] = cool_down_duration
            __props__.__dict__["daemonset_eviction_for_nodes"] = daemonset_eviction_for_nodes
            __props__.__dict__["expander"] = expander
            __props__.__dict__["gpu_utilization_threshold"] = gpu_utilization_threshold
            __props__.__dict__["max_graceful_termination_sec"] = max_graceful_termination_sec
            __props__.__dict__["min_replica_count"] = min_replica_count
            __props__.__dict__["recycle_node_deletion_enabled"] = recycle_node_deletion_enabled
            __props__.__dict__["scale_down_enabled"] = scale_down_enabled
            __props__.__dict__["scale_up_from_zero"] = scale_up_from_zero
            __props__.__dict__["scaler_type"] = scaler_type
            __props__.__dict__["scan_interval"] = scan_interval
            __props__.__dict__["skip_nodes_with_local_storage"] = skip_nodes_with_local_storage
            __props__.__dict__["skip_nodes_with_system_pods"] = skip_nodes_with_system_pods
            __props__.__dict__["unneeded_duration"] = unneeded_duration
            __props__.__dict__["utilization_threshold"] = utilization_threshold
        super(AutoscalingConfig, __self__).__init__(
            'alicloud:cs/autoscalingConfig:AutoscalingConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
            daemonset_eviction_for_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
            expander: Optional[pulumi.Input[_builtins.str]] = None,
            gpu_utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None,
            max_graceful_termination_sec: Optional[pulumi.Input[_builtins.int]] = None,
            min_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            recycle_node_deletion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            scale_down_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            scale_up_from_zero: Optional[pulumi.Input[_builtins.bool]] = None,
            scaler_type: Optional[pulumi.Input[_builtins.str]] = None,
            scan_interval: Optional[pulumi.Input[_builtins.str]] = None,
            skip_nodes_with_local_storage: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_nodes_with_system_pods: Optional[pulumi.Input[_builtins.bool]] = None,
            unneeded_duration: Optional[pulumi.Input[_builtins.str]] = None,
            utilization_threshold: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutoscalingConfig':
        """
        Get an existing AutoscalingConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        :param pulumi.Input[_builtins.bool] daemonset_eviction_for_nodes: If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        :param pulumi.Input[_builtins.str] expander: The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        :param pulumi.Input[_builtins.str] gpu_utilization_threshold: The scale-in threshold for GPU instance. Default is `0.5`.
        :param pulumi.Input[_builtins.int] max_graceful_termination_sec: Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        :param pulumi.Input[_builtins.int] min_replica_count: Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        :param pulumi.Input[_builtins.bool] recycle_node_deletion_enabled: Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        :param pulumi.Input[_builtins.bool] scale_down_enabled: Specify whether to allow the scale-in of nodes. Default is `true`.
        :param pulumi.Input[_builtins.bool] scale_up_from_zero: Should CA scale up when there 0 ready nodes. Default is `true`.
        :param pulumi.Input[_builtins.str] scaler_type: The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        :param pulumi.Input[_builtins.str] scan_interval: The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_local_storage: If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        :param pulumi.Input[_builtins.bool] skip_nodes_with_system_pods: If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        :param pulumi.Input[_builtins.str] unneeded_duration: The unneeded duration. Default is `10m`.
        :param pulumi.Input[_builtins.str] utilization_threshold: The scale-in threshold. Default is `0.5`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoscalingConfigState.__new__(_AutoscalingConfigState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cool_down_duration"] = cool_down_duration
        __props__.__dict__["daemonset_eviction_for_nodes"] = daemonset_eviction_for_nodes
        __props__.__dict__["expander"] = expander
        __props__.__dict__["gpu_utilization_threshold"] = gpu_utilization_threshold
        __props__.__dict__["max_graceful_termination_sec"] = max_graceful_termination_sec
        __props__.__dict__["min_replica_count"] = min_replica_count
        __props__.__dict__["recycle_node_deletion_enabled"] = recycle_node_deletion_enabled
        __props__.__dict__["scale_down_enabled"] = scale_down_enabled
        __props__.__dict__["scale_up_from_zero"] = scale_up_from_zero
        __props__.__dict__["scaler_type"] = scaler_type
        __props__.__dict__["scan_interval"] = scan_interval
        __props__.__dict__["skip_nodes_with_local_storage"] = skip_nodes_with_local_storage
        __props__.__dict__["skip_nodes_with_system_pods"] = skip_nodes_with_system_pods
        __props__.__dict__["unneeded_duration"] = unneeded_duration
        __props__.__dict__["utilization_threshold"] = utilization_threshold
        return AutoscalingConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="coolDownDuration")
    def cool_down_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
        """
        return pulumi.get(self, "cool_down_duration")

    @_builtins.property
    @pulumi.getter(name="daemonsetEvictionForNodes")
    def daemonset_eviction_for_nodes(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true DaemonSet pods will be  terminated from nodes. Default is `false`.
        """
        return pulumi.get(self, "daemonset_eviction_for_nodes")

    @_builtins.property
    @pulumi.getter
    def expander(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
        """
        return pulumi.get(self, "expander")

    @_builtins.property
    @pulumi.getter(name="gpuUtilizationThreshold")
    def gpu_utilization_threshold(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The scale-in threshold for GPU instance. Default is `0.5`.
        """
        return pulumi.get(self, "gpu_utilization_threshold")

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @_builtins.property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
        """
        return pulumi.get(self, "min_replica_count")

    @_builtins.property
    @pulumi.getter(name="recycleNodeDeletionEnabled")
    def recycle_node_deletion_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
        """
        return pulumi.get(self, "recycle_node_deletion_enabled")

    @_builtins.property
    @pulumi.getter(name="scaleDownEnabled")
    def scale_down_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specify whether to allow the scale-in of nodes. Default is `true`.
        """
        return pulumi.get(self, "scale_down_enabled")

    @_builtins.property
    @pulumi.getter(name="scaleUpFromZero")
    def scale_up_from_zero(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should CA scale up when there 0 ready nodes. Default is `true`.
        """
        return pulumi.get(self, "scale_up_from_zero")

    @_builtins.property
    @pulumi.getter(name="scalerType")
    def scaler_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of autoscaler. Valid values: `cluster-autoscaler`, `goatscaler`. For cluster version 1.22 and below, we only support `cluster-autoscaler`.
        """
        return pulumi.get(self, "scaler_type")

    @_builtins.property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The interval at which the cluster is reevaluated for scaling. Default is `30s`.
        """
        return pulumi.get(self, "scan_interval")

    @_builtins.property
    @pulumi.getter(name="skipNodesWithLocalStorage")
    def skip_nodes_with_local_storage(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
        """
        return pulumi.get(self, "skip_nodes_with_local_storage")

    @_builtins.property
    @pulumi.getter(name="skipNodesWithSystemPods")
    def skip_nodes_with_system_pods(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
        """
        return pulumi.get(self, "skip_nodes_with_system_pods")

    @_builtins.property
    @pulumi.getter(name="unneededDuration")
    def unneeded_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unneeded duration. Default is `10m`.
        """
        return pulumi.get(self, "unneeded_duration")

    @_builtins.property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The scale-in threshold. Default is `0.5`.
        """
        return pulumi.get(self, "utilization_threshold")

