# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesPermissionResult',
    'AwaitableGetKubernetesPermissionResult',
    'get_kubernetes_permission',
    'get_kubernetes_permission_output',
]

@pulumi.output_type
class GetKubernetesPermissionResult:
    """
    A collection of values returned by getKubernetesPermission.
    """
    def __init__(__self__, id=None, permissions=None, uid=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetKubernetesPermissionPermissionResult']:
        """
        A list of user permission. See `permissions` below.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
        """
        return pulumi.get(self, "uid")


class AwaitableGetKubernetesPermissionResult(GetKubernetesPermissionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesPermissionResult(
            id=self.id,
            permissions=self.permissions,
            uid=self.uid)


def get_kubernetes_permission(uid: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesPermissionResult:
    """
    This data source provides a list of Ram user permissions.

    > **NOTE:** Available since v1.122.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    default = alicloud.ram.get_users()
    # permissions
    default_get_kubernetes_permission = alicloud.cs.get_kubernetes_permission(uid=default.users[0].id)
    pulumi.export("permissions", default_get_kubernetes_permission.permissions)
    ```


    :param _builtins.str uid: The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
    """
    __args__ = dict()
    __args__['uid'] = uid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesPermission:getKubernetesPermission', __args__, opts=opts, typ=GetKubernetesPermissionResult).value

    return AwaitableGetKubernetesPermissionResult(
        id=pulumi.get(__ret__, 'id'),
        permissions=pulumi.get(__ret__, 'permissions'),
        uid=pulumi.get(__ret__, 'uid'))
def get_kubernetes_permission_output(uid: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesPermissionResult]:
    """
    This data source provides a list of Ram user permissions.

    > **NOTE:** Available since v1.122.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    default = alicloud.ram.get_users()
    # permissions
    default_get_kubernetes_permission = alicloud.cs.get_kubernetes_permission(uid=default.users[0].id)
    pulumi.export("permissions", default_get_kubernetes_permission.permissions)
    ```


    :param _builtins.str uid: The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
    """
    __args__ = dict()
    __args__['uid'] = uid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cs/getKubernetesPermission:getKubernetesPermission', __args__, opts=opts, typ=GetKubernetesPermissionResult)
    return __ret__.apply(lambda __response__: GetKubernetesPermissionResult(
        id=pulumi.get(__response__, 'id'),
        permissions=pulumi.get(__response__, 'permissions'),
        uid=pulumi.get(__response__, 'uid')))
