# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 zone_id: pulumi.Input[_builtins.str],
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_lists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]]] = None,
                 enable_raid: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 fs_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 raid_stripe_unit_number: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 used_scene: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] category: Category of database file system.
        :param pulumi.Input[_builtins.int] size: Size of database file system, unit GiB.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the database file system belongs.
        :param pulumi.Input[_builtins.str] advanced_features: The number of CPU cores and the upper limit of memory used by the database file storage instance.
        :param pulumi.Input[_builtins.bool] delete_snapshot: Whether to delete the original snapshot after creating DBFS using the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]] ecs_lists: The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        :param pulumi.Input[_builtins.bool] enable_raid: Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.bool] encryption: Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.str] fs_name: Database file system name.
        :param pulumi.Input[_builtins.str] instance_name: . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Value range:
               - dbfs.small
               - dbfs.medium
               - dbfs.large (default)
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key used by DBFS.
        :param pulumi.Input[_builtins.str] performance_level: When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
               - PL0: single disk maximum random read-write IOPS 10000
               - PL1: highest random read-write IOPS 50000 per disk (default)
               - PL2: single disk maximum random read-write IOPS 100000
               - PL3: single disk maximum random read-write IOPS 1 million.
        :param pulumi.Input[_builtins.int] raid_stripe_unit_number: Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot used to create the DBFS instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] used_scene: The usage scenario of DBFS. Value range:
               - MySQL 5.7
               - PostgreSQL
               - MongoDB.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "zone_id", zone_id)
        if advanced_features is not None:
            pulumi.set(__self__, "advanced_features", advanced_features)
        if delete_snapshot is not None:
            pulumi.set(__self__, "delete_snapshot", delete_snapshot)
        if ecs_lists is not None:
            warnings.warn("""Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""", DeprecationWarning)
            pulumi.log.warn("""ecs_lists is deprecated: Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""")
        if ecs_lists is not None:
            pulumi.set(__self__, "ecs_lists", ecs_lists)
        if enable_raid is not None:
            pulumi.set(__self__, "enable_raid", enable_raid)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if fs_name is not None:
            pulumi.set(__self__, "fs_name", fs_name)
        if instance_name is not None:
            warnings.warn("""Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_name is deprecated: Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""")
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if raid_stripe_unit_number is not None:
            pulumi.set(__self__, "raid_stripe_unit_number", raid_stripe_unit_number)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if used_scene is not None:
            pulumi.set(__self__, "used_scene", used_scene)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        Category of database file system.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        Size of database file system, unit GiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the zone to which the database file system belongs.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="advancedFeatures")
    def advanced_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of CPU cores and the upper limit of memory used by the database file storage instance.
        """
        return pulumi.get(self, "advanced_features")

    @advanced_features.setter
    def advanced_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_features", value)

    @_builtins.property
    @pulumi.getter(name="deleteSnapshot")
    def delete_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the original snapshot after creating DBFS using the snapshot.
        """
        return pulumi.get(self, "delete_snapshot")

    @delete_snapshot.setter
    def delete_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="ecsLists")
    @_utilities.deprecated("""Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""")
    def ecs_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]]]:
        """
        The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        """
        return pulumi.get(self, "ecs_lists")

    @ecs_lists.setter
    def ecs_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]]]):
        pulumi.set(self, "ecs_lists", value)

    @_builtins.property
    @pulumi.getter(name="enableRaid")
    def enable_raid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        """
        return pulumi.get(self, "enable_raid")

    @enable_raid.setter
    def enable_raid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_raid", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database file system name.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fs_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    @_utilities.deprecated("""Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type. Value range:
        - dbfs.small
        - dbfs.medium
        - dbfs.large (default)
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key used by DBFS.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
        - PL0: single disk maximum random read-write IOPS 10000
        - PL1: highest random read-write IOPS 50000 per disk (default)
        - PL2: single disk maximum random read-write IOPS 100000
        - PL3: single disk maximum random read-write IOPS 1 million.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter(name="raidStripeUnitNumber")
    def raid_stripe_unit_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        """
        return pulumi.get(self, "raid_stripe_unit_number")

    @raid_stripe_unit_number.setter
    def raid_stripe_unit_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "raid_stripe_unit_number", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot used to create the DBFS instance.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="usedScene")
    def used_scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usage scenario of DBFS. Value range:
        - MySQL 5.7
        - PostgreSQL
        - MongoDB.
        """
        return pulumi.get(self, "used_scene")

    @used_scene.setter
    def used_scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "used_scene", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_lists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]]] = None,
                 enable_raid: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 fs_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 raid_stripe_unit_number: Optional[pulumi.Input[_builtins.int]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 used_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] advanced_features: The number of CPU cores and the upper limit of memory used by the database file storage instance.
        :param pulumi.Input[_builtins.str] category: Category of database file system.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.bool] delete_snapshot: Whether to delete the original snapshot after creating DBFS using the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]] ecs_lists: The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        :param pulumi.Input[_builtins.bool] enable_raid: Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.bool] encryption: Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.str] fs_name: Database file system name.
        :param pulumi.Input[_builtins.str] instance_name: . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Value range:
               - dbfs.small
               - dbfs.medium
               - dbfs.large (default)
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key used by DBFS.
        :param pulumi.Input[_builtins.str] performance_level: When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
               - PL0: single disk maximum random read-write IOPS 10000
               - PL1: highest random read-write IOPS 50000 per disk (default)
               - PL2: single disk maximum random read-write IOPS 100000
               - PL3: single disk maximum random read-write IOPS 1 million.
        :param pulumi.Input[_builtins.int] raid_stripe_unit_number: Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        :param pulumi.Input[_builtins.int] size: Size of database file system, unit GiB.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot used to create the DBFS instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] used_scene: The usage scenario of DBFS. Value range:
               - MySQL 5.7
               - PostgreSQL
               - MongoDB.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the database file system belongs.
        """
        if advanced_features is not None:
            pulumi.set(__self__, "advanced_features", advanced_features)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_snapshot is not None:
            pulumi.set(__self__, "delete_snapshot", delete_snapshot)
        if ecs_lists is not None:
            warnings.warn("""Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""", DeprecationWarning)
            pulumi.log.warn("""ecs_lists is deprecated: Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""")
        if ecs_lists is not None:
            pulumi.set(__self__, "ecs_lists", ecs_lists)
        if enable_raid is not None:
            pulumi.set(__self__, "enable_raid", enable_raid)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if fs_name is not None:
            pulumi.set(__self__, "fs_name", fs_name)
        if instance_name is not None:
            warnings.warn("""Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_name is deprecated: Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""")
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if raid_stripe_unit_number is not None:
            pulumi.set(__self__, "raid_stripe_unit_number", raid_stripe_unit_number)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if used_scene is not None:
            pulumi.set(__self__, "used_scene", used_scene)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="advancedFeatures")
    def advanced_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of CPU cores and the upper limit of memory used by the database file storage instance.
        """
        return pulumi.get(self, "advanced_features")

    @advanced_features.setter
    def advanced_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_features", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Category of database file system.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteSnapshot")
    def delete_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the original snapshot after creating DBFS using the snapshot.
        """
        return pulumi.get(self, "delete_snapshot")

    @delete_snapshot.setter
    def delete_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="ecsLists")
    @_utilities.deprecated("""Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""")
    def ecs_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]]]:
        """
        The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        """
        return pulumi.get(self, "ecs_lists")

    @ecs_lists.setter
    def ecs_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEcsListArgs']]]]):
        pulumi.set(self, "ecs_lists", value)

    @_builtins.property
    @pulumi.getter(name="enableRaid")
    def enable_raid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        """
        return pulumi.get(self, "enable_raid")

    @enable_raid.setter
    def enable_raid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_raid", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database file system name.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fs_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    @_utilities.deprecated("""Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type. Value range:
        - dbfs.small
        - dbfs.medium
        - dbfs.large (default)
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key used by DBFS.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
        - PL0: single disk maximum random read-write IOPS 10000
        - PL1: highest random read-write IOPS 50000 per disk (default)
        - PL2: single disk maximum random read-write IOPS 100000
        - PL3: single disk maximum random read-write IOPS 1 million.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter(name="raidStripeUnitNumber")
    def raid_stripe_unit_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        """
        return pulumi.get(self, "raid_stripe_unit_number")

    @raid_stripe_unit_number.setter
    def raid_stripe_unit_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "raid_stripe_unit_number", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of database file system, unit GiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot used to create the DBFS instance.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="usedScene")
    def used_scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usage scenario of DBFS. Value range:
        - MySQL 5.7
        - PostgreSQL
        - MongoDB.
        """
        return pulumi.get(self, "used_scene")

    @used_scene.setter
    def used_scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "used_scene", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the database file system belongs.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:databasefilesystem/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEcsListArgs', 'InstanceEcsListArgsDict']]]]] = None,
                 enable_raid: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 fs_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 raid_stripe_unit_number: Optional[pulumi.Input[_builtins.int]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 used_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DBFS Dbfs Instance resource. An instance of a database file system is equivalent to a file system and can store data of file types.

        For information about DBFS Dbfs Instance and how to use it, see [What is Dbfs Instance](https://next.api.alibabacloud.com/document/DBFS/2020-04-18/CreateDbfs).

        > **NOTE:** Need to contact us open whitelist before you can use the resource.

        > **NOTE:** Available since v1.136.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.databasefilesystem.Instance("example",
            category="standard",
            zone_id="cn-hangzhou-i",
            performance_level="PL1",
            fs_name=name,
            size=100)
        ```

        ## Import

        DBFS Dbfs Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:databasefilesystem/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] advanced_features: The number of CPU cores and the upper limit of memory used by the database file storage instance.
        :param pulumi.Input[_builtins.str] category: Category of database file system.
        :param pulumi.Input[_builtins.bool] delete_snapshot: Whether to delete the original snapshot after creating DBFS using the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEcsListArgs', 'InstanceEcsListArgsDict']]]] ecs_lists: The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        :param pulumi.Input[_builtins.bool] enable_raid: Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.bool] encryption: Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.str] fs_name: Database file system name.
        :param pulumi.Input[_builtins.str] instance_name: . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Value range:
               - dbfs.small
               - dbfs.medium
               - dbfs.large (default)
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key used by DBFS.
        :param pulumi.Input[_builtins.str] performance_level: When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
               - PL0: single disk maximum random read-write IOPS 10000
               - PL1: highest random read-write IOPS 50000 per disk (default)
               - PL2: single disk maximum random read-write IOPS 100000
               - PL3: single disk maximum random read-write IOPS 1 million.
        :param pulumi.Input[_builtins.int] raid_stripe_unit_number: Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        :param pulumi.Input[_builtins.int] size: Size of database file system, unit GiB.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot used to create the DBFS instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] used_scene: The usage scenario of DBFS. Value range:
               - MySQL 5.7
               - PostgreSQL
               - MongoDB.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the database file system belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DBFS Dbfs Instance resource. An instance of a database file system is equivalent to a file system and can store data of file types.

        For information about DBFS Dbfs Instance and how to use it, see [What is Dbfs Instance](https://next.api.alibabacloud.com/document/DBFS/2020-04-18/CreateDbfs).

        > **NOTE:** Need to contact us open whitelist before you can use the resource.

        > **NOTE:** Available since v1.136.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.databasefilesystem.Instance("example",
            category="standard",
            zone_id="cn-hangzhou-i",
            performance_level="PL1",
            fs_name=name,
            size=100)
        ```

        ## Import

        DBFS Dbfs Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:databasefilesystem/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEcsListArgs', 'InstanceEcsListArgsDict']]]]] = None,
                 enable_raid: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 fs_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 raid_stripe_unit_number: Optional[pulumi.Input[_builtins.int]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 used_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["advanced_features"] = advanced_features
            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["delete_snapshot"] = delete_snapshot
            __props__.__dict__["ecs_lists"] = ecs_lists
            __props__.__dict__["enable_raid"] = enable_raid
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["fs_name"] = fs_name
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["performance_level"] = performance_level
            __props__.__dict__["raid_stripe_unit_number"] = raid_stripe_unit_number
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["used_scene"] = used_scene
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:databasefilesystem/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            ecs_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEcsListArgs', 'InstanceEcsListArgsDict']]]]] = None,
            enable_raid: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption: Optional[pulumi.Input[_builtins.bool]] = None,
            fs_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            raid_stripe_unit_number: Optional[pulumi.Input[_builtins.int]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            used_scene: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] advanced_features: The number of CPU cores and the upper limit of memory used by the database file storage instance.
        :param pulumi.Input[_builtins.str] category: Category of database file system.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.bool] delete_snapshot: Whether to delete the original snapshot after creating DBFS using the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEcsListArgs', 'InstanceEcsListArgsDict']]]] ecs_lists: The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        :param pulumi.Input[_builtins.bool] enable_raid: Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.bool] encryption: Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        :param pulumi.Input[_builtins.str] fs_name: Database file system name.
        :param pulumi.Input[_builtins.str] instance_name: . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Value range:
               - dbfs.small
               - dbfs.medium
               - dbfs.large (default)
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the KMS key used by DBFS.
        :param pulumi.Input[_builtins.str] performance_level: When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
               - PL0: single disk maximum random read-write IOPS 10000
               - PL1: highest random read-write IOPS 50000 per disk (default)
               - PL2: single disk maximum random read-write IOPS 100000
               - PL3: single disk maximum random read-write IOPS 1 million.
        :param pulumi.Input[_builtins.int] raid_stripe_unit_number: Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        :param pulumi.Input[_builtins.int] size: Size of database file system, unit GiB.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot used to create the DBFS instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] used_scene: The usage scenario of DBFS. Value range:
               - MySQL 5.7
               - PostgreSQL
               - MongoDB.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the database file system belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["advanced_features"] = advanced_features
        __props__.__dict__["category"] = category
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_snapshot"] = delete_snapshot
        __props__.__dict__["ecs_lists"] = ecs_lists
        __props__.__dict__["enable_raid"] = enable_raid
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["fs_name"] = fs_name
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["performance_level"] = performance_level
        __props__.__dict__["raid_stripe_unit_number"] = raid_stripe_unit_number
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["used_scene"] = used_scene
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedFeatures")
    def advanced_features(self) -> pulumi.Output[_builtins.str]:
        """
        The number of CPU cores and the upper limit of memory used by the database file storage instance.
        """
        return pulumi.get(self, "advanced_features")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Category of database file system.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteSnapshot")
    def delete_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to delete the original snapshot after creating DBFS using the snapshot.
        """
        return pulumi.get(self, "delete_snapshot")

    @_builtins.property
    @pulumi.getter(name="ecsLists")
    @_utilities.deprecated("""Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS.""")
    def ecs_lists(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceEcsList']]]:
        """
        The collection of ECS instances mounted to the Database file system. See `ecs_list` below.  **NOTE:** Field 'ecs_list' has been deprecated from provider version 1.156.0 and it will be removed in the future version. Please use the new resource 'alicloud_dbfs_instance_attachment' to attach ECS and DBFS. See `ecs_list` below.
        """
        return pulumi.get(self, "ecs_lists")

    @_builtins.property
    @pulumi.getter(name="enableRaid")
    def enable_raid(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create DBFS in RAID mode. If created in RAID mode, the capacity is at least 66GB.Valid values: true or false. Default value: false.
        """
        return pulumi.get(self, "enable_raid")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to encrypt DBFS.Valid values: true or false. Default value: false.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Output[_builtins.str]:
        """
        Database file system name.
        """
        return pulumi.get(self, "fs_name")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    @_utilities.deprecated("""Field 'instance_name' has been deprecated since provider version 1.212.0. New field 'fs_name' instead.""")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'instance_name' has been deprecated from provider version 1.212.0. New field 'fs_name' instead.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance type. Value range:
        - dbfs.small
        - dbfs.medium
        - dbfs.large (default)
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the KMS key used by DBFS.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> pulumi.Output[_builtins.str]:
        """
        When you create a DBFS instance, set the performance level of the DBFS instance. Value range:
        - PL0: single disk maximum random read-write IOPS 10000
        - PL1: highest random read-write IOPS 50000 per disk (default)
        - PL2: single disk maximum random read-write IOPS 100000
        - PL3: single disk maximum random read-write IOPS 1 million.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter(name="raidStripeUnitNumber")
    def raid_stripe_unit_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of strips. Required when the EnableRaid parameter is true.Value range: Currently, only 8 stripes are supported.
        """
        return pulumi.get(self, "raid_stripe_unit_number")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Size of database file system, unit GiB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the snapshot used to create the DBFS instance.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="usedScene")
    def used_scene(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The usage scenario of DBFS. Value range:
        - MySQL 5.7
        - PostgreSQL
        - MongoDB.
        """
        return pulumi.get(self, "used_scene")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the database file system belongs.
        """
        return pulumi.get(self, "zone_id")

