# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 connection_properties: pulumi.Input[_builtins.str],
                 connection_properties_mode: pulumi.Input[_builtins.str],
                 data_source_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[_builtins.str] connection_properties: Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        :param pulumi.Input[_builtins.str] connection_properties_mode: The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        :param pulumi.Input[_builtins.str] data_source_name: The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the data source belongs.
        :param pulumi.Input[_builtins.str] type: The type of data source. For a list of data source types, see the values listed in the API documentation.
        :param pulumi.Input[_builtins.str] description: Description of the data source
        """
        pulumi.set(__self__, "connection_properties", connection_properties)
        pulumi.set(__self__, "connection_properties_mode", connection_properties_mode)
        pulumi.set(__self__, "data_source_name", data_source_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> pulumi.Input[_builtins.str]:
        """
        Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        """
        return pulumi.get(self, "connection_properties")

    @connection_properties.setter
    def connection_properties(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_properties", value)

    @_builtins.property
    @pulumi.getter(name="connectionPropertiesMode")
    def connection_properties_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        """
        return pulumi.get(self, "connection_properties_mode")

    @connection_properties_mode.setter
    def connection_properties_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_properties_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Input[_builtins.str]:
        """
        The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the project to which the data source belongs.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of data source. For a list of data source types, see the values listed in the API documentation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the data source
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _DataSourceState:
    def __init__(__self__, *,
                 connection_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_properties_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 create_user: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_time: Optional[pulumi.Input[_builtins.int]] = None,
                 modify_user: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataSource resources.
        :param pulumi.Input[_builtins.str] connection_properties: Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        :param pulumi.Input[_builtins.str] connection_properties_mode: The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        :param pulumi.Input[_builtins.int] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] create_user: Creator of the data source
        :param pulumi.Input[_builtins.int] data_source_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] data_source_name: The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        :param pulumi.Input[_builtins.str] description: Description of the data source
        :param pulumi.Input[_builtins.int] modify_time: Modification time
        :param pulumi.Input[_builtins.str] modify_user: Modifier of the data source
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the data source belongs.
        :param pulumi.Input[_builtins.str] qualified_name: Business Unique Key of Data Source
        :param pulumi.Input[_builtins.str] type: The type of data source. For a list of data source types, see the values listed in the API documentation.
        """
        if connection_properties is not None:
            pulumi.set(__self__, "connection_properties", connection_properties)
        if connection_properties_mode is not None:
            pulumi.set(__self__, "connection_properties_mode", connection_properties_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if create_user is not None:
            pulumi.set(__self__, "create_user", create_user)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if modify_time is not None:
            pulumi.set(__self__, "modify_time", modify_time)
        if modify_user is not None:
            pulumi.set(__self__, "modify_user", modify_user)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if qualified_name is not None:
            pulumi.set(__self__, "qualified_name", qualified_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        """
        return pulumi.get(self, "connection_properties")

    @connection_properties.setter
    def connection_properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_properties", value)

    @_builtins.property
    @pulumi.getter(name="connectionPropertiesMode")
    def connection_properties_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        """
        return pulumi.get(self, "connection_properties_mode")

    @connection_properties_mode.setter
    def connection_properties_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_properties_mode", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="createUser")
    def create_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creator of the data source
        """
        return pulumi.get(self, "create_user")

    @create_user.setter
    def create_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_user", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the data source
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Modification time
        """
        return pulumi.get(self, "modify_time")

    @modify_time.setter
    def modify_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "modify_time", value)

    @_builtins.property
    @pulumi.getter(name="modifyUser")
    def modify_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modifier of the data source
        """
        return pulumi.get(self, "modify_user")

    @modify_user.setter
    def modify_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_user", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project to which the data source belongs.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="qualifiedName")
    def qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Business Unique Key of Data Source
        """
        return pulumi.get(self, "qualified_name")

    @qualified_name.setter
    def qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of data source. For a list of data source types, see the values listed in the API documentation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:dataworks/dataSource:DataSource")
class DataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_properties_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Data Works Data Source resource.

        For information about Data Works Data Source and how to use it, see [What is Data Source](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdatasource).

        > **NOTE:** Available since v1.237.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        randint = random.index.Integer("randint",
            max=999,
            min=1)
        default = alicloud.resourcemanager.get_resource_groups()
        defaultkguw4_r = alicloud.dataworks.Project("defaultkguw4R",
            status="Available",
            description="tf_desc",
            project_name=f"{name}{randint['id']}",
            pai_task_enabled=False,
            display_name="tf_new_api_display",
            dev_role_disabled=True,
            dev_environment_enabled=False,
            resource_group_id=default.ids[0])
        default_data_source = alicloud.dataworks.DataSource("default",
            type="hive",
            data_source_name=name,
            connection_properties=json.dumps({
                "address": [{
                    "host": "127.0.0.1",
                    "port": "1234",
                }],
                "database": "hive_database",
                "metaType": "HiveMetastore",
                "metastoreUris": "thrift://123:123",
                "version": "2.3.9",
                "loginMode": "Anonymous",
                "securityProtocol": "authTypeNone",
                "envType": "Prod",
                "properties": {
                    "key1": "value1",
                },
            }),
            connection_properties_mode="UrlMode",
            project_id=defaultkguw4_r.id,
            description=name)
        ```

        ## Import

        Data Works Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/dataSource:DataSource example <project_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_properties: Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        :param pulumi.Input[_builtins.str] connection_properties_mode: The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        :param pulumi.Input[_builtins.str] data_source_name: The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        :param pulumi.Input[_builtins.str] description: Description of the data source
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the data source belongs.
        :param pulumi.Input[_builtins.str] type: The type of data source. For a list of data source types, see the values listed in the API documentation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Data Source resource.

        For information about Data Works Data Source and how to use it, see [What is Data Source](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdatasource).

        > **NOTE:** Available since v1.237.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        randint = random.index.Integer("randint",
            max=999,
            min=1)
        default = alicloud.resourcemanager.get_resource_groups()
        defaultkguw4_r = alicloud.dataworks.Project("defaultkguw4R",
            status="Available",
            description="tf_desc",
            project_name=f"{name}{randint['id']}",
            pai_task_enabled=False,
            display_name="tf_new_api_display",
            dev_role_disabled=True,
            dev_environment_enabled=False,
            resource_group_id=default.ids[0])
        default_data_source = alicloud.dataworks.DataSource("default",
            type="hive",
            data_source_name=name,
            connection_properties=json.dumps({
                "address": [{
                    "host": "127.0.0.1",
                    "port": "1234",
                }],
                "database": "hive_database",
                "metaType": "HiveMetastore",
                "metastoreUris": "thrift://123:123",
                "version": "2.3.9",
                "loginMode": "Anonymous",
                "securityProtocol": "authTypeNone",
                "envType": "Prod",
                "properties": {
                    "key1": "value1",
                },
            }),
            connection_properties_mode="UrlMode",
            project_id=defaultkguw4_r.id,
            description=name)
        ```

        ## Import

        Data Works Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/dataSource:DataSource example <project_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_properties_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            if connection_properties is None and not opts.urn:
                raise TypeError("Missing required property 'connection_properties'")
            __props__.__dict__["connection_properties"] = None if connection_properties is None else pulumi.Output.secret(connection_properties)
            if connection_properties_mode is None and not opts.urn:
                raise TypeError("Missing required property 'connection_properties_mode'")
            __props__.__dict__["connection_properties_mode"] = connection_properties_mode
            if data_source_name is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_name'")
            __props__.__dict__["data_source_name"] = data_source_name
            __props__.__dict__["description"] = description
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["create_user"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["modify_time"] = None
            __props__.__dict__["modify_user"] = None
            __props__.__dict__["qualified_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionProperties"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DataSource, __self__).__init__(
            'alicloud:dataworks/dataSource:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_properties: Optional[pulumi.Input[_builtins.str]] = None,
            connection_properties_mode: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            create_user: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            modify_time: Optional[pulumi.Input[_builtins.int]] = None,
            modify_user: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_properties: Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        :param pulumi.Input[_builtins.str] connection_properties_mode: The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        :param pulumi.Input[_builtins.int] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] create_user: Creator of the data source
        :param pulumi.Input[_builtins.int] data_source_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] data_source_name: The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        :param pulumi.Input[_builtins.str] description: Description of the data source
        :param pulumi.Input[_builtins.int] modify_time: Modification time
        :param pulumi.Input[_builtins.str] modify_user: Modifier of the data source
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the data source belongs.
        :param pulumi.Input[_builtins.str] qualified_name: Business Unique Key of Data Source
        :param pulumi.Input[_builtins.str] type: The type of data source. For a list of data source types, see the values listed in the API documentation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourceState.__new__(_DataSourceState)

        __props__.__dict__["connection_properties"] = connection_properties
        __props__.__dict__["connection_properties_mode"] = connection_properties_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["create_user"] = create_user
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["data_source_name"] = data_source_name
        __props__.__dict__["description"] = description
        __props__.__dict__["modify_time"] = modify_time
        __props__.__dict__["modify_user"] = modify_user
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["qualified_name"] = qualified_name
        __props__.__dict__["type"] = type
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> pulumi.Output[_builtins.str]:
        """
        Data source connection configuration information, including the connection address, access identity, and environment information. The data source environment EnvType information is a member property of this object, including DEV (Development Environment) and PROD (production environment). The value of EnvType is not case-sensitive.
        """
        return pulumi.get(self, "connection_properties")

    @_builtins.property
    @pulumi.getter(name="connectionPropertiesMode")
    def connection_properties_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration mode of the data source. Different types of data sources have different configuration modes. For example, MySQL data sources support UrlMode and InstanceMode.
        """
        return pulumi.get(self, "connection_properties_mode")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createUser")
    def create_user(self) -> pulumi.Output[_builtins.str]:
        """
        Creator of the data source
        """
        return pulumi.get(self, "create_user")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.int]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[_builtins.str]:
        """
        The data source name. The name of a data source in a specific environment (development environment or production environment) is unique in a project.
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the data source
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> pulumi.Output[_builtins.int]:
        """
        Modification time
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter(name="modifyUser")
    def modify_user(self) -> pulumi.Output[_builtins.str]:
        """
        Modifier of the data source
        """
        return pulumi.get(self, "modify_user")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the project to which the data source belongs.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="qualifiedName")
    def qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Business Unique Key of Data Source
        """
        return pulumi.get(self, "qualified_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of data source. For a list of data source types, see the values listed in the API documentation.
        """
        return pulumi.get(self, "type")

