# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 pai_task_enabled: pulumi.Input[_builtins.bool],
                 project_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_environment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dev_role_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] display_name: Workspace Display Name
        :param pulumi.Input[_builtins.bool] pai_task_enabled: Create PAI Workspace Together
        :param pulumi.Input[_builtins.str] project_name: Workspace Name
        :param pulumi.Input[_builtins.str] description: Workspace Description
        :param pulumi.Input[_builtins.bool] dev_environment_enabled: Is Development Environment Enabled
        :param pulumi.Input[_builtins.bool] dev_role_disabled: Is Development Role Disabled
        :param pulumi.Input[_builtins.str] resource_group_id: Aliyun Resource Group Id
        :param pulumi.Input[_builtins.str] status: Workspace Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Aliyun Resource Tag
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "pai_task_enabled", pai_task_enabled)
        pulumi.set(__self__, "project_name", project_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dev_environment_enabled is not None:
            pulumi.set(__self__, "dev_environment_enabled", dev_environment_enabled)
        if dev_role_disabled is not None:
            pulumi.set(__self__, "dev_role_disabled", dev_role_disabled)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Workspace Display Name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="paiTaskEnabled")
    def pai_task_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Create PAI Workspace Together
        """
        return pulumi.get(self, "pai_task_enabled")

    @pai_task_enabled.setter
    def pai_task_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "pai_task_enabled", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        Workspace Name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="devEnvironmentEnabled")
    def dev_environment_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Development Environment Enabled
        """
        return pulumi.get(self, "dev_environment_enabled")

    @dev_environment_enabled.setter
    def dev_environment_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dev_environment_enabled", value)

    @_builtins.property
    @pulumi.getter(name="devRoleDisabled")
    def dev_role_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Development Role Disabled
        """
        return pulumi.get(self, "dev_role_disabled")

    @dev_role_disabled.setter
    def dev_role_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dev_role_disabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aliyun Resource Group Id
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Aliyun Resource Tag
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_environment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dev_role_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pai_task_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] description: Workspace Description
        :param pulumi.Input[_builtins.bool] dev_environment_enabled: Is Development Environment Enabled
        :param pulumi.Input[_builtins.bool] dev_role_disabled: Is Development Role Disabled
        :param pulumi.Input[_builtins.str] display_name: Workspace Display Name
        :param pulumi.Input[_builtins.bool] pai_task_enabled: Create PAI Workspace Together
        :param pulumi.Input[_builtins.str] project_name: Workspace Name
        :param pulumi.Input[_builtins.str] resource_group_id: Aliyun Resource Group Id
        :param pulumi.Input[_builtins.str] status: Workspace Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Aliyun Resource Tag
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dev_environment_enabled is not None:
            pulumi.set(__self__, "dev_environment_enabled", dev_environment_enabled)
        if dev_role_disabled is not None:
            pulumi.set(__self__, "dev_role_disabled", dev_role_disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if pai_task_enabled is not None:
            pulumi.set(__self__, "pai_task_enabled", pai_task_enabled)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="devEnvironmentEnabled")
    def dev_environment_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Development Environment Enabled
        """
        return pulumi.get(self, "dev_environment_enabled")

    @dev_environment_enabled.setter
    def dev_environment_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dev_environment_enabled", value)

    @_builtins.property
    @pulumi.getter(name="devRoleDisabled")
    def dev_role_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Development Role Disabled
        """
        return pulumi.get(self, "dev_role_disabled")

    @dev_role_disabled.setter
    def dev_role_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dev_role_disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Display Name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="paiTaskEnabled")
    def pai_task_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Create PAI Workspace Together
        """
        return pulumi.get(self, "pai_task_enabled")

    @pai_task_enabled.setter
    def pai_task_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pai_task_enabled", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aliyun Resource Group Id
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Aliyun Resource Tag
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:dataworks/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_environment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dev_role_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pai_task_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Data Works Project resource.

        For information about Data Works Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createproject).

        > **NOTE:** Available since v1.229.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        randint = random.index.Integer("randint",
            max=999,
            min=1)
        default = alicloud.resourcemanager.get_resource_groups()
        default_project = alicloud.dataworks.Project("default",
            status="Available",
            description="tf_desc",
            project_name=f"{name}{randint['id']}",
            pai_task_enabled=False,
            display_name="tf_new_api_display",
            dev_role_disabled=True,
            dev_environment_enabled=False,
            resource_group_id=default.ids[0])
        ```

        ## Import

        Data Works Project can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/project:Project example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Workspace Description
        :param pulumi.Input[_builtins.bool] dev_environment_enabled: Is Development Environment Enabled
        :param pulumi.Input[_builtins.bool] dev_role_disabled: Is Development Role Disabled
        :param pulumi.Input[_builtins.str] display_name: Workspace Display Name
        :param pulumi.Input[_builtins.bool] pai_task_enabled: Create PAI Workspace Together
        :param pulumi.Input[_builtins.str] project_name: Workspace Name
        :param pulumi.Input[_builtins.str] resource_group_id: Aliyun Resource Group Id
        :param pulumi.Input[_builtins.str] status: Workspace Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Aliyun Resource Tag
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Project resource.

        For information about Data Works Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createproject).

        > **NOTE:** Available since v1.229.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        randint = random.index.Integer("randint",
            max=999,
            min=1)
        default = alicloud.resourcemanager.get_resource_groups()
        default_project = alicloud.dataworks.Project("default",
            status="Available",
            description="tf_desc",
            project_name=f"{name}{randint['id']}",
            pai_task_enabled=False,
            display_name="tf_new_api_display",
            dev_role_disabled=True,
            dev_environment_enabled=False,
            resource_group_id=default.ids[0])
        ```

        ## Import

        Data Works Project can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/project:Project example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_environment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dev_role_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pai_task_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dev_environment_enabled"] = dev_environment_enabled
            __props__.__dict__["dev_role_disabled"] = dev_role_disabled
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if pai_task_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'pai_task_enabled'")
            __props__.__dict__["pai_task_enabled"] = pai_task_enabled
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
        super(Project, __self__).__init__(
            'alicloud:dataworks/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dev_environment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dev_role_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            pai_task_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Workspace Description
        :param pulumi.Input[_builtins.bool] dev_environment_enabled: Is Development Environment Enabled
        :param pulumi.Input[_builtins.bool] dev_role_disabled: Is Development Role Disabled
        :param pulumi.Input[_builtins.str] display_name: Workspace Display Name
        :param pulumi.Input[_builtins.bool] pai_task_enabled: Create PAI Workspace Together
        :param pulumi.Input[_builtins.str] project_name: Workspace Name
        :param pulumi.Input[_builtins.str] resource_group_id: Aliyun Resource Group Id
        :param pulumi.Input[_builtins.str] status: Workspace Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Aliyun Resource Tag
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dev_environment_enabled"] = dev_environment_enabled
        __props__.__dict__["dev_role_disabled"] = dev_role_disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["pai_task_enabled"] = pai_task_enabled
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="devEnvironmentEnabled")
    def dev_environment_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Is Development Environment Enabled
        """
        return pulumi.get(self, "dev_environment_enabled")

    @_builtins.property
    @pulumi.getter(name="devRoleDisabled")
    def dev_role_disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Is Development Role Disabled
        """
        return pulumi.get(self, "dev_role_disabled")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Workspace Display Name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="paiTaskEnabled")
    def pai_task_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Create PAI Workspace Together
        """
        return pulumi.get(self, "pai_task_enabled")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        Workspace Name
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Aliyun Resource Group Id
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Workspace Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Aliyun Resource Tag
        """
        return pulumi.get(self, "tags")

