# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] instance_type: EAIS instance type
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]] environment_vars: Setting environment variables in eais instance on Initialization See `environment_var` below.
        :param pulumi.Input[_builtins.bool] force: Whether to force the deletion when the instance status does not meet the deletion conditions.
        :param pulumi.Input[_builtins.str] image: EAIS instance image.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if force is not None:
            warnings.warn("""Field 'force' is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""force is deprecated: Field 'force' is deprecated and will be removed in a future release.""")
        if force is not None:
            pulumi.set(__self__, "force", force)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        EAIS instance type
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        Switch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]]]:
        """
        Setting environment variables in eais instance on Initialization See `environment_var` below.
        """
        return pulumi.get(self, "environment_vars")

    @environment_vars.setter
    def environment_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]]]):
        pulumi.set(self, "environment_vars", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'force' is deprecated and will be removed in a future release.""")
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force the deletion when the instance status does not meet the deletion conditions.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the instance
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]] environment_vars: Setting environment variables in eais instance on Initialization See `environment_var` below.
        :param pulumi.Input[_builtins.bool] force: Whether to force the deletion when the instance status does not meet the deletion conditions.
        :param pulumi.Input[_builtins.str] image: EAIS instance image.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance
        :param pulumi.Input[_builtins.str] instance_type: EAIS instance type
        :param pulumi.Input[_builtins.str] region_id: Region ID
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if force is not None:
            warnings.warn("""Field 'force' is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""force is deprecated: Field 'force' is deprecated and will be removed in a future release.""")
        if force is not None:
            pulumi.set(__self__, "force", force)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]]]:
        """
        Setting environment variables in eais instance on Initialization See `environment_var` below.
        """
        return pulumi.get(self, "environment_vars")

    @environment_vars.setter
    def environment_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEnvironmentVarArgs']]]]):
        pulumi.set(self, "environment_vars", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'force' is deprecated and will be removed in a future release.""")
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force the deletion when the instance status does not meet the deletion conditions.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the instance
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EAIS instance type
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region ID
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Switch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:eais/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEnvironmentVarArgs', 'InstanceEnvironmentVarArgsDict']]]]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        EAIS Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eais/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEnvironmentVarArgs', 'InstanceEnvironmentVarArgsDict']]]] environment_vars: Setting environment variables in eais instance on Initialization See `environment_var` below.
        :param pulumi.Input[_builtins.bool] force: Whether to force the deletion when the instance status does not meet the deletion conditions.
        :param pulumi.Input[_builtins.str] image: EAIS instance image.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance
        :param pulumi.Input[_builtins.str] instance_type: EAIS instance type
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        EAIS Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eais/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEnvironmentVarArgs', 'InstanceEnvironmentVarArgsDict']]]]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["environment_vars"] = environment_vars
            __props__.__dict__["force"] = force
            __props__.__dict__["image"] = image
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(Instance, __self__).__init__(
            'alicloud:eais/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEnvironmentVarArgs', 'InstanceEnvironmentVarArgsDict']]]]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            image: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEnvironmentVarArgs', 'InstanceEnvironmentVarArgsDict']]]] environment_vars: Setting environment variables in eais instance on Initialization See `environment_var` below.
        :param pulumi.Input[_builtins.bool] force: Whether to force the deletion when the instance status does not meet the deletion conditions.
        :param pulumi.Input[_builtins.str] image: EAIS instance image.
        :param pulumi.Input[_builtins.str] instance_name: Name of the instance
        :param pulumi.Input[_builtins.str] instance_type: EAIS instance type
        :param pulumi.Input[_builtins.str] region_id: Region ID
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["category"] = category
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["environment_vars"] = environment_vars
        __props__.__dict__["force"] = force
        __props__.__dict__["image"] = image
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        EAIS instance category, valid values: `eais`, `jupyter`, `ei`, default is `eais`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceEnvironmentVar']]]:
        """
        Setting environment variables in eais instance on Initialization See `environment_var` below.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'force' is deprecated and will be removed in a future release.""")
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to force the deletion when the instance status does not meet the deletion conditions.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        EAIS instance image.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the instance
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        EAIS instance type
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        Region ID
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        Switch ID.
        """
        return pulumi.get(self, "vswitch_id")

