# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiskReplicaGroupsResult',
    'AwaitableGetDiskReplicaGroupsResult',
    'get_disk_replica_groups',
    'get_disk_replica_groups_output',
]

@pulumi.output_type
class GetDiskReplicaGroupsResult:
    """
    A collection of values returned by getDiskReplicaGroups.
    """
    def __init__(__self__, groups=None, id=None, ids=None, output_file=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetDiskReplicaGroupsGroupResult']:
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetDiskReplicaGroupsResult(GetDiskReplicaGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiskReplicaGroupsResult(
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_disk_replica_groups(ids: Optional[Sequence[_builtins.str]] = None,
                            output_file: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiskReplicaGroupsResult:
    """
    This data source provides the Ebs Disk Replica Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.187.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ebs.get_disk_replica_groups(ids=["example_id"])
    pulumi.export("ebsDiskReplicaGroupId1", ids.groups[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Disk Replica Group IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ebs/getDiskReplicaGroups:getDiskReplicaGroups', __args__, opts=opts, typ=GetDiskReplicaGroupsResult).value

    return AwaitableGetDiskReplicaGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_disk_replica_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiskReplicaGroupsResult]:
    """
    This data source provides the Ebs Disk Replica Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.187.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ebs.get_disk_replica_groups(ids=["example_id"])
    pulumi.export("ebsDiskReplicaGroupId1", ids.groups[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Disk Replica Group IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ebs/getDiskReplicaGroups:getDiskReplicaGroups', __args__, opts=opts, typ=GetDiskReplicaGroupsResult)
    return __ret__.apply(lambda __response__: GetDiskReplicaGroupsResult(
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file')))
