# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ContainerGroupAcrRegistryInfo',
    'ContainerGroupContainer',
    'ContainerGroupContainerEnvironmentVar',
    'ContainerGroupContainerEnvironmentVarFieldRef',
    'ContainerGroupContainerLivenessProbe',
    'ContainerGroupContainerLivenessProbeExec',
    'ContainerGroupContainerLivenessProbeHttpGet',
    'ContainerGroupContainerLivenessProbeTcpSocket',
    'ContainerGroupContainerPort',
    'ContainerGroupContainerReadinessProbe',
    'ContainerGroupContainerReadinessProbeExec',
    'ContainerGroupContainerReadinessProbeHttpGet',
    'ContainerGroupContainerReadinessProbeTcpSocket',
    'ContainerGroupContainerSecurityContext',
    'ContainerGroupContainerSecurityContextCapability',
    'ContainerGroupContainerVolumeMount',
    'ContainerGroupDnsConfig',
    'ContainerGroupDnsConfigOption',
    'ContainerGroupHostAlias',
    'ContainerGroupImageRegistryCredential',
    'ContainerGroupInitContainer',
    'ContainerGroupInitContainerEnvironmentVar',
    'ContainerGroupInitContainerEnvironmentVarFieldRef',
    'ContainerGroupInitContainerPort',
    'ContainerGroupInitContainerSecurityContext',
    'ContainerGroupInitContainerSecurityContextCapability',
    'ContainerGroupInitContainerVolumeMount',
    'ContainerGroupSecurityContext',
    'ContainerGroupSecurityContextSysctl',
    'ContainerGroupVolume',
    'ContainerGroupVolumeConfigFileVolumeConfigFileToPath',
    'ImageCacheImageRegistryCredential',
    'OpenApiImageCacheImageRegistryCredential',
    'VirtualNodeTaint',
    'GetContainerGroupsGroupResult',
    'GetContainerGroupsGroupContainerResult',
    'GetContainerGroupsGroupContainerEnvironmentVarResult',
    'GetContainerGroupsGroupContainerPortResult',
    'GetContainerGroupsGroupContainerVolumeMountResult',
    'GetContainerGroupsGroupDnsConfigResult',
    'GetContainerGroupsGroupDnsConfigOptionResult',
    'GetContainerGroupsGroupEciSecurityContextResult',
    'GetContainerGroupsGroupEciSecurityContextSysctlResult',
    'GetContainerGroupsGroupEventResult',
    'GetContainerGroupsGroupHostAliasResult',
    'GetContainerGroupsGroupInitContainerResult',
    'GetContainerGroupsGroupInitContainerEnvironmentVarResult',
    'GetContainerGroupsGroupInitContainerPortResult',
    'GetContainerGroupsGroupInitContainerVolumeMountResult',
    'GetContainerGroupsGroupVolumeResult',
    'GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPathResult',
    'GetImageCachesCachResult',
    'GetImageCachesCachEventResult',
    'GetVirtualNodesNodeResult',
    'GetVirtualNodesNodeEventResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class ContainerGroupAcrRegistryInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupAcrRegistryInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupAcrRegistryInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupAcrRegistryInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domains: Optional[Sequence[_builtins.str]] = None,
                 instance_id: Optional[_builtins.str] = None,
                 instance_name: Optional[_builtins.str] = None,
                 region_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] domains: The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
        :param _builtins.str instance_id: The ACR enterprise edition example ID.
        :param _builtins.str instance_name: The name of the ACR enterprise edition instance.
        :param _builtins.str region_id: The ACR enterprise edition instance belongs to the region.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[_builtins.str]]:
        """
        The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        The ACR enterprise edition example ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[_builtins.str]:
        """
        The name of the ACR enterprise edition instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The ACR enterprise edition instance belongs to the region.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class ContainerGroupContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "lifecyclePreStopHandlerExecs":
            suggest = "lifecycle_pre_stop_handler_execs"
        elif key == "livenessProbes":
            suggest = "liveness_probes"
        elif key == "readinessProbes":
            suggest = "readiness_probes"
        elif key == "restartCount":
            suggest = "restart_count"
        elif key == "securityContexts":
            suggest = "security_contexts"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 cpu: Optional[_builtins.float] = None,
                 environment_vars: Optional[Sequence['outputs.ContainerGroupContainerEnvironmentVar']] = None,
                 gpu: Optional[_builtins.int] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 lifecycle_pre_stop_handler_execs: Optional[Sequence[_builtins.str]] = None,
                 liveness_probes: Optional[Sequence['outputs.ContainerGroupContainerLivenessProbe']] = None,
                 memory: Optional[_builtins.float] = None,
                 ports: Optional[Sequence['outputs.ContainerGroupContainerPort']] = None,
                 readiness_probes: Optional[Sequence['outputs.ContainerGroupContainerReadinessProbe']] = None,
                 ready: Optional[_builtins.bool] = None,
                 restart_count: Optional[_builtins.int] = None,
                 security_contexts: Optional[Sequence['outputs.ContainerGroupContainerSecurityContext']] = None,
                 volume_mounts: Optional[Sequence['outputs.ContainerGroupContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param _builtins.str image: The image of the container.
        :param _builtins.str name: The name of the mounted volume.
        :param Sequence[_builtins.str] args: The arguments passed to the commands.
        :param Sequence[_builtins.str] commands: Commands to be executed inside the container when performing health checks using the command line method.
        :param _builtins.float cpu: The amount of CPU resources allocated to the container. Default value: `0`.
        :param Sequence['ContainerGroupContainerEnvironmentVarArgs'] environment_vars: The structure of environmentVars. See `environment_vars` below.
        :param _builtins.int gpu: The number GPUs. Default value: `0`.
        :param _builtins.str image_pull_policy: The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        :param Sequence[_builtins.str] lifecycle_pre_stop_handler_execs: The commands to be executed in containers when you use the CLI to specify the preStop callback function.
        :param Sequence['ContainerGroupContainerLivenessProbeArgs'] liveness_probes: The health check of the container. See `liveness_probe` below.
        :param _builtins.float memory: The amount of memory resources allocated to the container. Default value: `0`.
        :param Sequence['ContainerGroupContainerPortArgs'] ports: The structure of port. See `ports` below.
        :param Sequence['ContainerGroupContainerReadinessProbeArgs'] readiness_probes: The health check of the container. See `readiness_probe` below.
        :param _builtins.bool ready: Indicates whether the container passed the readiness probe.
        :param _builtins.int restart_count: The number of times that the container restarted.
        :param Sequence['ContainerGroupContainerSecurityContextArgs'] security_contexts: The security context of the container. See `security_context` below.
        :param Sequence['ContainerGroupContainerVolumeMountArgs'] volume_mounts: The structure of volumeMounts. See `volume_mounts` below.
        :param _builtins.str working_dir: The working directory of the container.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle_pre_stop_handler_execs is not None:
            pulumi.set(__self__, "lifecycle_pre_stop_handler_execs", lifecycle_pre_stop_handler_execs)
        if liveness_probes is not None:
            pulumi.set(__self__, "liveness_probes", liveness_probes)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probes is not None:
            pulumi.set(__self__, "readiness_probes", readiness_probes)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if restart_count is not None:
            pulumi.set(__self__, "restart_count", restart_count)
        if security_contexts is not None:
            pulumi.set(__self__, "security_contexts", security_contexts)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Commands to be executed inside the container when performing health checks using the command line method.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        The amount of CPU resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.ContainerGroupContainerEnvironmentVar']]:
        """
        The structure of environmentVars. See `environment_vars` below.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> Optional[_builtins.int]:
        """
        The number GPUs. Default value: `0`.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter(name="lifecyclePreStopHandlerExecs")
    def lifecycle_pre_stop_handler_execs(self) -> Optional[Sequence[_builtins.str]]:
        """
        The commands to be executed in containers when you use the CLI to specify the preStop callback function.
        """
        return pulumi.get(self, "lifecycle_pre_stop_handler_execs")

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Optional[Sequence['outputs.ContainerGroupContainerLivenessProbe']]:
        """
        The health check of the container. See `liveness_probe` below.
        """
        return pulumi.get(self, "liveness_probes")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.float]:
        """
        The amount of memory resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerGroupContainerPort']]:
        """
        The structure of port. See `ports` below.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Optional[Sequence['outputs.ContainerGroupContainerReadinessProbe']]:
        """
        The health check of the container. See `readiness_probe` below.
        """
        return pulumi.get(self, "readiness_probes")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the container passed the readiness probe.
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> Optional[_builtins.int]:
        """
        The number of times that the container restarted.
        """
        return pulumi.get(self, "restart_count")

    @_builtins.property
    @pulumi.getter(name="securityContexts")
    def security_contexts(self) -> Optional[Sequence['outputs.ContainerGroupContainerSecurityContext']]:
        """
        The security context of the container. See `security_context` below.
        """
        return pulumi.get(self, "security_contexts")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ContainerGroupContainerVolumeMount']]:
        """
        The structure of volumeMounts. See `volume_mounts` below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ContainerGroupContainerEnvironmentVar(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldReves":
            suggest = "field_reves"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainerEnvironmentVar. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainerEnvironmentVar.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainerEnvironmentVar.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_reves: Optional[Sequence['outputs.ContainerGroupContainerEnvironmentVarFieldRef']] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if field_reves is not None:
            pulumi.set(__self__, "field_reves", field_reves)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="fieldReves")
    def field_reves(self) -> Optional[Sequence['outputs.ContainerGroupContainerEnvironmentVarFieldRef']]:
        return pulumi.get(self, "field_reves")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerGroupContainerEnvironmentVarFieldRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainerEnvironmentVarFieldRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainerEnvironmentVarFieldRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainerEnvironmentVarFieldRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: Optional[_builtins.str] = None):
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "field_path")


@pulumi.output_type
class ContainerGroupContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGets":
            suggest = "http_gets"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSockets":
            suggest = "tcp_sockets"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execs: Optional[Sequence['outputs.ContainerGroupContainerLivenessProbeExec']] = None,
                 failure_threshold: Optional[_builtins.int] = None,
                 http_gets: Optional[Sequence['outputs.ContainerGroupContainerLivenessProbeHttpGet']] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 success_threshold: Optional[_builtins.int] = None,
                 tcp_sockets: Optional[Sequence['outputs.ContainerGroupContainerLivenessProbeTcpSocket']] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence['ContainerGroupContainerLivenessProbeExecArgs'] execs: Health check using command line method. See `exec` below.
        :param _builtins.int failure_threshold: Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        :param Sequence['ContainerGroupContainerLivenessProbeHttpGetArgs'] http_gets: Health check using HTTP request method. See `http_get` below.
               
               > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
        :param _builtins.int initial_delay_seconds: Check the time to start execution, calculated from the completion of container startup.
        :param _builtins.int period_seconds: Buffer time for the program to handle operations before closing.
        :param _builtins.int success_threshold: The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        :param Sequence['ContainerGroupContainerLivenessProbeTcpSocketArgs'] tcp_sockets: Health check using TCP socket method. See `tcp_socket` below.
        :param _builtins.int timeout_seconds: Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        if execs is not None:
            pulumi.set(__self__, "execs", execs)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_gets is not None:
            pulumi.set(__self__, "http_gets", http_gets)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_sockets is not None:
            pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter
    def execs(self) -> Optional[Sequence['outputs.ContainerGroupContainerLivenessProbeExec']]:
        """
        Health check using command line method. See `exec` below.
        """
        return pulumi.get(self, "execs")

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Optional[Sequence['outputs.ContainerGroupContainerLivenessProbeHttpGet']]:
        """
        Health check using HTTP request method. See `http_get` below.

        > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Check the time to start execution, calculated from the completion of container startup.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        Buffer time for the program to handle operations before closing.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[_builtins.int]:
        """
        The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        """
        return pulumi.get(self, "success_threshold")

    @_builtins.property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Optional[Sequence['outputs.ContainerGroupContainerLivenessProbeTcpSocket']]:
        """
        Health check using TCP socket method. See `tcp_socket` below.
        """
        return pulumi.get(self, "tcp_sockets")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ContainerGroupContainerLivenessProbeExec(dict):
    def __init__(__self__, *,
                 commands: Optional[Sequence[_builtins.str]] = None):
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "commands")


@pulumi.output_type
class ContainerGroupContainerLivenessProbeHttpGet(dict):
    def __init__(__self__, *,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 scheme: Optional[_builtins.str] = None):
        """
        :param _builtins.str scheme: The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class ContainerGroupContainerLivenessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class ContainerGroupContainerPort(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerGroupContainerReadinessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGets":
            suggest = "http_gets"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSockets":
            suggest = "tcp_sockets"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainerReadinessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainerReadinessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainerReadinessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execs: Optional[Sequence['outputs.ContainerGroupContainerReadinessProbeExec']] = None,
                 failure_threshold: Optional[_builtins.int] = None,
                 http_gets: Optional[Sequence['outputs.ContainerGroupContainerReadinessProbeHttpGet']] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 success_threshold: Optional[_builtins.int] = None,
                 tcp_sockets: Optional[Sequence['outputs.ContainerGroupContainerReadinessProbeTcpSocket']] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence['ContainerGroupContainerReadinessProbeExecArgs'] execs: Health check using command line method. See `exec` below.
        :param _builtins.int failure_threshold: Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        :param Sequence['ContainerGroupContainerReadinessProbeHttpGetArgs'] http_gets: Health check using HTTP request method. See `http_get` below.
               
               > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
        :param _builtins.int initial_delay_seconds: Check the time to start execution, calculated from the completion of container startup.
        :param _builtins.int period_seconds: Buffer time for the program to handle operations before closing.
        :param _builtins.int success_threshold: The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        :param Sequence['ContainerGroupContainerReadinessProbeTcpSocketArgs'] tcp_sockets: Health check using TCP socket method. See `tcp_socket` below.
        :param _builtins.int timeout_seconds: Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        if execs is not None:
            pulumi.set(__self__, "execs", execs)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_gets is not None:
            pulumi.set(__self__, "http_gets", http_gets)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_sockets is not None:
            pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter
    def execs(self) -> Optional[Sequence['outputs.ContainerGroupContainerReadinessProbeExec']]:
        """
        Health check using command line method. See `exec` below.
        """
        return pulumi.get(self, "execs")

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Optional[Sequence['outputs.ContainerGroupContainerReadinessProbeHttpGet']]:
        """
        Health check using HTTP request method. See `http_get` below.

        > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Check the time to start execution, calculated from the completion of container startup.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        Buffer time for the program to handle operations before closing.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[_builtins.int]:
        """
        The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
        """
        return pulumi.get(self, "success_threshold")

    @_builtins.property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Optional[Sequence['outputs.ContainerGroupContainerReadinessProbeTcpSocket']]:
        """
        Health check using TCP socket method. See `tcp_socket` below.
        """
        return pulumi.get(self, "tcp_sockets")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Check the timeout, the default is 1 second, the minimum is 1 second.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ContainerGroupContainerReadinessProbeExec(dict):
    def __init__(__self__, *,
                 commands: Optional[Sequence[_builtins.str]] = None):
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "commands")


@pulumi.output_type
class ContainerGroupContainerReadinessProbeHttpGet(dict):
    def __init__(__self__, *,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 scheme: Optional[_builtins.str] = None):
        """
        :param _builtins.str scheme: The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class ContainerGroupContainerReadinessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class ContainerGroupContainerSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainerSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainerSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainerSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Optional[Sequence['outputs.ContainerGroupContainerSecurityContextCapability']] = None,
                 privileged: Optional[_builtins.bool] = None,
                 run_as_user: Optional[_builtins.int] = None):
        """
        :param _builtins.bool privileged: Specifies whether to give extended privileges to this container. Default value: `false`. Valid values: `true` and `false`.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[Sequence['outputs.ContainerGroupContainerSecurityContextCapability']]:
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def privileged(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to give extended privileges to this container. Default value: `false`. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "privileged")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class ContainerGroupContainerSecurityContextCapability(dict):
    def __init__(__self__, *,
                 adds: Optional[Sequence[_builtins.str]] = None):
        if adds is not None:
            pulumi.set(__self__, "adds", adds)

    @_builtins.property
    @pulumi.getter
    def adds(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "adds")


@pulumi.output_type
class ContainerGroupContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ContainerGroupDnsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameServers":
            suggest = "name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDnsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDnsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDnsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_servers: Optional[Sequence[_builtins.str]] = None,
                 options: Optional[Sequence['outputs.ContainerGroupDnsConfigOption']] = None,
                 searches: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] name_servers: The list of DNS server IP addresses.
        :param Sequence['ContainerGroupDnsConfigOptionArgs'] options: The structure of options. See `options` below.
        :param Sequence[_builtins.str] searches: The list of DNS lookup domains.
        """
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of DNS server IP addresses.
        """
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Sequence['outputs.ContainerGroupDnsConfigOption']]:
        """
        The structure of options. See `options` below.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def searches(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of DNS lookup domains.
        """
        return pulumi.get(self, "searches")


@pulumi.output_type
class ContainerGroupDnsConfigOption(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerGroupHostAlias(dict):
    def __init__(__self__, *,
                 hostnames: Optional[Sequence[_builtins.str]] = None,
                 ip: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] hostnames: The information about the host.
        :param _builtins.str ip: The IP address of the host.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[Sequence[_builtins.str]]:
        """
        The information about the host.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        The IP address of the host.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class ContainerGroupImageRegistryCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupImageRegistryCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupImageRegistryCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupImageRegistryCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: _builtins.str,
                 server: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str password: The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
        :param _builtins.str server: The address of the image repository. It is required when `image_registry_credential` is configured.
        :param _builtins.str user_name: The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The address of the image repository. It is required when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class ContainerGroupInitContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "restartCount":
            suggest = "restart_count"
        elif key == "securityContexts":
            suggest = "security_contexts"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupInitContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupInitContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupInitContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 cpu: Optional[_builtins.float] = None,
                 environment_vars: Optional[Sequence['outputs.ContainerGroupInitContainerEnvironmentVar']] = None,
                 gpu: Optional[_builtins.int] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.float] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.ContainerGroupInitContainerPort']] = None,
                 ready: Optional[_builtins.bool] = None,
                 restart_count: Optional[_builtins.int] = None,
                 security_contexts: Optional[Sequence['outputs.ContainerGroupInitContainerSecurityContext']] = None,
                 volume_mounts: Optional[Sequence['outputs.ContainerGroupInitContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] args: The arguments passed to the commands.
        :param Sequence[_builtins.str] commands: The commands run by the init container.
        :param _builtins.float cpu: The amount of CPU resources allocated to the container. Default value: `0`.
        :param Sequence['ContainerGroupInitContainerEnvironmentVarArgs'] environment_vars: The structure of environmentVars. See `environment_vars` below.
        :param _builtins.int gpu: The number GPUs. Default value: `0`.
        :param _builtins.str image: The image of the container.
        :param _builtins.str image_pull_policy: The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        :param _builtins.float memory: The amount of memory resources allocated to the container. Default value: `0`.
        :param _builtins.str name: The name of the mounted volume.
        :param Sequence['ContainerGroupInitContainerPortArgs'] ports: The structure of port. See `ports` below.
        :param _builtins.bool ready: Indicates whether the container passed the readiness probe.
        :param _builtins.int restart_count: The number of times that the container restarted.
        :param Sequence['ContainerGroupInitContainerSecurityContextArgs'] security_contexts: The security context of the container. See `security_context` below.
        :param Sequence['ContainerGroupInitContainerVolumeMountArgs'] volume_mounts: The structure of volumeMounts. See `volume_mounts` below.
        :param _builtins.str working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if restart_count is not None:
            pulumi.set(__self__, "restart_count", restart_count)
        if security_contexts is not None:
            pulumi.set(__self__, "security_contexts", security_contexts)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        The amount of CPU resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.ContainerGroupInitContainerEnvironmentVar']]:
        """
        The structure of environmentVars. See `environment_vars` below.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> Optional[_builtins.int]:
        """
        The number GPUs. Default value: `0`.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.float]:
        """
        The amount of memory resources allocated to the container. Default value: `0`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerGroupInitContainerPort']]:
        """
        The structure of port. See `ports` below.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the container passed the readiness probe.
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> Optional[_builtins.int]:
        """
        The number of times that the container restarted.
        """
        return pulumi.get(self, "restart_count")

    @_builtins.property
    @pulumi.getter(name="securityContexts")
    def security_contexts(self) -> Optional[Sequence['outputs.ContainerGroupInitContainerSecurityContext']]:
        """
        The security context of the container. See `security_context` below.
        """
        return pulumi.get(self, "security_contexts")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ContainerGroupInitContainerVolumeMount']]:
        """
        The structure of volumeMounts. See `volume_mounts` below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ContainerGroupInitContainerEnvironmentVar(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldReves":
            suggest = "field_reves"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupInitContainerEnvironmentVar. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupInitContainerEnvironmentVar.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupInitContainerEnvironmentVar.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_reves: Optional[Sequence['outputs.ContainerGroupInitContainerEnvironmentVarFieldRef']] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if field_reves is not None:
            pulumi.set(__self__, "field_reves", field_reves)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="fieldReves")
    def field_reves(self) -> Optional[Sequence['outputs.ContainerGroupInitContainerEnvironmentVarFieldRef']]:
        return pulumi.get(self, "field_reves")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerGroupInitContainerEnvironmentVarFieldRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupInitContainerEnvironmentVarFieldRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupInitContainerEnvironmentVarFieldRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupInitContainerEnvironmentVarFieldRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: Optional[_builtins.str] = None):
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "field_path")


@pulumi.output_type
class ContainerGroupInitContainerPort(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerGroupInitContainerSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupInitContainerSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupInitContainerSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupInitContainerSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Optional[Sequence['outputs.ContainerGroupInitContainerSecurityContextCapability']] = None,
                 run_as_user: Optional[_builtins.int] = None):
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[Sequence['outputs.ContainerGroupInitContainerSecurityContextCapability']]:
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class ContainerGroupInitContainerSecurityContextCapability(dict):
    def __init__(__self__, *,
                 adds: Optional[Sequence[_builtins.str]] = None):
        if adds is not None:
            pulumi.set(__self__, "adds", adds)

    @_builtins.property
    @pulumi.getter
    def adds(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "adds")


@pulumi.output_type
class ContainerGroupInitContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupInitContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupInitContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupInitContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ContainerGroupSecurityContext(dict):
    def __init__(__self__, *,
                 sysctls: Optional[Sequence['outputs.ContainerGroupSecurityContextSysctl']] = None):
        """
        :param Sequence['ContainerGroupSecurityContextSysctlArgs'] sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
        """
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)

    @_builtins.property
    @pulumi.getter
    def sysctls(self) -> Optional[Sequence['outputs.ContainerGroupSecurityContextSysctl']]:
        """
        Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
        """
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class ContainerGroupSecurityContextSysctl(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerGroupVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configFileVolumeConfigFileToPaths":
            suggest = "config_file_volume_config_file_to_paths"
        elif key == "diskVolumeDiskId":
            suggest = "disk_volume_disk_id"
        elif key == "diskVolumeFsType":
            suggest = "disk_volume_fs_type"
        elif key == "flexVolumeDriver":
            suggest = "flex_volume_driver"
        elif key == "flexVolumeFsType":
            suggest = "flex_volume_fs_type"
        elif key == "flexVolumeOptions":
            suggest = "flex_volume_options"
        elif key == "nfsVolumePath":
            suggest = "nfs_volume_path"
        elif key == "nfsVolumeReadOnly":
            suggest = "nfs_volume_read_only"
        elif key == "nfsVolumeServer":
            suggest = "nfs_volume_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_file_volume_config_file_to_paths: Optional[Sequence['outputs.ContainerGroupVolumeConfigFileVolumeConfigFileToPath']] = None,
                 disk_volume_disk_id: Optional[_builtins.str] = None,
                 disk_volume_fs_type: Optional[_builtins.str] = None,
                 flex_volume_driver: Optional[_builtins.str] = None,
                 flex_volume_fs_type: Optional[_builtins.str] = None,
                 flex_volume_options: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 nfs_volume_path: Optional[_builtins.str] = None,
                 nfs_volume_read_only: Optional[_builtins.bool] = None,
                 nfs_volume_server: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence['ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs'] config_file_volume_config_file_to_paths: The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
               > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
        :param _builtins.str disk_volume_disk_id: The ID of DiskVolume.
        :param _builtins.str disk_volume_fs_type: The system type of DiskVolume.
        :param _builtins.str flex_volume_driver: The name of the FlexVolume driver.
        :param _builtins.str flex_volume_fs_type: The type of the mounted file system. The default value is determined by the script of FlexVolume.
        :param _builtins.str flex_volume_options: The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
        :param _builtins.str name: The name of the volume.
        :param _builtins.str nfs_volume_path: The path to the NFS volume.
        :param _builtins.bool nfs_volume_read_only: The nfs volume read only. Default value: `false`.
        :param _builtins.str nfs_volume_server: The address of the NFS server.
        :param _builtins.str type: The type of the volume.
        """
        if config_file_volume_config_file_to_paths is not None:
            pulumi.set(__self__, "config_file_volume_config_file_to_paths", config_file_volume_config_file_to_paths)
        if disk_volume_disk_id is not None:
            pulumi.set(__self__, "disk_volume_disk_id", disk_volume_disk_id)
        if disk_volume_fs_type is not None:
            pulumi.set(__self__, "disk_volume_fs_type", disk_volume_fs_type)
        if flex_volume_driver is not None:
            pulumi.set(__self__, "flex_volume_driver", flex_volume_driver)
        if flex_volume_fs_type is not None:
            pulumi.set(__self__, "flex_volume_fs_type", flex_volume_fs_type)
        if flex_volume_options is not None:
            pulumi.set(__self__, "flex_volume_options", flex_volume_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_volume_path is not None:
            pulumi.set(__self__, "nfs_volume_path", nfs_volume_path)
        if nfs_volume_read_only is not None:
            pulumi.set(__self__, "nfs_volume_read_only", nfs_volume_read_only)
        if nfs_volume_server is not None:
            pulumi.set(__self__, "nfs_volume_server", nfs_volume_server)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configFileVolumeConfigFileToPaths")
    def config_file_volume_config_file_to_paths(self) -> Optional[Sequence['outputs.ContainerGroupVolumeConfigFileVolumeConfigFileToPath']]:
        """
        The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
        > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
        """
        return pulumi.get(self, "config_file_volume_config_file_to_paths")

    @_builtins.property
    @pulumi.getter(name="diskVolumeDiskId")
    def disk_volume_disk_id(self) -> Optional[_builtins.str]:
        """
        The ID of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_id")

    @_builtins.property
    @pulumi.getter(name="diskVolumeFsType")
    def disk_volume_fs_type(self) -> Optional[_builtins.str]:
        """
        The system type of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_fs_type")

    @_builtins.property
    @pulumi.getter(name="flexVolumeDriver")
    def flex_volume_driver(self) -> Optional[_builtins.str]:
        """
        The name of the FlexVolume driver.
        """
        return pulumi.get(self, "flex_volume_driver")

    @_builtins.property
    @pulumi.getter(name="flexVolumeFsType")
    def flex_volume_fs_type(self) -> Optional[_builtins.str]:
        """
        The type of the mounted file system. The default value is determined by the script of FlexVolume.
        """
        return pulumi.get(self, "flex_volume_fs_type")

    @_builtins.property
    @pulumi.getter(name="flexVolumeOptions")
    def flex_volume_options(self) -> Optional[_builtins.str]:
        """
        The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
        """
        return pulumi.get(self, "flex_volume_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsVolumePath")
    def nfs_volume_path(self) -> Optional[_builtins.str]:
        """
        The path to the NFS volume.
        """
        return pulumi.get(self, "nfs_volume_path")

    @_builtins.property
    @pulumi.getter(name="nfsVolumeReadOnly")
    def nfs_volume_read_only(self) -> Optional[_builtins.bool]:
        """
        The nfs volume read only. Default value: `false`.
        """
        return pulumi.get(self, "nfs_volume_read_only")

    @_builtins.property
    @pulumi.getter(name="nfsVolumeServer")
    def nfs_volume_server(self) -> Optional[_builtins.str]:
        """
        The address of the NFS server.
        """
        return pulumi.get(self, "nfs_volume_server")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the volume.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ContainerGroupVolumeConfigFileVolumeConfigFileToPath(dict):
    def __init__(__self__, *,
                 content: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: The content of the configuration file. Maximum size: 32 KB.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        The content of the configuration file. Maximum size: 32 KB.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "path")


@pulumi.output_type
class ImageCacheImageRegistryCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageCacheImageRegistryCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageCacheImageRegistryCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageCacheImageRegistryCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[_builtins.str] = None,
                 server: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The password of the Image Registry.
        :param _builtins.str server: The address of Image Registry without `http://` or `https://`.
        :param _builtins.str user_name: The user name of Image Registry.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password of the Image Registry.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[_builtins.str]:
        """
        The address of Image Registry without `http://` or `https://`.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        The user name of Image Registry.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class OpenApiImageCacheImageRegistryCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenApiImageCacheImageRegistryCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenApiImageCacheImageRegistryCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenApiImageCacheImageRegistryCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[_builtins.str] = None,
                 server: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None):
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class VirtualNodeTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
        :param _builtins.str key: The key of the taint.
        :param _builtins.str value: The value of the taint.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> Optional[_builtins.str]:
        """
        The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the taint.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetContainerGroupsGroupResult(dict):
    def __init__(__self__, *,
                 container_group_id: _builtins.str,
                 container_group_name: _builtins.str,
                 containers: Sequence['outputs.GetContainerGroupsGroupContainerResult'],
                 cpu: _builtins.float,
                 discount: _builtins.int,
                 dns_configs: Sequence['outputs.GetContainerGroupsGroupDnsConfigResult'],
                 eci_security_contexts: Sequence['outputs.GetContainerGroupsGroupEciSecurityContextResult'],
                 eni_instance_id: _builtins.str,
                 events: Sequence['outputs.GetContainerGroupsGroupEventResult'],
                 expired_time: _builtins.str,
                 failed_time: _builtins.str,
                 host_aliases: Sequence['outputs.GetContainerGroupsGroupHostAliasResult'],
                 id: _builtins.str,
                 init_containers: Sequence['outputs.GetContainerGroupsGroupInitContainerResult'],
                 instance_type: _builtins.str,
                 internet_ip: _builtins.str,
                 intranet_ip: _builtins.str,
                 ipv6_address: _builtins.str,
                 memory: _builtins.float,
                 ram_role_name: _builtins.str,
                 resource_group_id: _builtins.str,
                 restart_policy: _builtins.str,
                 security_group_id: _builtins.str,
                 status: _builtins.str,
                 succeeded_time: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 volumes: Sequence['outputs.GetContainerGroupsGroupVolumeResult'],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str container_group_id: The id if ContainerGroup.
        :param _builtins.str container_group_name: The name of ContainerGroup.
        :param Sequence['GetContainerGroupsGroupContainerArgs'] containers: A list of containers. Each element contains the following attributes:
        :param _builtins.float cpu: The amount of CPU resources allocated to the container group.
        :param Sequence['GetContainerGroupsGroupDnsConfigArgs'] dns_configs: The DNS settings.
        :param Sequence['GetContainerGroupsGroupEciSecurityContextArgs'] eci_security_contexts: The security context of the container group.
        :param _builtins.str eni_instance_id: The ID of the ENI instance.
        :param Sequence['GetContainerGroupsGroupEventArgs'] events: The events of the container group. Maximum: `50`.
        :param _builtins.str expired_time: The time when the container group failed to run due to overdue payments. The timestamp follows the UTC and RFC3339 formats.
        :param _builtins.str failed_time: The time when the container failed to run tasks. The timestamp follows the UTC and RFC3339 formats.
        :param Sequence['GetContainerGroupsGroupHostAliasArgs'] host_aliases: The mapping between host names and IP addresses for a container in the container group.
        :param _builtins.str id: The ID of the Container Group.
        :param Sequence['GetContainerGroupsGroupInitContainerArgs'] init_containers: A list of init containers. Each element contains the following attributes:
        :param _builtins.str instance_type: The type of the ECS instance.
        :param _builtins.str internet_ip: The public IP address of the container group.
        :param _builtins.str intranet_ip: The internal IP address of the container group.
        :param _builtins.str ipv6_address: The IPv6 address.
        :param _builtins.float memory: The amount of memory resources allocated to the container group.
        :param _builtins.str ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param _builtins.str resource_group_id: The ID of the resource group to which the container group belongs. If you have not specified a resource group for the container group, it is added to the default resource group.
        :param _builtins.str restart_policy: The restart policy of the container group.
        :param _builtins.str security_group_id: The ID of the security group.
        :param _builtins.str status: The status of container.
        :param _builtins.str succeeded_time: The time when all containers in the container group completed running the specified tasks. The timestamp follows the UTC and RFC 3339 formats. For example, 2018-08-02T15:00:00Z.
        :param Mapping[str, _builtins.str] tags: The tags attached to the container group. Each tag is a key-value pair. You can attach up to 20 tags to a container group.
        :param Sequence['GetContainerGroupsGroupVolumeArgs'] volumes: The information about the mounted volume. You can mount up to 20 volumes.
        :param _builtins.str vpc_id: The if of vpc.
        :param _builtins.str vswitch_id: The vswitch id.
        :param _builtins.str zone_id: The IDs of the zones where the container groups are deployed. If this parameter is not set, the system automatically selects the zones. By default, no value is specified.
        """
        pulumi.set(__self__, "container_group_id", container_group_id)
        pulumi.set(__self__, "container_group_name", container_group_name)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "discount", discount)
        pulumi.set(__self__, "dns_configs", dns_configs)
        pulumi.set(__self__, "eci_security_contexts", eci_security_contexts)
        pulumi.set(__self__, "eni_instance_id", eni_instance_id)
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "failed_time", failed_time)
        pulumi.set(__self__, "host_aliases", host_aliases)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "init_containers", init_containers)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "intranet_ip", intranet_ip)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "restart_policy", restart_policy)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "succeeded_time", succeeded_time)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="containerGroupId")
    def container_group_id(self) -> _builtins.str:
        """
        The id if ContainerGroup.
        """
        return pulumi.get(self, "container_group_id")

    @_builtins.property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> _builtins.str:
        """
        The name of ContainerGroup.
        """
        return pulumi.get(self, "container_group_name")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetContainerGroupsGroupContainerResult']:
        """
        A list of containers. Each element contains the following attributes:
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def discount(self) -> _builtins.int:
        return pulumi.get(self, "discount")

    @_builtins.property
    @pulumi.getter(name="dnsConfigs")
    def dns_configs(self) -> Sequence['outputs.GetContainerGroupsGroupDnsConfigResult']:
        """
        The DNS settings.
        """
        return pulumi.get(self, "dns_configs")

    @_builtins.property
    @pulumi.getter(name="eciSecurityContexts")
    def eci_security_contexts(self) -> Sequence['outputs.GetContainerGroupsGroupEciSecurityContextResult']:
        """
        The security context of the container group.
        """
        return pulumi.get(self, "eci_security_contexts")

    @_builtins.property
    @pulumi.getter(name="eniInstanceId")
    def eni_instance_id(self) -> _builtins.str:
        """
        The ID of the ENI instance.
        """
        return pulumi.get(self, "eni_instance_id")

    @_builtins.property
    @pulumi.getter
    def events(self) -> Sequence['outputs.GetContainerGroupsGroupEventResult']:
        """
        The events of the container group. Maximum: `50`.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The time when the container group failed to run due to overdue payments. The timestamp follows the UTC and RFC3339 formats.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="failedTime")
    def failed_time(self) -> _builtins.str:
        """
        The time when the container failed to run tasks. The timestamp follows the UTC and RFC3339 formats.
        """
        return pulumi.get(self, "failed_time")

    @_builtins.property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Sequence['outputs.GetContainerGroupsGroupHostAliasResult']:
        """
        The mapping between host names and IP addresses for a container in the container group.
        """
        return pulumi.get(self, "host_aliases")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Container Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Sequence['outputs.GetContainerGroupsGroupInitContainerResult']:
        """
        A list of init containers. Each element contains the following attributes:
        """
        return pulumi.get(self, "init_containers")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The type of the ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The public IP address of the container group.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> _builtins.str:
        """
        The internal IP address of the container group.
        """
        return pulumi.get(self, "intranet_ip")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        """
        The IPv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.float:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> _builtins.str:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group to which the container group belongs. If you have not specified a resource group for the container group, it is added to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> _builtins.str:
        """
        The restart policy of the container group.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of container.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="succeededTime")
    def succeeded_time(self) -> _builtins.str:
        """
        The time when all containers in the container group completed running the specified tasks. The timestamp follows the UTC and RFC 3339 formats. For example, 2018-08-02T15:00:00Z.
        """
        return pulumi.get(self, "succeeded_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags attached to the container group. Each tag is a key-value pair. You can attach up to 20 tags to a container group.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetContainerGroupsGroupVolumeResult']:
        """
        The information about the mounted volume. You can mount up to 20 volumes.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The if of vpc.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The IDs of the zones where the container groups are deployed. If this parameter is not set, the system automatically selects the zones. By default, no value is specified.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetContainerGroupsGroupContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 cpu: _builtins.float,
                 environment_vars: Sequence['outputs.GetContainerGroupsGroupContainerEnvironmentVarResult'],
                 gpu: _builtins.int,
                 image: _builtins.str,
                 image_pull_policy: _builtins.str,
                 memory: _builtins.float,
                 name: _builtins.str,
                 ports: Sequence['outputs.GetContainerGroupsGroupContainerPortResult'],
                 ready: _builtins.bool,
                 restart_count: _builtins.int,
                 volume_mounts: Sequence['outputs.GetContainerGroupsGroupContainerVolumeMountResult'],
                 working_dir: _builtins.str):
        """
        :param Sequence[_builtins.str] args: The arguments passed to the commands. Maximum: `10`.
        :param Sequence[_builtins.str] commands: The commands run by the container. You can define a maximum of 20 commands. Minimum length per string: 256 characters.
        :param _builtins.float cpu: The amount of CPU resources allocated to the container.
        :param Sequence['GetContainerGroupsGroupContainerEnvironmentVarArgs'] environment_vars: The environment variables.
        :param _builtins.int gpu: The amount of GPU resources allocated to the container.
        :param _builtins.str image: The image of the container.
        :param _builtins.str image_pull_policy: The policy for pulling an image.
        :param _builtins.float memory: The amount of memory resources allocated to the container.
        :param _builtins.str name: The name of the container.
        :param Sequence['GetContainerGroupsGroupContainerPortArgs'] ports: The list of exposed ports and protocols. Maximum: 100.
        :param _builtins.bool ready: Indicates whether the container is ready.
        :param _builtins.int restart_count: The number of times that the container has restarted.
        :param Sequence['GetContainerGroupsGroupContainerVolumeMountArgs'] volume_mounts: The list of volumes mounted to the container.
        :param _builtins.str working_dir: The working directory of the container.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "environment_vars", environment_vars)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "ready", ready)
        pulumi.set(__self__, "restart_count", restart_count)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        The arguments passed to the commands. Maximum: `10`.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        The commands run by the container. You can define a maximum of 20 commands. Minimum length per string: 256 characters.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Sequence['outputs.GetContainerGroupsGroupContainerEnvironmentVarResult']:
        """
        The environment variables.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> _builtins.int:
        """
        The amount of GPU resources allocated to the container.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> _builtins.str:
        """
        The policy for pulling an image.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.float:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetContainerGroupsGroupContainerPortResult']:
        """
        The list of exposed ports and protocols. Maximum: 100.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> _builtins.bool:
        """
        Indicates whether the container is ready.
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> _builtins.int:
        """
        The number of times that the container has restarted.
        """
        return pulumi.get(self, "restart_count")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetContainerGroupsGroupContainerVolumeMountResult']:
        """
        The list of volumes mounted to the container.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> _builtins.str:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetContainerGroupsGroupContainerEnvironmentVarResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The name of the variable.
        :param _builtins.str value: The value of the variable.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetContainerGroupsGroupContainerPortResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str):
        """
        :param _builtins.int port: The port number. Valid values: 1 to 65535.
        :param _builtins.str protocol: Valid values: `TCP` and `UDP`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Valid values: `TCP` and `UDP`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetContainerGroupsGroupContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str,
                 read_only: _builtins.bool):
        """
        :param _builtins.str mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        :param _builtins.str name: The name of the volume. The name is the same as the volume you selected when you purchased the container.
        :param _builtins.bool read_only: Default value: `false`.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume. The name is the same as the volume you selected when you purchased the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        Default value: `false`.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetContainerGroupsGroupDnsConfigResult(dict):
    def __init__(__self__, *,
                 name_servers: Sequence[_builtins.str],
                 options: Sequence['outputs.GetContainerGroupsGroupDnsConfigOptionResult'],
                 searches: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] name_servers: The list of DNS server IP addresses.
        :param Sequence['GetContainerGroupsGroupDnsConfigOptionArgs'] options: The list of objects. Each object is a name-value pair. The value is optional.
        :param Sequence[_builtins.str] searches: The list of DNS lookup domains.
        """
        pulumi.set(__self__, "name_servers", name_servers)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "searches", searches)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence[_builtins.str]:
        """
        The list of DNS server IP addresses.
        """
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetContainerGroupsGroupDnsConfigOptionResult']:
        """
        The list of objects. Each object is a name-value pair. The value is optional.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def searches(self) -> Sequence[_builtins.str]:
        """
        The list of DNS lookup domains.
        """
        return pulumi.get(self, "searches")


@pulumi.output_type
class GetContainerGroupsGroupDnsConfigOptionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the object variable.
        :param _builtins.str value: The value of the object variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the object variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetContainerGroupsGroupEciSecurityContextResult(dict):
    def __init__(__self__, *,
                 sysctls: Sequence['outputs.GetContainerGroupsGroupEciSecurityContextSysctlResult']):
        """
        :param Sequence['GetContainerGroupsGroupEciSecurityContextSysctlArgs'] sysctls: The system information.
        """
        pulumi.set(__self__, "sysctls", sysctls)

    @_builtins.property
    @pulumi.getter
    def sysctls(self) -> Sequence['outputs.GetContainerGroupsGroupEciSecurityContextSysctlResult']:
        """
        The system information.
        """
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class GetContainerGroupsGroupEciSecurityContextSysctlResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the variable.
        :param _builtins.str value: The value of the variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetContainerGroupsGroupEventResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 first_timestamp: _builtins.str,
                 last_timestamp: _builtins.str,
                 message: _builtins.str,
                 name: _builtins.str,
                 reason: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int count: The number of events.
        :param _builtins.str first_timestamp: The time when the event started.
        :param _builtins.str last_timestamp: The time when the event ended.
        :param _builtins.str message: The content of the event.
        :param _builtins.str name: The name of the object to which the event belongs.
        :param _builtins.str reason: The name of the event.
        :param _builtins.str type: The type of the event. Valid values: Normal and Warning.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "first_timestamp", first_timestamp)
        pulumi.set(__self__, "last_timestamp", last_timestamp)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of events.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> _builtins.str:
        """
        The time when the event started.
        """
        return pulumi.get(self, "first_timestamp")

    @_builtins.property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> _builtins.str:
        """
        The time when the event ended.
        """
        return pulumi.get(self, "last_timestamp")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        The content of the event.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object to which the event belongs.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        The name of the event.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the event. Valid values: Normal and Warning.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetContainerGroupsGroupHostAliasResult(dict):
    def __init__(__self__, *,
                 hostnames: Sequence[_builtins.str],
                 ip: _builtins.str):
        """
        :param Sequence[_builtins.str] hostnames: The name of the host.
        :param _builtins.str ip: The IP address of the container.
        """
        pulumi.set(__self__, "hostnames", hostnames)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Sequence[_builtins.str]:
        """
        The name of the host.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP address of the container.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetContainerGroupsGroupInitContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 cpu: _builtins.float,
                 environment_vars: Sequence['outputs.GetContainerGroupsGroupInitContainerEnvironmentVarResult'],
                 gpu: _builtins.int,
                 image: _builtins.str,
                 image_pull_policy: _builtins.str,
                 memory: _builtins.float,
                 name: _builtins.str,
                 ports: Sequence['outputs.GetContainerGroupsGroupInitContainerPortResult'],
                 ready: _builtins.bool,
                 restart_count: _builtins.int,
                 volume_mounts: Sequence['outputs.GetContainerGroupsGroupInitContainerVolumeMountResult'],
                 working_dir: _builtins.str):
        """
        :param Sequence[_builtins.str] args: The arguments passed to the commands.
        :param Sequence[_builtins.str] commands: The commands run by the container.
        :param _builtins.float cpu: The amount of CPU resources allocated to the container.
        :param Sequence['GetContainerGroupsGroupInitContainerEnvironmentVarArgs'] environment_vars: The environment variables.
        :param _builtins.int gpu: The amount of GPU resources allocated to the container.
        :param _builtins.str image: The image of the container.
        :param _builtins.str image_pull_policy: The policy for pulling an image.
        :param _builtins.float memory: The amount of memory resources allocated to the container.
        :param _builtins.str name: The name of the init container.
        :param Sequence['GetContainerGroupsGroupInitContainerPortArgs'] ports: The exposed ports and protocols. Maximum: `100`.
        :param _builtins.bool ready: Indicates whether the container is ready.
        :param _builtins.int restart_count: The number of times that the container has restarted.
        :param Sequence['GetContainerGroupsGroupInitContainerVolumeMountArgs'] volume_mounts: The list of volumes mounted to the container.
        :param _builtins.str working_dir: The working directory of the container.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "environment_vars", environment_vars)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "ready", ready)
        pulumi.set(__self__, "restart_count", restart_count)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        The commands run by the container.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Sequence['outputs.GetContainerGroupsGroupInitContainerEnvironmentVarResult']:
        """
        The environment variables.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> _builtins.int:
        """
        The amount of GPU resources allocated to the container.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> _builtins.str:
        """
        The policy for pulling an image.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.float:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the init container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetContainerGroupsGroupInitContainerPortResult']:
        """
        The exposed ports and protocols. Maximum: `100`.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> _builtins.bool:
        """
        Indicates whether the container is ready.
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> _builtins.int:
        """
        The number of times that the container has restarted.
        """
        return pulumi.get(self, "restart_count")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetContainerGroupsGroupInitContainerVolumeMountResult']:
        """
        The list of volumes mounted to the container.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> _builtins.str:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetContainerGroupsGroupInitContainerEnvironmentVarResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The name of the variable.
        :param _builtins.str value: The value of the variable.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetContainerGroupsGroupInitContainerPortResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str):
        """
        :param _builtins.int port: The port number. Valid values: 1 to 65535.
        :param _builtins.str protocol: Valid values: `TCP` and `UDP`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Valid values: `TCP` and `UDP`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetContainerGroupsGroupInitContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str,
                 read_only: _builtins.bool):
        """
        :param _builtins.str mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        :param _builtins.str name: The name of the volume. The name is the same as the volume you selected when you purchased the container.
        :param _builtins.bool read_only: Default value: `false`.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume. The name is the same as the volume you selected when you purchased the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        Default value: `false`.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetContainerGroupsGroupVolumeResult(dict):
    def __init__(__self__, *,
                 config_file_volume_config_file_to_paths: Sequence['outputs.GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPathResult'],
                 disk_volume_disk_id: _builtins.str,
                 disk_volume_fs_type: _builtins.str,
                 flex_volume_driver: _builtins.str,
                 flex_volume_fs_type: _builtins.str,
                 flex_volume_options: _builtins.str,
                 name: _builtins.str,
                 nfs_volume_path: _builtins.str,
                 nfs_volume_read_only: _builtins.bool,
                 nfs_volume_server: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence['GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPathArgs'] config_file_volume_config_file_to_paths: The list of configuration file paths.
        :param _builtins.str disk_volume_disk_id: The ID of DiskVolume.
        :param _builtins.str disk_volume_fs_type: The type of DiskVolume.
        :param _builtins.str flex_volume_driver: The name of the FlexVolume driver.
        :param _builtins.str flex_volume_fs_type: The type of the mounted file system. The default value is determined by the script of FlexVolume.
        :param _builtins.str flex_volume_options: The list of FlexVolume objects.
        :param _builtins.str name: The name of the volume.
        :param _builtins.str nfs_volume_path: The path to the NFS volume.
        :param _builtins.bool nfs_volume_read_only: Default value: `false`.
        :param _builtins.str nfs_volume_server: The address of the NFS server.
        :param _builtins.str type: The type of the volume. Currently, the following types of volumes are supported: EmptyDirVolume, NFSVolume, ConfigFileVolume, and FlexVolume.
        """
        pulumi.set(__self__, "config_file_volume_config_file_to_paths", config_file_volume_config_file_to_paths)
        pulumi.set(__self__, "disk_volume_disk_id", disk_volume_disk_id)
        pulumi.set(__self__, "disk_volume_fs_type", disk_volume_fs_type)
        pulumi.set(__self__, "flex_volume_driver", flex_volume_driver)
        pulumi.set(__self__, "flex_volume_fs_type", flex_volume_fs_type)
        pulumi.set(__self__, "flex_volume_options", flex_volume_options)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs_volume_path", nfs_volume_path)
        pulumi.set(__self__, "nfs_volume_read_only", nfs_volume_read_only)
        pulumi.set(__self__, "nfs_volume_server", nfs_volume_server)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configFileVolumeConfigFileToPaths")
    def config_file_volume_config_file_to_paths(self) -> Sequence['outputs.GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPathResult']:
        """
        The list of configuration file paths.
        """
        return pulumi.get(self, "config_file_volume_config_file_to_paths")

    @_builtins.property
    @pulumi.getter(name="diskVolumeDiskId")
    def disk_volume_disk_id(self) -> _builtins.str:
        """
        The ID of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_id")

    @_builtins.property
    @pulumi.getter(name="diskVolumeFsType")
    def disk_volume_fs_type(self) -> _builtins.str:
        """
        The type of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_fs_type")

    @_builtins.property
    @pulumi.getter(name="flexVolumeDriver")
    def flex_volume_driver(self) -> _builtins.str:
        """
        The name of the FlexVolume driver.
        """
        return pulumi.get(self, "flex_volume_driver")

    @_builtins.property
    @pulumi.getter(name="flexVolumeFsType")
    def flex_volume_fs_type(self) -> _builtins.str:
        """
        The type of the mounted file system. The default value is determined by the script of FlexVolume.
        """
        return pulumi.get(self, "flex_volume_fs_type")

    @_builtins.property
    @pulumi.getter(name="flexVolumeOptions")
    def flex_volume_options(self) -> _builtins.str:
        """
        The list of FlexVolume objects.
        """
        return pulumi.get(self, "flex_volume_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsVolumePath")
    def nfs_volume_path(self) -> _builtins.str:
        """
        The path to the NFS volume.
        """
        return pulumi.get(self, "nfs_volume_path")

    @_builtins.property
    @pulumi.getter(name="nfsVolumeReadOnly")
    def nfs_volume_read_only(self) -> _builtins.bool:
        """
        Default value: `false`.
        """
        return pulumi.get(self, "nfs_volume_read_only")

    @_builtins.property
    @pulumi.getter(name="nfsVolumeServer")
    def nfs_volume_server(self) -> _builtins.str:
        """
        The address of the NFS server.
        """
        return pulumi.get(self, "nfs_volume_server")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the volume. Currently, the following types of volumes are supported: EmptyDirVolume, NFSVolume, ConfigFileVolume, and FlexVolume.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetContainerGroupsGroupVolumeConfigFileVolumeConfigFileToPathResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str content: The content of the configuration file. Maximum size: 32 KB.
        :param _builtins.str path: The relative file path.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The content of the configuration file. Maximum size: 32 KB.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative file path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetImageCachesCachResult(dict):
    def __init__(__self__, *,
                 container_group_id: _builtins.str,
                 events: Sequence['outputs.GetImageCachesCachEventResult'],
                 expire_date_time: _builtins.str,
                 id: _builtins.str,
                 image_cache_id: _builtins.str,
                 image_cache_name: _builtins.str,
                 images: Sequence[_builtins.str],
                 progress: _builtins.str,
                 snapshot_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str container_group_id: The id of container group.
        :param Sequence['GetImageCachesCachEventArgs'] events: Image cache pulls image event information.
        :param _builtins.str expire_date_time: The time of expired.
        :param _builtins.str id: The ID of the ECI Image Cache.
        :param _builtins.str image_cache_id: The id of the ECI Image Cache.
        :param _builtins.str image_cache_name: The name of ECI Image Cache.
        :param Sequence[_builtins.str] images: The list of cached images.
        :param _builtins.str progress: The progress of ECI Image Cache.
        :param _builtins.str snapshot_id: The id of snapshot.
        :param _builtins.str status: The status of ECI Image Cache.
        """
        pulumi.set(__self__, "container_group_id", container_group_id)
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "expire_date_time", expire_date_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_cache_id", image_cache_id)
        pulumi.set(__self__, "image_cache_name", image_cache_name)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="containerGroupId")
    def container_group_id(self) -> _builtins.str:
        """
        The id of container group.
        """
        return pulumi.get(self, "container_group_id")

    @_builtins.property
    @pulumi.getter
    def events(self) -> Sequence['outputs.GetImageCachesCachEventResult']:
        """
        Image cache pulls image event information.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter(name="expireDateTime")
    def expire_date_time(self) -> _builtins.str:
        """
        The time of expired.
        """
        return pulumi.get(self, "expire_date_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the ECI Image Cache.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageCacheId")
    def image_cache_id(self) -> _builtins.str:
        """
        The id of the ECI Image Cache.
        """
        return pulumi.get(self, "image_cache_id")

    @_builtins.property
    @pulumi.getter(name="imageCacheName")
    def image_cache_name(self) -> _builtins.str:
        """
        The name of ECI Image Cache.
        """
        return pulumi.get(self, "image_cache_name")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Sequence[_builtins.str]:
        """
        The list of cached images.
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> _builtins.str:
        """
        The progress of ECI Image Cache.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        The id of snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of ECI Image Cache.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetImageCachesCachEventResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 first_timestamp: _builtins.str,
                 last_timestamp: _builtins.str,
                 message: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int count: Number of events.
        :param _builtins.str first_timestamp: Start time.
        :param _builtins.str last_timestamp: End time.
        :param _builtins.str name: The name of event.
        :param _builtins.str type: The type of event.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "first_timestamp", first_timestamp)
        pulumi.set(__self__, "last_timestamp", last_timestamp)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Number of events.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> _builtins.str:
        """
        Start time.
        """
        return pulumi.get(self, "first_timestamp")

    @_builtins.property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> _builtins.str:
        """
        End time.
        """
        return pulumi.get(self, "last_timestamp")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of event.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of event.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVirtualNodesNodeResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 create_time: _builtins.str,
                 eni_instance_id: _builtins.str,
                 events: Sequence['outputs.GetVirtualNodesNodeEventResult'],
                 id: _builtins.str,
                 internet_ip: _builtins.str,
                 intranet_ip: _builtins.str,
                 memory: _builtins.int,
                 ram_role_name: _builtins.str,
                 resource_group_id: _builtins.str,
                 security_group_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 virtual_node_id: _builtins.str,
                 virtual_node_name: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.int cpu: The Number of CPU.
        :param _builtins.str create_time: The creation time of the virtual node.
        :param _builtins.str eni_instance_id: The ENI instance ID.
        :param Sequence['GetVirtualNodesNodeEventArgs'] events: The event list.
        :param _builtins.str id: The ID of the Virtual Node.
        :param _builtins.str internet_ip: The IP address of a public network.
        :param _builtins.str intranet_ip: The private IP address of the RDS instance.
        :param _builtins.int memory: The memory size.
        :param _builtins.str ram_role_name: The ram role.
        :param _builtins.str resource_group_id: The resource group ID.
        :param _builtins.str security_group_id: The security group ID.
        :param _builtins.str status: The Status of the virtual node.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str virtual_node_id: Of the virtual node number.
        :param _builtins.str virtual_node_name: The name of the virtual node.
        :param _builtins.str vswitch_id: The vswitch id.
        :param _builtins.str zone_id: The Zone.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "eni_instance_id", eni_instance_id)
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "intranet_ip", intranet_ip)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "virtual_node_id", virtual_node_id)
        pulumi.set(__self__, "virtual_node_name", virtual_node_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        """
        The Number of CPU.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the virtual node.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="eniInstanceId")
    def eni_instance_id(self) -> _builtins.str:
        """
        The ENI instance ID.
        """
        return pulumi.get(self, "eni_instance_id")

    @_builtins.property
    @pulumi.getter
    def events(self) -> Sequence['outputs.GetVirtualNodesNodeEventResult']:
        """
        The event list.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Virtual Node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> _builtins.str:
        """
        The IP address of a public network.
        """
        return pulumi.get(self, "internet_ip")

    @_builtins.property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> _builtins.str:
        """
        The private IP address of the RDS instance.
        """
        return pulumi.get(self, "intranet_ip")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        The memory size.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> _builtins.str:
        """
        The ram role.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of the virtual node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNodeId")
    def virtual_node_id(self) -> _builtins.str:
        """
        Of the virtual node number.
        """
        return pulumi.get(self, "virtual_node_id")

    @_builtins.property
    @pulumi.getter(name="virtualNodeName")
    def virtual_node_name(self) -> _builtins.str:
        """
        The name of the virtual node.
        """
        return pulumi.get(self, "virtual_node_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The Zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetVirtualNodesNodeEventResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 first_timestamp: _builtins.str,
                 last_timestamp: _builtins.str,
                 message: _builtins.str,
                 name: _builtins.str,
                 reason: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int count: The number of occurrences.
        :param _builtins.str first_timestamp: The first presentation time stamp.
        :param _builtins.str last_timestamp: The most recent time stamp.
        :param _builtins.str message: The event of the message body.
        :param _builtins.str name: The name of the event.
        :param _builtins.str reason: The causes of the incident.
        :param _builtins.str type: The Event type.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "first_timestamp", first_timestamp)
        pulumi.set(__self__, "last_timestamp", last_timestamp)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of occurrences.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> _builtins.str:
        """
        The first presentation time stamp.
        """
        return pulumi.get(self, "first_timestamp")

    @_builtins.property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> _builtins.str:
        """
        The most recent time stamp.
        """
        return pulumi.get(self, "last_timestamp")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        The event of the message body.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the event.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        The causes of the incident.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Event type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 region_endpoint: _builtins.str,
                 zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str region_endpoint: The endpoint of the region.
        :param Sequence[_builtins.str] zone_ids: The list of available zone ids.
        """
        pulumi.set(__self__, "region_endpoint", region_endpoint)
        pulumi.set(__self__, "zone_ids", zone_ids)

    @_builtins.property
    @pulumi.getter(name="regionEndpoint")
    def region_endpoint(self) -> _builtins.str:
        """
        The endpoint of the region.
        """
        return pulumi.get(self, "region_endpoint")

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence[_builtins.str]:
        """
        The list of available zone ids.
        """
        return pulumi.get(self, "zone_ids")


