# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotPolicyArgs', 'SnapshotPolicy']

@pulumi.input_type
class SnapshotPolicyArgs:
    def __init__(__self__, *,
                 repeat_weekdays: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 retention_days: pulumi.Input[_builtins.int],
                 time_points: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input['SnapshotPolicyCopyEncryptionConfigurationArgs']] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SnapshotPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[_builtins.int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               
               Default value: -1.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        :param pulumi.Input[_builtins.str] name: The snapshot policy name.
        """
        pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "time_points", time_points)
        if auto_snapshot_policy_name is not None:
            pulumi.set(__self__, "auto_snapshot_policy_name", auto_snapshot_policy_name)
        if copied_snapshots_retention_days is not None:
            pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        if copy_encryption_configuration is not None:
            pulumi.set(__self__, "copy_encryption_configuration", copy_encryption_configuration)
        if enable_cross_region_copy is not None:
            pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_copy_regions is not None:
            pulumi.set(__self__, "target_copy_regions", target_copy_regions)

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
        - A maximum of seven time points can be selected.
        - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        """
        return pulumi.get(self, "repeat_weekdays")

    @repeat_weekdays.setter
    def repeat_weekdays(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "repeat_weekdays", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Input[_builtins.int]:
        """
        The snapshot retention time, and the unit of measurement is day. Optional values:
        - -1: The automatic snapshots are retained permanently.
        - [1, 65536]: The number of days retained.

        Default value: -1.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
        - A maximum of 24 time points can be selected.
        - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        return pulumi.get(self, "time_points")

    @time_points.setter
    def time_points(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "time_points", value)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_snapshot_policy_name")

    @auto_snapshot_policy_name.setter
    def auto_snapshot_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_snapshot_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "copied_snapshots_retention_days")

    @copied_snapshots_retention_days.setter
    def copied_snapshots_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "copied_snapshots_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="copyEncryptionConfiguration")
    def copy_encryption_configuration(self) -> Optional[pulumi.Input['SnapshotPolicyCopyEncryptionConfigurationArgs']]:
        return pulumi.get(self, "copy_encryption_configuration")

    @copy_encryption_configuration.setter
    def copy_encryption_configuration(self, value: Optional[pulumi.Input['SnapshotPolicyCopyEncryptionConfigurationArgs']]):
        pulumi.set(self, "copy_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_cross_region_copy")

    @enable_cross_region_copy.setter
    def enable_cross_region_copy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cross_region_copy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "target_copy_regions")

    @target_copy_regions.setter
    def target_copy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_copy_regions", value)


@pulumi.input_type
class _SnapshotPolicyState:
    def __init__(__self__, *,
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input['SnapshotPolicyCopyEncryptionConfigurationArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SnapshotPolicy resources.
        :param pulumi.Input[_builtins.str] name: The snapshot policy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[_builtins.int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               
               Default value: -1.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        if auto_snapshot_policy_name is not None:
            pulumi.set(__self__, "auto_snapshot_policy_name", auto_snapshot_policy_name)
        if copied_snapshots_retention_days is not None:
            pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        if copy_encryption_configuration is not None:
            pulumi.set(__self__, "copy_encryption_configuration", copy_encryption_configuration)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if enable_cross_region_copy is not None:
            pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if repeat_weekdays is not None:
            pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_copy_regions is not None:
            pulumi.set(__self__, "target_copy_regions", target_copy_regions)
        if time_points is not None:
            pulumi.set(__self__, "time_points", time_points)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_snapshot_policy_name")

    @auto_snapshot_policy_name.setter
    def auto_snapshot_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_snapshot_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "copied_snapshots_retention_days")

    @copied_snapshots_retention_days.setter
    def copied_snapshots_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "copied_snapshots_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="copyEncryptionConfiguration")
    def copy_encryption_configuration(self) -> Optional[pulumi.Input['SnapshotPolicyCopyEncryptionConfigurationArgs']]:
        return pulumi.get(self, "copy_encryption_configuration")

    @copy_encryption_configuration.setter
    def copy_encryption_configuration(self, value: Optional[pulumi.Input['SnapshotPolicyCopyEncryptionConfigurationArgs']]):
        pulumi.set(self, "copy_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_cross_region_copy")

    @enable_cross_region_copy.setter
    def enable_cross_region_copy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cross_region_copy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
        - A maximum of seven time points can be selected.
        - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        """
        return pulumi.get(self, "repeat_weekdays")

    @repeat_weekdays.setter
    def repeat_weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "repeat_weekdays", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The snapshot retention time, and the unit of measurement is day. Optional values:
        - -1: The automatic snapshots are retained permanently.
        - [1, 65536]: The number of days retained.

        Default value: -1.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "target_copy_regions")

    @target_copy_regions.setter
    def target_copy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_copy_regions", value)

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
        - A maximum of 24 time points can be selected.
        - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        return pulumi.get(self, "time_points")

    @time_points.setter
    def time_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "time_points", value)


@pulumi.type_token("alicloud:ecs/snapshotPolicy:SnapshotPolicy")
class SnapshotPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input[Union['SnapshotPolicyCopyEncryptionConfigurationArgs', 'SnapshotPolicyCopyEncryptionConfigurationArgsDict']]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        > **DEPRECATED:** This resource has been renamed to ecs.AutoSnapshotPolicy from version 1.117.0.

        Provides an ECS snapshot policy resource.

        For information about snapshot policy and how to use it, see [Snapshot](https://www.alibabacloud.com/help/doc-detail/25460.html).

        > **NOTE:** Available in 1.42.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        sp = alicloud.ecs.SnapshotPolicy("sp",
            name="tf-testAcc-sp",
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        ```

        ## Import

        Snapshot can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/snapshotPolicy:SnapshotPolicy snapshot sp-abc1234567890000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The snapshot policy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[_builtins.int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               
               Default value: -1.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **DEPRECATED:** This resource has been renamed to ecs.AutoSnapshotPolicy from version 1.117.0.

        Provides an ECS snapshot policy resource.

        For information about snapshot policy and how to use it, see [Snapshot](https://www.alibabacloud.com/help/doc-detail/25460.html).

        > **NOTE:** Available in 1.42.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        sp = alicloud.ecs.SnapshotPolicy("sp",
            name="tf-testAcc-sp",
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        ```

        ## Import

        Snapshot can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/snapshotPolicy:SnapshotPolicy snapshot sp-abc1234567890000
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 copy_encryption_configuration: Optional[pulumi.Input[Union['SnapshotPolicyCopyEncryptionConfigurationArgs', 'SnapshotPolicyCopyEncryptionConfigurationArgsDict']]] = None,
                 enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotPolicyArgs.__new__(SnapshotPolicyArgs)

            __props__.__dict__["auto_snapshot_policy_name"] = auto_snapshot_policy_name
            __props__.__dict__["copied_snapshots_retention_days"] = copied_snapshots_retention_days
            __props__.__dict__["copy_encryption_configuration"] = copy_encryption_configuration
            __props__.__dict__["enable_cross_region_copy"] = enable_cross_region_copy
            __props__.__dict__["name"] = name
            if repeat_weekdays is None and not opts.urn:
                raise TypeError("Missing required property 'repeat_weekdays'")
            __props__.__dict__["repeat_weekdays"] = repeat_weekdays
            __props__.__dict__["resource_group_id"] = resource_group_id
            if retention_days is None and not opts.urn:
                raise TypeError("Missing required property 'retention_days'")
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_copy_regions"] = target_copy_regions
            if time_points is None and not opts.urn:
                raise TypeError("Missing required property 'time_points'")
            __props__.__dict__["time_points"] = time_points
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(SnapshotPolicy, __self__).__init__(
            'alicloud:ecs/snapshotPolicy:SnapshotPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_snapshot_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            copied_snapshots_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            copy_encryption_configuration: Optional[pulumi.Input[Union['SnapshotPolicyCopyEncryptionConfigurationArgs', 'SnapshotPolicyCopyEncryptionConfigurationArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_cross_region_copy: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            repeat_weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_copy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SnapshotPolicy':
        """
        Get an existing SnapshotPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The snapshot policy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repeat_weekdays: The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
               - A maximum of seven time points can be selected.
               - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        :param pulumi.Input[_builtins.int] retention_days: The snapshot retention time, and the unit of measurement is day. Optional values:
               - -1: The automatic snapshots are retained permanently.
               - [1, 65536]: The number of days retained.
               
               Default value: -1.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
               - A maximum of 24 time points can be selected.
               - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotPolicyState.__new__(_SnapshotPolicyState)

        __props__.__dict__["auto_snapshot_policy_name"] = auto_snapshot_policy_name
        __props__.__dict__["copied_snapshots_retention_days"] = copied_snapshots_retention_days
        __props__.__dict__["copy_encryption_configuration"] = copy_encryption_configuration
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["enable_cross_region_copy"] = enable_cross_region_copy
        __props__.__dict__["name"] = name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["repeat_weekdays"] = repeat_weekdays
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retention_days"] = retention_days
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_copy_regions"] = target_copy_regions
        __props__.__dict__["time_points"] = time_points
        return SnapshotPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyName")
    def auto_snapshot_policy_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "auto_snapshot_policy_name")

    @_builtins.property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "copied_snapshots_retention_days")

    @_builtins.property
    @pulumi.getter(name="copyEncryptionConfiguration")
    def copy_encryption_configuration(self) -> pulumi.Output[Optional['outputs.SnapshotPolicyCopyEncryptionConfiguration']]:
        return pulumi.get(self, "copy_encryption_configuration")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "enable_cross_region_copy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.236.0. New field `auto_snapshot_policy_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The snapshot policy name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
        - A maximum of seven time points can be selected.
        - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
        """
        return pulumi.get(self, "repeat_weekdays")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[_builtins.int]:
        """
        The snapshot retention time, and the unit of measurement is day. Optional values:
        - -1: The automatic snapshots are retained permanently.
        - [1, 65536]: The number of days retained.

        Default value: -1.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "target_copy_regions")

    @_builtins.property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
        - A maximum of 24 time points can be selected.
        - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
        """
        return pulumi.get(self, "time_points")

