# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeGroupArgs', 'NodeGroup']

@pulumi.input_type
class NodeGroupArgs:
    def __init__(__self__, *,
                 az: pulumi.Input[_builtins.str],
                 cluster_id: pulumi.Input[_builtins.str],
                 image_id: pulumi.Input[_builtins.str],
                 machine_type: pulumi.Input[_builtins.str],
                 node_group_name: pulumi.Input[_builtins.str],
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_allocation_policies: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vswitch_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NodeGroup resource.
        :param pulumi.Input[_builtins.str] az: Az
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[_builtins.str] image_id: Image ID. You can modify the image ID since v1.252.0.
        :param pulumi.Input[_builtins.str] machine_type: Machine type
        :param pulumi.Input[_builtins.str] node_group_name: The name of the resource
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]] ip_allocation_policies: IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        :param pulumi.Input[_builtins.str] key_pair_name: key pair name
        :param pulumi.Input[_builtins.str] login_password: Login Password
        :param pulumi.Input[_builtins.str] node_group_description: NodeGroupDescription
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]] nodes: Node List See `nodes` below.
        :param pulumi.Input[_builtins.str] user_data: Custom Data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpd_subnets: Cluster subnet list
        :param pulumi.Input[_builtins.str] vswitch_zone_id: Zone ID of the switch
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        pulumi.set(__self__, "az", az)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "node_group_name", node_group_name)
        if ignore_failed_node_tasks is not None:
            pulumi.set(__self__, "ignore_failed_node_tasks", ignore_failed_node_tasks)
        if ip_allocation_policies is not None:
            pulumi.set(__self__, "ip_allocation_policies", ip_allocation_policies)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if login_password is not None:
            pulumi.set(__self__, "login_password", login_password)
        if node_group_description is not None:
            pulumi.set(__self__, "node_group_description", node_group_description)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpd_subnets is not None:
            pulumi.set(__self__, "vpd_subnets", vpd_subnets)
        if vswitch_zone_id is not None:
            pulumi.set(__self__, "vswitch_zone_id", vswitch_zone_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def az(self) -> pulumi.Input[_builtins.str]:
        """
        Az
        """
        return pulumi.get(self, "az")

    @az.setter
    def az(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "az", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Cluster ID
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[_builtins.str]:
        """
        Image ID. You can modify the image ID since v1.252.0.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[_builtins.str]:
        """
        Machine type
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_group_name", value)

    @_builtins.property
    @pulumi.getter(name="ignoreFailedNodeTasks")
    def ignore_failed_node_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow skipping failed nodes. Default value: False
        """
        return pulumi.get(self, "ignore_failed_node_tasks")

    @ignore_failed_node_tasks.setter
    def ignore_failed_node_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_failed_node_tasks", value)

    @_builtins.property
    @pulumi.getter(name="ipAllocationPolicies")
    def ip_allocation_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]]]:
        """
        IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        """
        return pulumi.get(self, "ip_allocation_policies")

    @ip_allocation_policies.setter
    def ip_allocation_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]]]):
        pulumi.set(self, "ip_allocation_policies", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        key pair name
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login Password
        """
        return pulumi.get(self, "login_password")

    @login_password.setter
    def login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_password", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupDescription")
    def node_group_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NodeGroupDescription
        """
        return pulumi.get(self, "node_group_description")

    @node_group_description.setter
    def node_group_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_description", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]]]:
        """
        Node List See `nodes` below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom Data
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vpdSubnets")
    def vpd_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Cluster subnet list
        """
        return pulumi.get(self, "vpd_subnets")

    @vpd_subnets.setter
    def vpd_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpd_subnets", value)

    @_builtins.property
    @pulumi.getter(name="vswitchZoneId")
    def vswitch_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID of the switch
        """
        return pulumi.get(self, "vswitch_zone_id")

    @vswitch_zone_id.setter
    def vswitch_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _NodeGroupState:
    def __init__(__self__, *,
                 az: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_allocation_policies: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vswitch_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NodeGroup resources.
        :param pulumi.Input[_builtins.str] az: Az
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[_builtins.str] create_time: Create time
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input[_builtins.str] image_id: Image ID. You can modify the image ID since v1.252.0.
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]] ip_allocation_policies: IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        :param pulumi.Input[_builtins.str] key_pair_name: key pair name
        :param pulumi.Input[_builtins.str] login_password: Login Password
        :param pulumi.Input[_builtins.str] machine_type: Machine type
        :param pulumi.Input[_builtins.str] node_group_description: NodeGroupDescription
        :param pulumi.Input[_builtins.str] node_group_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] node_group_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]] nodes: Node List See `nodes` below.
        :param pulumi.Input[_builtins.str] user_data: Custom Data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpd_subnets: Cluster subnet list
        :param pulumi.Input[_builtins.str] vswitch_zone_id: Zone ID of the switch
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        if az is not None:
            pulumi.set(__self__, "az", az)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ignore_failed_node_tasks is not None:
            pulumi.set(__self__, "ignore_failed_node_tasks", ignore_failed_node_tasks)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if ip_allocation_policies is not None:
            pulumi.set(__self__, "ip_allocation_policies", ip_allocation_policies)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if login_password is not None:
            pulumi.set(__self__, "login_password", login_password)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if node_group_description is not None:
            pulumi.set(__self__, "node_group_description", node_group_description)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpd_subnets is not None:
            pulumi.set(__self__, "vpd_subnets", vpd_subnets)
        if vswitch_zone_id is not None:
            pulumi.set(__self__, "vswitch_zone_id", vswitch_zone_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def az(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Az
        """
        return pulumi.get(self, "az")

    @az.setter
    def az(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "az", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster ID
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ignoreFailedNodeTasks")
    def ignore_failed_node_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow skipping failed nodes. Default value: False
        """
        return pulumi.get(self, "ignore_failed_node_tasks")

    @ignore_failed_node_tasks.setter
    def ignore_failed_node_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_failed_node_tasks", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image ID. You can modify the image ID since v1.252.0.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAllocationPolicies")
    def ip_allocation_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]]]:
        """
        IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        """
        return pulumi.get(self, "ip_allocation_policies")

    @ip_allocation_policies.setter
    def ip_allocation_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupIpAllocationPolicyArgs']]]]):
        pulumi.set(self, "ip_allocation_policies", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        key pair name
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login Password
        """
        return pulumi.get(self, "login_password")

    @login_password.setter
    def login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_password", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Machine type
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupDescription")
    def node_group_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NodeGroupDescription
        """
        return pulumi.get(self, "node_group_description")

    @node_group_description.setter
    def node_group_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_description", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]]]:
        """
        Node List See `nodes` below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom Data
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vpdSubnets")
    def vpd_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Cluster subnet list
        """
        return pulumi.get(self, "vpd_subnets")

    @vpd_subnets.setter
    def vpd_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpd_subnets", value)

    @_builtins.property
    @pulumi.getter(name="vswitchZoneId")
    def vswitch_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID of the switch
        """
        return pulumi.get(self, "vswitch_zone_id")

    @vswitch_zone_id.setter
    def vswitch_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:eflo/nodeGroup:NodeGroup")
class NodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 az: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_allocation_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupIpAllocationPolicyArgs', 'NodeGroupIpAllocationPolicyArgsDict']]]]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupNodeArgs', 'NodeGroupNodeArgsDict']]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vswitch_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Eflo Node Group resource.

        Node group. Divide a cluster into multiple node groups, each containing multiple nodes.

        For information about Eflo Node Group and how to use it, see [What is Node Group](https://next.api.alibabacloud.com/document/eflo-controller/2022-12-15/CreateNodeGroup).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        create_vpc = alicloud.vpc.Network("create_vpc",
            cidr_block="192.168.0.0/16",
            vpc_name="cluster-resoure-example")
        create_vswitch = alicloud.vpc.Switch("create_vswitch",
            vpc_id=create_vpc.id,
            zone_id="cn-hangzhou-b",
            cidr_block="192.168.0.0/24",
            vswitch_name="cluster-resoure-example")
        create_security_group = alicloud.ecs.SecurityGroup("create_security_group",
            description="sg",
            security_group_name="cluster-resoure-example",
            security_group_type="normal",
            vpc_id=create_vpc.id)
        default_cluster = alicloud.eflo.Cluster("default",
            cluster_description="cluster-resource-example",
            open_eni_jumbo_frame=False,
            hpn_zone="B1",
            nimiz_vswitches=["1111"],
            ignore_failed_node_tasks=True,
            resource_group_id=default.ids[1],
            node_groups=[{
                "image_id": "i198448731735114628708",
                "zone_id": "cn-hangzhou-b",
                "node_group_name": "cluster-resource-example",
                "node_group_description": "cluster-resource-example",
                "machine_type": "efg2.C48cA3sen",
            }],
            networks={
                "tail_ip_version": "ipv4",
                "new_vpd_info": {
                    "monitor_vpc_id": create_vpc.id,
                    "monitor_vswitch_id": create_vswitch.id,
                    "cen_id": "11111",
                    "cloud_link_id": "1111",
                    "vpd_cidr": "111",
                    "vpd_subnets": [{
                        "zone_id": "1111",
                        "subnet_cidr": "111",
                        "subnet_type": "111",
                    }],
                    "cloud_link_cidr": "169.254.128.0/23",
                },
                "security_group_id": create_security_group.id,
                "vswitch_zone_id": "cn-hangzhou-b",
                "vpc_id": create_vpc.id,
                "vswitch_id": create_vswitch.id,
                "vpd_info": {
                    "vpd_id": "111",
                    "vpd_subnets": ["111"],
                },
                "ip_allocation_policies": [{
                    "bond_policy": {
                        "bond_default_subnet": "111",
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                    },
                    "machine_type_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "machine_type": "111",
                    }],
                    "node_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "node_id": "111",
                    }],
                }],
            },
            cluster_name="tfacceflo7165",
            cluster_type="Lite")
        default_node = alicloud.eflo.Node("default",
            period=36,
            discount_level="36",
            billing_cycle="1month",
            classify="gpuserver",
            zone="cn-hangzhou-b",
            product_form="instance",
            payment_ratio="0",
            hpn_zone="B1",
            server_arch="bmserver",
            computing_server="efg1.nvga1n",
            stage_num="36",
            renewal_status="AutoRenewal",
            renew_period=36,
            status="Unused")
        default_node_group = alicloud.eflo.NodeGroup("default",
            nodes=[{
                "node_id": default_node.id,
                "vpc_id": create_vpc.id,
                "vswitch_id": create_vswitch.id,
                "hostname": "jxyhostname",
                "login_password": "Alibaba@2025",
            }],
            ignore_failed_node_tasks=True,
            cluster_id=default_cluster.id,
            image_id="i195048661660874208657",
            zone_id="cn-hangzhou-b",
            vpd_subnets=["example"],
            user_data="YWxpLGFsaSxhbGliYWJh",
            vswitch_zone_id="cn-hangzhou-b",
            ip_allocation_policies=[{
                "bond_policy": {
                    "bond_default_subnet": "example",
                    "bonds": [{
                        "name": "example",
                        "subnet": "example",
                    }],
                },
                "machine_type_policies": [{
                    "bonds": [{
                        "name": "example",
                        "subnet": "example",
                    }],
                    "machine_type": "example",
                }],
                "node_policies": [{
                    "node_id": default_node.id,
                    "bonds": [{
                        "name": "example",
                        "subnet": "example",
                    }],
                }],
            }],
            machine_type="efg1.nvga1",
            az="cn-hangzhou-b",
            node_group_description="resource-example1",
            node_group_name="tfacceflo63657_update")
        ```

        ## Import

        Eflo Node Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/nodeGroup:NodeGroup example <cluster_id>:<node_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] az: Az
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input[_builtins.str] image_id: Image ID. You can modify the image ID since v1.252.0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupIpAllocationPolicyArgs', 'NodeGroupIpAllocationPolicyArgsDict']]]] ip_allocation_policies: IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        :param pulumi.Input[_builtins.str] key_pair_name: key pair name
        :param pulumi.Input[_builtins.str] login_password: Login Password
        :param pulumi.Input[_builtins.str] machine_type: Machine type
        :param pulumi.Input[_builtins.str] node_group_description: NodeGroupDescription
        :param pulumi.Input[_builtins.str] node_group_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupNodeArgs', 'NodeGroupNodeArgsDict']]]] nodes: Node List See `nodes` below.
        :param pulumi.Input[_builtins.str] user_data: Custom Data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpd_subnets: Cluster subnet list
        :param pulumi.Input[_builtins.str] vswitch_zone_id: Zone ID of the switch
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Node Group resource.

        Node group. Divide a cluster into multiple node groups, each containing multiple nodes.

        For information about Eflo Node Group and how to use it, see [What is Node Group](https://next.api.alibabacloud.com/document/eflo-controller/2022-12-15/CreateNodeGroup).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        create_vpc = alicloud.vpc.Network("create_vpc",
            cidr_block="192.168.0.0/16",
            vpc_name="cluster-resoure-example")
        create_vswitch = alicloud.vpc.Switch("create_vswitch",
            vpc_id=create_vpc.id,
            zone_id="cn-hangzhou-b",
            cidr_block="192.168.0.0/24",
            vswitch_name="cluster-resoure-example")
        create_security_group = alicloud.ecs.SecurityGroup("create_security_group",
            description="sg",
            security_group_name="cluster-resoure-example",
            security_group_type="normal",
            vpc_id=create_vpc.id)
        default_cluster = alicloud.eflo.Cluster("default",
            cluster_description="cluster-resource-example",
            open_eni_jumbo_frame=False,
            hpn_zone="B1",
            nimiz_vswitches=["1111"],
            ignore_failed_node_tasks=True,
            resource_group_id=default.ids[1],
            node_groups=[{
                "image_id": "i198448731735114628708",
                "zone_id": "cn-hangzhou-b",
                "node_group_name": "cluster-resource-example",
                "node_group_description": "cluster-resource-example",
                "machine_type": "efg2.C48cA3sen",
            }],
            networks={
                "tail_ip_version": "ipv4",
                "new_vpd_info": {
                    "monitor_vpc_id": create_vpc.id,
                    "monitor_vswitch_id": create_vswitch.id,
                    "cen_id": "11111",
                    "cloud_link_id": "1111",
                    "vpd_cidr": "111",
                    "vpd_subnets": [{
                        "zone_id": "1111",
                        "subnet_cidr": "111",
                        "subnet_type": "111",
                    }],
                    "cloud_link_cidr": "169.254.128.0/23",
                },
                "security_group_id": create_security_group.id,
                "vswitch_zone_id": "cn-hangzhou-b",
                "vpc_id": create_vpc.id,
                "vswitch_id": create_vswitch.id,
                "vpd_info": {
                    "vpd_id": "111",
                    "vpd_subnets": ["111"],
                },
                "ip_allocation_policies": [{
                    "bond_policy": {
                        "bond_default_subnet": "111",
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                    },
                    "machine_type_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "machine_type": "111",
                    }],
                    "node_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "node_id": "111",
                    }],
                }],
            },
            cluster_name="tfacceflo7165",
            cluster_type="Lite")
        default_node = alicloud.eflo.Node("default",
            period=36,
            discount_level="36",
            billing_cycle="1month",
            classify="gpuserver",
            zone="cn-hangzhou-b",
            product_form="instance",
            payment_ratio="0",
            hpn_zone="B1",
            server_arch="bmserver",
            computing_server="efg1.nvga1n",
            stage_num="36",
            renewal_status="AutoRenewal",
            renew_period=36,
            status="Unused")
        default_node_group = alicloud.eflo.NodeGroup("default",
            nodes=[{
                "node_id": default_node.id,
                "vpc_id": create_vpc.id,
                "vswitch_id": create_vswitch.id,
                "hostname": "jxyhostname",
                "login_password": "Alibaba@2025",
            }],
            ignore_failed_node_tasks=True,
            cluster_id=default_cluster.id,
            image_id="i195048661660874208657",
            zone_id="cn-hangzhou-b",
            vpd_subnets=["example"],
            user_data="YWxpLGFsaSxhbGliYWJh",
            vswitch_zone_id="cn-hangzhou-b",
            ip_allocation_policies=[{
                "bond_policy": {
                    "bond_default_subnet": "example",
                    "bonds": [{
                        "name": "example",
                        "subnet": "example",
                    }],
                },
                "machine_type_policies": [{
                    "bonds": [{
                        "name": "example",
                        "subnet": "example",
                    }],
                    "machine_type": "example",
                }],
                "node_policies": [{
                    "node_id": default_node.id,
                    "bonds": [{
                        "name": "example",
                        "subnet": "example",
                    }],
                }],
            }],
            machine_type="efg1.nvga1",
            az="cn-hangzhou-b",
            node_group_description="resource-example1",
            node_group_name="tfacceflo63657_update")
        ```

        ## Import

        Eflo Node Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/nodeGroup:NodeGroup example <cluster_id>:<node_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param NodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 az: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_allocation_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupIpAllocationPolicyArgs', 'NodeGroupIpAllocationPolicyArgsDict']]]]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupNodeArgs', 'NodeGroupNodeArgsDict']]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpd_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vswitch_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupArgs.__new__(NodeGroupArgs)

            if az is None and not opts.urn:
                raise TypeError("Missing required property 'az'")
            __props__.__dict__["az"] = az
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["ignore_failed_node_tasks"] = ignore_failed_node_tasks
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["ip_allocation_policies"] = ip_allocation_policies
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["login_password"] = None if login_password is None else pulumi.Output.secret(login_password)
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["node_group_description"] = node_group_description
            if node_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'node_group_name'")
            __props__.__dict__["node_group_name"] = node_group_name
            __props__.__dict__["nodes"] = nodes
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vpd_subnets"] = vpd_subnets
            __props__.__dict__["vswitch_zone_id"] = vswitch_zone_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["node_group_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["loginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NodeGroup, __self__).__init__(
            'alicloud:eflo/nodeGroup:NodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            az: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_allocation_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupIpAllocationPolicyArgs', 'NodeGroupIpAllocationPolicyArgsDict']]]]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            login_password: Optional[pulumi.Input[_builtins.str]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            node_group_description: Optional[pulumi.Input[_builtins.str]] = None,
            node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupNodeArgs', 'NodeGroupNodeArgsDict']]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vpd_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vswitch_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NodeGroup':
        """
        Get an existing NodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] az: Az
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[_builtins.str] create_time: Create time
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input[_builtins.str] image_id: Image ID. You can modify the image ID since v1.252.0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupIpAllocationPolicyArgs', 'NodeGroupIpAllocationPolicyArgsDict']]]] ip_allocation_policies: IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        :param pulumi.Input[_builtins.str] key_pair_name: key pair name
        :param pulumi.Input[_builtins.str] login_password: Login Password
        :param pulumi.Input[_builtins.str] machine_type: Machine type
        :param pulumi.Input[_builtins.str] node_group_description: NodeGroupDescription
        :param pulumi.Input[_builtins.str] node_group_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] node_group_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupNodeArgs', 'NodeGroupNodeArgsDict']]]] nodes: Node List See `nodes` below.
        :param pulumi.Input[_builtins.str] user_data: Custom Data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpd_subnets: Cluster subnet list
        :param pulumi.Input[_builtins.str] vswitch_zone_id: Zone ID of the switch
        :param pulumi.Input[_builtins.str] zone_id: Zone ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeGroupState.__new__(_NodeGroupState)

        __props__.__dict__["az"] = az
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ignore_failed_node_tasks"] = ignore_failed_node_tasks
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["ip_allocation_policies"] = ip_allocation_policies
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["login_password"] = login_password
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["node_group_description"] = node_group_description
        __props__.__dict__["node_group_id"] = node_group_id
        __props__.__dict__["node_group_name"] = node_group_name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vpd_subnets"] = vpd_subnets
        __props__.__dict__["vswitch_zone_id"] = vswitch_zone_id
        __props__.__dict__["zone_id"] = zone_id
        return NodeGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def az(self) -> pulumi.Output[_builtins.str]:
        """
        Az
        """
        return pulumi.get(self, "az")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster ID
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ignoreFailedNodeTasks")
    def ignore_failed_node_tasks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow skipping failed nodes. Default value: False
        """
        return pulumi.get(self, "ignore_failed_node_tasks")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        Image ID. You can modify the image ID since v1.252.0.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="ipAllocationPolicies")
    def ip_allocation_policies(self) -> pulumi.Output[Optional[Sequence['outputs.NodeGroupIpAllocationPolicy']]]:
        """
        IP address combination policy: only one policy type can be selected for each policy, and multiple policies can be combined. See `ip_allocation_policy` below.
        """
        return pulumi.get(self, "ip_allocation_policies")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        key pair name
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Login Password
        """
        return pulumi.get(self, "login_password")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        Machine type
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="nodeGroupDescription")
    def node_group_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        NodeGroupDescription
        """
        return pulumi.get(self, "node_group_description")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "node_group_name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Optional[Sequence['outputs.NodeGroupNode']]]:
        """
        Node List See `nodes` below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom Data
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vpdSubnets")
    def vpd_subnets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Cluster subnet list
        """
        return pulumi.get(self, "vpd_subnets")

    @_builtins.property
    @pulumi.getter(name="vswitchZoneId")
    def vswitch_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Zone ID of the switch
        """
        return pulumi.get(self, "vswitch_zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")

