# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CacheReserveInstanceArgs', 'CacheReserveInstance']

@pulumi.input_type
class CacheReserveInstanceArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cr_region: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_gb: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a CacheReserveInstance resource.
        :param pulumi.Input[_builtins.str] payment_type: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.bool] auto_pay: Automatic payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to auto-renew:
        :param pulumi.Input[_builtins.str] cr_region: Cache holding area
               - `HK`: Hong Kong, China
               - `CN`: Mainland China
        :param pulumi.Input[_builtins.int] period: Purchase period (unit: month).
        :param pulumi.Input[_builtins.int] quota_gb: Cache retention specification (unit: GB).
        """
        pulumi.set(__self__, "payment_type", payment_type)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cr_region is not None:
            pulumi.set(__self__, "cr_region", cr_region)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if quota_gb is not None:
            pulumi.set(__self__, "quota_gb", quota_gb)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether to enable auto payment.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatic payment.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to auto-renew:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="crRegion")
    def cr_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache holding area
        - `HK`: Hong Kong, China
        - `CN`: Mainland China
        """
        return pulumi.get(self, "cr_region")

    @cr_region.setter
    def cr_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cr_region", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Purchase period (unit: month).
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="quotaGb")
    def quota_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache retention specification (unit: GB).
        """
        return pulumi.get(self, "quota_gb")

    @quota_gb.setter
    def quota_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "quota_gb", value)


@pulumi.input_type
class _CacheReserveInstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cr_region: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CacheReserveInstance resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Automatic payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to auto-renew:
        :param pulumi.Input[_builtins.str] cr_region: Cache holding area
               - `HK`: Hong Kong, China
               - `CN`: Mainland China
        :param pulumi.Input[_builtins.str] create_time: Instance purchase time.
        :param pulumi.Input[_builtins.str] payment_type: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.int] period: Purchase period (unit: month).
        :param pulumi.Input[_builtins.int] quota_gb: Cache retention specification (unit: GB).
        :param pulumi.Input[_builtins.str] status: The status of the cache reserve instance. , it is unavailable.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cr_region is not None:
            pulumi.set(__self__, "cr_region", cr_region)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if quota_gb is not None:
            pulumi.set(__self__, "quota_gb", quota_gb)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatic payment.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to auto-renew:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="crRegion")
    def cr_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache holding area
        - `HK`: Hong Kong, China
        - `CN`: Mainland China
        """
        return pulumi.get(self, "cr_region")

    @cr_region.setter
    def cr_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cr_region", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance purchase time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable auto payment.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Purchase period (unit: month).
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="quotaGb")
    def quota_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache retention specification (unit: GB).
        """
        return pulumi.get(self, "quota_gb")

    @quota_gb.setter
    def quota_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "quota_gb", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the cache reserve instance. , it is unavailable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/cacheReserveInstance:CacheReserveInstance")
class CacheReserveInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cr_region: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Cache Reserve Instance resource.

        For information about ESA Cache Reserve Instance and how to use it, see [What is Cache Reserve Instance](https://next.api.alibabacloud.com/document/ESA/2024-09-10/PurchaseCacheReserve).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.CacheReserveInstance("default",
            quota_gb=10240,
            cr_region="CN-beijing",
            auto_renew=True,
            period=1,
            payment_type="Subscription",
            auto_pay=True)
        ```

        ## Import

        ESA Cache Reserve Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/cacheReserveInstance:CacheReserveInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Automatic payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to auto-renew:
        :param pulumi.Input[_builtins.str] cr_region: Cache holding area
               - `HK`: Hong Kong, China
               - `CN`: Mainland China
        :param pulumi.Input[_builtins.str] payment_type: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.int] period: Purchase period (unit: month).
        :param pulumi.Input[_builtins.int] quota_gb: Cache retention specification (unit: GB).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheReserveInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Cache Reserve Instance resource.

        For information about ESA Cache Reserve Instance and how to use it, see [What is Cache Reserve Instance](https://next.api.alibabacloud.com/document/ESA/2024-09-10/PurchaseCacheReserve).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.CacheReserveInstance("default",
            quota_gb=10240,
            cr_region="CN-beijing",
            auto_renew=True,
            period=1,
            payment_type="Subscription",
            auto_pay=True)
        ```

        ## Import

        ESA Cache Reserve Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/cacheReserveInstance:CacheReserveInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CacheReserveInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheReserveInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cr_region: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheReserveInstanceArgs.__new__(CacheReserveInstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["cr_region"] = cr_region
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["quota_gb"] = quota_gb
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(CacheReserveInstance, __self__).__init__(
            'alicloud:esa/cacheReserveInstance:CacheReserveInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            cr_region: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            quota_gb: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'CacheReserveInstance':
        """
        Get an existing CacheReserveInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Automatic payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to auto-renew:
        :param pulumi.Input[_builtins.str] cr_region: Cache holding area
               - `HK`: Hong Kong, China
               - `CN`: Mainland China
        :param pulumi.Input[_builtins.str] create_time: Instance purchase time.
        :param pulumi.Input[_builtins.str] payment_type: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.int] period: Purchase period (unit: month).
        :param pulumi.Input[_builtins.int] quota_gb: Cache retention specification (unit: GB).
        :param pulumi.Input[_builtins.str] status: The status of the cache reserve instance. , it is unavailable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheReserveInstanceState.__new__(_CacheReserveInstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["cr_region"] = cr_region
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["quota_gb"] = quota_gb
        __props__.__dict__["status"] = status
        return CacheReserveInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatic payment.
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to auto-renew:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="crRegion")
    def cr_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cache holding area
        - `HK`: Hong Kong, China
        - `CN`: Mainland China
        """
        return pulumi.get(self, "cr_region")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Instance purchase time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable auto payment.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Purchase period (unit: month).
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="quotaGb")
    def quota_gb(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Cache retention specification (unit: GB).
        """
        return pulumi.get(self, "quota_gb")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the cache reserve instance. , it is unavailable.
        """
        return pulumi.get(self, "status")

