# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CacheRuleArgs', 'CacheRule']

@pulumi.input_type
class CacheRuleArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 additional_cacheable_ports: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deception_armor: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_header: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_status_code_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 include_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 include_header: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serve_stale: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_query_string_for_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 user_device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_geo: Optional[pulumi.Input[_builtins.str]] = None,
                 user_language: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CacheRule resource.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites] API.
        :param pulumi.Input[_builtins.str] additional_cacheable_ports: Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        :param pulumi.Input[_builtins.str] browser_cache_mode: Browser cache mode. Possible values:
        :param pulumi.Input[_builtins.str] browser_cache_ttl: Browser cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] bypass_cache: Set the bypass cache mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_deception_armor: Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        :param pulumi.Input[_builtins.str] cache_reserve_eligibility: Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        :param pulumi.Input[_builtins.str] check_presence_cookie: When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] check_presence_header: When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] edge_cache_mode: Edge cache mode. Possible values:
        :param pulumi.Input[_builtins.str] edge_cache_ttl: Edge cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] edge_status_code_cache_ttl: Status code cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] include_cookie: When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] include_header: When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string: Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string_mode: The processing mode for query strings when generating the cache key. Possible values:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true.
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.str] serve_stale: Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] sort_query_string_for_cache: Query string sorting, disabled by default. Possible values:
        :param pulumi.Input[_builtins.str] user_device_type: When generating the cache key, add the client device type. Possible values:
        :param pulumi.Input[_builtins.str] user_geo: When generating the cache key, add the client's geographic location. Possible values:
        :param pulumi.Input[_builtins.str] user_language: When generating cache keys, include the client's language type. Possible values:
        """
        pulumi.set(__self__, "site_id", site_id)
        if additional_cacheable_ports is not None:
            pulumi.set(__self__, "additional_cacheable_ports", additional_cacheable_ports)
        if browser_cache_mode is not None:
            pulumi.set(__self__, "browser_cache_mode", browser_cache_mode)
        if browser_cache_ttl is not None:
            pulumi.set(__self__, "browser_cache_ttl", browser_cache_ttl)
        if bypass_cache is not None:
            pulumi.set(__self__, "bypass_cache", bypass_cache)
        if cache_deception_armor is not None:
            pulumi.set(__self__, "cache_deception_armor", cache_deception_armor)
        if cache_reserve_eligibility is not None:
            pulumi.set(__self__, "cache_reserve_eligibility", cache_reserve_eligibility)
        if check_presence_cookie is not None:
            pulumi.set(__self__, "check_presence_cookie", check_presence_cookie)
        if check_presence_header is not None:
            pulumi.set(__self__, "check_presence_header", check_presence_header)
        if edge_cache_mode is not None:
            pulumi.set(__self__, "edge_cache_mode", edge_cache_mode)
        if edge_cache_ttl is not None:
            pulumi.set(__self__, "edge_cache_ttl", edge_cache_ttl)
        if edge_status_code_cache_ttl is not None:
            pulumi.set(__self__, "edge_status_code_cache_ttl", edge_status_code_cache_ttl)
        if include_cookie is not None:
            pulumi.set(__self__, "include_cookie", include_cookie)
        if include_header is not None:
            pulumi.set(__self__, "include_header", include_header)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if query_string_mode is not None:
            pulumi.set(__self__, "query_string_mode", query_string_mode)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if serve_stale is not None:
            pulumi.set(__self__, "serve_stale", serve_stale)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if sort_query_string_for_cache is not None:
            pulumi.set(__self__, "sort_query_string_for_cache", sort_query_string_for_cache)
        if user_device_type is not None:
            pulumi.set(__self__, "user_device_type", user_device_type)
        if user_geo is not None:
            pulumi.set(__self__, "user_geo", user_geo)
        if user_language is not None:
            pulumi.set(__self__, "user_language", user_language)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the [ListSites] API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalCacheablePorts")
    def additional_cacheable_ports(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        """
        return pulumi.get(self, "additional_cacheable_ports")

    @additional_cacheable_ports.setter
    def additional_cacheable_ports(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_cacheable_ports", value)

    @_builtins.property
    @pulumi.getter(name="browserCacheMode")
    def browser_cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Browser cache mode. Possible values:
        """
        return pulumi.get(self, "browser_cache_mode")

    @browser_cache_mode.setter
    def browser_cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_cache_mode", value)

    @_builtins.property
    @pulumi.getter(name="browserCacheTtl")
    def browser_cache_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Browser cache expiration time in seconds.
        """
        return pulumi.get(self, "browser_cache_ttl")

    @browser_cache_ttl.setter
    def browser_cache_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="bypassCache")
    def bypass_cache(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the bypass cache mode. Possible values:
        """
        return pulumi.get(self, "bypass_cache")

    @bypass_cache.setter
    def bypass_cache(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bypass_cache", value)

    @_builtins.property
    @pulumi.getter(name="cacheDeceptionArmor")
    def cache_deception_armor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        """
        return pulumi.get(self, "cache_deception_armor")

    @cache_deception_armor.setter
    def cache_deception_armor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_deception_armor", value)

    @_builtins.property
    @pulumi.getter(name="cacheReserveEligibility")
    def cache_reserve_eligibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        """
        return pulumi.get(self, "cache_reserve_eligibility")

    @cache_reserve_eligibility.setter
    def cache_reserve_eligibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_reserve_eligibility", value)

    @_builtins.property
    @pulumi.getter(name="checkPresenceCookie")
    def check_presence_cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        """
        return pulumi.get(self, "check_presence_cookie")

    @check_presence_cookie.setter
    def check_presence_cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_presence_cookie", value)

    @_builtins.property
    @pulumi.getter(name="checkPresenceHeader")
    def check_presence_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        """
        return pulumi.get(self, "check_presence_header")

    @check_presence_header.setter
    def check_presence_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_presence_header", value)

    @_builtins.property
    @pulumi.getter(name="edgeCacheMode")
    def edge_cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edge cache mode. Possible values:
        """
        return pulumi.get(self, "edge_cache_mode")

    @edge_cache_mode.setter
    def edge_cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_cache_mode", value)

    @_builtins.property
    @pulumi.getter(name="edgeCacheTtl")
    def edge_cache_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edge cache expiration time in seconds.
        """
        return pulumi.get(self, "edge_cache_ttl")

    @edge_cache_ttl.setter
    def edge_cache_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="edgeStatusCodeCacheTtl")
    def edge_status_code_cache_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status code cache expiration time in seconds.
        """
        return pulumi.get(self, "edge_status_code_cache_ttl")

    @edge_status_code_cache_ttl.setter
    def edge_status_code_cache_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_status_code_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="includeCookie")
    def include_cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "include_cookie")

    @include_cookie.setter
    def include_cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_cookie", value)

    @_builtins.property
    @pulumi.getter(name="includeHeader")
    def include_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "include_header")

    @include_header.setter
    def include_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_header", value)

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string", value)

    @_builtins.property
    @pulumi.getter(name="queryStringMode")
    def query_string_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The processing mode for query strings when generating the cache key. Possible values:
        """
        return pulumi.get(self, "query_string_mode")

    @query_string_mode.setter
    def query_string_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string_mode", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true.
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="serveStale")
    def serve_stale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        """
        return pulumi.get(self, "serve_stale")

    @serve_stale.setter
    def serve_stale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serve_stale", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="sortQueryStringForCache")
    def sort_query_string_for_cache(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query string sorting, disabled by default. Possible values:
        """
        return pulumi.get(self, "sort_query_string_for_cache")

    @sort_query_string_for_cache.setter
    def sort_query_string_for_cache(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sort_query_string_for_cache", value)

    @_builtins.property
    @pulumi.getter(name="userDeviceType")
    def user_device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the client device type. Possible values:
        """
        return pulumi.get(self, "user_device_type")

    @user_device_type.setter
    def user_device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_device_type", value)

    @_builtins.property
    @pulumi.getter(name="userGeo")
    def user_geo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the client's geographic location. Possible values:
        """
        return pulumi.get(self, "user_geo")

    @user_geo.setter
    def user_geo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_geo", value)

    @_builtins.property
    @pulumi.getter(name="userLanguage")
    def user_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating cache keys, include the client's language type. Possible values:
        """
        return pulumi.get(self, "user_language")

    @user_language.setter
    def user_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_language", value)


@pulumi.input_type
class _CacheRuleState:
    def __init__(__self__, *,
                 additional_cacheable_ports: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deception_armor: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 check_presence_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_header: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_status_code_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 include_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 include_header: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serve_stale: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_query_string_for_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 user_device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_geo: Optional[pulumi.Input[_builtins.str]] = None,
                 user_language: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CacheRule resources.
        :param pulumi.Input[_builtins.str] additional_cacheable_ports: Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        :param pulumi.Input[_builtins.str] browser_cache_mode: Browser cache mode. Possible values:
        :param pulumi.Input[_builtins.str] browser_cache_ttl: Browser cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] bypass_cache: Set the bypass cache mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_deception_armor: Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        :param pulumi.Input[_builtins.str] cache_reserve_eligibility: Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        :param pulumi.Input[_builtins.int] cache_rule_id: Cache Rule Id.
        :param pulumi.Input[_builtins.str] check_presence_cookie: When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] check_presence_header: When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] edge_cache_mode: Edge cache mode. Possible values:
        :param pulumi.Input[_builtins.str] edge_cache_ttl: Edge cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] edge_status_code_cache_ttl: Status code cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] include_cookie: When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] include_header: When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string: Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string_mode: The processing mode for query strings when generating the cache key. Possible values:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true.
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.str] serve_stale: Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites] API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] sort_query_string_for_cache: Query string sorting, disabled by default. Possible values:
        :param pulumi.Input[_builtins.str] user_device_type: When generating the cache key, add the client device type. Possible values:
        :param pulumi.Input[_builtins.str] user_geo: When generating the cache key, add the client's geographic location. Possible values:
        :param pulumi.Input[_builtins.str] user_language: When generating cache keys, include the client's language type. Possible values:
        """
        if additional_cacheable_ports is not None:
            pulumi.set(__self__, "additional_cacheable_ports", additional_cacheable_ports)
        if browser_cache_mode is not None:
            pulumi.set(__self__, "browser_cache_mode", browser_cache_mode)
        if browser_cache_ttl is not None:
            pulumi.set(__self__, "browser_cache_ttl", browser_cache_ttl)
        if bypass_cache is not None:
            pulumi.set(__self__, "bypass_cache", bypass_cache)
        if cache_deception_armor is not None:
            pulumi.set(__self__, "cache_deception_armor", cache_deception_armor)
        if cache_reserve_eligibility is not None:
            pulumi.set(__self__, "cache_reserve_eligibility", cache_reserve_eligibility)
        if cache_rule_id is not None:
            pulumi.set(__self__, "cache_rule_id", cache_rule_id)
        if check_presence_cookie is not None:
            pulumi.set(__self__, "check_presence_cookie", check_presence_cookie)
        if check_presence_header is not None:
            pulumi.set(__self__, "check_presence_header", check_presence_header)
        if edge_cache_mode is not None:
            pulumi.set(__self__, "edge_cache_mode", edge_cache_mode)
        if edge_cache_ttl is not None:
            pulumi.set(__self__, "edge_cache_ttl", edge_cache_ttl)
        if edge_status_code_cache_ttl is not None:
            pulumi.set(__self__, "edge_status_code_cache_ttl", edge_status_code_cache_ttl)
        if include_cookie is not None:
            pulumi.set(__self__, "include_cookie", include_cookie)
        if include_header is not None:
            pulumi.set(__self__, "include_header", include_header)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if query_string_mode is not None:
            pulumi.set(__self__, "query_string_mode", query_string_mode)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if serve_stale is not None:
            pulumi.set(__self__, "serve_stale", serve_stale)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if sort_query_string_for_cache is not None:
            pulumi.set(__self__, "sort_query_string_for_cache", sort_query_string_for_cache)
        if user_device_type is not None:
            pulumi.set(__self__, "user_device_type", user_device_type)
        if user_geo is not None:
            pulumi.set(__self__, "user_geo", user_geo)
        if user_language is not None:
            pulumi.set(__self__, "user_language", user_language)

    @_builtins.property
    @pulumi.getter(name="additionalCacheablePorts")
    def additional_cacheable_ports(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        """
        return pulumi.get(self, "additional_cacheable_ports")

    @additional_cacheable_ports.setter
    def additional_cacheable_ports(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "additional_cacheable_ports", value)

    @_builtins.property
    @pulumi.getter(name="browserCacheMode")
    def browser_cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Browser cache mode. Possible values:
        """
        return pulumi.get(self, "browser_cache_mode")

    @browser_cache_mode.setter
    def browser_cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_cache_mode", value)

    @_builtins.property
    @pulumi.getter(name="browserCacheTtl")
    def browser_cache_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Browser cache expiration time in seconds.
        """
        return pulumi.get(self, "browser_cache_ttl")

    @browser_cache_ttl.setter
    def browser_cache_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="bypassCache")
    def bypass_cache(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the bypass cache mode. Possible values:
        """
        return pulumi.get(self, "bypass_cache")

    @bypass_cache.setter
    def bypass_cache(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bypass_cache", value)

    @_builtins.property
    @pulumi.getter(name="cacheDeceptionArmor")
    def cache_deception_armor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        """
        return pulumi.get(self, "cache_deception_armor")

    @cache_deception_armor.setter
    def cache_deception_armor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_deception_armor", value)

    @_builtins.property
    @pulumi.getter(name="cacheReserveEligibility")
    def cache_reserve_eligibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        """
        return pulumi.get(self, "cache_reserve_eligibility")

    @cache_reserve_eligibility.setter
    def cache_reserve_eligibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_reserve_eligibility", value)

    @_builtins.property
    @pulumi.getter(name="cacheRuleId")
    def cache_rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cache Rule Id.
        """
        return pulumi.get(self, "cache_rule_id")

    @cache_rule_id.setter
    def cache_rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="checkPresenceCookie")
    def check_presence_cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        """
        return pulumi.get(self, "check_presence_cookie")

    @check_presence_cookie.setter
    def check_presence_cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_presence_cookie", value)

    @_builtins.property
    @pulumi.getter(name="checkPresenceHeader")
    def check_presence_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        """
        return pulumi.get(self, "check_presence_header")

    @check_presence_header.setter
    def check_presence_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_presence_header", value)

    @_builtins.property
    @pulumi.getter(name="edgeCacheMode")
    def edge_cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edge cache mode. Possible values:
        """
        return pulumi.get(self, "edge_cache_mode")

    @edge_cache_mode.setter
    def edge_cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_cache_mode", value)

    @_builtins.property
    @pulumi.getter(name="edgeCacheTtl")
    def edge_cache_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edge cache expiration time in seconds.
        """
        return pulumi.get(self, "edge_cache_ttl")

    @edge_cache_ttl.setter
    def edge_cache_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="edgeStatusCodeCacheTtl")
    def edge_status_code_cache_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status code cache expiration time in seconds.
        """
        return pulumi.get(self, "edge_status_code_cache_ttl")

    @edge_status_code_cache_ttl.setter
    def edge_status_code_cache_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_status_code_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="includeCookie")
    def include_cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "include_cookie")

    @include_cookie.setter
    def include_cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_cookie", value)

    @_builtins.property
    @pulumi.getter(name="includeHeader")
    def include_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "include_header")

    @include_header.setter
    def include_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_header", value)

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string", value)

    @_builtins.property
    @pulumi.getter(name="queryStringMode")
    def query_string_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The processing mode for query strings when generating the cache key. Possible values:
        """
        return pulumi.get(self, "query_string_mode")

    @query_string_mode.setter
    def query_string_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string_mode", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true.
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="serveStale")
    def serve_stale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        """
        return pulumi.get(self, "serve_stale")

    @serve_stale.setter
    def serve_stale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serve_stale", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the [ListSites] API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="sortQueryStringForCache")
    def sort_query_string_for_cache(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Query string sorting, disabled by default. Possible values:
        """
        return pulumi.get(self, "sort_query_string_for_cache")

    @sort_query_string_for_cache.setter
    def sort_query_string_for_cache(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sort_query_string_for_cache", value)

    @_builtins.property
    @pulumi.getter(name="userDeviceType")
    def user_device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the client device type. Possible values:
        """
        return pulumi.get(self, "user_device_type")

    @user_device_type.setter
    def user_device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_device_type", value)

    @_builtins.property
    @pulumi.getter(name="userGeo")
    def user_geo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating the cache key, add the client's geographic location. Possible values:
        """
        return pulumi.get(self, "user_geo")

    @user_geo.setter
    def user_geo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_geo", value)

    @_builtins.property
    @pulumi.getter(name="userLanguage")
    def user_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When generating cache keys, include the client's language type. Possible values:
        """
        return pulumi.get(self, "user_language")

    @user_language.setter
    def user_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_language", value)


@pulumi.type_token("alicloud:esa/cacheRule:CacheRule")
class CacheRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_cacheable_ports: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deception_armor: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_header: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_status_code_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 include_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 include_header: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serve_stale: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_query_string_for_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 user_device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_geo: Optional[pulumi.Input[_builtins.str]] = None,
                 user_language: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Cache Rule resource.

        For information about ESA Cache Rule and how to use it, see [What is Cache Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateCacheRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_cache_rule = alicloud.esa.CacheRule("default",
            user_device_type="off",
            browser_cache_mode="no_cache",
            user_language="off",
            check_presence_header="headername",
            include_cookie="cookie_exapmle",
            edge_cache_mode="follow_origin",
            additional_cacheable_ports="2053",
            rule_name="rule_example",
            edge_status_code_cache_ttl="300",
            browser_cache_ttl="300",
            query_string="example",
            user_geo="off",
            sort_query_string_for_cache="off",
            check_presence_cookie="cookiename",
            cache_reserve_eligibility="bypass_cache_reserve",
            query_string_mode="ignore_all",
            rule="http.host eq \\"video.example.com\\"",
            cache_deception_armor="off",
            site_id=default.sites[0].id,
            bypass_cache="cache_all",
            edge_cache_ttl="300",
            rule_enable="off",
            site_version=0,
            include_header="example",
            serve_stale="off")
        ```

        ## Import

        ESA Cache Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/cacheRule:CacheRule example <site_id>:<cache_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_cacheable_ports: Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        :param pulumi.Input[_builtins.str] browser_cache_mode: Browser cache mode. Possible values:
        :param pulumi.Input[_builtins.str] browser_cache_ttl: Browser cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] bypass_cache: Set the bypass cache mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_deception_armor: Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        :param pulumi.Input[_builtins.str] cache_reserve_eligibility: Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        :param pulumi.Input[_builtins.str] check_presence_cookie: When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] check_presence_header: When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] edge_cache_mode: Edge cache mode. Possible values:
        :param pulumi.Input[_builtins.str] edge_cache_ttl: Edge cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] edge_status_code_cache_ttl: Status code cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] include_cookie: When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] include_header: When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string: Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string_mode: The processing mode for query strings when generating the cache key. Possible values:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true.
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.str] serve_stale: Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites] API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] sort_query_string_for_cache: Query string sorting, disabled by default. Possible values:
        :param pulumi.Input[_builtins.str] user_device_type: When generating the cache key, add the client device type. Possible values:
        :param pulumi.Input[_builtins.str] user_geo: When generating the cache key, add the client's geographic location. Possible values:
        :param pulumi.Input[_builtins.str] user_language: When generating cache keys, include the client's language type. Possible values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Cache Rule resource.

        For information about ESA Cache Rule and how to use it, see [What is Cache Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateCacheRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_cache_rule = alicloud.esa.CacheRule("default",
            user_device_type="off",
            browser_cache_mode="no_cache",
            user_language="off",
            check_presence_header="headername",
            include_cookie="cookie_exapmle",
            edge_cache_mode="follow_origin",
            additional_cacheable_ports="2053",
            rule_name="rule_example",
            edge_status_code_cache_ttl="300",
            browser_cache_ttl="300",
            query_string="example",
            user_geo="off",
            sort_query_string_for_cache="off",
            check_presence_cookie="cookiename",
            cache_reserve_eligibility="bypass_cache_reserve",
            query_string_mode="ignore_all",
            rule="http.host eq \\"video.example.com\\"",
            cache_deception_armor="off",
            site_id=default.sites[0].id,
            bypass_cache="cache_all",
            edge_cache_ttl="300",
            rule_enable="off",
            site_version=0,
            include_header="example",
            serve_stale="off")
        ```

        ## Import

        ESA Cache Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/cacheRule:CacheRule example <site_id>:<cache_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param CacheRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_cacheable_ports: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_deception_armor: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 check_presence_header: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_status_code_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 include_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 include_header: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serve_stale: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_query_string_for_cache: Optional[pulumi.Input[_builtins.str]] = None,
                 user_device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_geo: Optional[pulumi.Input[_builtins.str]] = None,
                 user_language: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheRuleArgs.__new__(CacheRuleArgs)

            __props__.__dict__["additional_cacheable_ports"] = additional_cacheable_ports
            __props__.__dict__["browser_cache_mode"] = browser_cache_mode
            __props__.__dict__["browser_cache_ttl"] = browser_cache_ttl
            __props__.__dict__["bypass_cache"] = bypass_cache
            __props__.__dict__["cache_deception_armor"] = cache_deception_armor
            __props__.__dict__["cache_reserve_eligibility"] = cache_reserve_eligibility
            __props__.__dict__["check_presence_cookie"] = check_presence_cookie
            __props__.__dict__["check_presence_header"] = check_presence_header
            __props__.__dict__["edge_cache_mode"] = edge_cache_mode
            __props__.__dict__["edge_cache_ttl"] = edge_cache_ttl
            __props__.__dict__["edge_status_code_cache_ttl"] = edge_status_code_cache_ttl
            __props__.__dict__["include_cookie"] = include_cookie
            __props__.__dict__["include_header"] = include_header
            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["query_string_mode"] = query_string_mode
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["serve_stale"] = serve_stale
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["sort_query_string_for_cache"] = sort_query_string_for_cache
            __props__.__dict__["user_device_type"] = user_device_type
            __props__.__dict__["user_geo"] = user_geo
            __props__.__dict__["user_language"] = user_language
            __props__.__dict__["cache_rule_id"] = None
        super(CacheRule, __self__).__init__(
            'alicloud:esa/cacheRule:CacheRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_cacheable_ports: Optional[pulumi.Input[_builtins.str]] = None,
            browser_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
            browser_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            bypass_cache: Optional[pulumi.Input[_builtins.str]] = None,
            cache_deception_armor: Optional[pulumi.Input[_builtins.str]] = None,
            cache_reserve_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
            cache_rule_id: Optional[pulumi.Input[_builtins.int]] = None,
            check_presence_cookie: Optional[pulumi.Input[_builtins.str]] = None,
            check_presence_header: Optional[pulumi.Input[_builtins.str]] = None,
            edge_cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
            edge_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            edge_status_code_cache_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            include_cookie: Optional[pulumi.Input[_builtins.str]] = None,
            include_header: Optional[pulumi.Input[_builtins.str]] = None,
            query_string: Optional[pulumi.Input[_builtins.str]] = None,
            query_string_mode: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            serve_stale: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            sort_query_string_for_cache: Optional[pulumi.Input[_builtins.str]] = None,
            user_device_type: Optional[pulumi.Input[_builtins.str]] = None,
            user_geo: Optional[pulumi.Input[_builtins.str]] = None,
            user_language: Optional[pulumi.Input[_builtins.str]] = None) -> 'CacheRule':
        """
        Get an existing CacheRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] additional_cacheable_ports: Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        :param pulumi.Input[_builtins.str] browser_cache_mode: Browser cache mode. Possible values:
        :param pulumi.Input[_builtins.str] browser_cache_ttl: Browser cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] bypass_cache: Set the bypass cache mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_deception_armor: Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        :param pulumi.Input[_builtins.str] cache_reserve_eligibility: Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        :param pulumi.Input[_builtins.int] cache_rule_id: Cache Rule Id.
        :param pulumi.Input[_builtins.str] check_presence_cookie: When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] check_presence_header: When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] edge_cache_mode: Edge cache mode. Possible values:
        :param pulumi.Input[_builtins.str] edge_cache_ttl: Edge cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] edge_status_code_cache_ttl: Status code cache expiration time in seconds.
        :param pulumi.Input[_builtins.str] include_cookie: When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] include_header: When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string: Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        :param pulumi.Input[_builtins.str] query_string_mode: The processing mode for query strings when generating the cache key. Possible values:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true.
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.str] serve_stale: Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites] API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] sort_query_string_for_cache: Query string sorting, disabled by default. Possible values:
        :param pulumi.Input[_builtins.str] user_device_type: When generating the cache key, add the client device type. Possible values:
        :param pulumi.Input[_builtins.str] user_geo: When generating the cache key, add the client's geographic location. Possible values:
        :param pulumi.Input[_builtins.str] user_language: When generating cache keys, include the client's language type. Possible values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheRuleState.__new__(_CacheRuleState)

        __props__.__dict__["additional_cacheable_ports"] = additional_cacheable_ports
        __props__.__dict__["browser_cache_mode"] = browser_cache_mode
        __props__.__dict__["browser_cache_ttl"] = browser_cache_ttl
        __props__.__dict__["bypass_cache"] = bypass_cache
        __props__.__dict__["cache_deception_armor"] = cache_deception_armor
        __props__.__dict__["cache_reserve_eligibility"] = cache_reserve_eligibility
        __props__.__dict__["cache_rule_id"] = cache_rule_id
        __props__.__dict__["check_presence_cookie"] = check_presence_cookie
        __props__.__dict__["check_presence_header"] = check_presence_header
        __props__.__dict__["edge_cache_mode"] = edge_cache_mode
        __props__.__dict__["edge_cache_ttl"] = edge_cache_ttl
        __props__.__dict__["edge_status_code_cache_ttl"] = edge_status_code_cache_ttl
        __props__.__dict__["include_cookie"] = include_cookie
        __props__.__dict__["include_header"] = include_header
        __props__.__dict__["query_string"] = query_string
        __props__.__dict__["query_string_mode"] = query_string_mode
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["serve_stale"] = serve_stale
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["sort_query_string_for_cache"] = sort_query_string_for_cache
        __props__.__dict__["user_device_type"] = user_device_type
        __props__.__dict__["user_geo"] = user_geo
        __props__.__dict__["user_language"] = user_language
        return CacheRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalCacheablePorts")
    def additional_cacheable_ports(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable caching on specified ports. Value range: 8880, 2052, 2082, 2086, 2095, 2053, 2083, 2087, 2096
        """
        return pulumi.get(self, "additional_cacheable_ports")

    @_builtins.property
    @pulumi.getter(name="browserCacheMode")
    def browser_cache_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Browser cache mode. Possible values:
        """
        return pulumi.get(self, "browser_cache_mode")

    @_builtins.property
    @pulumi.getter(name="browserCacheTtl")
    def browser_cache_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Browser cache expiration time in seconds.
        """
        return pulumi.get(self, "browser_cache_ttl")

    @_builtins.property
    @pulumi.getter(name="bypassCache")
    def bypass_cache(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the bypass cache mode. Possible values:
        """
        return pulumi.get(self, "bypass_cache")

    @_builtins.property
    @pulumi.getter(name="cacheDeceptionArmor")
    def cache_deception_armor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cache deception protection. Used to defend against web cache deception attacks, only the cache content that passes the validation will be cached. Value range:
        """
        return pulumi.get(self, "cache_deception_armor")

    @_builtins.property
    @pulumi.getter(name="cacheReserveEligibility")
    def cache_reserve_eligibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cache retention eligibility. Used to control whether user requests bypass the cache retention node when returning to the origin. Possible values:
        """
        return pulumi.get(self, "cache_reserve_eligibility")

    @_builtins.property
    @pulumi.getter(name="cacheRuleId")
    def cache_rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        Cache Rule Id.
        """
        return pulumi.get(self, "cache_rule_id")

    @_builtins.property
    @pulumi.getter(name="checkPresenceCookie")
    def check_presence_cookie(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating the cache key, check if the cookie exists. If it does, add the cookie name (case-insensitive) to the cache key. Multiple cookie names are supported, separated by spaces.
        """
        return pulumi.get(self, "check_presence_cookie")

    @_builtins.property
    @pulumi.getter(name="checkPresenceHeader")
    def check_presence_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating the cache key, check if the header exists. If it does, add the header name (case-insensitive) to the cache key. Multiple header names are supported, separated by spaces.
        """
        return pulumi.get(self, "check_presence_header")

    @_builtins.property
    @pulumi.getter(name="edgeCacheMode")
    def edge_cache_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Edge cache mode. Possible values:
        """
        return pulumi.get(self, "edge_cache_mode")

    @_builtins.property
    @pulumi.getter(name="edgeCacheTtl")
    def edge_cache_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Edge cache expiration time in seconds.
        """
        return pulumi.get(self, "edge_cache_ttl")

    @_builtins.property
    @pulumi.getter(name="edgeStatusCodeCacheTtl")
    def edge_status_code_cache_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status code cache expiration time in seconds.
        """
        return pulumi.get(self, "edge_status_code_cache_ttl")

    @_builtins.property
    @pulumi.getter(name="includeCookie")
    def include_cookie(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating the cache key, add the specified cookie names and their values. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "include_cookie")

    @_builtins.property
    @pulumi.getter(name="includeHeader")
    def include_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating the cache key, add the specified header names and their values. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "include_header")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Query strings to be reserved or excluded. Multiple values are supported, separated by spaces.
        """
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter(name="queryStringMode")
    def query_string_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The processing mode for query strings when generating the cache key. Possible values:
        """
        return pulumi.get(self, "query_string_mode")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true.
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\").
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="serveStale")
    def serve_stale(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Serve stale cache. When enabled, the node can still respond to user requests with expired cached files when the origin server is unavailable. Value range:
        """
        return pulumi.get(self, "serve_stale")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the [ListSites] API.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter(name="sortQueryStringForCache")
    def sort_query_string_for_cache(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Query string sorting, disabled by default. Possible values:
        """
        return pulumi.get(self, "sort_query_string_for_cache")

    @_builtins.property
    @pulumi.getter(name="userDeviceType")
    def user_device_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating the cache key, add the client device type. Possible values:
        """
        return pulumi.get(self, "user_device_type")

    @_builtins.property
    @pulumi.getter(name="userGeo")
    def user_geo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating the cache key, add the client's geographic location. Possible values:
        """
        return pulumi.get(self, "user_geo")

    @_builtins.property
    @pulumi.getter(name="userLanguage")
    def user_language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When generating cache keys, include the client's language type. Possible values:
        """
        return pulumi.get(self, "user_language")

