# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KvNamespaceArgs', 'KvNamespace']

@pulumi.input_type
class KvNamespaceArgs:
    def __init__(__self__, *,
                 kv_namespace: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KvNamespace resource.
        :param pulumi.Input[_builtins.str] kv_namespace: The name of the namespace.
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        """
        pulumi.set(__self__, "kv_namespace", kv_namespace)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="kvNamespace")
    def kv_namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "kv_namespace")

    @kv_namespace.setter
    def kv_namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kv_namespace", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _KvNamespaceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kv_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KvNamespace resources.
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.str] kv_namespace: The name of the namespace.
        :param pulumi.Input[_builtins.str] status: The status of the namespace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kv_namespace is not None:
            pulumi.set(__self__, "kv_namespace", kv_namespace)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="kvNamespace")
    def kv_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "kv_namespace")

    @kv_namespace.setter
    def kv_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kv_namespace", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the namespace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/kvNamespace:KvNamespace")
class KvNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kv_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Kv Namespace resource.

        For information about ESA Kv Namespace and how to use it, see [What is Kv Namespace](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateKvNamespace).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.KvNamespace("default",
            description="this is a example namespace.",
            kv_namespace="example_namespace")
        ```

        ## Import

        ESA Kv Namespace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/kvNamespace:KvNamespace example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.str] kv_namespace: The name of the namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KvNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Kv Namespace resource.

        For information about ESA Kv Namespace and how to use it, see [What is Kv Namespace](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateKvNamespace).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.KvNamespace("default",
            description="this is a example namespace.",
            kv_namespace="example_namespace")
        ```

        ## Import

        ESA Kv Namespace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/kvNamespace:KvNamespace example <id>
        ```

        :param str resource_name: The name of the resource.
        :param KvNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KvNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kv_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KvNamespaceArgs.__new__(KvNamespaceArgs)

            __props__.__dict__["description"] = description
            if kv_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'kv_namespace'")
            __props__.__dict__["kv_namespace"] = kv_namespace
            __props__.__dict__["status"] = None
        super(KvNamespace, __self__).__init__(
            'alicloud:esa/kvNamespace:KvNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            kv_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'KvNamespace':
        """
        Get an existing KvNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.str] kv_namespace: The name of the namespace.
        :param pulumi.Input[_builtins.str] status: The status of the namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KvNamespaceState.__new__(_KvNamespaceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["kv_namespace"] = kv_namespace
        __props__.__dict__["status"] = status
        return KvNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="kvNamespace")
    def kv_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "kv_namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the namespace.
        """
        return pulumi.get(self, "status")

