# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecordArgs', 'Record']

@pulumi.input_type
class RecordArgs:
    def __init__(__self__, *,
                 data: pulumi.Input['RecordDataArgs'],
                 record_name: pulumi.Input[_builtins.str],
                 record_type: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 auth_conf: Optional[pulumi.Input['RecordAuthConfArgs']] = None,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 host_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Record resource.
        :param pulumi.Input['RecordDataArgs'] data: The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        :param pulumi.Input[_builtins.str] record_name: The record name. This parameter specifies a filter condition for the query.
        :param pulumi.Input[_builtins.str] record_type: The DNS record type.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input['RecordAuthConfArgs'] auth_conf: The origin authentication information of the CNAME record. See `auth_conf` below.
        :param pulumi.Input[_builtins.str] biz_name: The business scenario of the record for acceleration. Valid values:
        :param pulumi.Input[_builtins.str] comment: The comments of the record.
        :param pulumi.Input[_builtins.str] host_policy: The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        :param pulumi.Input[_builtins.bool] proxied: Filters by whether the record is proxied. Valid values:
        :param pulumi.Input[_builtins.str] source_type: The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:
               
               - `OSS`: OSS bucket.
               - `S3`: S3 bucket.
               - `LB`: load balancer.
               - `OP`: origin pool.
               - `Domain`: domain name.
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "record_name", record_name)
        pulumi.set(__self__, "record_type", record_type)
        pulumi.set(__self__, "site_id", site_id)
        if auth_conf is not None:
            pulumi.set(__self__, "auth_conf", auth_conf)
        if biz_name is not None:
            pulumi.set(__self__, "biz_name", biz_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if host_policy is not None:
            pulumi.set(__self__, "host_policy", host_policy)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Input['RecordDataArgs']:
        """
        The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input['RecordDataArgs']):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> pulumi.Input[_builtins.str]:
        """
        The record name. This parameter specifies a filter condition for the query.
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "record_name", value)

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> pulumi.Input[_builtins.str]:
        """
        The DNS record type.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "record_type", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="authConf")
    def auth_conf(self) -> Optional[pulumi.Input['RecordAuthConfArgs']]:
        """
        The origin authentication information of the CNAME record. See `auth_conf` below.
        """
        return pulumi.get(self, "auth_conf")

    @auth_conf.setter
    def auth_conf(self, value: Optional[pulumi.Input['RecordAuthConfArgs']]):
        pulumi.set(self, "auth_conf", value)

    @_builtins.property
    @pulumi.getter(name="bizName")
    def biz_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The business scenario of the record for acceleration. Valid values:
        """
        return pulumi.get(self, "biz_name")

    @biz_name.setter
    def biz_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "biz_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comments of the record.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="hostPolicy")
    def host_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        """
        return pulumi.get(self, "host_policy")

    @host_policy.setter
    def host_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_policy", value)

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Filters by whether the record is proxied. Valid values:
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxied", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:

        - `OSS`: OSS bucket.
        - `S3`: S3 bucket.
        - `LB`: load balancer.
        - `OP`: origin pool.
        - `Domain`: domain name.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _RecordState:
    def __init__(__self__, *,
                 auth_conf: Optional[pulumi.Input['RecordAuthConfArgs']] = None,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input['RecordDataArgs']] = None,
                 host_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Record resources.
        :param pulumi.Input['RecordAuthConfArgs'] auth_conf: The origin authentication information of the CNAME record. See `auth_conf` below.
        :param pulumi.Input[_builtins.str] biz_name: The business scenario of the record for acceleration. Valid values:
        :param pulumi.Input[_builtins.str] comment: The comments of the record.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the record. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        :param pulumi.Input['RecordDataArgs'] data: The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        :param pulumi.Input[_builtins.str] host_policy: The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        :param pulumi.Input[_builtins.bool] proxied: Filters by whether the record is proxied. Valid values:
        :param pulumi.Input[_builtins.str] record_name: The record name. This parameter specifies a filter condition for the query.
        :param pulumi.Input[_builtins.str] record_type: The DNS record type.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.str] source_type: The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:
               
               - `OSS`: OSS bucket.
               - `S3`: S3 bucket.
               - `LB`: load balancer.
               - `OP`: origin pool.
               - `Domain`: domain name.
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        if auth_conf is not None:
            pulumi.set(__self__, "auth_conf", auth_conf)
        if biz_name is not None:
            pulumi.set(__self__, "biz_name", biz_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if host_policy is not None:
            pulumi.set(__self__, "host_policy", host_policy)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="authConf")
    def auth_conf(self) -> Optional[pulumi.Input['RecordAuthConfArgs']]:
        """
        The origin authentication information of the CNAME record. See `auth_conf` below.
        """
        return pulumi.get(self, "auth_conf")

    @auth_conf.setter
    def auth_conf(self, value: Optional[pulumi.Input['RecordAuthConfArgs']]):
        pulumi.set(self, "auth_conf", value)

    @_builtins.property
    @pulumi.getter(name="bizName")
    def biz_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The business scenario of the record for acceleration. Valid values:
        """
        return pulumi.get(self, "biz_name")

    @biz_name.setter
    def biz_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "biz_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comments of the record.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the record. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input['RecordDataArgs']]:
        """
        The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input['RecordDataArgs']]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="hostPolicy")
    def host_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        """
        return pulumi.get(self, "host_policy")

    @host_policy.setter
    def host_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_policy", value)

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Filters by whether the record is proxied. Valid values:
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxied", value)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The record name. This parameter specifies a filter condition for the query.
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_name", value)

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS record type.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_type", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:

        - `OSS`: OSS bucket.
        - `S3`: S3 bucket.
        - `LB`: load balancer.
        - `OP`: origin pool.
        - `Domain`: domain name.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("alicloud:esa/record:Record")
class Record(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_conf: Optional[pulumi.Input[Union['RecordAuthConfArgs', 'RecordAuthConfArgsDict']]] = None,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']]] = None,
                 host_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Record resource.

        For information about ESA Record and how to use it, see [What is Record](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/user-guide/add-parsing-record/).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.RatePlanInstance("default",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default_site = alicloud.esa.Site("default",
            site_name="idlexamplerecord.com",
            instance_id=default.id,
            coverage="overseas",
            access_type="NS")
        default_record = alicloud.esa.Record("default",
            data={
                "value": "www.eerrraaa.com",
                "weight": 1,
                "priority": 1,
                "port": 80,
            },
            ttl=100,
            record_name="_udp._sip.idlexamplerecord.com",
            comment="This is a remark",
            site_id=default_site.id,
            record_type="SRV")
        ```

        ## Import

        ESA Record can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/record:Record example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RecordAuthConfArgs', 'RecordAuthConfArgsDict']] auth_conf: The origin authentication information of the CNAME record. See `auth_conf` below.
        :param pulumi.Input[_builtins.str] biz_name: The business scenario of the record for acceleration. Valid values:
        :param pulumi.Input[_builtins.str] comment: The comments of the record.
        :param pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']] data: The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        :param pulumi.Input[_builtins.str] host_policy: The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        :param pulumi.Input[_builtins.bool] proxied: Filters by whether the record is proxied. Valid values:
        :param pulumi.Input[_builtins.str] record_name: The record name. This parameter specifies a filter condition for the query.
        :param pulumi.Input[_builtins.str] record_type: The DNS record type.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.str] source_type: The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:
               
               - `OSS`: OSS bucket.
               - `S3`: S3 bucket.
               - `LB`: load balancer.
               - `OP`: origin pool.
               - `Domain`: domain name.
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Record resource.

        For information about ESA Record and how to use it, see [What is Record](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/user-guide/add-parsing-record/).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.RatePlanInstance("default",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default_site = alicloud.esa.Site("default",
            site_name="idlexamplerecord.com",
            instance_id=default.id,
            coverage="overseas",
            access_type="NS")
        default_record = alicloud.esa.Record("default",
            data={
                "value": "www.eerrraaa.com",
                "weight": 1,
                "priority": 1,
                "port": 80,
            },
            ttl=100,
            record_name="_udp._sip.idlexamplerecord.com",
            comment="This is a remark",
            site_id=default_site.id,
            record_type="SRV")
        ```

        ## Import

        ESA Record can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/record:Record example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_conf: Optional[pulumi.Input[Union['RecordAuthConfArgs', 'RecordAuthConfArgsDict']]] = None,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']]] = None,
                 host_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 proxied: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 record_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordArgs.__new__(RecordArgs)

            __props__.__dict__["auth_conf"] = auth_conf
            __props__.__dict__["biz_name"] = biz_name
            __props__.__dict__["comment"] = comment
            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            __props__.__dict__["host_policy"] = host_policy
            __props__.__dict__["proxied"] = proxied
            if record_name is None and not opts.urn:
                raise TypeError("Missing required property 'record_name'")
            __props__.__dict__["record_name"] = record_name
            if record_type is None and not opts.urn:
                raise TypeError("Missing required property 'record_type'")
            __props__.__dict__["record_type"] = record_type
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["create_time"] = None
        super(Record, __self__).__init__(
            'alicloud:esa/record:Record',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_conf: Optional[pulumi.Input[Union['RecordAuthConfArgs', 'RecordAuthConfArgsDict']]] = None,
            biz_name: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data: Optional[pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']]] = None,
            host_policy: Optional[pulumi.Input[_builtins.str]] = None,
            proxied: Optional[pulumi.Input[_builtins.bool]] = None,
            record_name: Optional[pulumi.Input[_builtins.str]] = None,
            record_type: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'Record':
        """
        Get an existing Record resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RecordAuthConfArgs', 'RecordAuthConfArgsDict']] auth_conf: The origin authentication information of the CNAME record. See `auth_conf` below.
        :param pulumi.Input[_builtins.str] biz_name: The business scenario of the record for acceleration. Valid values:
        :param pulumi.Input[_builtins.str] comment: The comments of the record.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the record. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        :param pulumi.Input[Union['RecordDataArgs', 'RecordDataArgsDict']] data: The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        :param pulumi.Input[_builtins.str] host_policy: The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        :param pulumi.Input[_builtins.bool] proxied: Filters by whether the record is proxied. Valid values:
        :param pulumi.Input[_builtins.str] record_name: The record name. This parameter specifies a filter condition for the query.
        :param pulumi.Input[_builtins.str] record_type: The DNS record type.
        :param pulumi.Input[_builtins.int] site_id: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.str] source_type: The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:
               
               - `OSS`: OSS bucket.
               - `S3`: S3 bucket.
               - `LB`: load balancer.
               - `OP`: origin pool.
               - `Domain`: domain name.
        :param pulumi.Input[_builtins.int] ttl: The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordState.__new__(_RecordState)

        __props__.__dict__["auth_conf"] = auth_conf
        __props__.__dict__["biz_name"] = biz_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data"] = data
        __props__.__dict__["host_policy"] = host_policy
        __props__.__dict__["proxied"] = proxied
        __props__.__dict__["record_name"] = record_name
        __props__.__dict__["record_type"] = record_type
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["ttl"] = ttl
        return Record(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authConf")
    def auth_conf(self) -> pulumi.Output[Optional['outputs.RecordAuthConf']]:
        """
        The origin authentication information of the CNAME record. See `auth_conf` below.
        """
        return pulumi.get(self, "auth_conf")

    @_builtins.property
    @pulumi.getter(name="bizName")
    def biz_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The business scenario of the record for acceleration. Valid values:
        """
        return pulumi.get(self, "biz_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The comments of the record.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the record. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output['outputs.RecordData']:
        """
        The DNS record information. The format of this field varies based on the record type. For more information, see [Add DNS records](https://www.alibabacloud.com/help/doc-detail/2708761.html). See `data` below.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="hostPolicy")
    def host_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        """
        return pulumi.get(self, "host_policy")

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Filters by whether the record is proxied. Valid values:
        """
        return pulumi.get(self, "proxied")

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> pulumi.Output[_builtins.str]:
        """
        The record name. This parameter specifies a filter condition for the query.
        """
        return pulumi.get(self, "record_name")

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS record type.
        """
        return pulumi.get(self, "record_type")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:

        - `OSS`: OSS bucket.
        - `S3`: S3 bucket.
        - `LB`: load balancer.
        - `OP`: origin pool.
        - `Domain`: domain name.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The TTL of the record. Unit: seconds. The range is 30 to 86,400, or 1. If the value is 1, the TTL of the record is determined by the system.
        """
        return pulumi.get(self, "ttl")

