# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApiDestinationHttpApiParameters',
    'ConnectionAuthParameters',
    'ConnectionAuthParametersApiKeyAuthParameters',
    'ConnectionAuthParametersBasicAuthParameters',
    'ConnectionAuthParametersOauthParameters',
    'ConnectionAuthParametersOauthParametersClientParameters',
    'ConnectionAuthParametersOauthParametersOauthHttpParameters',
    'ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter',
    'ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter',
    'ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter',
    'ConnectionNetworkParameters',
    'RuleTarget',
    'RuleTargetDeadLetterQueue',
    'RuleTargetParamList',
    'GetEventBusesBusResult',
    'GetEventSourcesSourceResult',
    'GetRulesRuleResult',
    'GetRulesRuleTargetResult',
]

@pulumi.output_type
class ApiDestinationHttpApiParameters(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 method: _builtins.str):
        """
        :param _builtins.str endpoint: The endpoint of the API destination.
        :param _builtins.str method: The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "method", method)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint of the API destination.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class ConnectionAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyAuthParameters":
            suggest = "api_key_auth_parameters"
        elif key == "authorizationType":
            suggest = "authorization_type"
        elif key == "basicAuthParameters":
            suggest = "basic_auth_parameters"
        elif key == "oauthParameters":
            suggest = "oauth_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_auth_parameters: Optional['outputs.ConnectionAuthParametersApiKeyAuthParameters'] = None,
                 authorization_type: Optional[_builtins.str] = None,
                 basic_auth_parameters: Optional['outputs.ConnectionAuthParametersBasicAuthParameters'] = None,
                 oauth_parameters: Optional['outputs.ConnectionAuthParametersOauthParameters'] = None):
        """
        :param 'ConnectionAuthParametersApiKeyAuthParametersArgs' api_key_auth_parameters: The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
        :param _builtins.str authorization_type: The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
        :param 'ConnectionAuthParametersBasicAuthParametersArgs' basic_auth_parameters: The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
        :param 'ConnectionAuthParametersOauthParametersArgs' oauth_parameters: The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
        """
        if api_key_auth_parameters is not None:
            pulumi.set(__self__, "api_key_auth_parameters", api_key_auth_parameters)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if basic_auth_parameters is not None:
            pulumi.set(__self__, "basic_auth_parameters", basic_auth_parameters)
        if oauth_parameters is not None:
            pulumi.set(__self__, "oauth_parameters", oauth_parameters)

    @_builtins.property
    @pulumi.getter(name="apiKeyAuthParameters")
    def api_key_auth_parameters(self) -> Optional['outputs.ConnectionAuthParametersApiKeyAuthParameters']:
        """
        The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
        """
        return pulumi.get(self, "api_key_auth_parameters")

    @_builtins.property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[_builtins.str]:
        """
        The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
        """
        return pulumi.get(self, "authorization_type")

    @_builtins.property
    @pulumi.getter(name="basicAuthParameters")
    def basic_auth_parameters(self) -> Optional['outputs.ConnectionAuthParametersBasicAuthParameters']:
        """
        The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
        """
        return pulumi.get(self, "basic_auth_parameters")

    @_builtins.property
    @pulumi.getter(name="oauthParameters")
    def oauth_parameters(self) -> Optional['outputs.ConnectionAuthParametersOauthParameters']:
        """
        The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
        """
        return pulumi.get(self, "oauth_parameters")


@pulumi.output_type
class ConnectionAuthParametersApiKeyAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyName":
            suggest = "api_key_name"
        elif key == "apiKeyValue":
            suggest = "api_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersApiKeyAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersApiKeyAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersApiKeyAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_name: Optional[_builtins.str] = None,
                 api_key_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_key_name: The name of the API key.
        :param _builtins.str api_key_value: The value of the API key.
        """
        if api_key_name is not None:
            pulumi.set(__self__, "api_key_name", api_key_name)
        if api_key_value is not None:
            pulumi.set(__self__, "api_key_value", api_key_value)

    @_builtins.property
    @pulumi.getter(name="apiKeyName")
    def api_key_name(self) -> Optional[_builtins.str]:
        """
        The name of the API key.
        """
        return pulumi.get(self, "api_key_name")

    @_builtins.property
    @pulumi.getter(name="apiKeyValue")
    def api_key_value(self) -> Optional[_builtins.str]:
        """
        The value of the API key.
        """
        return pulumi.get(self, "api_key_value")


@pulumi.output_type
class ConnectionAuthParametersBasicAuthParameters(dict):
    def __init__(__self__, *,
                 password: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The password for basic authentication.
        :param _builtins.str username: The username for basic authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for basic authentication.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username for basic authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionAuthParametersOauthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientParameters":
            suggest = "client_parameters"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "oauthHttpParameters":
            suggest = "oauth_http_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: Optional[_builtins.str] = None,
                 client_parameters: Optional['outputs.ConnectionAuthParametersOauthParametersClientParameters'] = None,
                 http_method: Optional[_builtins.str] = None,
                 oauth_http_parameters: Optional['outputs.ConnectionAuthParametersOauthParametersOauthHttpParameters'] = None):
        """
        :param _builtins.str authorization_endpoint: The IP address of the authorized endpoint.
        :param 'ConnectionAuthParametersOauthParametersClientParametersArgs' client_parameters: The parameters that are configured for the client. See `client_parameters` below.
        :param _builtins.str http_method: The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        :param 'ConnectionAuthParametersOauthParametersOauthHttpParametersArgs' oauth_http_parameters: The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
        """
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if client_parameters is not None:
            pulumi.set(__self__, "client_parameters", client_parameters)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if oauth_http_parameters is not None:
            pulumi.set(__self__, "oauth_http_parameters", oauth_http_parameters)

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[_builtins.str]:
        """
        The IP address of the authorized endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @_builtins.property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> Optional['outputs.ConnectionAuthParametersOauthParametersClientParameters']:
        """
        The parameters that are configured for the client. See `client_parameters` below.
        """
        return pulumi.get(self, "client_parameters")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[_builtins.str]:
        """
        The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        """
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="oauthHttpParameters")
    def oauth_http_parameters(self) -> Optional['outputs.ConnectionAuthParametersOauthParametersOauthHttpParameters']:
        """
        The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
        """
        return pulumi.get(self, "oauth_http_parameters")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersClientParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersClientParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersClientParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersClientParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 client_secret: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: The ID of the client.
        :param _builtins.str client_secret: The AccessKey secret of the client.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        The AccessKey secret of the client.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyParameters":
            suggest = "body_parameters"
        elif key == "headerParameters":
            suggest = "header_parameters"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_parameters: Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter']] = None,
                 header_parameters: Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter']] = None,
                 query_string_parameters: Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter']] = None):
        """
        :param Sequence['ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs'] body_parameters: The parameters that are configured for the request body. See `body_parameters` below.
        :param Sequence['ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs'] header_parameters: The parameters that are configured for the request header. See `header_parameters` below.
        :param Sequence['ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs'] query_string_parameters: The parameters that are configured for the request path. See `query_string_parameters` below.
        """
        if body_parameters is not None:
            pulumi.set(__self__, "body_parameters", body_parameters)
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @_builtins.property
    @pulumi.getter(name="bodyParameters")
    def body_parameters(self) -> Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter']]:
        """
        The parameters that are configured for the request body. See `body_parameters` below.
        """
        return pulumi.get(self, "body_parameters")

    @_builtins.property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter']]:
        """
        The parameters that are configured for the request header. See `header_parameters` below.
        """
        return pulumi.get(self, "header_parameters")

    @_builtins.property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter']]:
        """
        The parameters that are configured for the request path. See `query_string_parameters` below.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str is_value_secret: Specifies whether to enable authentication.
        :param _builtins.str key: The key of the request path.
        :param _builtins.str value: The key of the request path.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.str]:
        """
        Specifies whether to enable authentication.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str is_value_secret: Specifies whether to enable authentication.
        :param _builtins.str key: The key of the request path.
        :param _builtins.str value: The key of the request path.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.str]:
        """
        Specifies whether to enable authentication.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str is_value_secret: Specifies whether to enable authentication.
        :param _builtins.str key: The key of the request path.
        :param _builtins.str value: The key of the request path.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.str]:
        """
        Specifies whether to enable authentication.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionNetworkParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkType":
            suggest = "network_type"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitcheId":
            suggest = "vswitche_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionNetworkParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionNetworkParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionNetworkParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_type: _builtins.str,
                 security_group_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitche_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str network_type: The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
        :param _builtins.str security_group_id: The ID of the security group.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitche_id: The ID of the VSwitch.
        """
        pulumi.set(__self__, "network_type", network_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitche_id is not None:
            pulumi.set(__self__, "vswitche_id", vswitche_id)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitcheId")
    def vswitche_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VSwitch.
        """
        return pulumi.get(self, "vswitche_id")


@pulumi.output_type
class RuleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramLists":
            suggest = "param_lists"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "deadLetterQueue":
            suggest = "dead_letter_queue"
        elif key == "pushRetryStrategy":
            suggest = "push_retry_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 param_lists: Sequence['outputs.RuleTargetParamList'],
                 target_id: _builtins.str,
                 type: _builtins.str,
                 dead_letter_queue: Optional['outputs.RuleTargetDeadLetterQueue'] = None,
                 push_retry_strategy: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: The endpoint of the event target.
        :param Sequence['RuleTargetParamListArgs'] param_lists: The parameters that are configured for the event target. See `param_list` below.
        :param _builtins.str target_id: The ID of the custom event target.
        :param _builtins.str type: The type of the event target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
               **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
        :param 'RuleTargetDeadLetterQueueArgs' dead_letter_queue: The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
        :param _builtins.str push_retry_strategy: The retry policy that is used to push the event. Valid values:
               - `BACKOFF_RETRY`: Backoff retry. The request can be retried up to three times. The interval between two consecutive retries is a random value between 10 and 20 seconds.
               - `EXPONENTIAL_DECAY_RETRY`: Exponential decay retry. The request can be retried up to 176 times. The interval between two consecutive retries exponentially increases to 512 seconds, and the total retry time is one day. The specific retry intervals are 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, ..., and 512 seconds, including a maximum of one hundred and sixty-seven 512 seconds in total.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "param_lists", param_lists)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "type", type)
        if dead_letter_queue is not None:
            pulumi.set(__self__, "dead_letter_queue", dead_letter_queue)
        if push_retry_strategy is not None:
            pulumi.set(__self__, "push_retry_strategy", push_retry_strategy)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint of the event target.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="paramLists")
    def param_lists(self) -> Sequence['outputs.RuleTargetParamList']:
        """
        The parameters that are configured for the event target. See `param_list` below.
        """
        return pulumi.get(self, "param_lists")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The ID of the custom event target.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the event target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
        **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> Optional['outputs.RuleTargetDeadLetterQueue']:
        """
        The dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
        """
        return pulumi.get(self, "dead_letter_queue")

    @_builtins.property
    @pulumi.getter(name="pushRetryStrategy")
    def push_retry_strategy(self) -> Optional[_builtins.str]:
        """
        The retry policy that is used to push the event. Valid values:
        - `BACKOFF_RETRY`: Backoff retry. The request can be retried up to three times. The interval between two consecutive retries is a random value between 10 and 20 seconds.
        - `EXPONENTIAL_DECAY_RETRY`: Exponential decay retry. The request can be retried up to 176 times. The interval between two consecutive retries exponentially increases to 512 seconds, and the total retry time is one day. The specific retry intervals are 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, ..., and 512 seconds, including a maximum of one hundred and sixty-seven 512 seconds in total.
        """
        return pulumi.get(self, "push_retry_strategy")


@pulumi.output_type
class RuleTargetDeadLetterQueue(dict):
    def __init__(__self__, *,
                 arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn: The Alibaba Cloud Resource Name (ARN) of the dead letter queue. Events that are not processed or whose maximum retries are exceeded are written to the dead-letter queue. The ARN feature is supported by the following queue types: MNS and Message Queue for Apache RocketMQ.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[_builtins.str]:
        """
        The Alibaba Cloud Resource Name (ARN) of the dead letter queue. Events that are not processed or whose maximum retries are exceeded are written to the dead-letter queue. The ARN feature is supported by the following queue types: MNS and Message Queue for Apache RocketMQ.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class RuleTargetParamList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceKey":
            suggest = "resource_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTargetParamList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTargetParamList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTargetParamList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 form: _builtins.str,
                 resource_key: _builtins.str,
                 template: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str form: The format of the event target parameter. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
        :param _builtins.str resource_key: The resource parameter of the event target. For more information, see [How to use it](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
        :param _builtins.str template: The template of the event target parameter.
        :param _builtins.str value: The value of the event target parameter.
               
               > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:
               
               ```
               param_list {
               resource_key = "IsBase64Encode"
               form         = "CONSTANT"
               value        = "false"
               template     = ""
               }
               ```
               
               In order to fix the diff, from version 1.160.0, this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
               If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
        """
        pulumi.set(__self__, "form", form)
        pulumi.set(__self__, "resource_key", resource_key)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def form(self) -> _builtins.str:
        """
        The format of the event target parameter. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
        """
        return pulumi.get(self, "form")

    @_builtins.property
    @pulumi.getter(name="resourceKey")
    def resource_key(self) -> _builtins.str:
        """
        The resource parameter of the event target. For more information, see [How to use it](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
        """
        return pulumi.get(self, "resource_key")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[_builtins.str]:
        """
        The template of the event target parameter.
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the event target parameter.

        > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:

        ```
        param_list {
        resource_key = "IsBase64Encode"
        form         = "CONSTANT"
        value        = "false"
        template     = ""
        }
        ```

        In order to fix the diff, from version 1.160.0, this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
        If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetEventBusesBusResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 event_bus_name: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str create_time: The time of this bus was created.
        :param _builtins.str description: The description of event bus.
        :param _builtins.str event_bus_name: The name of event bus.
        :param _builtins.str id: The ID of the Event Bus. Its value is same as Queue Name.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_bus_name", event_bus_name)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time of this bus was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of event bus.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> _builtins.str:
        """
        The name of event bus.
        """
        return pulumi.get(self, "event_bus_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Event Bus. Its value is same as Queue Name.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetEventSourcesSourceResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 event_source_name: _builtins.str,
                 external_source_config: Mapping[str, _builtins.str],
                 external_source_type: _builtins.str,
                 id: _builtins.str,
                 linked_external_source: _builtins.bool,
                 type: _builtins.str):
        """
        :param _builtins.str description: The detail describe of event source.
        :param _builtins.str event_source_name: The code name of event source.
        :param Mapping[str, _builtins.str] external_source_config: The config of external data source.
        :param _builtins.str external_source_type: The type of external data source.
        :param _builtins.str id: The ID of the Event Source.
        :param _builtins.bool linked_external_source: Whether to connect to an external data source.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_source_name", event_source_name)
        pulumi.set(__self__, "external_source_config", external_source_config)
        pulumi.set(__self__, "external_source_type", external_source_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "linked_external_source", linked_external_source)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The detail describe of event source.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> _builtins.str:
        """
        The code name of event source.
        """
        return pulumi.get(self, "event_source_name")

    @_builtins.property
    @pulumi.getter(name="externalSourceConfig")
    def external_source_config(self) -> Mapping[str, _builtins.str]:
        """
        The config of external data source.
        """
        return pulumi.get(self, "external_source_config")

    @_builtins.property
    @pulumi.getter(name="externalSourceType")
    def external_source_type(self) -> _builtins.str:
        """
        The type of external data source.
        """
        return pulumi.get(self, "external_source_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Event Source.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="linkedExternalSource")
    def linked_external_source(self) -> _builtins.bool:
        """
        Whether to connect to an external data source.
        """
        return pulumi.get(self, "linked_external_source")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRulesRuleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 event_bus_name: _builtins.str,
                 filter_pattern: _builtins.str,
                 id: _builtins.str,
                 rule_name: _builtins.str,
                 status: _builtins.str,
                 targets: Sequence['outputs.GetRulesRuleTargetResult']):
        """
        :param _builtins.str description: The description of rule.
        :param _builtins.str event_bus_name: The name of event bus.
        :param _builtins.str filter_pattern: The pattern to match interested events.
        :param _builtins.str id: The ID of the Rule.
        :param _builtins.str rule_name: The name of rule.
        :param _builtins.str status: Rule status, either Enable or Disable.
        :param Sequence['GetRulesRuleTargetArgs'] targets: The target for rule.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_bus_name", event_bus_name)
        pulumi.set(__self__, "filter_pattern", filter_pattern)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "targets", targets)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> _builtins.str:
        """
        The name of event bus.
        """
        return pulumi.get(self, "event_bus_name")

    @_builtins.property
    @pulumi.getter(name="filterPattern")
    def filter_pattern(self) -> _builtins.str:
        """
        The pattern to match interested events.
        """
        return pulumi.get(self, "filter_pattern")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        The name of rule.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Rule status, either Enable or Disable.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetRulesRuleTargetResult']:
        """
        The target for rule.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetRulesRuleTargetResult(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 target_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str endpoint: The endpoint.
        :param _builtins.str target_id: The id of target.
        :param _builtins.str type: The type of target.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The id of target.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of target.
        """
        return pulumi.get(self, "type")


