# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterVpcAssociationArgs', 'RouterVpcAssociation']

@pulumi.input_type
class RouterVpcAssociationArgs:
    def __init__(__self__, *,
                 association_region_id: pulumi.Input[_builtins.str],
                 ecr_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RouterVpcAssociation resource.
        :param pulumi.Input[_builtins.str] association_region_id: The region ID of the resource to be associated.
        :param pulumi.Input[_builtins.str] ecr_id: The ECR ID.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: The list of allowed route prefixes.
        :param pulumi.Input[_builtins.int] vpc_owner_id: The ID of the Alibaba Cloud account that owns the VPC.
               > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        pulumi.set(__self__, "association_region_id", association_region_id)
        pulumi.set(__self__, "ecr_id", ecr_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if allowed_prefixes is not None:
            pulumi.set(__self__, "allowed_prefixes", allowed_prefixes)
        if vpc_owner_id is not None:
            pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)

    @_builtins.property
    @pulumi.getter(name="associationRegionId")
    def association_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID of the resource to be associated.
        """
        return pulumi.get(self, "association_region_id")

    @association_region_id.setter
    def association_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "association_region_id", value)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ECR ID.
        """
        return pulumi.get(self, "ecr_id")

    @ecr_id.setter
    def ecr_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ecr_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of allowed route prefixes.
        """
        return pulumi.get(self, "allowed_prefixes")

    @allowed_prefixes.setter
    def allowed_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account that owns the VPC.
        > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        return pulumi.get(self, "vpc_owner_id")

    @vpc_owner_id.setter
    def vpc_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_owner_id", value)


@pulumi.input_type
class _RouterVpcAssociationState:
    def __init__(__self__, *,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RouterVpcAssociation resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: The list of allowed route prefixes.
        :param pulumi.Input[_builtins.str] association_id: The ID of the association between the ECR and the VPC.
        :param pulumi.Input[_builtins.str] association_region_id: The region ID of the resource to be associated.
        :param pulumi.Input[_builtins.str] create_time: The time when the association was created.
        :param pulumi.Input[_builtins.str] ecr_id: The ECR ID.
        :param pulumi.Input[_builtins.str] status: The deployment state of the associated resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.int] vpc_owner_id: The ID of the Alibaba Cloud account that owns the VPC.
               > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        if allowed_prefixes is not None:
            pulumi.set(__self__, "allowed_prefixes", allowed_prefixes)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if association_region_id is not None:
            pulumi.set(__self__, "association_region_id", association_region_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ecr_id is not None:
            pulumi.set(__self__, "ecr_id", ecr_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_owner_id is not None:
            pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of allowed route prefixes.
        """
        return pulumi.get(self, "allowed_prefixes")

    @allowed_prefixes.setter
    def allowed_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the association between the ECR and the VPC.
        """
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_id", value)

    @_builtins.property
    @pulumi.getter(name="associationRegionId")
    def association_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource to be associated.
        """
        return pulumi.get(self, "association_region_id")

    @association_region_id.setter
    def association_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "association_region_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the association was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ECR ID.
        """
        return pulumi.get(self, "ecr_id")

    @ecr_id.setter
    def ecr_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecr_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment state of the associated resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account that owns the VPC.
        > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        return pulumi.get(self, "vpc_owner_id")

    @vpc_owner_id.setter
    def vpc_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_owner_id", value)


@pulumi.type_token("alicloud:expressconnect/routerVpcAssociation:RouterVpcAssociation")
class RouterVpcAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Express Connect Router Express Connect Router Vpc Association resource. Bind relationship object between leased line gateway and VPC.

        For information about Express Connect Router Express Connect Router Vpc Association and how to use it, see [What is Express Connect Router Vpc Association](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-expressconnectrouter-2023-09-01-createexpressconnectrouterassociation).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default8q_at_d6 = alicloud.vpc.Network("default8qAtD6", cidr_block="172.16.0.0/16")
        default_m9_yx_gw = alicloud.expressconnect.RouterExpressConnectRouter("defaultM9YxGW", alibaba_side_asn=65533)
        current = alicloud.get_account()
        default = alicloud.expressconnect.RouterVpcAssociation("default",
            ecr_id=default_m9_yx_gw.id,
            allowed_prefixes=[
                "172.16.4.0/24",
                "172.16.3.0/24",
                "172.16.2.0/24",
                "172.16.1.0/24",
            ],
            vpc_owner_id=current.id,
            association_region_id="cn-hangzhou",
            vpc_id=default8q_at_d6.id)
        ```

        ## Import

        Express Connect Router Express Connect Router Vpc Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerVpcAssociation:RouterVpcAssociation example <ecr_id>:<association_id>:<vpc_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: The list of allowed route prefixes.
        :param pulumi.Input[_builtins.str] association_region_id: The region ID of the resource to be associated.
        :param pulumi.Input[_builtins.str] ecr_id: The ECR ID.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.int] vpc_owner_id: The ID of the Alibaba Cloud account that owns the VPC.
               > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterVpcAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Router Express Connect Router Vpc Association resource. Bind relationship object between leased line gateway and VPC.

        For information about Express Connect Router Express Connect Router Vpc Association and how to use it, see [What is Express Connect Router Vpc Association](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-expressconnectrouter-2023-09-01-createexpressconnectrouterassociation).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default8q_at_d6 = alicloud.vpc.Network("default8qAtD6", cidr_block="172.16.0.0/16")
        default_m9_yx_gw = alicloud.expressconnect.RouterExpressConnectRouter("defaultM9YxGW", alibaba_side_asn=65533)
        current = alicloud.get_account()
        default = alicloud.expressconnect.RouterVpcAssociation("default",
            ecr_id=default_m9_yx_gw.id,
            allowed_prefixes=[
                "172.16.4.0/24",
                "172.16.3.0/24",
                "172.16.2.0/24",
                "172.16.1.0/24",
            ],
            vpc_owner_id=current.id,
            association_region_id="cn-hangzhou",
            vpc_id=default8q_at_d6.id)
        ```

        ## Import

        Express Connect Router Express Connect Router Vpc Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerVpcAssociation:RouterVpcAssociation example <ecr_id>:<association_id>:<vpc_id>
        ```

        :param str resource_name: The name of the resource.
        :param RouterVpcAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterVpcAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterVpcAssociationArgs.__new__(RouterVpcAssociationArgs)

            __props__.__dict__["allowed_prefixes"] = allowed_prefixes
            if association_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'association_region_id'")
            __props__.__dict__["association_region_id"] = association_region_id
            if ecr_id is None and not opts.urn:
                raise TypeError("Missing required property 'ecr_id'")
            __props__.__dict__["ecr_id"] = ecr_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpc_owner_id"] = vpc_owner_id
            __props__.__dict__["association_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(RouterVpcAssociation, __self__).__init__(
            'alicloud:expressconnect/routerVpcAssociation:RouterVpcAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            association_id: Optional[pulumi.Input[_builtins.str]] = None,
            association_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'RouterVpcAssociation':
        """
        Get an existing RouterVpcAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_prefixes: The list of allowed route prefixes.
        :param pulumi.Input[_builtins.str] association_id: The ID of the association between the ECR and the VPC.
        :param pulumi.Input[_builtins.str] association_region_id: The region ID of the resource to be associated.
        :param pulumi.Input[_builtins.str] create_time: The time when the association was created.
        :param pulumi.Input[_builtins.str] ecr_id: The ECR ID.
        :param pulumi.Input[_builtins.str] status: The deployment state of the associated resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.int] vpc_owner_id: The ID of the Alibaba Cloud account that owns the VPC.
               > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterVpcAssociationState.__new__(_RouterVpcAssociationState)

        __props__.__dict__["allowed_prefixes"] = allowed_prefixes
        __props__.__dict__["association_id"] = association_id
        __props__.__dict__["association_region_id"] = association_region_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ecr_id"] = ecr_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_owner_id"] = vpc_owner_id
        return RouterVpcAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedPrefixes")
    def allowed_prefixes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of allowed route prefixes.
        """
        return pulumi.get(self, "allowed_prefixes")

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the association between the ECR and the VPC.
        """
        return pulumi.get(self, "association_id")

    @_builtins.property
    @pulumi.getter(name="associationRegionId")
    def association_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource to be associated.
        """
        return pulumi.get(self, "association_region_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the association was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ECR ID.
        """
        return pulumi.get(self, "ecr_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The deployment state of the associated resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Alibaba Cloud account that owns the VPC.
        > **NOTE:** If you want to connect to a network instance that belongs to a different account, `vpc_owner_id` is required.
        """
        return pulumi.get(self, "vpc_owner_id")

