# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomRoutingEndpointArgs', 'CustomRoutingEndpoint']

@pulumi.input_type
class CustomRoutingEndpointArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[_builtins.str],
                 endpoint_group_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 traffic_to_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomRoutingEndpoint resource.
        :param pulumi.Input[_builtins.str] endpoint: The ID of the endpoint (vSwitch).
        :param pulumi.Input[_builtins.str] endpoint_group_id: The ID of the endpoint group in which to create endpoints.
        :param pulumi.Input[_builtins.str] type: The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        :param pulumi.Input[_builtins.str] traffic_to_endpoint_policy: The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
               - `DenyAll`: denies all traffic to the endpoint.
               - `AllowAll`: allows all traffic to the endpoint.
               - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "type", type)
        if traffic_to_endpoint_policy is not None:
            pulumi.set(__self__, "traffic_to_endpoint_policy", traffic_to_endpoint_policy)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the endpoint (vSwitch).
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the endpoint group in which to create endpoints.
        """
        return pulumi.get(self, "endpoint_group_id")

    @endpoint_group_id.setter
    def endpoint_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_group_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="trafficToEndpointPolicy")
    def traffic_to_endpoint_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
        - `DenyAll`: denies all traffic to the endpoint.
        - `AllowAll`: allows all traffic to the endpoint.
        - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        """
        return pulumi.get(self, "traffic_to_endpoint_policy")

    @traffic_to_endpoint_policy.setter
    def traffic_to_endpoint_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_to_endpoint_policy", value)


@pulumi.input_type
class _CustomRoutingEndpointState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_routing_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_to_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomRoutingEndpoint resources.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance with which the endpoint is associated.
        :param pulumi.Input[_builtins.str] custom_routing_endpoint_id: The ID of the Custom Routing Endpoint.
        :param pulumi.Input[_builtins.str] endpoint: The ID of the endpoint (vSwitch).
        :param pulumi.Input[_builtins.str] endpoint_group_id: The ID of the endpoint group in which to create endpoints.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener with which the endpoint is associated.
        :param pulumi.Input[_builtins.str] status: The status of the Custom Routing Endpoint.
        :param pulumi.Input[_builtins.str] traffic_to_endpoint_policy: The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
               - `DenyAll`: denies all traffic to the endpoint.
               - `AllowAll`: allows all traffic to the endpoint.
               - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        :param pulumi.Input[_builtins.str] type: The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if custom_routing_endpoint_id is not None:
            pulumi.set(__self__, "custom_routing_endpoint_id", custom_routing_endpoint_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if endpoint_group_id is not None:
            pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if traffic_to_endpoint_policy is not None:
            pulumi.set(__self__, "traffic_to_endpoint_policy", traffic_to_endpoint_policy)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the GA instance with which the endpoint is associated.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="customRoutingEndpointId")
    def custom_routing_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Custom Routing Endpoint.
        """
        return pulumi.get(self, "custom_routing_endpoint_id")

    @custom_routing_endpoint_id.setter
    def custom_routing_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_routing_endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the endpoint (vSwitch).
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the endpoint group in which to create endpoints.
        """
        return pulumi.get(self, "endpoint_group_id")

    @endpoint_group_id.setter
    def endpoint_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_group_id", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the listener with which the endpoint is associated.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Custom Routing Endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="trafficToEndpointPolicy")
    def traffic_to_endpoint_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
        - `DenyAll`: denies all traffic to the endpoint.
        - `AllowAll`: allows all traffic to the endpoint.
        - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        """
        return pulumi.get(self, "traffic_to_endpoint_policy")

    @traffic_to_endpoint_policy.setter
    def traffic_to_endpoint_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_to_endpoint_policy", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:ga/customRoutingEndpoint:CustomRoutingEndpoint")
class CustomRoutingEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_to_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Custom Routing Endpoint resource.

        For information about Global Accelerator (GA) Custom Routing Endpoint and how to use it, see [What is Custom Routing Endpoint](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createcustomroutingendpoints).

        > **NOTE:** Available since v1.197.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_accelerator = alicloud.ga.Accelerator("default",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("default",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            listener_type="CustomRouting",
            port_ranges=[{
                "from_port": 10000,
                "to_port": 16000,
            }])
        default_custom_routing_endpoint_group = alicloud.ga.CustomRoutingEndpointGroup("default",
            accelerator_id=default_listener.accelerator_id,
            listener_id=default_listener.id,
            endpoint_group_region=region,
            custom_routing_endpoint_group_name="terraform-example",
            description="terraform-example")
        default_custom_routing_endpoint = alicloud.ga.CustomRoutingEndpoint("default",
            endpoint_group_id=default_custom_routing_endpoint_group.id,
            endpoint=default_switch.id,
            type="PrivateSubNet",
            traffic_to_endpoint_policy="DenyAll")
        ```

        ## Import

        Global Accelerator (GA) Custom Routing Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/customRoutingEndpoint:CustomRoutingEndpoint example <endpoint_group_id>:<custom_routing_endpoint_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: The ID of the endpoint (vSwitch).
        :param pulumi.Input[_builtins.str] endpoint_group_id: The ID of the endpoint group in which to create endpoints.
        :param pulumi.Input[_builtins.str] traffic_to_endpoint_policy: The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
               - `DenyAll`: denies all traffic to the endpoint.
               - `AllowAll`: allows all traffic to the endpoint.
               - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        :param pulumi.Input[_builtins.str] type: The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomRoutingEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Custom Routing Endpoint resource.

        For information about Global Accelerator (GA) Custom Routing Endpoint and how to use it, see [What is Custom Routing Endpoint](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createcustomroutingendpoints).

        > **NOTE:** Available since v1.197.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_accelerator = alicloud.ga.Accelerator("default",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("default",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            listener_type="CustomRouting",
            port_ranges=[{
                "from_port": 10000,
                "to_port": 16000,
            }])
        default_custom_routing_endpoint_group = alicloud.ga.CustomRoutingEndpointGroup("default",
            accelerator_id=default_listener.accelerator_id,
            listener_id=default_listener.id,
            endpoint_group_region=region,
            custom_routing_endpoint_group_name="terraform-example",
            description="terraform-example")
        default_custom_routing_endpoint = alicloud.ga.CustomRoutingEndpoint("default",
            endpoint_group_id=default_custom_routing_endpoint_group.id,
            endpoint=default_switch.id,
            type="PrivateSubNet",
            traffic_to_endpoint_policy="DenyAll")
        ```

        ## Import

        Global Accelerator (GA) Custom Routing Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/customRoutingEndpoint:CustomRoutingEndpoint example <endpoint_group_id>:<custom_routing_endpoint_id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomRoutingEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomRoutingEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_to_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomRoutingEndpointArgs.__new__(CustomRoutingEndpointArgs)

            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            if endpoint_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_group_id'")
            __props__.__dict__["endpoint_group_id"] = endpoint_group_id
            __props__.__dict__["traffic_to_endpoint_policy"] = traffic_to_endpoint_policy
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["accelerator_id"] = None
            __props__.__dict__["custom_routing_endpoint_id"] = None
            __props__.__dict__["listener_id"] = None
            __props__.__dict__["status"] = None
        super(CustomRoutingEndpoint, __self__).__init__(
            'alicloud:ga/customRoutingEndpoint:CustomRoutingEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_routing_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_to_endpoint_policy: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomRoutingEndpoint':
        """
        Get an existing CustomRoutingEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance with which the endpoint is associated.
        :param pulumi.Input[_builtins.str] custom_routing_endpoint_id: The ID of the Custom Routing Endpoint.
        :param pulumi.Input[_builtins.str] endpoint: The ID of the endpoint (vSwitch).
        :param pulumi.Input[_builtins.str] endpoint_group_id: The ID of the endpoint group in which to create endpoints.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener with which the endpoint is associated.
        :param pulumi.Input[_builtins.str] status: The status of the Custom Routing Endpoint.
        :param pulumi.Input[_builtins.str] traffic_to_endpoint_policy: The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
               - `DenyAll`: denies all traffic to the endpoint.
               - `AllowAll`: allows all traffic to the endpoint.
               - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        :param pulumi.Input[_builtins.str] type: The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomRoutingEndpointState.__new__(_CustomRoutingEndpointState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["custom_routing_endpoint_id"] = custom_routing_endpoint_id
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["endpoint_group_id"] = endpoint_group_id
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["status"] = status
        __props__.__dict__["traffic_to_endpoint_policy"] = traffic_to_endpoint_policy
        __props__.__dict__["type"] = type
        return CustomRoutingEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the GA instance with which the endpoint is associated.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="customRoutingEndpointId")
    def custom_routing_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Custom Routing Endpoint.
        """
        return pulumi.get(self, "custom_routing_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the endpoint (vSwitch).
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the endpoint group in which to create endpoints.
        """
        return pulumi.get(self, "endpoint_group_id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the listener with which the endpoint is associated.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Custom Routing Endpoint.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficToEndpointPolicy")
    def traffic_to_endpoint_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The access policy of traffic to the endpoint. Default value: `DenyAll`. Valid values:
        - `DenyAll`: denies all traffic to the endpoint.
        - `AllowAll`: allows all traffic to the endpoint.
        - `AllowCustom`: allows traffic only to specified destinations in the endpoint.
        """
        return pulumi.get(self, "traffic_to_endpoint_policy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The backend service type of the endpoint. Valid values: `PrivateSubNet`.
        """
        return pulumi.get(self, "type")

