# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainsResult',
    'AwaitableGetDomainsResult',
    'get_domains',
    'get_domains_output',
]

@pulumi.output_type
class GetDomainsResult:
    """
    A collection of values returned by getDomains.
    """
    def __init__(__self__, accelerator_id=None, domain=None, domains=None, id=None, ids=None, output_file=None, page_number=None, page_size=None, status=None):
        if accelerator_id and not isinstance(accelerator_id, str):
            raise TypeError("Expected argument 'accelerator_id' to be a str")
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[_builtins.str]:
        """
        The ID of the global acceleration instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        The accelerated domain name to be added.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.GetDomainsDomainResult']:
        """
        A list of Domain Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")


class AwaitableGetDomainsResult(GetDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsResult(
            accelerator_id=self.accelerator_id,
            domain=self.domain,
            domains=self.domains,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status)


def get_domains(accelerator_id: Optional[_builtins.str] = None,
                domain: Optional[_builtins.str] = None,
                ids: Optional[Sequence[_builtins.str]] = None,
                output_file: Optional[_builtins.str] = None,
                page_number: Optional[_builtins.int] = None,
                page_size: Optional[_builtins.int] = None,
                status: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsResult:
    """
    This data source provides Ga Domain available to the user.[What is Domain](https://www.alibabacloud.com/help/en/global-accelerator/latest/createdomain)

    > **NOTE:** Available since v1.197.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ga.get_accelerators(status="active")
    default_accelerator = []
    def create_default(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            default_accelerator.append(alicloud.ga.Accelerator(f"default-{range['value']}",
                duration=1,
                auto_use_coupon=True,
                spec="1"))

    len(default.accelerators).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
    accelerator_id = pulumi.Output.all(
        length=len(default.accelerators),
        id=default_accelerator[0].id
    ).apply(lambda resolved_outputs: default.accelerators[0].id if resolved_outputs['length'] > 0 else resolved_outputs['id'])

    default_get_domains = alicloud.ga.get_domains(accelerator_id=accelerator_id_locals,
        domain="your_domain")
    pulumi.export("alicloudGaDomainExampleId", default_get_domains.domains[0].id)
    ```


    :param _builtins.str accelerator_id: The ID of the global acceleration instance.
    :param _builtins.str domain: The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
    :param Sequence[_builtins.str] ids: A list of Ga Domain IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['domain'] = domain
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ga/getDomains:getDomains', __args__, opts=opts, typ=GetDomainsResult).value

    return AwaitableGetDomainsResult(
        accelerator_id=pulumi.get(__ret__, 'accelerator_id'),
        domain=pulumi.get(__ret__, 'domain'),
        domains=pulumi.get(__ret__, 'domains'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'))
def get_domains_output(accelerator_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainsResult]:
    """
    This data source provides Ga Domain available to the user.[What is Domain](https://www.alibabacloud.com/help/en/global-accelerator/latest/createdomain)

    > **NOTE:** Available since v1.197.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ga.get_accelerators(status="active")
    default_accelerator = []
    def create_default(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            default_accelerator.append(alicloud.ga.Accelerator(f"default-{range['value']}",
                duration=1,
                auto_use_coupon=True,
                spec="1"))

    len(default.accelerators).apply(lambda resolved_outputs: create_default(0 if resolved_outputs['length'] > 0 else 1))
    accelerator_id = pulumi.Output.all(
        length=len(default.accelerators),
        id=default_accelerator[0].id
    ).apply(lambda resolved_outputs: default.accelerators[0].id if resolved_outputs['length'] > 0 else resolved_outputs['id'])

    default_get_domains = alicloud.ga.get_domains(accelerator_id=accelerator_id_locals,
        domain="your_domain")
    pulumi.export("alicloudGaDomainExampleId", default_get_domains.domains[0].id)
    ```


    :param _builtins.str accelerator_id: The ID of the global acceleration instance.
    :param _builtins.str domain: The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
    :param Sequence[_builtins.str] ids: A list of Ga Domain IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['domain'] = domain
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ga/getDomains:getDomains', __args__, opts=opts, typ=GetDomainsResult)
    return __ret__.apply(lambda __response__: GetDomainsResult(
        accelerator_id=pulumi.get(__response__, 'accelerator_id'),
        domain=pulumi.get(__response__, 'domain'),
        domains=pulumi.get(__response__, 'domains'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        status=pulumi.get(__response__, 'status')))
