# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LoadBalancerZoneMapping',
    'LoadBalancerZoneMappingLoadBalancerAddress',
    'ServerGroupConnectionDrainConfig',
    'ServerGroupHealthCheckConfig',
    'ServerGroupServer',
    'GetZonesZoneResult',
]

@pulumi.output_type
class LoadBalancerZoneMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"
        elif key == "loadBalancerAddresses":
            suggest = "load_balancer_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerZoneMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerZoneMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerZoneMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str,
                 load_balancer_addresses: Optional[Sequence['outputs.LoadBalancerZoneMappingLoadBalancerAddress']] = None):
        """
        :param _builtins.str vswitch_id: The ID of the vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of a GWLB instance.
        :param _builtins.str zone_id: The zone ID. You can call the DescribeZones operation to query the most recent zone list.
        :param Sequence['LoadBalancerZoneMappingLoadBalancerAddressArgs'] load_balancer_addresses: The information about the IP addresses used by the GWLB instance.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if load_balancer_addresses is not None:
            pulumi.set(__self__, "load_balancer_addresses", load_balancer_addresses)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of a GWLB instance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID. You can call the DescribeZones operation to query the most recent zone list.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerAddresses")
    def load_balancer_addresses(self) -> Optional[Sequence['outputs.LoadBalancerZoneMappingLoadBalancerAddress']]:
        """
        The information about the IP addresses used by the GWLB instance.
        """
        return pulumi.get(self, "load_balancer_addresses")


@pulumi.output_type
class LoadBalancerZoneMappingLoadBalancerAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eniId":
            suggest = "eni_id"
        elif key == "privateIpv4Address":
            suggest = "private_ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerZoneMappingLoadBalancerAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerZoneMappingLoadBalancerAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerZoneMappingLoadBalancerAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eni_id: Optional[_builtins.str] = None,
                 private_ipv4_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str eni_id: The ID of the elastic network interface (ENI) used by the GWLB instance.
        :param _builtins.str private_ipv4_address: The private IPv4 address.
        """
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[_builtins.str]:
        """
        The ID of the elastic network interface (ENI) used by the GWLB instance.
        """
        return pulumi.get(self, "eni_id")

    @_builtins.property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "private_ipv4_address")


@pulumi.output_type
class ServerGroupConnectionDrainConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionDrainEnabled":
            suggest = "connection_drain_enabled"
        elif key == "connectionDrainTimeout":
            suggest = "connection_drain_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupConnectionDrainConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupConnectionDrainConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupConnectionDrainConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_drain_enabled: Optional[_builtins.bool] = None,
                 connection_drain_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.bool connection_drain_enabled: Indicates whether connection draining is enabled. Valid values:
        :param _builtins.int connection_drain_timeout: The timeout period of connection draining.
               
               Unit: seconds
               
               Valid values: `1` to `3600`.
               
               Default value: `300`.
        """
        if connection_drain_enabled is not None:
            pulumi.set(__self__, "connection_drain_enabled", connection_drain_enabled)
        if connection_drain_timeout is not None:
            pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)

    @_builtins.property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether connection draining is enabled. Valid values:
        """
        return pulumi.get(self, "connection_drain_enabled")

    @_builtins.property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> Optional[_builtins.int]:
        """
        The timeout period of connection draining.

        Unit: seconds

        Valid values: `1` to `3600`.

        Default value: `300`.
        """
        return pulumi.get(self, "connection_drain_timeout")


@pulumi.output_type
class ServerGroupHealthCheckConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckConnectPort":
            suggest = "health_check_connect_port"
        elif key == "healthCheckConnectTimeout":
            suggest = "health_check_connect_timeout"
        elif key == "healthCheckDomain":
            suggest = "health_check_domain"
        elif key == "healthCheckEnabled":
            suggest = "health_check_enabled"
        elif key == "healthCheckHttpCodes":
            suggest = "health_check_http_codes"
        elif key == "healthCheckInterval":
            suggest = "health_check_interval"
        elif key == "healthCheckPath":
            suggest = "health_check_path"
        elif key == "healthCheckProtocol":
            suggest = "health_check_protocol"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupHealthCheckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupHealthCheckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupHealthCheckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_connect_port: Optional[_builtins.int] = None,
                 health_check_connect_timeout: Optional[_builtins.int] = None,
                 health_check_domain: Optional[_builtins.str] = None,
                 health_check_enabled: Optional[_builtins.bool] = None,
                 health_check_http_codes: Optional[Sequence[_builtins.str]] = None,
                 health_check_interval: Optional[_builtins.int] = None,
                 health_check_path: Optional[_builtins.str] = None,
                 health_check_protocol: Optional[_builtins.str] = None,
                 healthy_threshold: Optional[_builtins.int] = None,
                 unhealthy_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int health_check_connect_port: The backend server port that is used for health checks.
               
               Valid values: `1` to `65535`.
               
               Default value: `80`.
        :param _builtins.int health_check_connect_timeout: The maximum timeout period of a health check response.
               
               Unit: seconds
               
               Valid values: `1` to `300`.
               
               Default value: `5`.
        :param _builtins.str health_check_domain: The domain name that you want to use for health checks. Valid values:
               
               *   **$SERVER_IP** (default): the private IP address of a backend server.
        :param _builtins.bool health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param Sequence[_builtins.str] health_check_http_codes: The HTTP status codes that the system returns for health checks.
        :param _builtins.int health_check_interval: The interval at which health checks are performed.
               
               Unit: seconds
               
               Valid values: `1` to `50`.
               
               Default value: `10`.
        :param _builtins.str health_check_path: The URL that is used for health checks.
               
               The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: \\_ ; ~ ! ( ) \\* \\[ ] @ $ ^ : ' , + =
               
               The URL must start with a forward slash (/).
               
               > **NOTE:**  This parameter takes effect only if you set `HealthCheckProtocol` to `HTTP`.
        :param _builtins.str health_check_protocol: The protocol that is used for health checks. Valid values:
               
               - `TCP`: TCP health checks send TCP SYN packets to a backend server to check whether the port of the backend server is reachable.
               - `HTTP`: HTTP health checks simulate a process that uses a web browser to access resources by sending HEAD or GET requests to an instance. These requests are used to check whether the instance is healthy.
        :param _builtins.int healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.
               
               Valid values: `2` to `10`.
               
               Default value: `2`.
        :param _builtins.int unhealthy_threshold: The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.
               
               Valid values: `2` to `10`.
               
               Default value: `2`.
        """
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_connect_timeout is not None:
            pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_http_codes is not None:
            pulumi.set(__self__, "health_check_http_codes", health_check_http_codes)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[_builtins.int]:
        """
        The backend server port that is used for health checks.

        Valid values: `1` to `65535`.

        Default value: `80`.
        """
        return pulumi.get(self, "health_check_connect_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> Optional[_builtins.int]:
        """
        The maximum timeout period of a health check response.

        Unit: seconds

        Valid values: `1` to `300`.

        Default value: `5`.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[_builtins.str]:
        """
        The domain name that you want to use for health checks. Valid values:

        *   **$SERVER_IP** (default): the private IP address of a backend server.
        """
        return pulumi.get(self, "health_check_domain")

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        return pulumi.get(self, "health_check_enabled")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCodes")
    def health_check_http_codes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The HTTP status codes that the system returns for health checks.
        """
        return pulumi.get(self, "health_check_http_codes")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[_builtins.int]:
        """
        The interval at which health checks are performed.

        Unit: seconds

        Valid values: `1` to `50`.

        Default value: `10`.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[_builtins.str]:
        """
        The URL that is used for health checks.

        The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: \\_ ; ~ ! ( ) \\* \\[ ] @ $ ^ : ' , + =

        The URL must start with a forward slash (/).

        > **NOTE:**  This parameter takes effect only if you set `HealthCheckProtocol` to `HTTP`.
        """
        return pulumi.get(self, "health_check_path")

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[_builtins.str]:
        """
        The protocol that is used for health checks. Valid values:

        - `TCP`: TCP health checks send TCP SYN packets to a backend server to check whether the port of the backend server is reachable.
        - `HTTP`: HTTP health checks simulate a process that uses a web browser to access resources by sending HEAD or GET requests to an instance. These requests are used to check whether the instance is healthy.
        """
        return pulumi.get(self, "health_check_protocol")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[_builtins.int]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.

        Valid values: `2` to `10`.

        Default value: `2`.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[_builtins.int]:
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.

        Valid values: `2` to `10`.

        Default value: `2`.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ServerGroupServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "serverType":
            suggest = "server_type"
        elif key == "serverGroupId":
            suggest = "server_group_id"
        elif key == "serverIp":
            suggest = "server_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_id: _builtins.str,
                 server_type: _builtins.str,
                 port: Optional[_builtins.int] = None,
                 server_group_id: Optional[_builtins.str] = None,
                 server_ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str server_id: The backend server ID.
               
               - If the server group is of the `Instance` type, set this parameter to the IDs of servers of the `Ecs`, `Eni`, or `Eci` type.
               - If the server group is of the `Ip` type, set ServerId to IP addresses.
        :param _builtins.str server_type: The type of the backend server. Valid values:
               
               - `Ecs`: Elastic Compute Service (ECS) instance
               - `Eni`: elastic network interface (ENI)
               - `Eci`: elastic container instance
               - `Ip`: IP address
        :param _builtins.int port: (Optional, Computed, Int) The port that is used by the backend server.
        :param _builtins.str server_group_id: The server group ID.
        :param _builtins.str server_ip: The IP address of the backend server.
        :param _builtins.str status: Indicates the status of the backend server.
        """
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "server_type", server_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if server_ip is not None:
            pulumi.set(__self__, "server_ip", server_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The backend server ID.

        - If the server group is of the `Instance` type, set this parameter to the IDs of servers of the `Ecs`, `Eni`, or `Eci` type.
        - If the server group is of the `Ip` type, set ServerId to IP addresses.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> _builtins.str:
        """
        The type of the backend server. Valid values:

        - `Ecs`: Elastic Compute Service (ECS) instance
        - `Eni`: elastic network interface (ENI)
        - `Eci`: elastic container instance
        - `Ip`: IP address
        """
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Optional, Computed, Int) The port that is used by the backend server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[_builtins.str]:
        """
        The server group ID.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter(name="serverIp")
    def server_ip(self) -> Optional[_builtins.str]:
        """
        The IP address of the backend server.
        """
        return pulumi.get(self, "server_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Indicates the status of the backend server.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 local_name: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str id: The zone ID.
        :param _builtins.str local_name: The zone name.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_name", local_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localName")
    def local_name(self) -> _builtins.str:
        """
        The zone name.
        """
        return pulumi.get(self, "local_name")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


