# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CrossAccountArgs', 'CrossAccount']

@pulumi.input_type
class CrossAccountArgs:
    def __init__(__self__, *,
                 cross_account_role_name: pulumi.Input[_builtins.str],
                 cross_account_user_id: pulumi.Input[_builtins.int],
                 alias: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CrossAccount resource.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The name of RAM role that the backup account authorizes the management account to manage its resources
        :param pulumi.Input[_builtins.int] cross_account_user_id: The uid of the backup account.
        :param pulumi.Input[_builtins.str] alias: Backup account alias
        """
        pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of RAM role that the backup account authorizes the management account to manage its resources
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Input[_builtins.int]:
        """
        The uid of the backup account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup account alias
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)


@pulumi.input_type
class _CrossAccountState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CrossAccount resources.
        :param pulumi.Input[_builtins.str] alias: Backup account alias
        :param pulumi.Input[_builtins.int] create_time: Timestamp of the creation time
        :param pulumi.Input[_builtins.str] cross_account_role_name: The name of RAM role that the backup account authorizes the management account to manage its resources
        :param pulumi.Input[_builtins.int] cross_account_user_id: The uid of the backup account.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup account alias
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp of the creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of RAM role that the backup account authorizes the management account to manage its resources
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The uid of the backup account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)


@pulumi.type_token("alicloud:hbr/crossAccount:CrossAccount")
class CrossAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Hybrid Backup Recovery (HBR) Cross Account resource.

        The cross account is used for the cross-account backup in the Cloud Backup. The management account can back up the resources under the cross account.

        For information about Hybrid Backup Recovery (HBR) Cross Account and how to use it, see [What is Cross Account](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.hbr.CrossAccount("default",
            cross_account_user_id=1,
            cross_account_role_name=name,
            alias=name)
        ```

        ## Import

        Hybrid Backup Recovery (HBR) Cross Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/crossAccount:CrossAccount example <cross_account_user_id>:<cross_account_role_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: Backup account alias
        :param pulumi.Input[_builtins.str] cross_account_role_name: The name of RAM role that the backup account authorizes the management account to manage its resources
        :param pulumi.Input[_builtins.int] cross_account_user_id: The uid of the backup account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CrossAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Hybrid Backup Recovery (HBR) Cross Account resource.

        The cross account is used for the cross-account backup in the Cloud Backup. The management account can back up the resources under the cross account.

        For information about Hybrid Backup Recovery (HBR) Cross Account and how to use it, see [What is Cross Account](https://www.alibabacloud.com/help/en/).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.hbr.CrossAccount("default",
            cross_account_user_id=1,
            cross_account_role_name=name,
            alias=name)
        ```

        ## Import

        Hybrid Backup Recovery (HBR) Cross Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/crossAccount:CrossAccount example <cross_account_user_id>:<cross_account_role_name>
        ```

        :param str resource_name: The name of the resource.
        :param CrossAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CrossAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CrossAccountArgs.__new__(CrossAccountArgs)

            __props__.__dict__["alias"] = alias
            if cross_account_role_name is None and not opts.urn:
                raise TypeError("Missing required property 'cross_account_role_name'")
            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            if cross_account_user_id is None and not opts.urn:
                raise TypeError("Missing required property 'cross_account_user_id'")
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["create_time"] = None
        super(CrossAccount, __self__).__init__(
            'alicloud:hbr/crossAccount:CrossAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'CrossAccount':
        """
        Get an existing CrossAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: Backup account alias
        :param pulumi.Input[_builtins.int] create_time: Timestamp of the creation time
        :param pulumi.Input[_builtins.str] cross_account_role_name: The name of RAM role that the backup account authorizes the management account to manage its resources
        :param pulumi.Input[_builtins.int] cross_account_user_id: The uid of the backup account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CrossAccountState.__new__(_CrossAccountState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        return CrossAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Backup account alias
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp of the creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of RAM role that the backup account authorizes the management account to manage its resources
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[_builtins.int]:
        """
        The uid of the backup account.
        """
        return pulumi.get(self, "cross_account_user_id")

