# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBackupJobsResult',
    'AwaitableGetBackupJobsResult',
    'get_backup_jobs',
    'get_backup_jobs_output',
]

@pulumi.output_type
class GetBackupJobsResult:
    """
    A collection of values returned by getBackupJobs.
    """
    def __init__(__self__, filters=None, id=None, ids=None, jobs=None, output_file=None, sort_direction=None, source_type=None, status=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if jobs and not isinstance(jobs, list):
            raise TypeError("Expected argument 'jobs' to be a list")
        pulumi.set(__self__, "jobs", jobs)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if sort_direction and not isinstance(sort_direction, str):
            raise TypeError("Expected argument 'sort_direction' to be a str")
        pulumi.set(__self__, "sort_direction", sort_direction)
        if source_type and not isinstance(source_type, str):
            raise TypeError("Expected argument 'source_type' to be a str")
        pulumi.set(__self__, "source_type", source_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBackupJobsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def jobs(self) -> Sequence['outputs.GetBackupJobsJobResult']:
        return pulumi.get(self, "jobs")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="sortDirection")
    def sort_direction(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sort_direction")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


class AwaitableGetBackupJobsResult(GetBackupJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupJobsResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            jobs=self.jobs,
            output_file=self.output_file,
            sort_direction=self.sort_direction,
            source_type=self.source_type,
            status=self.status)


def get_backup_jobs(filters: Optional[Sequence[Union['GetBackupJobsFilterArgs', 'GetBackupJobsFilterArgsDict']]] = None,
                    ids: Optional[Sequence[_builtins.str]] = None,
                    output_file: Optional[_builtins.str] = None,
                    sort_direction: Optional[_builtins.str] = None,
                    source_type: Optional[_builtins.str] = None,
                    status: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupJobsResult:
    """
    This data source provides the Hbr Backup Jobs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.138.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
    default_get_backup_jobs = alicloud.hbr.get_backup_jobs(source_type="ECS_FILE",
        filters=[
            {
                "key": "VaultId",
                "operator": "IN",
                "values": [default.plans[0].vault_id],
            },
            {
                "key": "InstanceId",
                "operator": "IN",
                "values": [default.plans[0].instance_id],
            },
            {
                "key": "CompleteTime",
                "operator": "BETWEEN",
                "values": [
                    "2021-08-23T14:17:15CST",
                    "2021-08-24T14:17:15CST",
                ],
            },
        ])
    example = alicloud.hbr.get_backup_jobs(source_type="ECS_FILE",
        status="COMPLETE",
        filters=[
            {
                "key": "VaultId",
                "operator": "IN",
                "values": [default.plans[0].vault_id],
            },
            {
                "key": "InstanceId",
                "operator": "IN",
                "values": [default.plans[0].instance_id],
            },
            {
                "key": "CompleteTime",
                "operator": "LESS_THAN",
                "values": ["2021-10-20T20:20:20CST"],
            },
        ])
    pulumi.export("alicloudHbrBackupJobsDefault1", default_get_backup_jobs.jobs[0].id)
    pulumi.export("alicloudHbrBackupJobsExample1", example.jobs[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Backup Job IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str sort_direction: The sort direction, sort results by ascending or descending order based on the value jobs id. Valid values: `ASCEND`, `DESCEND`.
    :param _builtins.str source_type: The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS`, `UDM_ECS`, `UDM_ECS_DISK`.
    :param _builtins.str status: The status of backup job. Valid values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`, `UNAVAILABLE`.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['sortDirection'] = sort_direction
    __args__['sourceType'] = source_type
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getBackupJobs:getBackupJobs', __args__, opts=opts, typ=GetBackupJobsResult).value

    return AwaitableGetBackupJobsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        jobs=pulumi.get(__ret__, 'jobs'),
        output_file=pulumi.get(__ret__, 'output_file'),
        sort_direction=pulumi.get(__ret__, 'sort_direction'),
        source_type=pulumi.get(__ret__, 'source_type'),
        status=pulumi.get(__ret__, 'status'))
def get_backup_jobs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBackupJobsFilterArgs', 'GetBackupJobsFilterArgsDict']]]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           sort_direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           source_type: Optional[pulumi.Input[_builtins.str]] = None,
                           status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupJobsResult]:
    """
    This data source provides the Hbr Backup Jobs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.138.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
    default_get_backup_jobs = alicloud.hbr.get_backup_jobs(source_type="ECS_FILE",
        filters=[
            {
                "key": "VaultId",
                "operator": "IN",
                "values": [default.plans[0].vault_id],
            },
            {
                "key": "InstanceId",
                "operator": "IN",
                "values": [default.plans[0].instance_id],
            },
            {
                "key": "CompleteTime",
                "operator": "BETWEEN",
                "values": [
                    "2021-08-23T14:17:15CST",
                    "2021-08-24T14:17:15CST",
                ],
            },
        ])
    example = alicloud.hbr.get_backup_jobs(source_type="ECS_FILE",
        status="COMPLETE",
        filters=[
            {
                "key": "VaultId",
                "operator": "IN",
                "values": [default.plans[0].vault_id],
            },
            {
                "key": "InstanceId",
                "operator": "IN",
                "values": [default.plans[0].instance_id],
            },
            {
                "key": "CompleteTime",
                "operator": "LESS_THAN",
                "values": ["2021-10-20T20:20:20CST"],
            },
        ])
    pulumi.export("alicloudHbrBackupJobsDefault1", default_get_backup_jobs.jobs[0].id)
    pulumi.export("alicloudHbrBackupJobsExample1", example.jobs[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Backup Job IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str sort_direction: The sort direction, sort results by ascending or descending order based on the value jobs id. Valid values: `ASCEND`, `DESCEND`.
    :param _builtins.str source_type: The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS`, `UDM_ECS`, `UDM_ECS_DISK`.
    :param _builtins.str status: The status of backup job. Valid values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`, `UNAVAILABLE`.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['sortDirection'] = sort_direction
    __args__['sourceType'] = source_type
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:hbr/getBackupJobs:getBackupJobs', __args__, opts=opts, typ=GetBackupJobsResult)
    return __ret__.apply(lambda __response__: GetBackupJobsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        jobs=pulumi.get(__response__, 'jobs'),
        output_file=pulumi.get(__response__, 'output_file'),
        sort_direction=pulumi.get(__response__, 'sort_direction'),
        source_type=pulumi.get(__response__, 'source_type'),
        status=pulumi.get(__response__, 'status')))
