# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceBindVpc',
    'GetAliasesAliasResult',
    'GetInstancesInstanceResult',
    'GetKeyVersionsVersionResult',
    'GetKeysKeyResult',
    'GetSecretVersionsVersionResult',
    'GetSecretsSecretResult',
]

@pulumi.output_type
class InstanceBindVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpcOwnerId":
            suggest = "vpc_owner_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBindVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBindVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBindVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vpc_owner_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str region_id: region id
        :param _builtins.str vpc_id: VPC ID
        :param _builtins.str vpc_owner_id: VPC owner root user ID
        :param _builtins.str vswitch_id: vswitch id
        """
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_owner_id is not None:
            pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        region id
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[_builtins.str]:
        """
        VPC owner root user ID
        """
        return pulumi.get(self, "vpc_owner_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        vswitch id
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAliasesAliasResult(dict):
    def __init__(__self__, *,
                 alias_name: _builtins.str,
                 id: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str alias_name: The unique identifier of the alias.
        :param _builtins.str id: ID of the alias. The value is same as KMS alias_name.
        :param _builtins.str key_id: ID of the key.
        """
        pulumi.set(__self__, "alias_name", alias_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> _builtins.str:
        """
        The unique identifier of the alias.
        """
        return pulumi.get(self, "alias_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the alias. The value is same as KMS alias_name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        ID of the key.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 instance_id: _builtins.str):
        """
        :param _builtins.str instance_id: The first ID of the resource
        """
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetKeyVersionsVersionResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 creation_date: _builtins.str,
                 id: _builtins.str,
                 key_id: _builtins.str,
                 key_version_id: _builtins.str):
        """
        :param _builtins.str create_time: Date and time when the key version was created (UTC time).
        :param _builtins.str creation_date: (Removed from v1.124.4) It has been removed and using `create_time` instead.
        :param _builtins.str id: ID of the KMS KeyVersion resource.
        :param _builtins.str key_id: The id of kms key.
        :param _builtins.str key_version_id: ID of the key version.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_version_id", key_version_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Date and time when the key version was created (UTC time).
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        (Removed from v1.124.4) It has been removed and using `create_time` instead.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the KMS KeyVersion resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The id of kms key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> _builtins.str:
        """
        ID of the key version.
        """
        return pulumi.get(self, "key_version_id")


@pulumi.output_type
class GetKeysKeyResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 automatic_rotation: _builtins.str,
                 creation_date: _builtins.str,
                 creator: _builtins.str,
                 delete_date: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 key_id: _builtins.str,
                 key_spec: _builtins.str,
                 key_usage: _builtins.str,
                 last_rotation_date: _builtins.str,
                 material_expire_time: _builtins.str,
                 next_rotation_date: _builtins.str,
                 origin: _builtins.str,
                 primary_key_version: _builtins.str,
                 protection_level: _builtins.str,
                 rotation_interval: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str arn: The Alibaba Cloud Resource Name (ARN) of the key.
        :param _builtins.str automatic_rotation: (Available in 1.123.1+) Specifies whether to enable automatic key rotation.
        :param _builtins.str creation_date: Creation date of key.
        :param _builtins.str creator: The owner of the key.
        :param _builtins.str delete_date: Deletion date of key.
        :param _builtins.str description: Description of the key.
        :param _builtins.str id: ID of the key.
        :param _builtins.str key_id: (Available in 1.123.1+)  ID of the key.
        :param _builtins.str key_spec: (Available in 1.123.1+)  The type of the CMK.
        :param _builtins.str key_usage: (Available in 1.123.1+)  The usage of CMK.
        :param _builtins.str last_rotation_date: (Available in 1.123.1+)  The date and time the last rotation was performed.
        :param _builtins.str material_expire_time: (Available in 1.123.1+)  The time and date the key material for the CMK expires.
        :param _builtins.str next_rotation_date: (Available in 1.123.1+)  The time the next rotation is scheduled for execution.
        :param _builtins.str origin: (Available in 1.123.1+)  The source of the key material for the CMK.
        :param _builtins.str primary_key_version: (Available in 1.123.1+)  The ID of the current primary key version of the symmetric CMK.
        :param _builtins.str protection_level: (Available in 1.123.1+)  The protection level of the CMK.
        :param _builtins.str rotation_interval: (Available in 1.123.1+)  The period of automatic key rotation.
        :param _builtins.str status: Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "automatic_rotation", automatic_rotation)
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "delete_date", delete_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_spec", key_spec)
        pulumi.set(__self__, "key_usage", key_usage)
        pulumi.set(__self__, "last_rotation_date", last_rotation_date)
        pulumi.set(__self__, "material_expire_time", material_expire_time)
        pulumi.set(__self__, "next_rotation_date", next_rotation_date)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "primary_key_version", primary_key_version)
        pulumi.set(__self__, "protection_level", protection_level)
        pulumi.set(__self__, "rotation_interval", rotation_interval)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Alibaba Cloud Resource Name (ARN) of the key.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="automaticRotation")
    def automatic_rotation(self) -> _builtins.str:
        """
        (Available in 1.123.1+) Specifies whether to enable automatic key rotation.
        """
        return pulumi.get(self, "automatic_rotation")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Creation date of key.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> _builtins.str:
        """
        The owner of the key.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="deleteDate")
    def delete_date(self) -> _builtins.str:
        """
        Deletion date of key.
        """
        return pulumi.get(self, "delete_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the key.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  ID of the key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The type of the CMK.
        """
        return pulumi.get(self, "key_spec")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The usage of CMK.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="lastRotationDate")
    def last_rotation_date(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The date and time the last rotation was performed.
        """
        return pulumi.get(self, "last_rotation_date")

    @_builtins.property
    @pulumi.getter(name="materialExpireTime")
    def material_expire_time(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The time and date the key material for the CMK expires.
        """
        return pulumi.get(self, "material_expire_time")

    @_builtins.property
    @pulumi.getter(name="nextRotationDate")
    def next_rotation_date(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The time the next rotation is scheduled for execution.
        """
        return pulumi.get(self, "next_rotation_date")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The source of the key material for the CMK.
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="primaryKeyVersion")
    def primary_key_version(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The ID of the current primary key version of the symmetric CMK.
        """
        return pulumi.get(self, "primary_key_version")

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The protection level of the CMK.
        """
        return pulumi.get(self, "protection_level")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> _builtins.str:
        """
        (Available in 1.123.1+)  The period of automatic key rotation.
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSecretVersionsVersionResult(dict):
    def __init__(__self__, *,
                 secret_data: _builtins.str,
                 secret_data_type: _builtins.str,
                 secret_name: _builtins.str,
                 version_id: _builtins.str,
                 version_stages: Sequence[_builtins.str]):
        """
        :param _builtins.str secret_data: The secret value. Secrets Manager decrypts the stored secret value in ciphertext and returns it. (Returned when `enable_details` is true).
        :param _builtins.str secret_data_type: The type of the secret value. (Returned when `enable_details` is true).
        :param _builtins.str secret_name: The name of the secret.
        :param _builtins.str version_id: The version number of the secret value.
        :param Sequence[_builtins.str] version_stages: Stage labels that mark the secret version.
        """
        pulumi.set(__self__, "secret_data", secret_data)
        pulumi.set(__self__, "secret_data_type", secret_data_type)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "version_id", version_id)
        pulumi.set(__self__, "version_stages", version_stages)

    @_builtins.property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> _builtins.str:
        """
        The secret value. Secrets Manager decrypts the stored secret value in ciphertext and returns it. (Returned when `enable_details` is true).
        """
        return pulumi.get(self, "secret_data")

    @_builtins.property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> _builtins.str:
        """
        The type of the secret value. (Returned when `enable_details` is true).
        """
        return pulumi.get(self, "secret_data_type")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        The version number of the secret value.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Sequence[_builtins.str]:
        """
        Stage labels that mark the secret version.
        """
        return pulumi.get(self, "version_stages")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 description: _builtins.str,
                 encryption_key_id: _builtins.str,
                 id: _builtins.str,
                 planned_delete_time: _builtins.str,
                 secret_data: _builtins.str,
                 secret_data_type: _builtins.str,
                 secret_name: _builtins.str,
                 secret_type: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 version_id: _builtins.str,
                 version_stages: Sequence[_builtins.str]):
        """
        :param _builtins.str arn: (Available since v1.124.0) A mapping of tags to assign to the resource.
        :param _builtins.str description: (Available since v1.124.0)  The description of the secret.
        :param _builtins.str encryption_key_id: (Available since v1.124.0)  The ID of the KMS CMK that is used to encrypt the secret value.
        :param _builtins.str id: ID of the Kms Secret. The value is same as KMS secret_name.
        :param _builtins.str planned_delete_time: Schedule deletion time.
        :param _builtins.str secret_data: (Available since v1.124.0)  The value of the secret that you want to create.
        :param _builtins.str secret_data_type: (Available since v1.124.0)  The type of the secret data value.
        :param _builtins.str secret_name: Name of the KMS Secret.
        :param _builtins.str secret_type: (Available since v1.124.0)  The type of the secret.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource, and can be used to filter secrets.
        :param _builtins.str version_id: (Available since v1.124.0)  The version number of the initial version.
        :param Sequence[_builtins.str] version_stages: (Available since v1.124.0)  The stage labels that mark the new secret version.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encryption_key_id", encryption_key_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "planned_delete_time", planned_delete_time)
        pulumi.set(__self__, "secret_data", secret_data)
        pulumi.set(__self__, "secret_data_type", secret_data_type)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "secret_type", secret_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "version_id", version_id)
        pulumi.set(__self__, "version_stages", version_stages)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        (Available since v1.124.0) A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Available since v1.124.0)  The description of the secret.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> _builtins.str:
        """
        (Available since v1.124.0)  The ID of the KMS CMK that is used to encrypt the secret value.
        """
        return pulumi.get(self, "encryption_key_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the Kms Secret. The value is same as KMS secret_name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="plannedDeleteTime")
    def planned_delete_time(self) -> _builtins.str:
        """
        Schedule deletion time.
        """
        return pulumi.get(self, "planned_delete_time")

    @_builtins.property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> _builtins.str:
        """
        (Available since v1.124.0)  The value of the secret that you want to create.
        """
        return pulumi.get(self, "secret_data")

    @_builtins.property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> _builtins.str:
        """
        (Available since v1.124.0)  The type of the secret data value.
        """
        return pulumi.get(self, "secret_data_type")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        Name of the KMS Secret.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> _builtins.str:
        """
        (Available since v1.124.0)  The type of the secret.
        """
        return pulumi.get(self, "secret_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource, and can be used to filter secrets.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        (Available since v1.124.0)  The version number of the initial version.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.124.0)  The stage labels that mark the new secret version.
        """
        return pulumi.get(self, "version_stages")


