# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicNetworkArgs', 'PublicNetwork']

@pulumi.input_type
class PublicNetworkArgs:
    def __init__(__self__, *,
                 engine_type: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 enable_public_network: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PublicNetwork resource.
        :param pulumi.Input[_builtins.str] engine_type: Engine type, value:
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.int] enable_public_network: Open or close the public connection. Value:
        """
        pulumi.set(__self__, "engine_type", engine_type)
        pulumi.set(__self__, "instance_id", instance_id)
        if enable_public_network is not None:
            pulumi.set(__self__, "enable_public_network", enable_public_network)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Input[_builtins.str]:
        """
        Engine type, value:
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicNetwork")
    def enable_public_network(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Open or close the public connection. Value:
        """
        return pulumi.get(self, "enable_public_network")

    @enable_public_network.setter
    def enable_public_network(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_public_network", value)


@pulumi.input_type
class _PublicNetworkState:
    def __init__(__self__, *,
                 enable_public_network: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicNetwork resources.
        :param pulumi.Input[_builtins.int] enable_public_network: Open or close the public connection. Value:
        :param pulumi.Input[_builtins.str] engine_type: Engine type, value:
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] status: Instance status, returns:_EXPANDING`: Capacity-based cloud storage is being expanded._version_transing`: The minor version is being upgraded._CHANGING`: The specification is being upgraded or downgraded._SWITCHING`:SSL is being changed._OPENING`: The data subscription function is being activated._TRANSFER`: migrates data to the database._CREATING`: in the production disaster recovery instance._RECOVERING`: The backup is being restored._IMPORTING`: Data is being imported._MODIFYING`: The network is being changed._SWITCHING`: The internal network and the external network are being switched._CREATING`: creates a network link._DELETING`: deletes a network link.
        """
        if enable_public_network is not None:
            pulumi.set(__self__, "enable_public_network", enable_public_network)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enablePublicNetwork")
    def enable_public_network(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Open or close the public connection. Value:
        """
        return pulumi.get(self, "enable_public_network")

    @enable_public_network.setter
    def enable_public_network(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_public_network", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Engine type, value:
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status, returns:_EXPANDING`: Capacity-based cloud storage is being expanded._version_transing`: The minor version is being upgraded._CHANGING`: The specification is being upgraded or downgraded._SWITCHING`:SSL is being changed._OPENING`: The data subscription function is being activated._TRANSFER`: migrates data to the database._CREATING`: in the production disaster recovery instance._RECOVERING`: The backup is being restored._IMPORTING`: Data is being imported._MODIFYING`: The network is being changed._SWITCHING`: The internal network and the external network are being switched._CREATING`: creates a network link._DELETING`: deletes a network link.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:lindorm/publicNetwork:PublicNetwork")
class PublicNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_public_network: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Lindorm Public Network can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:lindorm/publicNetwork:PublicNetwork example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] enable_public_network: Open or close the public connection. Value:
        :param pulumi.Input[_builtins.str] engine_type: Engine type, value:
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Lindorm Public Network can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:lindorm/publicNetwork:PublicNetwork example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PublicNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_public_network: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicNetworkArgs.__new__(PublicNetworkArgs)

            __props__.__dict__["enable_public_network"] = enable_public_network
            if engine_type is None and not opts.urn:
                raise TypeError("Missing required property 'engine_type'")
            __props__.__dict__["engine_type"] = engine_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["status"] = None
        super(PublicNetwork, __self__).__init__(
            'alicloud:lindorm/publicNetwork:PublicNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_public_network: Optional[pulumi.Input[_builtins.int]] = None,
            engine_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'PublicNetwork':
        """
        Get an existing PublicNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] enable_public_network: Open or close the public connection. Value:
        :param pulumi.Input[_builtins.str] engine_type: Engine type, value:
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] status: Instance status, returns:_EXPANDING`: Capacity-based cloud storage is being expanded._version_transing`: The minor version is being upgraded._CHANGING`: The specification is being upgraded or downgraded._SWITCHING`:SSL is being changed._OPENING`: The data subscription function is being activated._TRANSFER`: migrates data to the database._CREATING`: in the production disaster recovery instance._RECOVERING`: The backup is being restored._IMPORTING`: Data is being imported._MODIFYING`: The network is being changed._SWITCHING`: The internal network and the external network are being switched._CREATING`: creates a network link._DELETING`: deletes a network link.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicNetworkState.__new__(_PublicNetworkState)

        __props__.__dict__["enable_public_network"] = enable_public_network
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["status"] = status
        return PublicNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enablePublicNetwork")
    def enable_public_network(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Open or close the public connection. Value:
        """
        return pulumi.get(self, "enable_public_network")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[_builtins.str]:
        """
        Engine type, value:
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status, returns:_EXPANDING`: Capacity-based cloud storage is being expanded._version_transing`: The minor version is being upgraded._CHANGING`: The specification is being upgraded or downgraded._SWITCHING`:SSL is being changed._OPENING`: The data subscription function is being activated._TRANSFER`: migrates data to the database._CREATING`: in the production disaster recovery instance._RECOVERING`: The backup is being restored._IMPORTING`: Data is being imported._MODIFYING`: The network is being changed._SWITCHING`: The internal network and the external network are being switched._CREATING`: creates a network link._DELETING`: deletes a network link.
        """
        return pulumi.get(self, "status")

